import * as React from 'react';
export const useQueryTableCellPropertyCommand = ({ commandName, editor, tableUtilsPluginConstructor, defaultValue = '', }) => {
    const [value, setValue] = React.useState(defaultValue);
    const onEditorChange = React.useCallback(() => {
        const tableUtils = editor?.plugins.get(tableUtilsPluginConstructor);
        if (editor) {
            const selectedTableCells = tableUtils?.getSelectionAffectedTableCells(editor.model.document.selection);
            if (selectedTableCells?.[0]) {
                const currentValue = selectedTableCells[0].getAttribute(commandName);
                if (currentValue !== value) {
                    setValue(currentValue || defaultValue);
                }
            }
        }
    }, [editor, commandName, value, tableUtilsPluginConstructor, defaultValue]);
    React.useEffect(() => {
        onEditorChange();
        editor?.model.document.on('change', onEditorChange);
        return () => {
            editor?.model.document.off('change', onEditorChange);
        };
    }, [editor, commandName, onEditorChange]);
    const onChange = React.useCallback((value) => {
        setValue(value);
        editor?.execute(commandName, { value });
    }, [editor, commandName]);
    return { value, onChange };
};
//# sourceMappingURL=use-table-cell-property-command.js.map