import * as React from 'react';
import { ATTR_BREAK_PAGE_AFTER } from '@sage/xtrem-shared';
import { GridColumn } from '@sage/xtrem-ui-components';
import Switch from 'carbon-react/esm/components/switch';
import { useQueryTableRowPropertyCommand } from './use-table-row-attr-command';
export function PageBreak({ title, editor, commandName, tableUtilsPluginConstructor, isEnabled, }) {
    const attrName = ATTR_BREAK_PAGE_AFTER;
    const { value, onChange } = useQueryTableRowPropertyCommand({
        commandName,
        editor,
        tableUtilsPluginConstructor,
        attrName,
    });
    const onSwitchChange = React.useCallback((event) => {
        onChange(event.target.checked);
    }, [onChange]);
    if (!isEnabled || !editor) {
        return null;
    }
    return (React.createElement(GridColumn, { columnSpan: 4 },
        React.createElement("label", { className: "field-label" }, title),
        React.createElement(Switch, { marginTop: "12px", size: "small", name: "pageBreak", onChange: onSwitchChange, checked: value })));
}
//# sourceMappingURL=page-break.js.map