import * as React from 'react';
import type { DocumentContextProvider, DataModelProperty, ContextType } from '../../context-provider';
import type { Order } from '@sage/xtrem-ui-components';
import { type FiltersComponentProps } from '../filter/filters-component';
import type { Aggregations, Dict, LocalizeEnumFunction, LocalizeFunction, LocalizeLocale } from '@sage/xtrem-shared';
import type { ToastProps } from 'carbon-react/esm/components/toast';
export type SelectionType = 'property' | 'recordContext' | 'list';
export interface GroupAggregation {
    group: number;
    operation: Aggregations | 'NONE';
}
export interface DocumentEditorInsertDialogResult {
    selectedFields?: Dict<DataModelProperty> | null;
    aggregations?: Dict<GroupAggregation>;
    filters?: FiltersComponentProps['filters'];
    orderBy?: Dict<Order>;
    collectionType?: Dict<DataModelProperty> | null;
    selectedMode: 'list' | 'recordContext';
}
export interface LookupRequest {
    root: ContextType;
    contextObjectType: string;
    onSelected: (result: DocumentEditorInsertDialogResult) => void;
}
export interface InsertListPropertyDialogProps {
    contextProvider: DocumentContextProvider;
    locale: LocalizeLocale;
    localize: LocalizeFunction;
    localizeEnumMember: LocalizeEnumFunction;
    lookupRequest?: LookupRequest | null;
    onClose: () => void;
    onDisplayNotification: (content: string, type: ToastProps['variant']) => void;
}
export declare function InsertListPropertyDialog({ contextProvider, locale, localize, localizeEnumMember, lookupRequest, onClose, onDisplayNotification, }: InsertListPropertyDialogProps): React.ReactElement;
//# sourceMappingURL=insert-list-property-dialog.d.ts.map