import IconButton from 'carbon-react/esm/components/icon-button';
import Icon from 'carbon-react/esm/components/icon';
import tokens from '@sage/design-tokens/js/base/es6';
import * as React from 'react';
export function PanelHeader({ title, actionUiPlugin: action, editorRef, localize, }) {
    const onClose = React.useCallback(() => {
        const plugin = editorRef.plugins.get(action);
        plugin.togglePanel();
    }, [editorRef, action]);
    return (React.createElement("div", { className: "document-editor-panel-header" },
        React.createElement("span", { className: "document-editor-panel-header-label" }, title),
        React.createElement(IconButton, { onAction: onClose, "aria-label": localize('@sage/xtrem-document-editor/close', 'Close') },
            React.createElement(Icon, { fontSize: "large", type: "cross", color: tokens.colorsActionMinor500 }))));
}
//# sourceMappingURL=panel-header.js.map