import * as React from 'react';
import ButtonMinor from 'carbon-react/esm/components/button-minor';
import { GridColumn } from '@sage/xtrem-ui-components';
import { COMMAND_EDIT_FILTER_QUERY_TABLE } from '../constants';
import Dialog from 'carbon-react/esm/components/dialog';
import Form from 'carbon-react/esm/components/form';
import Button from 'carbon-react/esm/components/button';
import { getContextFilter, getContextObjectType, getSelectedItemsFromProperties } from '../plugins/utils';
import Loader from 'carbon-react/esm/components/loader';
import { FiltersComponent } from './filter/filters-component';
import { isEmpty } from 'lodash';
import { getDeepObjectDetails } from './utils';
export function EditFilterActionButton({ contextProvider, editor, locale, localize, localizeEnumMember, isEnabled, }) {
    const [isOpen, setOpen] = React.useState(false);
    const [properties, setProperties] = React.useState(null);
    const [filters, setFilters] = React.useState([]);
    const [contextObjectType, setContextObjectType] = React.useState(null);
    React.useEffect(() => {
        setProperties(null);
        if (editor && isOpen) {
            const focusedElement = editor.model.document.selection.focus?.parent;
            const objectType = getContextObjectType(focusedElement);
            setContextObjectType(objectType);
            setFilters(getContextFilter(focusedElement) || []);
        }
    }, [contextProvider, editor, isOpen]);
    React.useEffect(() => {
        if (editor && isEnabled && isOpen && contextObjectType) {
            const referenceIds = filters.filter(obj => obj.id && obj.id.includes('.')).map(obj => obj.id);
            getDeepObjectDetails(contextProvider, contextObjectType, referenceIds).then(dataModel => {
                setProperties(dataModel);
            });
        }
    }, [isEnabled, isOpen, contextProvider, editor, contextObjectType, filters]);
    const onSaveOrder = React.useCallback(() => {
        if (editor) {
            editor.execute(COMMAND_EDIT_FILTER_QUERY_TABLE, { filters });
        }
        setOpen(false);
    }, [editor, filters]);
    const selectedItems = React.useMemo(() => getSelectedItemsFromProperties(properties), [properties]);
    if (!isEnabled) {
        return null;
    }
    return (React.createElement(React.Fragment, null,
        React.createElement(Dialog, { open: isOpen, onCancel: () => setOpen(false), title: localize('@sage/xtrem-document-editor/edit-filters-dialog-title', 'Edit Filters'), className: "document-editor-edit-filter-dialog", size: "extra-large" },
            React.createElement(Form, { onSubmit: (ev) => {
                    ev.preventDefault();
                }, stickyFooter: true, height: "500px", saveButton: React.createElement(Button, { buttonType: "primary", type: "submit", onClick: onSaveOrder }, localize('@sage/xtrem-document-editor/apply-button', 'Apply')) },
                (isEmpty(properties) || !contextObjectType) && React.createElement(Loader, null),
                !isEmpty(properties) && properties && contextObjectType && (React.createElement(FiltersComponent, { contextProvider: contextProvider, filters: filters, locale: locale, localize: localize, localizeEnumMember: localizeEnumMember, objectType: contextObjectType, onChange: setFilters, selectedItems: selectedItems })))),
        React.createElement(GridColumn, { columnSpan: 2 },
            React.createElement(ButtonMinor, { fullWidth: true, onClick: () => setOpen(true), "data-testid": "document-editor-edit-filter-button" }, localize('@sage/xtrem-document-editor/edit-filters-button', 'Edit filters')))));
}
//# sourceMappingURL=edit-filter-action-button.js.map