"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomerInvoiceHeader = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3InvoicingData = require("..");
const joins = {
    referenceJoins: {
        billToCustomer: {
            code: 'billToCustomer',
        },
        company: {
            code: 'company',
        },
        financialSite: {
            code: 'financialSite',
        },
        currency: {
            code: 'currency',
        },
        payByBusinessPartner: {
            code: 'payByBusinessPartner',
        },
        payByBusinessPartnerAddress: {
            entityType() {
                return 'businessPartner';
            },
            businessPartner: 'payByBusinessPartner',
            code: 'payByBusinessPartnerAddress',
        },
        payByBusinessPartnerCountry: {
            code: 'payByBusinessPartnerCountry',
        },
        paymentTerm: {
            code: 'paymentTerm',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
            line() {
                return 1;
            },
        },
        earlyDiscountOrLateCharge: {
            code: 'earlyDiscountOrLateCharge',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        taxRule: {
            code: 'taxRule',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        entityUserCode: {
            glossaryId() {
                return 202;
            },
            code: 'entityUserCode',
        },
        billToCustomerAddress: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'billToCustomer',
            code: 'billToCustomerAddress',
        },
        billToCustomerCountry: {
            code: 'billToCustomerCountry',
        },
        stockMovementGroup: {
            glossaryId() {
                return 9;
            },
            code: 'stockMovementGroup',
        },
        warehouse: {
            code: 'warehouse',
        },
        mandate: {
            company: 'company',
            code: 'mandate',
        },
        field40Reason: {
            glossaryId() {
                return 8300;
            },
            code: 'field40Reason',
        },
        field41Reason: {
            glossaryId() {
                return 8301;
            },
            code: 'field41Reason',
        },
        project: {
            id: 'project',
        },
        businessProcessType: {
            glossaryId() {
                return 207;
            },
            code: 'businessProcessType',
        },
    },
};
let CustomerInvoiceHeader = class CustomerInvoiceHeader extends xtrem_core_1.Node {
};
exports.CustomerInvoiceHeader = CustomerInvoiceHeader;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerInvoiceHeader.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVTYP',
        dataType: () => sageX3InvoicingData.enums.invoiceTypeDatatype,
    })
], CustomerInvoiceHeader.prototype, "category", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORIMOD',
        dataType: () => sageX3System.enums.moduleTableDatatype,
    })
], CustomerInvoiceHeader.prototype, "sourceModule", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], CustomerInvoiceHeader.prototype, "billToCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRSAC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerInvoiceHeader.prototype, "control", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], CustomerInvoiceHeader.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], CustomerInvoiceHeader.prototype, "financialSite", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], CustomerInvoiceHeader.prototype, "accountingDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCNUM',
    })
], CustomerInvoiceHeader.prototype, "internalNumber", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], CustomerInvoiceHeader.prototype, "sourceDocumentDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRVCR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerInvoiceHeader.prototype, "sourceDocument", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], CustomerInvoiceHeader.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CURTYP',
        dataType: () => sageX3System.enums.exchangeRateTypeDatatype,
    })
], CustomerInvoiceHeader.prototype, "rateType", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RATDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], CustomerInvoiceHeader.prototype, "rateDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPRPAY',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], CustomerInvoiceHeader.prototype, "payByBusinessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAPAY',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.BusinessPartnerAddress,
    })
], CustomerInvoiceHeader.prototype, "payByBusinessPartnerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPYPOSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerInvoiceHeader.prototype, "payByBusinessPartnerPostalCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPYCTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerInvoiceHeader.prototype, "payByBusinessPartnerCity", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPYSAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerInvoiceHeader.prototype, "payByBusinessPartnerState", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPYCRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], CustomerInvoiceHeader.prototype, "payByBusinessPartnerCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPYCRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerInvoiceHeader.prototype, "payByBusinessPartnerCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STRDUDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], CustomerInvoiceHeader.prototype, "dueDateCalculationStartDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PTE',
        columnType: 'string',
        filters: {
            lookup: {
                line: 1,
            },
            control: {
                line: 1,
            },
        },
        node: () => sageX3InvoicingData.nodes.PaymentTerm,
    })
], CustomerInvoiceHeader.prototype, "paymentTerm", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.EarlyDiscountLateCharge,
    })
], CustomerInvoiceHeader.prototype, "earlyDiscountOrLateCharge", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEPRAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], CustomerInvoiceHeader.prototype, "earlyDiscountOrLateChargeRate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VAC',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.TaxRule,
    })
], CustomerInvoiceHeader.prototype, "taxRule", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SSTENTCOD',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 202,
            },
            control: {
                glossaryId: 202,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
        serviceOptions: () => [sageX3System.serviceOptions.LtaActivityCode],
    })
], CustomerInvoiceHeader.prototype, "entityUserCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DIRINVFLG',
    })
], CustomerInvoiceHeader.prototype, "isDirectInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECNUMDEB',
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], CustomerInvoiceHeader.prototype, "intrastatProcessingNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STA',
        dataType: () => sageX3MasterData.enums.invoiceStatusDatatype,
    })
], CustomerInvoiceHeader.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerInvoiceHeader.prototype, "originalInvoiceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SNS',
    })
], CustomerInvoiceHeader.prototype, "debitOrCredit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTATI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], CustomerInvoiceHeader.prototype, "totalAmountIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTNOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], CustomerInvoiceHeader.prototype, "totalAmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTNOTL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], CustomerInvoiceHeader.prototype, "totalAmountExcludingTaxInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTATIL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], CustomerInvoiceHeader.prototype, "totalAmountIncludingTaxInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VATDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], CustomerInvoiceHeader.prototype, "taxReferenceDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NBRTAX',
    })
], CustomerInvoiceHeader.prototype, "numberOfTaxes", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAINV',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.CustomerAddress,
    })
], CustomerInvoiceHeader.prototype, "billToCustomerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerInvoiceHeader.prototype, "billToCustomerPostalCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerInvoiceHeader.prototype, "billToCustomerCity", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerInvoiceHeader.prototype, "billToCustomerState", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], CustomerInvoiceHeader.prototype, "billToCustomerCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerInvoiceHeader.prototype, "billToCustomerCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BILVCR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerInvoiceHeader.prototype, "draftNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRSFAM',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 9,
            },
            control: {
                glossaryId: 9,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], CustomerInvoiceHeader.prototype, "stockMovementGroup", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FIY',
    })
], CustomerInvoiceHeader.prototype, "fiscalYear", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PER',
    })
], CustomerInvoiceHeader.prototype, "period", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STRDATSVC',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.SvcActivityCode],
    })
], CustomerInvoiceHeader.prototype, "serviceStartDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ENDDATSVC',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.SvcActivityCode],
    })
], CustomerInvoiceHeader.prototype, "serviceEndDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LASDATSVC',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.SvcActivityCode],
    })
], CustomerInvoiceHeader.prototype, "lastServiceAccountedDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WRHE',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Warehouse,
        serviceOptions: () => [sageX3System.serviceOptions.WrhActivityCode],
    })
], CustomerInvoiceHeader.prototype, "warehouse", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STARPT',
    })
], CustomerInvoiceHeader.prototype, "isPrinted", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ISEXTDOC',
        serviceOptions: () => [sageX3System.serviceOptions.DksActivityCode],
    })
], CustomerInvoiceHeader.prototype, "isExternalDocument", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BASDEP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], CustomerInvoiceHeader.prototype, "earlyDiscountOrLateChargeBasis", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BELVCS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KbeActivityCode],
    })
], CustomerInvoiceHeader.prototype, "versionControlSystemNumber", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ADRVAL',
        serviceOptions: () => [sageX3System.serviceOptions.LtaActivityCode],
    })
], CustomerInvoiceHeader.prototype, "isValidatedAddress", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SALPRITYP',
        dataType: () => sageX3MasterData.enums.priceAmountTaxTaxDatatype,
    })
], CustomerInvoiceHeader.prototype, "priceOrAmountTaxType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DCLEECNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.VattnActivityCode],
    })
], CustomerInvoiceHeader.prototype, "vatDeclarationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POREXPDCL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], CustomerInvoiceHeader.prototype, "exportDeclaration", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UMRNUM',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.Mandate,
        serviceOptions: () => [sageX3System.serviceOptions.SddActivityCode],
    })
], CustomerInvoiceHeader.prototype, "mandate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RCRNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerInvoiceHeader.prototype, "recurringNumber", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RCRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], CustomerInvoiceHeader.prototype, "recurringInvoicingDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NBRCPY',
    })
], CustomerInvoiceHeader.prototype, "numberOfCompanies", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CSHVAT',
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], CustomerInvoiceHeader.prototype, "cashVatTaxRule", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPADERNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], CustomerInvoiceHeader.prototype, "derCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FLD40REN',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 8300,
            },
            control: {
                glossaryId: 8300,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], CustomerInvoiceHeader.prototype, "field40Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FLD41REN',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 8301,
            },
            control: {
                glossaryId: 8301,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], CustomerInvoiceHeader.prototype, "field41Reason", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ORIDOCNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], CustomerInvoiceHeader.prototype, "originalDocumentNumber", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PERDEB',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], CustomerInvoiceHeader.prototype, "creditMemoReferenceStartDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PERFIN',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], CustomerInvoiceHeader.prototype, "creditMemoReferenceEndDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BVRREFNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KswActivityCode],
    })
], CustomerInvoiceHeader.prototype, "inPaymentSlipWithReferenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REVCANSTA',
        serviceOptions: () => [sageX3System.serviceOptions.InvcaActivityCode],
    })
], CustomerInvoiceHeader.prototype, "cancellationStatus", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PJTH',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
    })
], CustomerInvoiceHeader.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'METCOR',
        dataType: () => sageX3InvoicingData.enums.correctionMethodDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], CustomerInvoiceHeader.prototype, "correctionMethod", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerInvoiceHeader.prototype, "siteIdentificationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVTYPSPA',
        dataType: () => sageX3MasterData.enums.spanishInvoiceTypeDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], CustomerInvoiceHeader.prototype, "spanishInvoiceType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BUSPROTYP',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 207,
            },
            control: {
                glossaryId: 207,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], CustomerInvoiceHeader.prototype, "businessProcessType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BUSOPETYP',
        dataType: () => sageX3InvoicingData.enums.typeOfOperationDatatype,
    })
], CustomerInvoiceHeader.prototype, "operationType", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ISSBYREC',
        serviceOptions: () => [sageX3System.serviceOptions.CtswActivityCode],
    })
], CustomerInvoiceHeader.prototype, "autoInvoicingSpanish", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ISSBYRECG',
        serviceOptions: () => [sageX3System.serviceOptions.CtswActivityCode],
    })
], CustomerInvoiceHeader.prototype, "manualAutoInvoicingSpaGenerated", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ISSAUTGEN',
        serviceOptions: () => [sageX3System.serviceOptions.CtswActivityCode],
    })
], CustomerInvoiceHeader.prototype, "automaticAutoInvoicingSpaGenerated", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DESGEN',
        dataType: () => sageX3InvoicingData.enums.autoInvoiceRecipientDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.CtswActivityCode],
    })
], CustomerInvoiceHeader.prototype, "destinationGeneration", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VATDATSPA',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], CustomerInvoiceHeader.prototype, "spanishTaxDate", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3InvoicingData.nodes.CustomerInvoiceHeaderBillToCustomerAddressLines,
    })
], CustomerInvoiceHeader.prototype, "billToCustomerAddressLines", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3InvoicingData.nodes.CustomerInvoiceHeaderBillToCustomerCompanyNames,
    })
], CustomerInvoiceHeader.prototype, "billToCustomerCompanyNames", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3InvoicingData.nodes.CustomerInvoiceHeaderComments,
    })
], CustomerInvoiceHeader.prototype, "comments", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3InvoicingData.nodes.CustomerInvoiceHeaderPayByBusinessPartnerAddressLines,
    })
], CustomerInvoiceHeader.prototype, "payByBusinessPartnerAddressLines", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3InvoicingData.nodes.CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames,
    })
], CustomerInvoiceHeader.prototype, "payByBusinessPartnerCompanyNames", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3InvoicingData.nodes.CustomerInvoiceHeaderTaxes,
    })
], CustomerInvoiceHeader.prototype, "taxes", void 0);
exports.CustomerInvoiceHeader = CustomerInvoiceHeader = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SINVOICE',
        keyPropertyNames: ['id'],
        indexes: [
            {
                orderBy: {
                    id: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], CustomerInvoiceHeader);
//# sourceMappingURL=customer-invoice-header.js.map