declare module '@sage/x3-invoicing-data-api-partial' {
    import type {
        Address,
        BomCodes,
        BusinessPartner,
        BusinessPartnerAddress,
        BusinessPartnerCompanyExceptionInput,
        BusinessPartnerCompanyNames,
        BusinessPartnerCompanyNamesInput,
        Carrier,
        Currency,
        Customer,
        CustomerAddress,
        CustomerAddressInput,
        CustomerBankDetail,
        CustomerBankDetailInput,
        CustomerCashTaxRules,
        CustomerCashTaxRulesBinding,
        CustomerCashTaxRulesInput,
        CustomerCategory,
        CustomerContact,
        CustomerContactInput,
        CustomerInput,
        CustomerPaymentDays,
        CustomerPaymentDaysBinding,
        CustomerPaymentDaysInput,
        CustomerProduct,
        CustomerProductInput,
        CustomerSalesReps,
        CustomerSalesRepsBinding,
        CustomerSalesRepsInput,
        CustomerStatisticalGroups,
        CustomerStatisticalGroupsBinding,
        CustomerStatisticalGroupsInput,
        Incoterm,
        Mapping,
        Package as SageX3MasterData$Package,
        PrintTemplate,
        Product,
        ProductCategory,
        ProductCategoryInput,
        ProductCategoryStatisticalGroups,
        ProductCategoryStatisticalGroupsBinding,
        ProductCategoryStatisticalGroupsInput,
        ProductPackingUnits,
        ProductPackingUnitsBinding,
        ProductPackingUnitsInput,
        ProductSite,
        ProductStatisticalGroups,
        ProductStatisticalGroupsBinding,
        ProductStatisticalGroupsInput,
        ShipToCustomerAddress,
        ShipToCustomerAddressCompanyNames,
        ShipToCustomerAddressCompanyNamesBinding,
        ShipToCustomerAddressCompanyNamesInput,
        ShipToCustomerAddressInput,
        ShipToCustomerAddressSalesReps,
        ShipToCustomerAddressSalesRepsBinding,
        ShipToCustomerAddressSalesRepsInput,
        Supplier,
        SupplierAddress,
        SupplierAddressInput,
        SupplierCategory,
        SupplierContact,
        SupplierContactInput,
        SupplierInput,
        SupplierProduct,
        SupplierProductInput,
        TechnicalSheet,
        UnavailablePeriods,
        UnitOfMeasure,
    } from '@sage/x3-master-data-api';
    import type {
        CostType,
        Package as SageX3ProjectManagementData$Package,
        ProjectLink,
    } from '@sage/x3-project-management-data-api';
    import type {
        Package as SageX3StockData$Package,
        ProductCategoryDefaultLocations,
        ProductCategoryDefaultLocationsBinding,
        ProductCategoryDefaultLocationsInput,
        ProductCategoryOverheads,
        ProductCategoryOverheadsBinding,
        ProductCategoryOverheadsInput,
        ProductCategoryPackingUnits,
        ProductCategoryPackingUnitsBinding,
        ProductCategoryPackingUnitsInput,
        StockManagementRules,
        StockManagementRulesInput,
        Warehouse,
    } from '@sage/x3-stock-data-api';
    import type { Country, Package as SageX3Structure$Package, SiteGroupings } from '@sage/x3-structure-api';
    import type {
        Access,
        Company,
        GenericPrintReport,
        Language,
        MiscellaneousTable,
        Package as SageX3System$Package,
        Site,
        User,
    } from '@sage/x3-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        BinaryStream,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        QueryOperation,
        ReadOperation,
        TextStream,
        VitalClientNode,
        VitalClientNodeInput,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface AutoInvoiceRecipient$Enum {
        no: 1;
        company: 2;
        bp: 3;
    }
    export type AutoInvoiceRecipient = keyof AutoInvoiceRecipient$Enum;
    export interface CorrectionMethod$Enum {
        rectificacionIntegra: 1;
        rectificacionPorDiferencias: 2;
        rectificacionPorDescuentoPorVolumenDeOperacionesDuranteUnPeriodo: 3;
        autorizadasPorLaAgenciaTributaria: 4;
    }
    export type CorrectionMethod = keyof CorrectionMethod$Enum;
    export interface InvoiceType$Enum {
        invoice: 1;
        creditMemo: 2;
        debitNote: 3;
        creditNote: 4;
        proforma: 5;
    }
    export type InvoiceType = keyof InvoiceType$Enum;
    export interface MatchStatusEnum$Enum {
        notApplicable: 1;
        successful: 2;
        warning: 3;
        blocked: 4;
        unblocked: 5;
    }
    export type MatchStatusEnum = keyof MatchStatusEnum$Enum;
    export interface PeriodicityType$Enum {
        days: 1;
        week: 2;
        tenDayPeriod: 3;
        twoWeekPeriod: 4;
        month: 5;
    }
    export type PeriodicityType = keyof PeriodicityType$Enum;
    export interface PurchaseType$Enum {
        purchase: 1;
        fixedAsset: 2;
        services: 3;
    }
    export type PurchaseType = keyof PurchaseType$Enum;
    export interface PurchasingInvoiceStatus$Enum {
        pending: 1;
        toValidate: 2;
        validated: 3;
    }
    export type PurchasingInvoiceStatus = keyof PurchasingInvoiceStatus$Enum;
    export interface TypeOfOperation$Enum {
        goodsDelivery: 1;
        provisionOfServices: 2;
        mixedOperation: 3;
    }
    export type TypeOfOperation = keyof TypeOfOperation$Enum;
    export interface CustomerInvoiceHeaderBillToCustomerAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface CustomerInvoiceHeaderBillToCustomerAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        addressLine?: string;
    }
    export interface CustomerInvoiceHeaderBillToCustomerAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface CustomerInvoiceHeaderBillToCustomerAddressLines$Operations {
        query: QueryOperation<CustomerInvoiceHeaderBillToCustomerAddressLines>;
        read: ReadOperation<CustomerInvoiceHeaderBillToCustomerAddressLines>;
        aggregate: {
            read: AggregateReadOperation<CustomerInvoiceHeaderBillToCustomerAddressLines>;
            query: AggregateQueryOperation<CustomerInvoiceHeaderBillToCustomerAddressLines>;
        };
        getDefaults: GetDefaultsOperation<CustomerInvoiceHeaderBillToCustomerAddressLines>;
    }
    export interface CustomerInvoiceHeaderBillToCustomerCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface CustomerInvoiceHeaderBillToCustomerCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        companyName?: string;
    }
    export interface CustomerInvoiceHeaderBillToCustomerCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface CustomerInvoiceHeaderBillToCustomerCompanyNames$Operations {
        query: QueryOperation<CustomerInvoiceHeaderBillToCustomerCompanyNames>;
        read: ReadOperation<CustomerInvoiceHeaderBillToCustomerCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<CustomerInvoiceHeaderBillToCustomerCompanyNames>;
            query: AggregateQueryOperation<CustomerInvoiceHeaderBillToCustomerCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<CustomerInvoiceHeaderBillToCustomerCompanyNames>;
    }
    export interface CustomerInvoiceHeaderComments extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        comment: string;
    }
    export interface CustomerInvoiceHeaderCommentsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        comment?: string;
    }
    export interface CustomerInvoiceHeaderCommentsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        comment: string;
    }
    export interface CustomerInvoiceHeaderComments$Operations {
        query: QueryOperation<CustomerInvoiceHeaderComments>;
        read: ReadOperation<CustomerInvoiceHeaderComments>;
        aggregate: {
            read: AggregateReadOperation<CustomerInvoiceHeaderComments>;
            query: AggregateQueryOperation<CustomerInvoiceHeaderComments>;
        };
        getDefaults: GetDefaultsOperation<CustomerInvoiceHeaderComments>;
    }
    export interface CustomerInvoiceHeaderPayByBusinessPartnerAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface CustomerInvoiceHeaderPayByBusinessPartnerAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        addressLine?: string;
    }
    export interface CustomerInvoiceHeaderPayByBusinessPartnerAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface CustomerInvoiceHeaderPayByBusinessPartnerAddressLines$Operations {
        query: QueryOperation<CustomerInvoiceHeaderPayByBusinessPartnerAddressLines>;
        read: ReadOperation<CustomerInvoiceHeaderPayByBusinessPartnerAddressLines>;
        aggregate: {
            read: AggregateReadOperation<CustomerInvoiceHeaderPayByBusinessPartnerAddressLines>;
            query: AggregateQueryOperation<CustomerInvoiceHeaderPayByBusinessPartnerAddressLines>;
        };
        getDefaults: GetDefaultsOperation<CustomerInvoiceHeaderPayByBusinessPartnerAddressLines>;
    }
    export interface CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface CustomerInvoiceHeaderPayByBusinessPartnerCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        companyName?: string;
    }
    export interface CustomerInvoiceHeaderPayByBusinessPartnerCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames$Operations {
        query: QueryOperation<CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames>;
        read: ReadOperation<CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames>;
            query: AggregateQueryOperation<CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames>;
    }
    export interface CustomerInvoiceHeaderTaxes extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        tax: Tax;
        taxBasis: string;
        taxAmount: string;
        exemptionAmount: string;
        sageSalesTaxAmount: string;
    }
    export interface CustomerInvoiceHeaderTaxesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        tax?: string;
        taxBasis?: decimal | string;
        taxAmount?: decimal | string;
        exemptionAmount?: decimal | string;
        sageSalesTaxAmount?: decimal | string;
    }
    export interface CustomerInvoiceHeaderTaxesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        tax: Tax;
        taxBasis: string;
        taxAmount: string;
        exemptionAmount: string;
        sageSalesTaxAmount: string;
    }
    export interface CustomerInvoiceHeaderTaxes$Lookups {
        tax: QueryOperation<Tax>;
    }
    export interface CustomerInvoiceHeaderTaxes$Operations {
        query: QueryOperation<CustomerInvoiceHeaderTaxes>;
        read: ReadOperation<CustomerInvoiceHeaderTaxes>;
        aggregate: {
            read: AggregateReadOperation<CustomerInvoiceHeaderTaxes>;
            query: AggregateQueryOperation<CustomerInvoiceHeaderTaxes>;
        };
        lookups(dataOrId: string | { data: CustomerInvoiceHeaderTaxesInput }): CustomerInvoiceHeaderTaxes$Lookups;
        getDefaults: GetDefaultsOperation<CustomerInvoiceHeaderTaxes>;
    }
    export interface CustomerInvoiceHeader extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        category: InvoiceType;
        sourceModule: ModuleTable;
        billToCustomer: Customer;
        control: string;
        company: Company;
        financialSite: Site;
        accountingDate: string;
        internalNumber: integer;
        sourceDocumentDate: string;
        sourceDocument: string;
        currency: Currency;
        rateType: ExchangeRateType;
        rateDate: string;
        payByBusinessPartner: BusinessPartner;
        payByBusinessPartnerAddress: BusinessPartnerAddress;
        payByBusinessPartnerPostalCode: string;
        payByBusinessPartnerCity: string;
        payByBusinessPartnerState: string;
        payByBusinessPartnerCountry: Country;
        payByBusinessPartnerCountryName: string;
        dueDateCalculationStartDate: string;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        earlyDiscountOrLateChargeRate: string;
        taxRule: TaxRule;
        entityUserCode: MiscellaneousTable;
        isDirectInvoice: boolean;
        intrastatProcessingNumber: integer;
        status: InvoiceStatus;
        originalInvoiceNumber: string;
        debitOrCredit: integer;
        totalAmountIncludingTax: string;
        totalAmountExcludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        taxReferenceDate: string;
        numberOfTaxes: integer;
        billToCustomerAddress: CustomerAddress;
        billToCustomerPostalCode: string;
        billToCustomerCity: string;
        billToCustomerState: string;
        billToCustomerCountry: Country;
        billToCustomerCountryName: string;
        draftNumber: string;
        stockMovementGroup: MiscellaneousTable;
        fiscalYear: integer;
        period: integer;
        serviceStartDate: string;
        serviceEndDate: string;
        lastServiceAccountedDate: string;
        warehouse: Warehouse;
        isPrinted: boolean;
        isExternalDocument: boolean;
        earlyDiscountOrLateChargeBasis: string;
        versionControlSystemNumber: string;
        isValidatedAddress: boolean;
        priceOrAmountTaxType: PriceAmountTaxTax;
        vatDeclarationNumber: string;
        exportDeclaration: string;
        mandate: Mandate;
        recurringNumber: string;
        recurringInvoicingDate: string;
        numberOfCompanies: integer;
        cashVatTaxRule: boolean;
        derCode: string;
        field40Reason: MiscellaneousTable;
        field41Reason: MiscellaneousTable;
        originalDocumentNumber: string;
        creditMemoReferenceStartDate: string;
        creditMemoReferenceEndDate: string;
        inPaymentSlipWithReferenceNumber: string;
        cancellationStatus: integer;
        project: ProjectLink;
        correctionMethod: CorrectionMethod;
        siteIdentificationNumber: string;
        spanishInvoiceType: SpanishInvoiceType;
        businessProcessType: MiscellaneousTable;
        operationType: TypeOfOperation;
        autoInvoicingSpanish: boolean;
        manualAutoInvoicingSpaGenerated: boolean;
        automaticAutoInvoicingSpaGenerated: boolean;
        destinationGeneration: AutoInvoiceRecipient;
        spanishTaxDate: string;
        billToCustomerAddressLines: ClientCollection<CustomerInvoiceHeaderBillToCustomerAddressLines>;
        billToCustomerCompanyNames: ClientCollection<CustomerInvoiceHeaderBillToCustomerCompanyNames>;
        comments: ClientCollection<CustomerInvoiceHeaderComments>;
        payByBusinessPartnerAddressLines: ClientCollection<CustomerInvoiceHeaderPayByBusinessPartnerAddressLines>;
        payByBusinessPartnerCompanyNames: ClientCollection<CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames>;
        taxes: ClientCollection<CustomerInvoiceHeaderTaxes>;
    }
    export interface CustomerInvoiceHeaderInput extends ClientNodeInput {
        id?: string;
        category?: InvoiceType;
        sourceModule?: ModuleTable;
        billToCustomer?: string;
        control?: string;
        company?: string;
        financialSite?: string;
        accountingDate?: string;
        internalNumber?: integer | string;
        sourceDocumentDate?: string;
        sourceDocument?: string;
        currency?: string;
        rateType?: ExchangeRateType;
        rateDate?: string;
        payByBusinessPartner?: string;
        payByBusinessPartnerAddress?: string;
        payByBusinessPartnerPostalCode?: string;
        payByBusinessPartnerCity?: string;
        payByBusinessPartnerState?: string;
        payByBusinessPartnerCountry?: string;
        payByBusinessPartnerCountryName?: string;
        dueDateCalculationStartDate?: string;
        paymentTerm?: string;
        earlyDiscountOrLateCharge?: string;
        earlyDiscountOrLateChargeRate?: decimal | string;
        taxRule?: string;
        entityUserCode?: string;
        isDirectInvoice?: boolean | string;
        intrastatProcessingNumber?: integer | string;
        status?: InvoiceStatus;
        originalInvoiceNumber?: string;
        debitOrCredit?: integer | string;
        totalAmountIncludingTax?: decimal | string;
        totalAmountExcludingTax?: decimal | string;
        totalAmountExcludingTaxInCompanyCurrency?: decimal | string;
        totalAmountIncludingTaxInCompanyCurrency?: decimal | string;
        taxReferenceDate?: string;
        numberOfTaxes?: integer | string;
        billToCustomerAddress?: string;
        billToCustomerPostalCode?: string;
        billToCustomerCity?: string;
        billToCustomerState?: string;
        billToCustomerCountry?: string;
        billToCustomerCountryName?: string;
        draftNumber?: string;
        stockMovementGroup?: string;
        fiscalYear?: integer | string;
        period?: integer | string;
        serviceStartDate?: string;
        serviceEndDate?: string;
        lastServiceAccountedDate?: string;
        warehouse?: string;
        isPrinted?: boolean | string;
        isExternalDocument?: boolean | string;
        earlyDiscountOrLateChargeBasis?: decimal | string;
        versionControlSystemNumber?: string;
        isValidatedAddress?: boolean | string;
        priceOrAmountTaxType?: PriceAmountTaxTax;
        vatDeclarationNumber?: string;
        exportDeclaration?: string;
        mandate?: string;
        recurringNumber?: string;
        recurringInvoicingDate?: string;
        numberOfCompanies?: integer | string;
        cashVatTaxRule?: boolean | string;
        derCode?: string;
        field40Reason?: string;
        field41Reason?: string;
        originalDocumentNumber?: string;
        creditMemoReferenceStartDate?: string;
        creditMemoReferenceEndDate?: string;
        inPaymentSlipWithReferenceNumber?: string;
        cancellationStatus?: integer | string;
        project?: string;
        correctionMethod?: CorrectionMethod;
        siteIdentificationNumber?: string;
        spanishInvoiceType?: SpanishInvoiceType;
        businessProcessType?: string;
        operationType?: TypeOfOperation;
        autoInvoicingSpanish?: boolean | string;
        manualAutoInvoicingSpaGenerated?: boolean | string;
        automaticAutoInvoicingSpaGenerated?: boolean | string;
        destinationGeneration?: AutoInvoiceRecipient;
        spanishTaxDate?: string;
        billToCustomerAddressLines?: Partial<CustomerInvoiceHeaderBillToCustomerAddressLinesInput>[];
        billToCustomerCompanyNames?: Partial<CustomerInvoiceHeaderBillToCustomerCompanyNamesInput>[];
        comments?: Partial<CustomerInvoiceHeaderCommentsInput>[];
        payByBusinessPartnerAddressLines?: Partial<CustomerInvoiceHeaderPayByBusinessPartnerAddressLinesInput>[];
        payByBusinessPartnerCompanyNames?: Partial<CustomerInvoiceHeaderPayByBusinessPartnerCompanyNamesInput>[];
        taxes?: Partial<CustomerInvoiceHeaderTaxesInput>[];
    }
    export interface CustomerInvoiceHeaderBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        category: InvoiceType;
        sourceModule: ModuleTable;
        billToCustomer: Customer;
        control: string;
        company: Company;
        financialSite: Site;
        accountingDate: string;
        internalNumber: integer;
        sourceDocumentDate: string;
        sourceDocument: string;
        currency: Currency;
        rateType: ExchangeRateType;
        rateDate: string;
        payByBusinessPartner: BusinessPartner;
        payByBusinessPartnerAddress: BusinessPartnerAddress;
        payByBusinessPartnerPostalCode: string;
        payByBusinessPartnerCity: string;
        payByBusinessPartnerState: string;
        payByBusinessPartnerCountry: Country;
        payByBusinessPartnerCountryName: string;
        dueDateCalculationStartDate: string;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        earlyDiscountOrLateChargeRate: string;
        taxRule: TaxRule;
        entityUserCode: MiscellaneousTable;
        isDirectInvoice: boolean;
        intrastatProcessingNumber: integer;
        status: InvoiceStatus;
        originalInvoiceNumber: string;
        debitOrCredit: integer;
        totalAmountIncludingTax: string;
        totalAmountExcludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        taxReferenceDate: string;
        numberOfTaxes: integer;
        billToCustomerAddress: CustomerAddress;
        billToCustomerPostalCode: string;
        billToCustomerCity: string;
        billToCustomerState: string;
        billToCustomerCountry: Country;
        billToCustomerCountryName: string;
        draftNumber: string;
        stockMovementGroup: MiscellaneousTable;
        fiscalYear: integer;
        period: integer;
        serviceStartDate: string;
        serviceEndDate: string;
        lastServiceAccountedDate: string;
        warehouse: Warehouse;
        isPrinted: boolean;
        isExternalDocument: boolean;
        earlyDiscountOrLateChargeBasis: string;
        versionControlSystemNumber: string;
        isValidatedAddress: boolean;
        priceOrAmountTaxType: PriceAmountTaxTax;
        vatDeclarationNumber: string;
        exportDeclaration: string;
        mandate: Mandate;
        recurringNumber: string;
        recurringInvoicingDate: string;
        numberOfCompanies: integer;
        cashVatTaxRule: boolean;
        derCode: string;
        field40Reason: MiscellaneousTable;
        field41Reason: MiscellaneousTable;
        originalDocumentNumber: string;
        creditMemoReferenceStartDate: string;
        creditMemoReferenceEndDate: string;
        inPaymentSlipWithReferenceNumber: string;
        cancellationStatus: integer;
        project: ProjectLink;
        correctionMethod: CorrectionMethod;
        siteIdentificationNumber: string;
        spanishInvoiceType: SpanishInvoiceType;
        businessProcessType: MiscellaneousTable;
        operationType: TypeOfOperation;
        autoInvoicingSpanish: boolean;
        manualAutoInvoicingSpaGenerated: boolean;
        automaticAutoInvoicingSpaGenerated: boolean;
        destinationGeneration: AutoInvoiceRecipient;
        spanishTaxDate: string;
        billToCustomerAddressLines: ClientCollection<CustomerInvoiceHeaderBillToCustomerAddressLinesBinding>;
        billToCustomerCompanyNames: ClientCollection<CustomerInvoiceHeaderBillToCustomerCompanyNamesBinding>;
        comments: ClientCollection<CustomerInvoiceHeaderCommentsBinding>;
        payByBusinessPartnerAddressLines: ClientCollection<CustomerInvoiceHeaderPayByBusinessPartnerAddressLinesBinding>;
        payByBusinessPartnerCompanyNames: ClientCollection<CustomerInvoiceHeaderPayByBusinessPartnerCompanyNamesBinding>;
        taxes: ClientCollection<CustomerInvoiceHeaderTaxesBinding>;
    }
    export interface CustomerInvoiceHeader$Lookups {
        billToCustomer: QueryOperation<Customer>;
        company: QueryOperation<Company>;
        financialSite: QueryOperation<Site>;
        currency: QueryOperation<Currency>;
        payByBusinessPartner: QueryOperation<BusinessPartner>;
        payByBusinessPartnerAddress: QueryOperation<BusinessPartnerAddress>;
        payByBusinessPartnerCountry: QueryOperation<Country>;
        paymentTerm: QueryOperation<PaymentTerm>;
        earlyDiscountOrLateCharge: QueryOperation<EarlyDiscountLateCharge>;
        taxRule: QueryOperation<TaxRule>;
        entityUserCode: QueryOperation<MiscellaneousTable>;
        billToCustomerAddress: QueryOperation<CustomerAddress>;
        billToCustomerCountry: QueryOperation<Country>;
        stockMovementGroup: QueryOperation<MiscellaneousTable>;
        warehouse: QueryOperation<Warehouse>;
        mandate: QueryOperation<Mandate>;
        field40Reason: QueryOperation<MiscellaneousTable>;
        field41Reason: QueryOperation<MiscellaneousTable>;
        project: QueryOperation<ProjectLink>;
        businessProcessType: QueryOperation<MiscellaneousTable>;
    }
    export interface CustomerInvoiceHeader$Operations {
        query: QueryOperation<CustomerInvoiceHeader>;
        read: ReadOperation<CustomerInvoiceHeader>;
        aggregate: {
            read: AggregateReadOperation<CustomerInvoiceHeader>;
            query: AggregateQueryOperation<CustomerInvoiceHeader>;
        };
        lookups(dataOrId: string | { data: CustomerInvoiceHeaderInput }): CustomerInvoiceHeader$Lookups;
        getDefaults: GetDefaultsOperation<CustomerInvoiceHeader>;
    }
    export interface CustomerInvoicingElements extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        percentageOrAmount: string;
        invoicingElement: SalesInvoicingElement;
    }
    export interface CustomerInvoicingElementsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        percentageOrAmount?: decimal | string;
        invoicingElement?: integer | string;
    }
    export interface CustomerInvoicingElementsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        percentageOrAmount: string;
        invoicingElement: SalesInvoicingElement;
    }
    export interface CustomerInvoicingElements$Lookups {
        invoicingElement: QueryOperation<SalesInvoicingElement>;
    }
    export interface CustomerInvoicingElements$Operations {
        query: QueryOperation<CustomerInvoicingElements>;
        read: ReadOperation<CustomerInvoicingElements>;
        aggregate: {
            read: AggregateReadOperation<CustomerInvoicingElements>;
            query: AggregateQueryOperation<CustomerInvoicingElements>;
        };
        lookups(dataOrId: string | { data: CustomerInvoicingElementsInput }): CustomerInvoicingElements$Lookups;
        getDefaults: GetDefaultsOperation<CustomerInvoicingElements>;
    }
    export interface EarlyDiscountLateCharge extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface EarlyDiscountLateChargeInput extends ClientNodeInput {
        code?: string;
        legislation?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface EarlyDiscountLateChargeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface EarlyDiscountLateCharge$Lookups {
        legislation: QueryOperation<MiscellaneousTable>;
    }
    export interface EarlyDiscountLateCharge$Operations {
        query: QueryOperation<EarlyDiscountLateCharge>;
        read: ReadOperation<EarlyDiscountLateCharge>;
        aggregate: {
            read: AggregateReadOperation<EarlyDiscountLateCharge>;
            query: AggregateQueryOperation<EarlyDiscountLateCharge>;
        };
        lookups(dataOrId: string | { data: EarlyDiscountLateChargeInput }): EarlyDiscountLateCharge$Lookups;
        getDefaults: GetDefaultsOperation<EarlyDiscountLateCharge>;
    }
    export interface InvoicingTerm extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface InvoicingTermInput extends ClientNodeInput {
        code?: string;
        legislation?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface InvoicingTermBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface InvoicingTerm$Lookups {
        legislation: QueryOperation<MiscellaneousTable>;
    }
    export interface InvoicingTerm$Operations {
        query: QueryOperation<InvoicingTerm>;
        read: ReadOperation<InvoicingTerm>;
        aggregate: {
            read: AggregateReadOperation<InvoicingTerm>;
            query: AggregateQueryOperation<InvoicingTerm>;
        };
        lookups(dataOrId: string | { data: InvoicingTermInput }): InvoicingTerm$Lookups;
        getDefaults: GetDefaultsOperation<InvoicingTerm>;
    }
    export interface Mandate extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        company: Company;
        code: string;
        description: string;
        customer: BusinessPartner;
    }
    export interface MandateInput extends ClientNodeInput {
        company?: string;
        code?: string;
        description?: string;
        customer?: string;
    }
    export interface MandateBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        company: Company;
        code: string;
        description: string;
        customer: BusinessPartner;
    }
    export interface Mandate$Lookups {
        company: QueryOperation<Company>;
        customer: QueryOperation<BusinessPartner>;
    }
    export interface Mandate$Operations {
        query: QueryOperation<Mandate>;
        read: ReadOperation<Mandate>;
        aggregate: {
            read: AggregateReadOperation<Mandate>;
            query: AggregateQueryOperation<Mandate>;
        };
        lookups(dataOrId: string | { data: MandateInput }): Mandate$Lookups;
        getDefaults: GetDefaultsOperation<Mandate>;
    }
    export interface PaymentMethod extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface PaymentMethodInput extends ClientNodeInput {
        code?: string;
        legislation?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface PaymentMethodBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface PaymentMethod$Lookups {
        legislation: QueryOperation<MiscellaneousTable>;
    }
    export interface PaymentMethod$Operations {
        query: QueryOperation<PaymentMethod>;
        read: ReadOperation<PaymentMethod>;
        aggregate: {
            read: AggregateReadOperation<PaymentMethod>;
            query: AggregateQueryOperation<PaymentMethod>;
        };
        lookups(dataOrId: string | { data: PaymentMethodInput }): PaymentMethod$Lookups;
        getDefaults: GetDefaultsOperation<PaymentMethod>;
    }
    export interface PaymentTerm extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        line: integer;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface PaymentTermInput extends ClientNodeInput {
        code?: string;
        legislation?: string;
        line?: integer | string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface PaymentTermBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        line: integer;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface PaymentTerm$Lookups {
        legislation: QueryOperation<MiscellaneousTable>;
    }
    export interface PaymentTerm$Operations {
        query: QueryOperation<PaymentTerm>;
        read: ReadOperation<PaymentTerm>;
        aggregate: {
            read: AggregateReadOperation<PaymentTerm>;
            query: AggregateQueryOperation<PaymentTerm>;
        };
        lookups(dataOrId: string | { data: PaymentTermInput }): PaymentTerm$Lookups;
        getDefaults: GetDefaultsOperation<PaymentTerm>;
    }
    export interface PriceStructureLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        customerOrSupplier: SupplierCustomerType;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        description: string;
        increaseOrDecrease: IncreaseDecrease;
        valueType: DiscountCalculationRules;
        calculationBasis: ChargeDiscountCalculation;
    }
    export interface PriceStructureLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        customerOrSupplier?: SupplierCustomerType;
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        description?: string;
        increaseOrDecrease?: IncreaseDecrease;
        valueType?: DiscountCalculationRules;
        calculationBasis?: ChargeDiscountCalculation;
    }
    export interface PriceStructureLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        customerOrSupplier: SupplierCustomerType;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        description: string;
        increaseOrDecrease: IncreaseDecrease;
        valueType: DiscountCalculationRules;
        calculationBasis: ChargeDiscountCalculation;
    }
    export interface PriceStructureLines$Operations {
        query: QueryOperation<PriceStructureLines>;
        read: ReadOperation<PriceStructureLines>;
        aggregate: {
            read: AggregateReadOperation<PriceStructureLines>;
            query: AggregateQueryOperation<PriceStructureLines>;
        };
        getDefaults: GetDefaultsOperation<PriceStructureLines>;
    }
    export interface PriceStructure extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        customerOrSupplier: SupplierCustomerType;
        code: string;
        alphaNumericNumber: string;
        lines: ClientCollection<PriceStructureLines>;
    }
    export interface PriceStructureInput extends ClientNodeInput {
        customerOrSupplier?: SupplierCustomerType;
        code?: string;
        alphaNumericNumber?: string;
        lines?: Partial<PriceStructureLinesInput>[];
    }
    export interface PriceStructureBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        customerOrSupplier: SupplierCustomerType;
        code: string;
        alphaNumericNumber: string;
        lines: ClientCollection<PriceStructureLinesBinding>;
    }
    export interface PriceStructure$Operations {
        query: QueryOperation<PriceStructure>;
        read: ReadOperation<PriceStructure>;
        aggregate: {
            read: AggregateReadOperation<PriceStructure>;
            query: AggregateQueryOperation<PriceStructure>;
        };
        getDefaults: GetDefaultsOperation<PriceStructure>;
    }
    export interface ProductCategoryTaxLevels extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        stockSite: string;
        code: string;
        taxLevel: TaxLevel;
    }
    export interface ProductCategoryTaxLevelsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        stockSite?: string;
        code?: string;
        taxLevel?: string;
    }
    export interface ProductCategoryTaxLevelsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        stockSite: string;
        code: string;
        taxLevel: TaxLevel;
    }
    export interface ProductCategoryTaxLevels$Lookups {
        taxLevel: QueryOperation<TaxLevel>;
    }
    export interface ProductCategoryTaxLevels$Operations {
        query: QueryOperation<ProductCategoryTaxLevels>;
        read: ReadOperation<ProductCategoryTaxLevels>;
        aggregate: {
            read: AggregateReadOperation<ProductCategoryTaxLevels>;
            query: AggregateQueryOperation<ProductCategoryTaxLevels>;
        };
        lookups(dataOrId: string | { data: ProductCategoryTaxLevelsInput }): ProductCategoryTaxLevels$Lookups;
        getDefaults: GetDefaultsOperation<ProductCategoryTaxLevels>;
    }
    export interface ProductTaxLevels extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        taxLevel: TaxLevel;
    }
    export interface ProductTaxLevelsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        taxLevel?: string;
    }
    export interface ProductTaxLevelsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        taxLevel: TaxLevel;
    }
    export interface ProductTaxLevels$Lookups {
        taxLevel: QueryOperation<TaxLevel>;
    }
    export interface ProductTaxLevels$Operations {
        query: QueryOperation<ProductTaxLevels>;
        read: ReadOperation<ProductTaxLevels>;
        aggregate: {
            read: AggregateReadOperation<ProductTaxLevels>;
            query: AggregateQueryOperation<ProductTaxLevels>;
        };
        lookups(dataOrId: string | { data: ProductTaxLevelsInput }): ProductTaxLevels$Lookups;
        getDefaults: GetDefaultsOperation<ProductTaxLevels>;
    }
    export interface PurchaseInvoicingElement extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: integer;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface PurchaseInvoicingElementInput extends ClientNodeInput {
        code?: integer | string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface PurchaseInvoicingElementBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: integer;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface PurchaseInvoicingElement$Operations {
        query: QueryOperation<PurchaseInvoicingElement>;
        read: ReadOperation<PurchaseInvoicingElement>;
        aggregate: {
            read: AggregateReadOperation<PurchaseInvoicingElement>;
            query: AggregateQueryOperation<PurchaseInvoicingElement>;
        };
        getDefaults: GetDefaultsOperation<PurchaseInvoicingElement>;
    }
    export interface SalesInvoicingElement extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: integer;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface SalesInvoicingElementInput extends ClientNodeInput {
        code?: integer | string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface SalesInvoicingElementBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: integer;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface SalesInvoicingElement$Operations {
        query: QueryOperation<SalesInvoicingElement>;
        read: ReadOperation<SalesInvoicingElement>;
        aggregate: {
            read: AggregateReadOperation<SalesInvoicingElement>;
            query: AggregateQueryOperation<SalesInvoicingElement>;
        };
        getDefaults: GetDefaultsOperation<SalesInvoicingElement>;
    }
    export interface SupplierInvoiceHeaderBillBySupplierAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SupplierInvoiceHeaderBillBySupplierAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        addressLine?: string;
    }
    export interface SupplierInvoiceHeaderBillBySupplierAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SupplierInvoiceHeaderBillBySupplierAddressLines$Operations {
        query: QueryOperation<SupplierInvoiceHeaderBillBySupplierAddressLines>;
        read: ReadOperation<SupplierInvoiceHeaderBillBySupplierAddressLines>;
        aggregate: {
            read: AggregateReadOperation<SupplierInvoiceHeaderBillBySupplierAddressLines>;
            query: AggregateQueryOperation<SupplierInvoiceHeaderBillBySupplierAddressLines>;
        };
        getDefaults: GetDefaultsOperation<SupplierInvoiceHeaderBillBySupplierAddressLines>;
    }
    export interface SupplierInvoiceHeaderBillBySupplierCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SupplierInvoiceHeaderBillBySupplierCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        companyName?: string;
    }
    export interface SupplierInvoiceHeaderBillBySupplierCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SupplierInvoiceHeaderBillBySupplierCompanyNames$Operations {
        query: QueryOperation<SupplierInvoiceHeaderBillBySupplierCompanyNames>;
        read: ReadOperation<SupplierInvoiceHeaderBillBySupplierCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<SupplierInvoiceHeaderBillBySupplierCompanyNames>;
            query: AggregateQueryOperation<SupplierInvoiceHeaderBillBySupplierCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<SupplierInvoiceHeaderBillBySupplierCompanyNames>;
    }
    export interface SupplierInvoiceHeaderComments extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        comment: string;
    }
    export interface SupplierInvoiceHeaderCommentsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        comment?: string;
    }
    export interface SupplierInvoiceHeaderCommentsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        comment: string;
    }
    export interface SupplierInvoiceHeaderComments$Operations {
        query: QueryOperation<SupplierInvoiceHeaderComments>;
        read: ReadOperation<SupplierInvoiceHeaderComments>;
        aggregate: {
            read: AggregateReadOperation<SupplierInvoiceHeaderComments>;
            query: AggregateQueryOperation<SupplierInvoiceHeaderComments>;
        };
        getDefaults: GetDefaultsOperation<SupplierInvoiceHeaderComments>;
    }
    export interface SupplierInvoiceHeaderPayToBusinessPartnerAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SupplierInvoiceHeaderPayToBusinessPartnerAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        addressLine?: string;
    }
    export interface SupplierInvoiceHeaderPayToBusinessPartnerAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface SupplierInvoiceHeaderPayToBusinessPartnerAddressLines$Operations {
        query: QueryOperation<SupplierInvoiceHeaderPayToBusinessPartnerAddressLines>;
        read: ReadOperation<SupplierInvoiceHeaderPayToBusinessPartnerAddressLines>;
        aggregate: {
            read: AggregateReadOperation<SupplierInvoiceHeaderPayToBusinessPartnerAddressLines>;
            query: AggregateQueryOperation<SupplierInvoiceHeaderPayToBusinessPartnerAddressLines>;
        };
        getDefaults: GetDefaultsOperation<SupplierInvoiceHeaderPayToBusinessPartnerAddressLines>;
    }
    export interface SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SupplierInvoiceHeaderPayToBusinessPartnerCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        companyName?: string;
    }
    export interface SupplierInvoiceHeaderPayToBusinessPartnerCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames$Operations {
        query: QueryOperation<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames>;
        read: ReadOperation<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames>;
            query: AggregateQueryOperation<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames>;
    }
    export interface SupplierInvoiceHeaderTaxes extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        tax: Tax;
        taxBasis: string;
        taxAmount: string;
        deductibleTax: string;
        purchaseType: PurchaseType;
    }
    export interface SupplierInvoiceHeaderTaxesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        tax?: string;
        taxBasis?: decimal | string;
        taxAmount?: decimal | string;
        deductibleTax?: decimal | string;
        purchaseType?: PurchaseType;
    }
    export interface SupplierInvoiceHeaderTaxesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        tax: Tax;
        taxBasis: string;
        taxAmount: string;
        deductibleTax: string;
        purchaseType: PurchaseType;
    }
    export interface SupplierInvoiceHeaderTaxes$Lookups {
        tax: QueryOperation<Tax>;
    }
    export interface SupplierInvoiceHeaderTaxes$Operations {
        query: QueryOperation<SupplierInvoiceHeaderTaxes>;
        read: ReadOperation<SupplierInvoiceHeaderTaxes>;
        aggregate: {
            read: AggregateReadOperation<SupplierInvoiceHeaderTaxes>;
            query: AggregateQueryOperation<SupplierInvoiceHeaderTaxes>;
        };
        lookups(dataOrId: string | { data: SupplierInvoiceHeaderTaxesInput }): SupplierInvoiceHeaderTaxes$Lookups;
        getDefaults: GetDefaultsOperation<SupplierInvoiceHeaderTaxes>;
    }
    export interface SupplierInvoiceHeader extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        category: InvoiceType;
        purchaseInvoiceCategory: PurchaseInvoiceCategory;
        sourceModule: ModuleTable;
        billBySupplier: Supplier;
        control: string;
        company: Company;
        site: Site;
        accountingDate: string;
        internalNumber: integer;
        internalReference: string;
        sourceDocumentDate: string;
        sourceDocument: string;
        currency: Currency;
        rateType: ExchangeRateType;
        rateDate: string;
        isDAS2Submitted: boolean;
        payToBusinessPartner: BusinessPartner;
        dueDateCalculationStartDate: string;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        earlyDiscountOrLateChargeRate: string;
        taxRule: TaxRule;
        isEuropeanUnionInvoice: boolean;
        intrastatProcessingNumber: integer;
        status: PurchasingInvoiceStatus;
        paymentApproval: PaymentApprovalType;
        originalInvoiceNumber: string;
        debitOrCredit: integer;
        totalAmountIncludingTax: string;
        totalAmountExcludingTax: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        taxReferenceDate: string;
        numberOfTaxes: integer;
        billBySupplierAddress: SupplierAddress;
        billBySupplierPostalCode: string;
        billBySupplierCity: string;
        billBySupplierState: string;
        billBySupplierCountry: Country;
        billBySupplierCountryName: string;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        payToBusinessPartnerPostalCode: string;
        payToBusinessPartnerCity: string;
        payToBusinessPartnerState: string;
        payToBusinessPartnerCountry: Country;
        payToBusinessPartnerCountryName: string;
        incoterm: Incoterm;
        incotermTown: string;
        intrastatTransportLocation: CountryLocation;
        europeanUnionIdentification: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: SupplierAddress;
        fiscalYear: integer;
        period: integer;
        serviceStartDate: string;
        serviceEndDate: string;
        lastServiceAccountedDate: string;
        unblockUser: User;
        unblockDate: string;
        unblockAmount: string;
        matchStatus: MatchStatusEnum;
        earlyDiscountOrLateChargeBasis: string;
        priceOrAmountType: PriceAmountTaxTax;
        singleCustomsDocumentDate: string;
        singleCustomsDocumentReference: string;
        singleCustomsDocumentBusinessPartnerCode: Supplier;
        derCode: string;
        versionControlSystemNumber: string;
        priceOrAmountTaxType: PriceAmountTaxTax;
        recurringNumber: string;
        importTaxAmountNumber: string;
        recurringInvoicingDate: string;
        numberOfCompanies: integer;
        cashVatTaxRule: boolean;
        field40Reason: MiscellaneousTable;
        field41Reason: MiscellaneousTable;
        originalDocumentNumber: string;
        inPaymentSlipWithReferenceLine: string;
        bankId: string;
        project: ProjectLink;
        numberOfInvoiceCopies: integer;
        billBySupplierAddressLines: ClientCollection<SupplierInvoiceHeaderBillBySupplierAddressLines>;
        billBySupplierCompanyNames: ClientCollection<SupplierInvoiceHeaderBillBySupplierCompanyNames>;
        comments: ClientCollection<SupplierInvoiceHeaderComments>;
        payToBusinessPartnerAddressLines: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerAddressLines>;
        payToBusinessPartnerCompanyNames: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames>;
        taxes: ClientCollection<SupplierInvoiceHeaderTaxes>;
    }
    export interface SupplierInvoiceHeaderInput extends ClientNodeInput {
        id?: string;
        category?: InvoiceType;
        purchaseInvoiceCategory?: PurchaseInvoiceCategory;
        sourceModule?: ModuleTable;
        billBySupplier?: string;
        control?: string;
        company?: string;
        site?: string;
        accountingDate?: string;
        internalNumber?: integer | string;
        internalReference?: string;
        sourceDocumentDate?: string;
        sourceDocument?: string;
        currency?: string;
        rateType?: ExchangeRateType;
        rateDate?: string;
        isDAS2Submitted?: boolean | string;
        payToBusinessPartner?: string;
        dueDateCalculationStartDate?: string;
        paymentTerm?: string;
        earlyDiscountOrLateCharge?: string;
        earlyDiscountOrLateChargeRate?: decimal | string;
        taxRule?: string;
        isEuropeanUnionInvoice?: boolean | string;
        intrastatProcessingNumber?: integer | string;
        status?: PurchasingInvoiceStatus;
        paymentApproval?: PaymentApprovalType;
        originalInvoiceNumber?: string;
        debitOrCredit?: integer | string;
        totalAmountIncludingTax?: decimal | string;
        totalAmountExcludingTax?: decimal | string;
        totalAmountIncludingTaxInCompanyCurrency?: decimal | string;
        totalAmountExcludingTaxInCompanyCurrency?: decimal | string;
        taxReferenceDate?: string;
        numberOfTaxes?: integer | string;
        billBySupplierAddress?: string;
        billBySupplierPostalCode?: string;
        billBySupplierCity?: string;
        billBySupplierState?: string;
        billBySupplierCountry?: string;
        billBySupplierCountryName?: string;
        payToBusinessPartnerAddress?: string;
        payToBusinessPartnerPostalCode?: string;
        payToBusinessPartnerCity?: string;
        payToBusinessPartnerState?: string;
        payToBusinessPartnerCountry?: string;
        payToBusinessPartnerCountryName?: string;
        incoterm?: string;
        incotermTown?: string;
        intrastatTransportLocation?: CountryLocation;
        europeanUnionIdentification?: string;
        forwardingAgent?: string;
        forwardingAgentAddress?: string;
        fiscalYear?: integer | string;
        period?: integer | string;
        serviceStartDate?: string;
        serviceEndDate?: string;
        lastServiceAccountedDate?: string;
        unblockUser?: string;
        unblockDate?: string;
        unblockAmount?: decimal | string;
        matchStatus?: MatchStatusEnum;
        earlyDiscountOrLateChargeBasis?: decimal | string;
        priceOrAmountType?: PriceAmountTaxTax;
        singleCustomsDocumentDate?: string;
        singleCustomsDocumentReference?: string;
        singleCustomsDocumentBusinessPartnerCode?: string;
        derCode?: string;
        versionControlSystemNumber?: string;
        priceOrAmountTaxType?: PriceAmountTaxTax;
        recurringNumber?: string;
        importTaxAmountNumber?: string;
        recurringInvoicingDate?: string;
        numberOfCompanies?: integer | string;
        cashVatTaxRule?: boolean | string;
        field40Reason?: string;
        field41Reason?: string;
        originalDocumentNumber?: string;
        inPaymentSlipWithReferenceLine?: string;
        bankId?: string;
        project?: string;
        numberOfInvoiceCopies?: integer | string;
        billBySupplierAddressLines?: Partial<SupplierInvoiceHeaderBillBySupplierAddressLinesInput>[];
        billBySupplierCompanyNames?: Partial<SupplierInvoiceHeaderBillBySupplierCompanyNamesInput>[];
        comments?: Partial<SupplierInvoiceHeaderCommentsInput>[];
        payToBusinessPartnerAddressLines?: Partial<SupplierInvoiceHeaderPayToBusinessPartnerAddressLinesInput>[];
        payToBusinessPartnerCompanyNames?: Partial<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNamesInput>[];
        taxes?: Partial<SupplierInvoiceHeaderTaxesInput>[];
    }
    export interface SupplierInvoiceHeaderBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        category: InvoiceType;
        purchaseInvoiceCategory: PurchaseInvoiceCategory;
        sourceModule: ModuleTable;
        billBySupplier: Supplier;
        control: string;
        company: Company;
        site: Site;
        accountingDate: string;
        internalNumber: integer;
        internalReference: string;
        sourceDocumentDate: string;
        sourceDocument: string;
        currency: Currency;
        rateType: ExchangeRateType;
        rateDate: string;
        isDAS2Submitted: boolean;
        payToBusinessPartner: BusinessPartner;
        dueDateCalculationStartDate: string;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        earlyDiscountOrLateChargeRate: string;
        taxRule: TaxRule;
        isEuropeanUnionInvoice: boolean;
        intrastatProcessingNumber: integer;
        status: PurchasingInvoiceStatus;
        paymentApproval: PaymentApprovalType;
        originalInvoiceNumber: string;
        debitOrCredit: integer;
        totalAmountIncludingTax: string;
        totalAmountExcludingTax: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        taxReferenceDate: string;
        numberOfTaxes: integer;
        billBySupplierAddress: SupplierAddress;
        billBySupplierPostalCode: string;
        billBySupplierCity: string;
        billBySupplierState: string;
        billBySupplierCountry: Country;
        billBySupplierCountryName: string;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        payToBusinessPartnerPostalCode: string;
        payToBusinessPartnerCity: string;
        payToBusinessPartnerState: string;
        payToBusinessPartnerCountry: Country;
        payToBusinessPartnerCountryName: string;
        incoterm: Incoterm;
        incotermTown: string;
        intrastatTransportLocation: CountryLocation;
        europeanUnionIdentification: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: SupplierAddress;
        fiscalYear: integer;
        period: integer;
        serviceStartDate: string;
        serviceEndDate: string;
        lastServiceAccountedDate: string;
        unblockUser: User;
        unblockDate: string;
        unblockAmount: string;
        matchStatus: MatchStatusEnum;
        earlyDiscountOrLateChargeBasis: string;
        priceOrAmountType: PriceAmountTaxTax;
        singleCustomsDocumentDate: string;
        singleCustomsDocumentReference: string;
        singleCustomsDocumentBusinessPartnerCode: Supplier;
        derCode: string;
        versionControlSystemNumber: string;
        priceOrAmountTaxType: PriceAmountTaxTax;
        recurringNumber: string;
        importTaxAmountNumber: string;
        recurringInvoicingDate: string;
        numberOfCompanies: integer;
        cashVatTaxRule: boolean;
        field40Reason: MiscellaneousTable;
        field41Reason: MiscellaneousTable;
        originalDocumentNumber: string;
        inPaymentSlipWithReferenceLine: string;
        bankId: string;
        project: ProjectLink;
        numberOfInvoiceCopies: integer;
        billBySupplierAddressLines: ClientCollection<SupplierInvoiceHeaderBillBySupplierAddressLinesBinding>;
        billBySupplierCompanyNames: ClientCollection<SupplierInvoiceHeaderBillBySupplierCompanyNamesBinding>;
        comments: ClientCollection<SupplierInvoiceHeaderCommentsBinding>;
        payToBusinessPartnerAddressLines: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerAddressLinesBinding>;
        payToBusinessPartnerCompanyNames: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNamesBinding>;
        taxes: ClientCollection<SupplierInvoiceHeaderTaxesBinding>;
    }
    export interface SupplierInvoiceHeader$Lookups {
        billBySupplier: QueryOperation<Supplier>;
        company: QueryOperation<Company>;
        site: QueryOperation<Site>;
        currency: QueryOperation<Currency>;
        payToBusinessPartner: QueryOperation<BusinessPartner>;
        paymentTerm: QueryOperation<PaymentTerm>;
        earlyDiscountOrLateCharge: QueryOperation<EarlyDiscountLateCharge>;
        taxRule: QueryOperation<TaxRule>;
        billBySupplierAddress: QueryOperation<SupplierAddress>;
        billBySupplierCountry: QueryOperation<Country>;
        payToBusinessPartnerAddress: QueryOperation<BusinessPartnerAddress>;
        payToBusinessPartnerCountry: QueryOperation<Country>;
        incoterm: QueryOperation<Incoterm>;
        forwardingAgent: QueryOperation<Carrier>;
        forwardingAgentAddress: QueryOperation<SupplierAddress>;
        unblockUser: QueryOperation<User>;
        singleCustomsDocumentBusinessPartnerCode: QueryOperation<Supplier>;
        field40Reason: QueryOperation<MiscellaneousTable>;
        field41Reason: QueryOperation<MiscellaneousTable>;
        project: QueryOperation<ProjectLink>;
    }
    export interface SupplierInvoiceHeader$Operations {
        query: QueryOperation<SupplierInvoiceHeader>;
        read: ReadOperation<SupplierInvoiceHeader>;
        aggregate: {
            read: AggregateReadOperation<SupplierInvoiceHeader>;
            query: AggregateQueryOperation<SupplierInvoiceHeader>;
        };
        lookups(dataOrId: string | { data: SupplierInvoiceHeaderInput }): SupplierInvoiceHeader$Lookups;
        getDefaults: GetDefaultsOperation<SupplierInvoiceHeader>;
    }
    export interface TaxLevel extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface TaxLevelInput extends ClientNodeInput {
        code?: string;
        legislation?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface TaxLevelBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface TaxLevel$Lookups {
        legislation: QueryOperation<MiscellaneousTable>;
    }
    export interface TaxLevel$Operations {
        query: QueryOperation<TaxLevel>;
        read: ReadOperation<TaxLevel>;
        aggregate: {
            read: AggregateReadOperation<TaxLevel>;
            query: AggregateQueryOperation<TaxLevel>;
        };
        lookups(dataOrId: string | { data: TaxLevelInput }): TaxLevel$Lookups;
        getDefaults: GetDefaultsOperation<TaxLevel>;
    }
    export interface TaxRule extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface TaxRuleInput extends ClientNodeInput {
        code?: string;
        legislation?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface TaxRuleBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface TaxRule$Lookups {
        legislation: QueryOperation<MiscellaneousTable>;
    }
    export interface TaxRule$Operations {
        query: QueryOperation<TaxRule>;
        read: ReadOperation<TaxRule>;
        aggregate: {
            read: AggregateReadOperation<TaxRule>;
            query: AggregateQueryOperation<TaxRule>;
        };
        lookups(dataOrId: string | { data: TaxRuleInput }): TaxRule$Lookups;
        getDefaults: GetDefaultsOperation<TaxRule>;
    }
    export interface Tax extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface TaxInput extends ClientNodeInput {
        code?: string;
        legislation?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface TaxBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface Tax$Lookups {
        legislation: QueryOperation<MiscellaneousTable>;
    }
    export interface Tax$Operations {
        query: QueryOperation<Tax>;
        read: ReadOperation<Tax>;
        aggregate: {
            read: AggregateReadOperation<Tax>;
            query: AggregateQueryOperation<Tax>;
        };
        lookups(dataOrId: string | { data: TaxInput }): Tax$Lookups;
        getDefaults: GetDefaultsOperation<Tax>;
    }
    export interface BusinessPartnerCompanyExceptionExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        businessPartner: BusinessPartner;
        company: Company;
        isAuthorizedEntry: boolean;
        contractualPeriod: integer;
        isCashExcluded: boolean;
        electronicInvoiceType: ElectronicInvoiceType;
        mappingCode: Mapping;
        registrationAgreement: string;
        businessPartnerTaxRule: TaxRule;
        customerTaxRule: TaxRule;
        supplierTaxRule: TaxRule;
        customerPaymentTerm: PaymentTerm;
        supplierPaymentTerm: PaymentTerm;
        customerEarlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        supplierEarlyDiscountOrLateCharge: EarlyDiscountLateCharge;
    }
    export interface BusinessPartnerCompanyExceptionInputExtension {
        businessPartner?: string;
        company?: string;
        isAuthorizedEntry?: boolean | string;
        contractualPeriod?: integer | string;
        isCashExcluded?: boolean | string;
        electronicInvoiceType?: ElectronicInvoiceType;
        mappingCode?: string;
        registrationAgreement?: string;
        businessPartnerTaxRule?: string;
        customerTaxRule?: string;
        supplierTaxRule?: string;
        customerPaymentTerm?: string;
        supplierPaymentTerm?: string;
        customerEarlyDiscountOrLateCharge?: string;
        supplierEarlyDiscountOrLateCharge?: string;
    }
    export interface BusinessPartnerCompanyExceptionBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        businessPartner: BusinessPartner;
        company: Company;
        isAuthorizedEntry: boolean;
        contractualPeriod: integer;
        isCashExcluded: boolean;
        electronicInvoiceType: ElectronicInvoiceType;
        mappingCode: Mapping;
        registrationAgreement: string;
        businessPartnerTaxRule: TaxRule;
        customerTaxRule: TaxRule;
        supplierTaxRule: TaxRule;
        customerPaymentTerm: PaymentTerm;
        supplierPaymentTerm: PaymentTerm;
        customerEarlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        supplierEarlyDiscountOrLateCharge: EarlyDiscountLateCharge;
    }
    export interface BusinessPartnerCompanyExceptionExtension$Lookups {
        businessPartnerTaxRule: QueryOperation<TaxRule>;
        customerTaxRule: QueryOperation<TaxRule>;
        supplierTaxRule: QueryOperation<TaxRule>;
        customerPaymentTerm: QueryOperation<PaymentTerm>;
        supplierPaymentTerm: QueryOperation<PaymentTerm>;
        customerEarlyDiscountOrLateCharge: QueryOperation<EarlyDiscountLateCharge>;
        supplierEarlyDiscountOrLateCharge: QueryOperation<EarlyDiscountLateCharge>;
    }
    export interface BusinessPartnerCompanyExceptionExtension$Operations {
        lookups(
            dataOrId: string | { data: BusinessPartnerCompanyExceptionInput },
        ): BusinessPartnerCompanyExceptionExtension$Lookups;
    }
    export interface CustomerExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: BusinessPartner;
        customerCategory: CustomerCategory;
        billToCustomer: Customer;
        billToCustomerAddress: CustomerAddress;
        payByCustomer: BusinessPartner;
        payByCustomerAddress: BusinessPartnerAddress;
        groupCustomer: Customer;
        riskCustomer: Customer;
        defaultAddress: CustomerAddress;
        defaultShipToAddress: ShipToCustomerAddress;
        defaultContact: CustomerContact;
        isActive: boolean;
        ourSupplierCode: string;
        currency: Currency;
        rateType: ExchangeRateType;
        commissionCategory: CommissionCategory;
        exemptionTaxNumber: string;
        priceOrAmountType: PriceAmountTaxTax;
        creditControl: WorkInProgressControl;
        authorizedCreditAmount: string;
        minimumOrderAmount: string;
        creditInsuranceAmount: string;
        insuranceDate: string;
        insuranceCompany: BusinessPartner;
        reminderType: ReminderType;
        minimumReminderAmount: string;
        canBeMatched: boolean;
        isLoanAllowed: boolean;
        mustPrintAcknowledgment: boolean;
        isOrderClosingAllowed: boolean;
        mustContainOneOrderPerDelivery: boolean;
        businessSector: MiscellaneousTable;
        prospectOrigin: MiscellaneousTable;
        tokenCredit: integer;
        manualAdditionalToken: integer;
        totalTokenCredit: integer;
        necessaryTokensForServiceContract: integer;
        firstContactDate: string;
        firstOrderDate: string;
        lastQuoteDate: string;
        lastContactDate: string;
        nextContactDate: string;
        customerAbcClass: ProductAbcClass;
        printTemplate: PrintTemplate;
        initialDateSinceCustomer: string;
        unavailablePaymentPeriod: UnavailablePeriods;
        isSubjectToTax: boolean;
        isEfatElectronicInvoicingAllowed: boolean;
        contact: CustomerContact;
        startDateforElectronicInvoice: string;
        isElectronicInvoiceAllowed: boolean;
        addresses: ClientCollection<CustomerAddress>;
        contacts: ClientCollection<CustomerContact>;
        bankDetails: ClientCollection<CustomerBankDetail>;
        businessPartner: BusinessPartner;
        shipToCustomers: ClientCollection<ShipToCustomerAddress>;
        acronym: string;
        businessPartnerSite: Site;
        cfonbPaymentMethod: MiscellaneousTable;
        companyName1: string;
        companyName2: string;
        companyNames: ClientCollection<BusinessPartnerCompanyNames>;
        consolidationCode: string;
        consolidationGroup: SiteGroupings;
        consolidationPartner: BusinessPartner;
        country: Country;
        customerOrSupplierOriginCategory: string;
        documentType: DocumentType;
        economicOperatorRegistrationAndIdNumber: string;
        electronicAddress: string;
        electronicInvoiceType: ElectronicInvoiceType;
        europeanUnionVatNumber: string;
        fiscalCode: string;
        invoiceHeaderText: TextStream;
        isCashExcluded: boolean;
        isIntersite: boolean;
        isMailingProhibited: boolean;
        isPhysicalPerson: boolean;
        isPublicSector: boolean;
        isServiceCaller: boolean;
        isServiceSupplier: boolean;
        italianTaxNumber: string;
        language: Language;
        nonResidentAccount: BusinessPartnerAddress;
        orderHeaderText: TextStream;
        registrationNumber: string;
        relatedCompany: RelatedCompanySettings;
        reportAccessCode: Access;
        routingCode: string;
        serviceCode: string;
        shortCompanyName: string;
        siteIdentificationNumber: string;
        standardIndustrialClassificationCode: string;
        vatNumber: string;
        cashTaxRules: ClientCollection<CustomerCashTaxRules>;
        paymentDays: ClientCollection<CustomerPaymentDays>;
        salesReps: ClientCollection<CustomerSalesReps>;
        statisticalGroups: ClientCollection<CustomerStatisticalGroups>;
        taxRule: TaxRule;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        invoicingTerm: InvoicingTerm;
        invoicingElements: ClientCollection<CustomerInvoicingElements>;
    }
    export interface CustomerInputExtension {
        code?: string;
        customerCategory?: string;
        billToCustomer?: string;
        billToCustomerAddress?: string;
        payByCustomer?: string;
        payByCustomerAddress?: string;
        groupCustomer?: string;
        riskCustomer?: string;
        defaultAddress?: string;
        defaultShipToAddress?: string;
        defaultContact?: string;
        isActive?: boolean | string;
        ourSupplierCode?: string;
        currency?: string;
        rateType?: ExchangeRateType;
        commissionCategory?: CommissionCategory;
        exemptionTaxNumber?: string;
        priceOrAmountType?: PriceAmountTaxTax;
        creditControl?: WorkInProgressControl;
        authorizedCreditAmount?: decimal | string;
        minimumOrderAmount?: decimal | string;
        creditInsuranceAmount?: decimal | string;
        insuranceDate?: string;
        insuranceCompany?: string;
        reminderType?: ReminderType;
        minimumReminderAmount?: decimal | string;
        canBeMatched?: boolean | string;
        isLoanAllowed?: boolean | string;
        mustPrintAcknowledgment?: boolean | string;
        isOrderClosingAllowed?: boolean | string;
        mustContainOneOrderPerDelivery?: boolean | string;
        businessSector?: string;
        prospectOrigin?: string;
        tokenCredit?: integer | string;
        manualAdditionalToken?: integer | string;
        totalTokenCredit?: integer | string;
        necessaryTokensForServiceContract?: integer | string;
        firstContactDate?: string;
        firstOrderDate?: string;
        lastQuoteDate?: string;
        lastContactDate?: string;
        nextContactDate?: string;
        customerAbcClass?: ProductAbcClass;
        printTemplate?: string;
        initialDateSinceCustomer?: string;
        unavailablePaymentPeriod?: string;
        isSubjectToTax?: boolean | string;
        isEfatElectronicInvoicingAllowed?: boolean | string;
        contact?: string;
        startDateforElectronicInvoice?: string;
        isElectronicInvoiceAllowed?: boolean | string;
        addresses?: Partial<CustomerAddressInput>[];
        contacts?: Partial<CustomerContactInput>[];
        bankDetails?: Partial<CustomerBankDetailInput>[];
        businessPartner?: string;
        shipToCustomers?: Partial<ShipToCustomerAddressInput>[];
        acronym?: string;
        businessPartnerSite?: string;
        cfonbPaymentMethod?: string;
        companyName1?: string;
        companyName2?: string;
        companyNames?: Partial<BusinessPartnerCompanyNamesInput>[];
        consolidationCode?: string;
        consolidationGroup?: string;
        consolidationPartner?: string;
        country?: string;
        customerOrSupplierOriginCategory?: string;
        documentType?: DocumentType;
        economicOperatorRegistrationAndIdNumber?: string;
        electronicAddress?: string;
        electronicInvoiceType?: ElectronicInvoiceType;
        europeanUnionVatNumber?: string;
        fiscalCode?: string;
        invoiceHeaderText?: TextStream;
        isCashExcluded?: boolean | string;
        isIntersite?: boolean | string;
        isMailingProhibited?: boolean | string;
        isPhysicalPerson?: boolean | string;
        isPublicSector?: boolean | string;
        isServiceCaller?: boolean | string;
        isServiceSupplier?: boolean | string;
        italianTaxNumber?: string;
        language?: string;
        nonResidentAccount?: string;
        orderHeaderText?: TextStream;
        registrationNumber?: string;
        relatedCompany?: RelatedCompanySettings;
        reportAccessCode?: string;
        routingCode?: string;
        serviceCode?: string;
        shortCompanyName?: string;
        siteIdentificationNumber?: string;
        standardIndustrialClassificationCode?: string;
        vatNumber?: string;
        cashTaxRules?: Partial<CustomerCashTaxRulesInput>[];
        paymentDays?: Partial<CustomerPaymentDaysInput>[];
        salesReps?: Partial<CustomerSalesRepsInput>[];
        statisticalGroups?: Partial<CustomerStatisticalGroupsInput>[];
        taxRule?: string;
        paymentTerm?: string;
        earlyDiscountOrLateCharge?: string;
        invoicingTerm?: string;
        invoicingElements?: Partial<CustomerInvoicingElementsInput>[];
    }
    export interface CustomerBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: BusinessPartner;
        customerCategory: CustomerCategory;
        billToCustomer: Customer;
        billToCustomerAddress: CustomerAddress;
        payByCustomer: BusinessPartner;
        payByCustomerAddress: BusinessPartnerAddress;
        groupCustomer: Customer;
        riskCustomer: Customer;
        defaultAddress: CustomerAddress;
        defaultShipToAddress: ShipToCustomerAddress;
        defaultContact: CustomerContact;
        isActive: boolean;
        ourSupplierCode: string;
        currency: Currency;
        rateType: ExchangeRateType;
        commissionCategory: CommissionCategory;
        exemptionTaxNumber: string;
        priceOrAmountType: PriceAmountTaxTax;
        creditControl: WorkInProgressControl;
        authorizedCreditAmount: string;
        minimumOrderAmount: string;
        creditInsuranceAmount: string;
        insuranceDate: string;
        insuranceCompany: BusinessPartner;
        reminderType: ReminderType;
        minimumReminderAmount: string;
        canBeMatched: boolean;
        isLoanAllowed: boolean;
        mustPrintAcknowledgment: boolean;
        isOrderClosingAllowed: boolean;
        mustContainOneOrderPerDelivery: boolean;
        businessSector: MiscellaneousTable;
        prospectOrigin: MiscellaneousTable;
        tokenCredit: integer;
        manualAdditionalToken: integer;
        totalTokenCredit: integer;
        necessaryTokensForServiceContract: integer;
        firstContactDate: string;
        firstOrderDate: string;
        lastQuoteDate: string;
        lastContactDate: string;
        nextContactDate: string;
        customerAbcClass: ProductAbcClass;
        printTemplate: PrintTemplate;
        initialDateSinceCustomer: string;
        unavailablePaymentPeriod: UnavailablePeriods;
        isSubjectToTax: boolean;
        isEfatElectronicInvoicingAllowed: boolean;
        contact: CustomerContact;
        startDateforElectronicInvoice: string;
        isElectronicInvoiceAllowed: boolean;
        addresses: ClientCollection<CustomerAddress>;
        contacts: ClientCollection<CustomerContact>;
        bankDetails: ClientCollection<CustomerBankDetail>;
        businessPartner: BusinessPartner;
        shipToCustomers: ClientCollection<ShipToCustomerAddress>;
        acronym: string;
        businessPartnerSite: Site;
        cfonbPaymentMethod: MiscellaneousTable;
        companyName1: string;
        companyName2: string;
        companyNames: ClientCollection<BusinessPartnerCompanyNames>;
        consolidationCode: string;
        consolidationGroup: SiteGroupings;
        consolidationPartner: BusinessPartner;
        country: Country;
        customerOrSupplierOriginCategory: string;
        documentType: DocumentType;
        economicOperatorRegistrationAndIdNumber: string;
        electronicAddress: string;
        electronicInvoiceType: ElectronicInvoiceType;
        europeanUnionVatNumber: string;
        fiscalCode: string;
        invoiceHeaderText: TextStream;
        isCashExcluded: boolean;
        isIntersite: boolean;
        isMailingProhibited: boolean;
        isPhysicalPerson: boolean;
        isPublicSector: boolean;
        isServiceCaller: boolean;
        isServiceSupplier: boolean;
        italianTaxNumber: string;
        language: Language;
        nonResidentAccount: BusinessPartnerAddress;
        orderHeaderText: TextStream;
        registrationNumber: string;
        relatedCompany: RelatedCompanySettings;
        reportAccessCode: Access;
        routingCode: string;
        serviceCode: string;
        shortCompanyName: string;
        siteIdentificationNumber: string;
        standardIndustrialClassificationCode: string;
        vatNumber: string;
        cashTaxRules: ClientCollection<CustomerCashTaxRulesBinding>;
        paymentDays: ClientCollection<CustomerPaymentDaysBinding>;
        salesReps: ClientCollection<CustomerSalesRepsBinding>;
        statisticalGroups: ClientCollection<CustomerStatisticalGroupsBinding>;
        taxRule: TaxRule;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        invoicingTerm: InvoicingTerm;
        invoicingElements: ClientCollection<CustomerInvoicingElementsBinding>;
    }
    export interface CustomerExtension$Lookups {
        taxRule: QueryOperation<TaxRule>;
        paymentTerm: QueryOperation<PaymentTerm>;
        earlyDiscountOrLateCharge: QueryOperation<EarlyDiscountLateCharge>;
        invoicingTerm: QueryOperation<InvoicingTerm>;
    }
    export interface CustomerExtension$Operations {
        lookups(dataOrId: string | { data: CustomerInput }): CustomerExtension$Lookups;
    }
    export interface ProductCategoryExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        code: string;
        description: string;
        localizedDescription: string;
        shortDescription: string;
        localizedShortDescription: string;
        isSold: boolean;
        productSequenceNumber: string;
        creationMethod: ProductCreationMode;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticUnit: UnitOfMeasure;
        euUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        salesUnitToStockUnitConversionFactor: string;
        statisticalUnitToStockUnitConversionFactor: string;
        euUnitToStockUnitConversionFactor: string;
        isPurchaseConversionFactorEntryAllowed: boolean;
        isSalesConversionFactorEntryAllowed: boolean;
        weightUnit: UnitOfMeasure;
        stockUnitWeight: string;
        volumeUnit: UnitOfMeasure;
        stockUnitVolume: string;
        labelFormatForStockUnit: GenericPrintReport;
        stockManagementMode: StockManagement;
        managementMode: StandardProductCode;
        isNegativeStockAuthorized: boolean;
        lotSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        serialSequenceNumber: string;
        valuationMethod: string;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        userAccessCode: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        buyer: User;
        planner: User;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        salesPriceOrigin: PriceOrigin;
        percentagePricePurchaseApplied: string;
        configuratorProductLine: string;
        isLocationManaged: boolean;
        salesOrderAllocationRule: string;
        workOrderAllocationRule: string;
        shipmentAllocationRule: string;
        materialConsumptionAllocationRule: string;
        transferAllocationRule: string;
        subcontractReplenishmentAllocationRule: string;
        subcontractConsumptionAllocationRule: string;
        afterSalesAllocationRule: string;
        isStatusAAuthorizedInGlobalAllocation: boolean;
        isStatusQAuthorizedInGlobalAllocation: boolean;
        isStatusRAuthorizedInGlobalAllocation: boolean;
        abcClass: ProductAbcClass;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        shrinkagePercent: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningRequestHorizon: integer;
        planningRequestHorizonTimeUnit: LeadTimeUnit;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        stockCoverageInWeeks: integer;
        safetyStock: string;
        reorderingThreshold: string;
        reorderingMaximumStock: string;
        economicOrderQuantity: string;
        technicalLotQuantity: string;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        isReleasedIfShortage: boolean;
        automaticClosingPercentage: string;
        salesDeliveryTolerance: string;
        salesMinimumQuantity: string;
        salesMaximumQuantity: string;
        isLoanAuthorized: boolean;
        isBackToBackOrderManaged: boolean;
        directBackToBackOrderQuantity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTool: boolean;
        isDeliverable: boolean;
        isIntermediary: boolean;
        isMaintenance: boolean;
        packagingCapacity: string;
        assignmentRules: string;
        isStockDetailedInPacking: boolean;
        technicalSheet: TechnicalSheet;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        afterSalesWarehouse: string;
        canBeCapitalized: boolean;
        isPackingManaged: boolean;
        sageSalesTax: MiscellaneousTable;
        saftProductType: SafTProductType;
        freightClass: string;
        freightCommodityCode: string;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        inventoryProductType: ProductType;
        containerManagement: boolean;
        statisticalGroups: ClientCollection<ProductCategoryStatisticalGroups>;
        costType: CostType;
        lotManagementMode: LotManagementMode;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        materialCostGroup: MaterialCostGroup;
        reorderingManagementMode: ReorderingManagementMode;
        stockVersionMode: StockVersionMode;
        stockManagementRules: ClientCollection<StockManagementRules>;
        defaultLocations: ClientCollection<ProductCategoryDefaultLocations>;
        overheads: ClientCollection<ProductCategoryOverheads>;
        packingUnits: ClientCollection<ProductCategoryPackingUnits>;
        invoicingTerm: InvoicingTerm;
        taxLevels: ClientCollection<ProductCategoryTaxLevels>;
    }
    export interface ProductCategoryInputExtension {
        stockSite?: string;
        code?: string;
        description?: string;
        localizedDescription?: string;
        shortDescription?: string;
        localizedShortDescription?: string;
        isSold?: boolean | string;
        productSequenceNumber?: string;
        creationMethod?: ProductCreationMode;
        qualityControlManagementMode?: SubjectToControl;
        qualityControlAccessCode?: string;
        stockUnit?: string;
        purchaseUnit?: string;
        salesUnit?: string;
        statisticUnit?: string;
        euUnit?: string;
        purchaseUnitToStockUnitConversionFactor?: decimal | string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        statisticalUnitToStockUnitConversionFactor?: decimal | string;
        euUnitToStockUnitConversionFactor?: decimal | string;
        isPurchaseConversionFactorEntryAllowed?: boolean | string;
        isSalesConversionFactorEntryAllowed?: boolean | string;
        weightUnit?: string;
        stockUnitWeight?: decimal | string;
        volumeUnit?: string;
        stockUnitVolume?: decimal | string;
        labelFormatForStockUnit?: string;
        stockManagementMode?: StockManagement;
        managementMode?: StandardProductCode;
        isNegativeStockAuthorized?: boolean | string;
        lotSequenceNumber?: string;
        serialNumberManagementMode?: SerialNumberManagement;
        serialSequenceNumber?: string;
        valuationMethod?: string;
        expirationManagementMode?: ExpirationManagement;
        expirationStockStatus?: string;
        userAccessCode?: string;
        purchasingPlanningHorizonTimeUnit?: LeadTimeUnit;
        purchasingPlanningHorizon?: integer | string;
        purchasingFirmHorizon?: integer | string;
        purchasingFirmHorizonTimeUnit?: LeadTimeUnit;
        reorderLeadTime?: decimal | string;
        buyer?: string;
        planner?: string;
        purchaseDeliveryTolerance?: decimal | string;
        isReceived?: boolean | string;
        isMandatoryPurchaseOrderRequest?: boolean | string;
        landedCostCoefficient?: decimal | string;
        fixedLandedCostPerUnit?: decimal | string;
        salesPriceOrigin?: PriceOrigin;
        percentagePricePurchaseApplied?: decimal | string;
        configuratorProductLine?: string;
        isLocationManaged?: boolean | string;
        salesOrderAllocationRule?: string;
        workOrderAllocationRule?: string;
        shipmentAllocationRule?: string;
        materialConsumptionAllocationRule?: string;
        transferAllocationRule?: string;
        subcontractReplenishmentAllocationRule?: string;
        subcontractConsumptionAllocationRule?: string;
        afterSalesAllocationRule?: string;
        isStatusAAuthorizedInGlobalAllocation?: boolean | string;
        isStatusQAuthorizedInGlobalAllocation?: boolean | string;
        isStatusRAuthorizedInGlobalAllocation?: boolean | string;
        abcClass?: ProductAbcClass;
        stockWithdrawalMode?: StockWithdrawal;
        countManagementMode?: Count;
        trendProfile?: string;
        shrinkagePercent?: decimal | string;
        planningFirmHorizon?: integer | string;
        planningFirmHorizonTimeUnit?: LeadTimeUnit;
        planningRequestHorizon?: integer | string;
        planningRequestHorizonTimeUnit?: LeadTimeUnit;
        reorderingPeriodicity?: integer | string;
        reorderingSuggestionType?: SuggestionType;
        reorderingSite?: string;
        reorderingPolicy?: string;
        stockCoverageInWeeks?: integer | string;
        safetyStock?: decimal | string;
        reorderingThreshold?: decimal | string;
        reorderingMaximumStock?: decimal | string;
        economicOrderQuantity?: decimal | string;
        technicalLotQuantity?: decimal | string;
        standardCostUpdate?: PriceUpdateMode;
        revisedStandardCostUpdate?: PriceUpdateMode;
        budgetStandardCostUpdate?: PriceUpdateMode;
        simulatedCostUpdate?: PriceUpdateMode;
        isReleasedIfShortage?: boolean | string;
        automaticClosingPercentage?: decimal | string;
        salesDeliveryTolerance?: decimal | string;
        salesMinimumQuantity?: decimal | string;
        salesMaximumQuantity?: decimal | string;
        isLoanAuthorized?: boolean | string;
        isBackToBackOrderManaged?: boolean | string;
        directBackToBackOrderQuantity?: decimal | string;
        isPurchased?: boolean | string;
        isManufactured?: boolean | string;
        isSubcontracted?: boolean | string;
        isService?: boolean | string;
        isPhantom?: boolean | string;
        isGeneric?: boolean | string;
        isTool?: boolean | string;
        isDeliverable?: boolean | string;
        isIntermediary?: boolean | string;
        isMaintenance?: boolean | string;
        packagingCapacity?: decimal | string;
        assignmentRules?: string;
        isStockDetailedInPacking?: boolean | string;
        technicalSheet?: string;
        orderWarehouse?: string;
        workOrderWarehouse?: string;
        shippingWarehouse?: string;
        materialConsumptionWarehouse?: string;
        internalMovementWarehouse?: string;
        subcontractShipmentWarehouse?: string;
        subcontractConsumptionWarehouse?: string;
        afterSalesWarehouse?: string;
        canBeCapitalized?: boolean | string;
        isPackingManaged?: boolean | string;
        sageSalesTax?: string;
        saftProductType?: SafTProductType;
        freightClass?: string;
        freightCommodityCode?: string;
        isVersionManaged?: boolean | string;
        minorVersionSequence?: string;
        majorVersionSequence?: string;
        isVersionPreloaded?: boolean | string;
        inventoryProductType?: ProductType;
        containerManagement?: boolean | string;
        statisticalGroups?: Partial<ProductCategoryStatisticalGroupsInput>[];
        costType?: string;
        lotManagementMode?: LotManagementMode;
        traceabilityManagementMode?: TraceabilityManagementMode;
        traceabilityLevel?: TraceabilityLevel;
        materialCostGroup?: MaterialCostGroup;
        reorderingManagementMode?: ReorderingManagementMode;
        stockVersionMode?: StockVersionMode;
        stockManagementRules?: Partial<StockManagementRulesInput>[];
        defaultLocations?: Partial<ProductCategoryDefaultLocationsInput>[];
        overheads?: Partial<ProductCategoryOverheadsInput>[];
        packingUnits?: Partial<ProductCategoryPackingUnitsInput>[];
        invoicingTerm?: string;
        taxLevels?: Partial<ProductCategoryTaxLevelsInput>[];
    }
    export interface ProductCategoryBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        code: string;
        description: string;
        localizedDescription: string;
        shortDescription: string;
        localizedShortDescription: string;
        isSold: boolean;
        productSequenceNumber: string;
        creationMethod: ProductCreationMode;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticUnit: UnitOfMeasure;
        euUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        salesUnitToStockUnitConversionFactor: string;
        statisticalUnitToStockUnitConversionFactor: string;
        euUnitToStockUnitConversionFactor: string;
        isPurchaseConversionFactorEntryAllowed: boolean;
        isSalesConversionFactorEntryAllowed: boolean;
        weightUnit: UnitOfMeasure;
        stockUnitWeight: string;
        volumeUnit: UnitOfMeasure;
        stockUnitVolume: string;
        labelFormatForStockUnit: GenericPrintReport;
        stockManagementMode: StockManagement;
        managementMode: StandardProductCode;
        isNegativeStockAuthorized: boolean;
        lotSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        serialSequenceNumber: string;
        valuationMethod: string;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        userAccessCode: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        buyer: User;
        planner: User;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        salesPriceOrigin: PriceOrigin;
        percentagePricePurchaseApplied: string;
        configuratorProductLine: string;
        isLocationManaged: boolean;
        salesOrderAllocationRule: string;
        workOrderAllocationRule: string;
        shipmentAllocationRule: string;
        materialConsumptionAllocationRule: string;
        transferAllocationRule: string;
        subcontractReplenishmentAllocationRule: string;
        subcontractConsumptionAllocationRule: string;
        afterSalesAllocationRule: string;
        isStatusAAuthorizedInGlobalAllocation: boolean;
        isStatusQAuthorizedInGlobalAllocation: boolean;
        isStatusRAuthorizedInGlobalAllocation: boolean;
        abcClass: ProductAbcClass;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        shrinkagePercent: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningRequestHorizon: integer;
        planningRequestHorizonTimeUnit: LeadTimeUnit;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        stockCoverageInWeeks: integer;
        safetyStock: string;
        reorderingThreshold: string;
        reorderingMaximumStock: string;
        economicOrderQuantity: string;
        technicalLotQuantity: string;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        isReleasedIfShortage: boolean;
        automaticClosingPercentage: string;
        salesDeliveryTolerance: string;
        salesMinimumQuantity: string;
        salesMaximumQuantity: string;
        isLoanAuthorized: boolean;
        isBackToBackOrderManaged: boolean;
        directBackToBackOrderQuantity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTool: boolean;
        isDeliverable: boolean;
        isIntermediary: boolean;
        isMaintenance: boolean;
        packagingCapacity: string;
        assignmentRules: string;
        isStockDetailedInPacking: boolean;
        technicalSheet: TechnicalSheet;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        afterSalesWarehouse: string;
        canBeCapitalized: boolean;
        isPackingManaged: boolean;
        sageSalesTax: MiscellaneousTable;
        saftProductType: SafTProductType;
        freightClass: string;
        freightCommodityCode: string;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        inventoryProductType: ProductType;
        containerManagement: boolean;
        statisticalGroups: ClientCollection<ProductCategoryStatisticalGroupsBinding>;
        costType: CostType;
        lotManagementMode: LotManagementMode;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        materialCostGroup: MaterialCostGroup;
        reorderingManagementMode: ReorderingManagementMode;
        stockVersionMode: StockVersionMode;
        stockManagementRules: ClientCollection<StockManagementRules>;
        defaultLocations: ClientCollection<ProductCategoryDefaultLocationsBinding>;
        overheads: ClientCollection<ProductCategoryOverheadsBinding>;
        packingUnits: ClientCollection<ProductCategoryPackingUnitsBinding>;
        invoicingTerm: InvoicingTerm;
        taxLevels: ClientCollection<ProductCategoryTaxLevelsBinding>;
    }
    export interface ProductCategoryExtension$Lookups {
        invoicingTerm: QueryOperation<InvoicingTerm>;
    }
    export interface ProductCategoryExtension$Operations {
        lookups(dataOrId: string | { data: ProductCategoryInput }): ProductCategoryExtension$Lookups;
    }
    export interface ProductExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        company: Company;
        productCategory: ProductCategory;
        searchKey: string;
        description1: string;
        description2: string;
        description3: string;
        localizedDescription1: string;
        localizedDescription2: string;
        localizedDescription3: string;
        managementMode: StandardProductCode;
        standard: string;
        upc: string;
        productStatus: ProductStatus;
        isPrototype: boolean;
        defaultPotencyInPercentage: string;
        defaultPotencyInInternationalUnit: string;
        serviceLifeStartDate: string;
        serviceLifeEndDate: string;
        storageSheet: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticalUnit: UnitOfMeasure;
        eeUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        isPurchaseFactorEntryAllowed: boolean;
        salesUnitToStockUnitConversionFactor: string;
        isSalesFactorEntryAllowed: boolean;
        statisticalUnitToStockUnitConversionFactor: string;
        eeUnitToStockUnitConversionFactor: string;
        weightUnit: UnitOfMeasure;
        productWeight: string;
        volumeUnit: UnitOfMeasure;
        productVolume: string;
        lotSequenceNumber: string;
        serialSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        expirationLeadTime: integer;
        checkLeadTime: integer;
        isNegativeStockAuthorized: boolean;
        costGroup: string;
        userAccessCode: Access;
        alternateProduct: Product;
        isIntrastatDeclarationSubmitted: boolean;
        intrastatCommodity: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        buyer: User;
        planner: User;
        reorderLeadTime: integer;
        purchaseBasePrice: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        exemptionFlag: string;
        taxFlagStatusLocal: string;
        configuratorProductLine: string;
        configuratorNumericField1: string;
        configuratorNumericField2: string;
        configuratorNumericField3: string;
        configuratorNumericField4: string;
        configuratorNumericField5: string;
        configuratorNumericField6: string;
        configuratorAlphaField1: string;
        configuratorAlphaField2: string;
        configuratorAlphaField3: string;
        configuratorAlphaField4: string;
        configuratorAlphaField5: string;
        configuratorAlphaField6: string;
        configurationJournal: string;
        configuratorBusinessPartner: BusinessPartner;
        configuratorBusinessPartnerReference: string;
        configuratorReferenceProduct: Product;
        configuratorPurgeDate: string;
        isInstalledBaseCreated: boolean;
        voucherCategory: MiscellaneousTable;
        tokensToBeCredited: integer;
        creditUnit: UnitOfMeasure;
        labelFormatForStockUnit: GenericPrintReport;
        bomCodeForAfterSales: BomCodes;
        productTypeForAfterSales: TypeOfProduct;
        isAfterSalesProductIssuedByDefault: boolean;
        daysUnit: UnitOfMeasure;
        hourUnit: UnitOfMeasure;
        minuteUnit: UnitOfMeasure;
        productDensity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTools: boolean;
        isDeliverable: boolean;
        isSold: boolean;
        isIntermediary: boolean;
        isCapitalized: boolean;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        intrastatFederalStateOrRegion: MiscellaneousTable;
        plmProductReference: string;
        plmLinkedDocuments: string;
        plmProductHistory: string;
        sageSalesTax: MiscellaneousTable;
        allergens: string;
        allergenChangeDate: string;
        allergenBomCode: integer;
        saftProductType: SafTProductType;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        productType: ProductType;
        globalTradeItemNumber: string;
        productSites: ClientCollection<ProductSite>;
        supplierProduct: ClientCollection<SupplierProduct>;
        customerProduct: ClientCollection<CustomerProduct>;
        manufacturingText: TextStream;
        picture: BinaryStream;
        purchasingText: TextStream;
        packingUnits: ClientCollection<ProductPackingUnits>;
        statisticalGroups: ClientCollection<ProductStatisticalGroups>;
        costType: CostType;
        stockManagementMode: StockManagement;
        lotManagementMode: LotManagementMode;
        materialCostGroup: MaterialCostGroup;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        expirationTimeUnit: ExpirationLeadTimeUnits;
        recontrolTimeUnit: ExpirationLeadTimeUnits;
        stockVersionMode: StockVersionMode;
        taxLevels: ClientCollection<ProductTaxLevels>;
    }
    export interface ProductInputExtension {
        code?: string;
        company?: string;
        productCategory?: string;
        searchKey?: string;
        description1?: string;
        description2?: string;
        description3?: string;
        localizedDescription1?: string;
        localizedDescription2?: string;
        localizedDescription3?: string;
        managementMode?: StandardProductCode;
        standard?: string;
        upc?: string;
        productStatus?: ProductStatus;
        isPrototype?: boolean | string;
        defaultPotencyInPercentage?: decimal | string;
        defaultPotencyInInternationalUnit?: decimal | string;
        serviceLifeStartDate?: string;
        serviceLifeEndDate?: string;
        storageSheet?: string;
        stockUnit?: string;
        purchaseUnit?: string;
        salesUnit?: string;
        statisticalUnit?: string;
        eeUnit?: string;
        purchaseUnitToStockUnitConversionFactor?: decimal | string;
        isPurchaseFactorEntryAllowed?: boolean | string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        isSalesFactorEntryAllowed?: boolean | string;
        statisticalUnitToStockUnitConversionFactor?: decimal | string;
        eeUnitToStockUnitConversionFactor?: decimal | string;
        weightUnit?: string;
        productWeight?: decimal | string;
        volumeUnit?: string;
        productVolume?: decimal | string;
        lotSequenceNumber?: string;
        serialSequenceNumber?: string;
        serialNumberManagementMode?: SerialNumberManagement;
        expirationManagementMode?: ExpirationManagement;
        expirationStockStatus?: string;
        expirationLeadTime?: integer | string;
        checkLeadTime?: integer | string;
        isNegativeStockAuthorized?: boolean | string;
        costGroup?: string;
        userAccessCode?: string;
        alternateProduct?: string;
        isIntrastatDeclarationSubmitted?: boolean | string;
        intrastatCommodity?: string;
        purchasingPlanningHorizonTimeUnit?: LeadTimeUnit;
        purchasingPlanningHorizon?: integer | string;
        purchasingFirmHorizon?: integer | string;
        purchasingFirmHorizonTimeUnit?: LeadTimeUnit;
        buyer?: string;
        planner?: string;
        reorderLeadTime?: integer | string;
        purchaseBasePrice?: decimal | string;
        landedCostCoefficient?: decimal | string;
        fixedLandedCostPerUnit?: decimal | string;
        purchaseDeliveryTolerance?: decimal | string;
        isReceived?: boolean | string;
        isMandatoryPurchaseOrderRequest?: boolean | string;
        exemptionFlag?: string;
        taxFlagStatusLocal?: string;
        configuratorProductLine?: string;
        configuratorNumericField1?: decimal | string;
        configuratorNumericField2?: decimal | string;
        configuratorNumericField3?: decimal | string;
        configuratorNumericField4?: decimal | string;
        configuratorNumericField5?: decimal | string;
        configuratorNumericField6?: decimal | string;
        configuratorAlphaField1?: string;
        configuratorAlphaField2?: string;
        configuratorAlphaField3?: string;
        configuratorAlphaField4?: string;
        configuratorAlphaField5?: string;
        configuratorAlphaField6?: string;
        configurationJournal?: string;
        configuratorBusinessPartner?: string;
        configuratorBusinessPartnerReference?: string;
        configuratorReferenceProduct?: string;
        configuratorPurgeDate?: string;
        isInstalledBaseCreated?: boolean | string;
        voucherCategory?: string;
        tokensToBeCredited?: integer | string;
        creditUnit?: string;
        labelFormatForStockUnit?: string;
        bomCodeForAfterSales?: integer | string;
        productTypeForAfterSales?: TypeOfProduct;
        isAfterSalesProductIssuedByDefault?: boolean | string;
        daysUnit?: string;
        hourUnit?: string;
        minuteUnit?: string;
        productDensity?: decimal | string;
        isPurchased?: boolean | string;
        isManufactured?: boolean | string;
        isSubcontracted?: boolean | string;
        isService?: boolean | string;
        isPhantom?: boolean | string;
        isGeneric?: boolean | string;
        isTools?: boolean | string;
        isDeliverable?: boolean | string;
        isSold?: boolean | string;
        isIntermediary?: boolean | string;
        isCapitalized?: boolean | string;
        newStockStatusAfterRecontrol?: string;
        useByDateCoefficient?: decimal | string;
        intrastatFederalStateOrRegion?: string;
        plmProductReference?: string;
        plmLinkedDocuments?: string;
        plmProductHistory?: string;
        sageSalesTax?: string;
        allergens?: string;
        allergenChangeDate?: string;
        allergenBomCode?: integer | string;
        saftProductType?: SafTProductType;
        isVersionManaged?: boolean | string;
        minorVersionSequence?: string;
        majorVersionSequence?: string;
        isVersionPreloaded?: boolean | string;
        productType?: ProductType;
        globalTradeItemNumber?: string;
        supplierProduct?: Partial<SupplierProductInput>[];
        customerProduct?: Partial<CustomerProductInput>[];
        manufacturingText?: TextStream;
        picture?: BinaryStream;
        purchasingText?: TextStream;
        packingUnits?: Partial<ProductPackingUnitsInput>[];
        statisticalGroups?: Partial<ProductStatisticalGroupsInput>[];
        costType?: string;
        stockManagementMode?: StockManagement;
        lotManagementMode?: LotManagementMode;
        materialCostGroup?: MaterialCostGroup;
        traceabilityManagementMode?: TraceabilityManagementMode;
        traceabilityLevel?: TraceabilityLevel;
        expirationTimeUnit?: ExpirationLeadTimeUnits;
        recontrolTimeUnit?: ExpirationLeadTimeUnits;
        stockVersionMode?: StockVersionMode;
        taxLevels?: Partial<ProductTaxLevelsInput>[];
    }
    export interface ProductBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        company: Company;
        productCategory: ProductCategory;
        searchKey: string;
        description1: string;
        description2: string;
        description3: string;
        localizedDescription1: string;
        localizedDescription2: string;
        localizedDescription3: string;
        managementMode: StandardProductCode;
        standard: string;
        upc: string;
        productStatus: ProductStatus;
        isPrototype: boolean;
        defaultPotencyInPercentage: string;
        defaultPotencyInInternationalUnit: string;
        serviceLifeStartDate: string;
        serviceLifeEndDate: string;
        storageSheet: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticalUnit: UnitOfMeasure;
        eeUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        isPurchaseFactorEntryAllowed: boolean;
        salesUnitToStockUnitConversionFactor: string;
        isSalesFactorEntryAllowed: boolean;
        statisticalUnitToStockUnitConversionFactor: string;
        eeUnitToStockUnitConversionFactor: string;
        weightUnit: UnitOfMeasure;
        productWeight: string;
        volumeUnit: UnitOfMeasure;
        productVolume: string;
        lotSequenceNumber: string;
        serialSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        expirationLeadTime: integer;
        checkLeadTime: integer;
        isNegativeStockAuthorized: boolean;
        costGroup: string;
        userAccessCode: Access;
        alternateProduct: Product;
        isIntrastatDeclarationSubmitted: boolean;
        intrastatCommodity: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        buyer: User;
        planner: User;
        reorderLeadTime: integer;
        purchaseBasePrice: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        exemptionFlag: string;
        taxFlagStatusLocal: string;
        configuratorProductLine: string;
        configuratorNumericField1: string;
        configuratorNumericField2: string;
        configuratorNumericField3: string;
        configuratorNumericField4: string;
        configuratorNumericField5: string;
        configuratorNumericField6: string;
        configuratorAlphaField1: string;
        configuratorAlphaField2: string;
        configuratorAlphaField3: string;
        configuratorAlphaField4: string;
        configuratorAlphaField5: string;
        configuratorAlphaField6: string;
        configurationJournal: string;
        configuratorBusinessPartner: BusinessPartner;
        configuratorBusinessPartnerReference: string;
        configuratorReferenceProduct: Product;
        configuratorPurgeDate: string;
        isInstalledBaseCreated: boolean;
        voucherCategory: MiscellaneousTable;
        tokensToBeCredited: integer;
        creditUnit: UnitOfMeasure;
        labelFormatForStockUnit: GenericPrintReport;
        bomCodeForAfterSales: BomCodes;
        productTypeForAfterSales: TypeOfProduct;
        isAfterSalesProductIssuedByDefault: boolean;
        daysUnit: UnitOfMeasure;
        hourUnit: UnitOfMeasure;
        minuteUnit: UnitOfMeasure;
        productDensity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTools: boolean;
        isDeliverable: boolean;
        isSold: boolean;
        isIntermediary: boolean;
        isCapitalized: boolean;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        intrastatFederalStateOrRegion: MiscellaneousTable;
        plmProductReference: string;
        plmLinkedDocuments: string;
        plmProductHistory: string;
        sageSalesTax: MiscellaneousTable;
        allergens: string;
        allergenChangeDate: string;
        allergenBomCode: integer;
        saftProductType: SafTProductType;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        productType: ProductType;
        globalTradeItemNumber: string;
        productSites: ClientCollection<ProductSite>;
        supplierProduct: ClientCollection<SupplierProduct>;
        customerProduct: ClientCollection<CustomerProduct>;
        manufacturingText: TextStream;
        picture: BinaryStream;
        purchasingText: TextStream;
        packingUnits: ClientCollection<ProductPackingUnitsBinding>;
        statisticalGroups: ClientCollection<ProductStatisticalGroupsBinding>;
        costType: CostType;
        stockManagementMode: StockManagement;
        lotManagementMode: LotManagementMode;
        materialCostGroup: MaterialCostGroup;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        expirationTimeUnit: ExpirationLeadTimeUnits;
        recontrolTimeUnit: ExpirationLeadTimeUnits;
        stockVersionMode: StockVersionMode;
        taxLevels: ClientCollection<ProductTaxLevelsBinding>;
    }
    export interface ShipToCustomerAddressExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        customer: Customer;
        shipToAddress: CustomerAddress;
        company: Company;
        isActive: boolean;
        shippingSite: Site;
        receiptSite: Site;
        language: Language;
        carrier: Carrier;
        incoterm: Incoterm;
        intrastatTransportLocation: CountryLocation;
        deliveryLeadTime: integer;
        isMondayWorkday: boolean;
        isTuesdayWorkday: boolean;
        isWednesdayWorkday: boolean;
        isThursdayWorkday: boolean;
        isFridayWorkday: boolean;
        isSaturdayWorkday: boolean;
        isSundayWorkday: boolean;
        unavailablePeriod: UnavailablePeriods;
        intrastatIncreaseCoefficient: string;
        europeanUnionVatNumber: string;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: Address;
        geographicCode: string;
        insideCityLimits: string;
        taxExemptionNumber: string;
        exemptionFlag: string;
        mustPrintPickTicket: boolean;
        mustPrintPackingSlip: boolean;
        entityUse: MiscellaneousTable;
        deliveryHeaderText: TextStream;
        pickingHeaderText: TextStream;
        companyNames: ClientCollection<ShipToCustomerAddressCompanyNames>;
        salesReps: ClientCollection<ShipToCustomerAddressSalesReps>;
        taxRule: TaxRule;
    }
    export interface ShipToCustomerAddressInputExtension {
        customer?: string;
        shipToAddress?: string;
        company?: string;
        isActive?: boolean | string;
        shippingSite?: string;
        receiptSite?: string;
        language?: string;
        carrier?: string;
        incoterm?: string;
        intrastatTransportLocation?: CountryLocation;
        deliveryLeadTime?: integer | string;
        isMondayWorkday?: boolean | string;
        isTuesdayWorkday?: boolean | string;
        isWednesdayWorkday?: boolean | string;
        isThursdayWorkday?: boolean | string;
        isFridayWorkday?: boolean | string;
        isSaturdayWorkday?: boolean | string;
        isSundayWorkday?: boolean | string;
        unavailablePeriod?: string;
        intrastatIncreaseCoefficient?: decimal | string;
        europeanUnionVatNumber?: string;
        incotermTown?: string;
        forwardingAgent?: string;
        forwardingAgentAddress?: string;
        geographicCode?: string;
        insideCityLimits?: string;
        taxExemptionNumber?: string;
        exemptionFlag?: string;
        mustPrintPickTicket?: boolean | string;
        mustPrintPackingSlip?: boolean | string;
        entityUse?: string;
        deliveryHeaderText?: TextStream;
        pickingHeaderText?: TextStream;
        companyNames?: Partial<ShipToCustomerAddressCompanyNamesInput>[];
        salesReps?: Partial<ShipToCustomerAddressSalesRepsInput>[];
        taxRule?: string;
    }
    export interface ShipToCustomerAddressBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        customer: Customer;
        shipToAddress: CustomerAddress;
        company: Company;
        isActive: boolean;
        shippingSite: Site;
        receiptSite: Site;
        language: Language;
        carrier: Carrier;
        incoterm: Incoterm;
        intrastatTransportLocation: CountryLocation;
        deliveryLeadTime: integer;
        isMondayWorkday: boolean;
        isTuesdayWorkday: boolean;
        isWednesdayWorkday: boolean;
        isThursdayWorkday: boolean;
        isFridayWorkday: boolean;
        isSaturdayWorkday: boolean;
        isSundayWorkday: boolean;
        unavailablePeriod: UnavailablePeriods;
        intrastatIncreaseCoefficient: string;
        europeanUnionVatNumber: string;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: Address;
        geographicCode: string;
        insideCityLimits: string;
        taxExemptionNumber: string;
        exemptionFlag: string;
        mustPrintPickTicket: boolean;
        mustPrintPackingSlip: boolean;
        entityUse: MiscellaneousTable;
        deliveryHeaderText: TextStream;
        pickingHeaderText: TextStream;
        companyNames: ClientCollection<ShipToCustomerAddressCompanyNamesBinding>;
        salesReps: ClientCollection<ShipToCustomerAddressSalesRepsBinding>;
        taxRule: TaxRule;
    }
    export interface ShipToCustomerAddressExtension$Lookups {
        taxRule: QueryOperation<TaxRule>;
    }
    export interface ShipToCustomerAddressExtension$Operations {
        lookups(dataOrId: string | { data: ShipToCustomerAddressInput }): ShipToCustomerAddressExtension$Lookups;
    }
    export interface SupplierExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: BusinessPartner;
        category: SupplierCategory;
        payToBusinessPartner: BusinessPartner;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        groupSupplier: Supplier;
        riskSupplier: Supplier;
        ourCustomerNumberForSupplier: string;
        carrier: Carrier;
        defaultContact: SupplierContact;
        location: string;
        supplierABCClass: ProductAbcClass;
        rateType: ExchangeRateType;
        incoterm: Incoterm;
        intrastatTransportLocation: CountryLocation;
        addressByDefault: SupplierAddress;
        isMultiLineOrder: boolean;
        leadTimeRankingCoefficient: string;
        priceRankingCoefficient: string;
        qualityRankingCoefficient: string;
        quantityRankingCoefficient: string;
        freeRankingCoefficient: string;
        leadTimeRanking: string;
        priceRanking: string;
        qualityRanking: string;
        quantityRanking: string;
        freeRanking: string;
        totalRanking: string;
        creditControl: WorkInProgressControl;
        intrastatIncreaseCoefficient: string;
        mustRemindDelivery: boolean;
        mustRemindAcknowledgment: boolean;
        isDas2Submitted: boolean;
        isActive: boolean;
        isPaymentHeld: boolean;
        mustPrintOrderForm: boolean;
        mustPrintReceiptNote: boolean;
        mustPrintReturnSlip: boolean;
        ourCustomerNameForSupplier: string;
        is281Submitted: boolean;
        amountType: PriceAmountTaxTax;
        isCashVat: boolean;
        cashVatDeadline: string;
        selfBillingCode: string;
        rexNumber: string;
        hasNoWhiteListVerification: boolean;
        isElectronicInvoicingAllowed: boolean;
        contact: SupplierContact;
        startDateForElectronicInvoice: string;
        addresses: ClientCollection<SupplierAddress>;
        contacts: ClientCollection<SupplierContact>;
        acronym: string;
        businessPartnerSite: Site;
        cfonbPaymentMethod: MiscellaneousTable;
        companyName1: string;
        companyName2: string;
        companyNames: ClientCollection<BusinessPartnerCompanyNames>;
        consolidationCode: string;
        consolidationGroup: SiteGroupings;
        consolidationPartner: BusinessPartner;
        country: Country;
        customerOrSupplierOriginCategory: string;
        documentType: DocumentType;
        economicOperatorRegistrationAndIdNumber: string;
        europeanUnionVatNumber: string;
        fiscalCode: string;
        isCashExcluded: boolean;
        isIntersite: boolean;
        isMailingProhibited: boolean;
        isPhysicalPerson: boolean;
        isPublicSector: boolean;
        isServiceCaller: boolean;
        isServiceSupplier: boolean;
        italianTaxNumber: string;
        language: Language;
        nonResidentAccount: BusinessPartnerAddress;
        purchaseOrderText: TextStream;
        registrationNumber: string;
        relatedCompany: RelatedCompanySettings;
        reportAccessCode: Access;
        returnOrderText: TextStream;
        shortCompanyName: string;
        siteIdentificationNumber: string;
        standardIndustrialClassificationCode: string;
        vatNumber: string;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        taxRule: TaxRule;
    }
    export interface SupplierInputExtension {
        code?: string;
        category?: string;
        payToBusinessPartner?: string;
        payToBusinessPartnerAddress?: string;
        billBySupplier?: string;
        billBySupplierAddress?: string;
        groupSupplier?: string;
        riskSupplier?: string;
        ourCustomerNumberForSupplier?: string;
        carrier?: string;
        defaultContact?: string;
        location?: string;
        supplierABCClass?: ProductAbcClass;
        rateType?: ExchangeRateType;
        incoterm?: string;
        intrastatTransportLocation?: CountryLocation;
        addressByDefault?: string;
        isMultiLineOrder?: boolean | string;
        leadTimeRankingCoefficient?: decimal | string;
        priceRankingCoefficient?: decimal | string;
        qualityRankingCoefficient?: decimal | string;
        quantityRankingCoefficient?: decimal | string;
        freeRankingCoefficient?: decimal | string;
        leadTimeRanking?: decimal | string;
        priceRanking?: decimal | string;
        qualityRanking?: decimal | string;
        quantityRanking?: decimal | string;
        freeRanking?: decimal | string;
        totalRanking?: decimal | string;
        creditControl?: WorkInProgressControl;
        intrastatIncreaseCoefficient?: decimal | string;
        mustRemindDelivery?: boolean | string;
        mustRemindAcknowledgment?: boolean | string;
        isDas2Submitted?: boolean | string;
        isActive?: boolean | string;
        isPaymentHeld?: boolean | string;
        mustPrintOrderForm?: boolean | string;
        mustPrintReceiptNote?: boolean | string;
        mustPrintReturnSlip?: boolean | string;
        ourCustomerNameForSupplier?: string;
        is281Submitted?: boolean | string;
        amountType?: PriceAmountTaxTax;
        isCashVat?: boolean | string;
        cashVatDeadline?: string;
        selfBillingCode?: string;
        rexNumber?: string;
        hasNoWhiteListVerification?: boolean | string;
        isElectronicInvoicingAllowed?: boolean | string;
        contact?: string;
        startDateForElectronicInvoice?: string;
        addresses?: Partial<SupplierAddressInput>[];
        contacts?: Partial<SupplierContactInput>[];
        acronym?: string;
        businessPartnerSite?: string;
        cfonbPaymentMethod?: string;
        companyName1?: string;
        companyName2?: string;
        companyNames?: Partial<BusinessPartnerCompanyNamesInput>[];
        consolidationCode?: string;
        consolidationGroup?: string;
        consolidationPartner?: string;
        country?: string;
        customerOrSupplierOriginCategory?: string;
        documentType?: DocumentType;
        economicOperatorRegistrationAndIdNumber?: string;
        europeanUnionVatNumber?: string;
        fiscalCode?: string;
        isCashExcluded?: boolean | string;
        isIntersite?: boolean | string;
        isMailingProhibited?: boolean | string;
        isPhysicalPerson?: boolean | string;
        isPublicSector?: boolean | string;
        isServiceCaller?: boolean | string;
        isServiceSupplier?: boolean | string;
        italianTaxNumber?: string;
        language?: string;
        nonResidentAccount?: string;
        purchaseOrderText?: TextStream;
        registrationNumber?: string;
        relatedCompany?: RelatedCompanySettings;
        reportAccessCode?: string;
        returnOrderText?: TextStream;
        shortCompanyName?: string;
        siteIdentificationNumber?: string;
        standardIndustrialClassificationCode?: string;
        vatNumber?: string;
        paymentTerm?: string;
        earlyDiscountOrLateCharge?: string;
        taxRule?: string;
    }
    export interface SupplierBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: BusinessPartner;
        category: SupplierCategory;
        payToBusinessPartner: BusinessPartner;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        groupSupplier: Supplier;
        riskSupplier: Supplier;
        ourCustomerNumberForSupplier: string;
        carrier: Carrier;
        defaultContact: SupplierContact;
        location: string;
        supplierABCClass: ProductAbcClass;
        rateType: ExchangeRateType;
        incoterm: Incoterm;
        intrastatTransportLocation: CountryLocation;
        addressByDefault: SupplierAddress;
        isMultiLineOrder: boolean;
        leadTimeRankingCoefficient: string;
        priceRankingCoefficient: string;
        qualityRankingCoefficient: string;
        quantityRankingCoefficient: string;
        freeRankingCoefficient: string;
        leadTimeRanking: string;
        priceRanking: string;
        qualityRanking: string;
        quantityRanking: string;
        freeRanking: string;
        totalRanking: string;
        creditControl: WorkInProgressControl;
        intrastatIncreaseCoefficient: string;
        mustRemindDelivery: boolean;
        mustRemindAcknowledgment: boolean;
        isDas2Submitted: boolean;
        isActive: boolean;
        isPaymentHeld: boolean;
        mustPrintOrderForm: boolean;
        mustPrintReceiptNote: boolean;
        mustPrintReturnSlip: boolean;
        ourCustomerNameForSupplier: string;
        is281Submitted: boolean;
        amountType: PriceAmountTaxTax;
        isCashVat: boolean;
        cashVatDeadline: string;
        selfBillingCode: string;
        rexNumber: string;
        hasNoWhiteListVerification: boolean;
        isElectronicInvoicingAllowed: boolean;
        contact: SupplierContact;
        startDateForElectronicInvoice: string;
        addresses: ClientCollection<SupplierAddress>;
        contacts: ClientCollection<SupplierContact>;
        acronym: string;
        businessPartnerSite: Site;
        cfonbPaymentMethod: MiscellaneousTable;
        companyName1: string;
        companyName2: string;
        companyNames: ClientCollection<BusinessPartnerCompanyNames>;
        consolidationCode: string;
        consolidationGroup: SiteGroupings;
        consolidationPartner: BusinessPartner;
        country: Country;
        customerOrSupplierOriginCategory: string;
        documentType: DocumentType;
        economicOperatorRegistrationAndIdNumber: string;
        europeanUnionVatNumber: string;
        fiscalCode: string;
        isCashExcluded: boolean;
        isIntersite: boolean;
        isMailingProhibited: boolean;
        isPhysicalPerson: boolean;
        isPublicSector: boolean;
        isServiceCaller: boolean;
        isServiceSupplier: boolean;
        italianTaxNumber: string;
        language: Language;
        nonResidentAccount: BusinessPartnerAddress;
        purchaseOrderText: TextStream;
        registrationNumber: string;
        relatedCompany: RelatedCompanySettings;
        reportAccessCode: Access;
        returnOrderText: TextStream;
        shortCompanyName: string;
        siteIdentificationNumber: string;
        standardIndustrialClassificationCode: string;
        vatNumber: string;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        taxRule: TaxRule;
    }
    export interface SupplierExtension$Lookups {
        paymentTerm: QueryOperation<PaymentTerm>;
        earlyDiscountOrLateCharge: QueryOperation<EarlyDiscountLateCharge>;
        taxRule: QueryOperation<TaxRule>;
    }
    export interface SupplierExtension$Operations {
        lookups(dataOrId: string | { data: SupplierInput }): SupplierExtension$Lookups;
    }
    export interface Package {
        '@sage/x3-invoicing-data/CustomerInvoiceHeaderBillToCustomerAddressLines': CustomerInvoiceHeaderBillToCustomerAddressLines$Operations;
        '@sage/x3-invoicing-data/CustomerInvoiceHeaderBillToCustomerCompanyNames': CustomerInvoiceHeaderBillToCustomerCompanyNames$Operations;
        '@sage/x3-invoicing-data/CustomerInvoiceHeaderComments': CustomerInvoiceHeaderComments$Operations;
        '@sage/x3-invoicing-data/CustomerInvoiceHeaderPayByBusinessPartnerAddressLines': CustomerInvoiceHeaderPayByBusinessPartnerAddressLines$Operations;
        '@sage/x3-invoicing-data/CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames': CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames$Operations;
        '@sage/x3-invoicing-data/CustomerInvoiceHeaderTaxes': CustomerInvoiceHeaderTaxes$Operations;
        '@sage/x3-invoicing-data/CustomerInvoiceHeader': CustomerInvoiceHeader$Operations;
        '@sage/x3-invoicing-data/CustomerInvoicingElements': CustomerInvoicingElements$Operations;
        '@sage/x3-invoicing-data/EarlyDiscountLateCharge': EarlyDiscountLateCharge$Operations;
        '@sage/x3-invoicing-data/InvoicingTerm': InvoicingTerm$Operations;
        '@sage/x3-invoicing-data/Mandate': Mandate$Operations;
        '@sage/x3-invoicing-data/PaymentMethod': PaymentMethod$Operations;
        '@sage/x3-invoicing-data/PaymentTerm': PaymentTerm$Operations;
        '@sage/x3-invoicing-data/PriceStructureLines': PriceStructureLines$Operations;
        '@sage/x3-invoicing-data/PriceStructure': PriceStructure$Operations;
        '@sage/x3-invoicing-data/ProductCategoryTaxLevels': ProductCategoryTaxLevels$Operations;
        '@sage/x3-invoicing-data/ProductTaxLevels': ProductTaxLevels$Operations;
        '@sage/x3-invoicing-data/PurchaseInvoicingElement': PurchaseInvoicingElement$Operations;
        '@sage/x3-invoicing-data/SalesInvoicingElement': SalesInvoicingElement$Operations;
        '@sage/x3-invoicing-data/SupplierInvoiceHeaderBillBySupplierAddressLines': SupplierInvoiceHeaderBillBySupplierAddressLines$Operations;
        '@sage/x3-invoicing-data/SupplierInvoiceHeaderBillBySupplierCompanyNames': SupplierInvoiceHeaderBillBySupplierCompanyNames$Operations;
        '@sage/x3-invoicing-data/SupplierInvoiceHeaderComments': SupplierInvoiceHeaderComments$Operations;
        '@sage/x3-invoicing-data/SupplierInvoiceHeaderPayToBusinessPartnerAddressLines': SupplierInvoiceHeaderPayToBusinessPartnerAddressLines$Operations;
        '@sage/x3-invoicing-data/SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames': SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames$Operations;
        '@sage/x3-invoicing-data/SupplierInvoiceHeaderTaxes': SupplierInvoiceHeaderTaxes$Operations;
        '@sage/x3-invoicing-data/SupplierInvoiceHeader': SupplierInvoiceHeader$Operations;
        '@sage/x3-invoicing-data/TaxLevel': TaxLevel$Operations;
        '@sage/x3-invoicing-data/TaxRule': TaxRule$Operations;
        '@sage/x3-invoicing-data/Tax': Tax$Operations;
    }
    export interface GraphApi
        extends Package,
            SageX3MasterData$Package,
            SageX3ProjectManagementData$Package,
            SageX3StockData$Package,
            SageX3Structure$Package,
            SageX3System$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/x3-invoicing-data-api' {
    export type * from '@sage/x3-invoicing-data-api-partial';
}
declare module '@sage/x3-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-invoicing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-project-management-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-invoicing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-invoicing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-invoicing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-invoicing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-invoicing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-invoicing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type {
        BusinessPartnerCompanyExceptionBindingExtension,
        BusinessPartnerCompanyExceptionExtension,
        BusinessPartnerCompanyExceptionExtension$Lookups,
        BusinessPartnerCompanyExceptionExtension$Operations,
        BusinessPartnerCompanyExceptionInputExtension,
        CustomerBindingExtension,
        CustomerExtension,
        CustomerExtension$Lookups,
        CustomerExtension$Operations,
        CustomerInputExtension,
        ProductBindingExtension,
        ProductCategoryBindingExtension,
        ProductCategoryExtension,
        ProductCategoryExtension$Lookups,
        ProductCategoryExtension$Operations,
        ProductCategoryInputExtension,
        ProductExtension,
        ProductInputExtension,
        ShipToCustomerAddressBindingExtension,
        ShipToCustomerAddressExtension,
        ShipToCustomerAddressExtension$Lookups,
        ShipToCustomerAddressExtension$Operations,
        ShipToCustomerAddressInputExtension,
        SupplierBindingExtension,
        SupplierExtension,
        SupplierExtension$Lookups,
        SupplierExtension$Operations,
        SupplierInputExtension,
    } from '@sage/x3-invoicing-data-api';
    export interface BusinessPartnerCompanyException extends BusinessPartnerCompanyExceptionExtension {}
    export interface BusinessPartnerCompanyExceptionBinding extends BusinessPartnerCompanyExceptionBindingExtension {}
    export interface BusinessPartnerCompanyExceptionInput extends BusinessPartnerCompanyExceptionInputExtension {}
    export interface BusinessPartnerCompanyException$Lookups extends BusinessPartnerCompanyExceptionExtension$Lookups {}
    export interface BusinessPartnerCompanyException$Operations
        extends BusinessPartnerCompanyExceptionExtension$Operations {}
    export interface Customer extends CustomerExtension {}
    export interface CustomerBinding extends CustomerBindingExtension {}
    export interface CustomerInput extends CustomerInputExtension {}
    export interface Customer$Lookups extends CustomerExtension$Lookups {}
    export interface Customer$Operations extends CustomerExtension$Operations {}
    export interface ProductCategory extends ProductCategoryExtension {}
    export interface ProductCategoryBinding extends ProductCategoryBindingExtension {}
    export interface ProductCategoryInput extends ProductCategoryInputExtension {}
    export interface ProductCategory$Lookups extends ProductCategoryExtension$Lookups {}
    export interface ProductCategory$Operations extends ProductCategoryExtension$Operations {}
    export interface Product extends ProductExtension {}
    export interface ProductBinding extends ProductBindingExtension {}
    export interface ProductInput extends ProductInputExtension {}
    export interface ShipToCustomerAddress extends ShipToCustomerAddressExtension {}
    export interface ShipToCustomerAddressBinding extends ShipToCustomerAddressBindingExtension {}
    export interface ShipToCustomerAddressInput extends ShipToCustomerAddressInputExtension {}
    export interface ShipToCustomerAddress$Lookups extends ShipToCustomerAddressExtension$Lookups {}
    export interface ShipToCustomerAddress$Operations extends ShipToCustomerAddressExtension$Operations {}
    export interface Supplier extends SupplierExtension {}
    export interface SupplierBinding extends SupplierBindingExtension {}
    export interface SupplierInput extends SupplierInputExtension {}
    export interface Supplier$Lookups extends SupplierExtension$Lookups {}
    export interface Supplier$Operations extends SupplierExtension$Operations {}
}
