"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocalDeveloperAsyncContextProvider = void 0;
const xtrem_deployment_1 = require("@sage/xtrem-deployment");
const node_crypto_1 = require("node:crypto");
const persistableAsyncContext_1 = require("../../business/persistableAsyncContext");
const asyncContextXtremRepository_1 = require("../asyncContextXtremRepository");
class LocalDeveloperAsyncContextProvider extends asyncContextXtremRepository_1.AsyncContextXtremRepository {
    contextCache = new Map();
    thirdPartyConfig;
    constructor(thirdPartyConfig) {
        super();
        this.thirdPartyConfig = thirdPartyConfig;
    }
    async createAsyncContext(context) {
        const persistableContext = new persistableAsyncContext_1.PersistableAsyncContext(context);
        persistableContext.getWritableContextXtrem(); // executed just to trigger on dev context a potential error on too big payload
        this.contextCache.set(persistableContext.nanoId, persistableContext);
        return persistableContext.nanoId;
    }
    async deleteAsyncContext(contextId) {
        this.contextCache.delete(contextId);
    }
    async getAsyncContext(contextId) {
        return this.contextCache.get(contextId);
    }
    async createThirdPartyCallbackAsyncContext(callbackContext) {
        if (!this?.thirdPartyConfig || !this?.thirdPartyConfig.callbackUrl || !this?.thirdPartyConfig?.signingKey) {
            throw new Error("callback config not set");
        }
        const context = {
            cluster: callbackContext.cluster,
            app: callbackContext.app?.trim() ? callbackContext.app : undefined,
            tenantId: callbackContext.tenantId,
            contextXtrem: callbackContext.contextXtrem,
            responseQueueName: callbackContext.responseQueueName,
            nanoId: callbackContext.nanoId,
            expireDatetimeIso: callbackContext.expireDatetimeIso,
            contextKind: xtrem_deployment_1.ASYNC_CONTEXT_CONST.CONTEXT_SERVICE_FABRIC_NOTIFICATION,
            notifyTimeout: true
        };
        const persistableContext = new persistableAsyncContext_1.PersistableAsyncContext(context);
        persistableContext.getWritableContextXtrem();
        this.contextCache.set(persistableContext.nanoId, persistableContext);
        const callbackUrlSignature = (0, node_crypto_1.createHash)("sha256").update(`${persistableContext.nanoId}.${this.thirdPartyConfig.signingKey}`).digest("base64");
        return {
            callbackUrl: `${this.thirdPartyConfig.callbackUrl}?contextId=${persistableContext.nanoId}&signingKey=${callbackUrlSignature}`,
            id: persistableContext.nanoId
        };
    }
}
exports.LocalDeveloperAsyncContextProvider = LocalDeveloperAsyncContextProvider;
//# sourceMappingURL=localDeveloperAsyncContextProvider.js.map