import { DynamoDBClientConfig } from "@aws-sdk/client-dynamodb";
import { AsyncContext } from "../../business/asyncContext";
import { PersistableAsyncContext } from "../../business/persistableAsyncContext";
export interface DynamoDBAsyncContextIdProviderConfig {
    dynamoDBTableName: string;
    awsConfigOverride?: DynamoDBClientConfig;
    tracer?: (msg: string) => void;
    AWSOverrideForUnitTesting?: any;
}
export declare class DynamoDBAsyncContextRepository {
    private readonly DynamoDB;
    private readonly dynamoDBTableName;
    private readonly tracer;
    constructor(config: DynamoDBAsyncContextIdProviderConfig);
    /***
     * Return dynamoDB instance using identity token or var envs for aws credentials
     * @param awsConfigOverride
     */
    private getAwsDynamoDB;
    createAsyncContext(context: PersistableAsyncContext): Promise<string>;
    replaceAsyncInfraContext(contextId: string, infraContext: any): Promise<void>;
    deleteAsyncContext(contextId: string): Promise<void>;
    getAsyncContext(contextId: string): Promise<AsyncContext | undefined>;
    getExpiredAsyncContexts(clusterId?: string, app?: string): Promise<AsyncContext[]>;
    getAsyncContextsForCluster(clusterId: string, app?: string): Promise<AsyncContext[]>;
    private persistAsyncContext;
    private updateInfraContextInDynamo;
    private readMandatoryString;
    private readMandatoryBoolean;
    private getContextFromDynamoDBRecord;
    private safeParseJson;
}
