import { AsyncContext } from "./asyncContext";
/***
 * Represent an async context before it's persisted, allows to perform control checks
 */
export declare class PersistableAsyncContext implements AsyncContext {
    nanoId: string;
    tenantId: string;
    cluster: string;
    contextKind: string;
    expireDatetimeIso: string;
    contextXtrem?: any;
    responseQueueName?: string;
    contextInfra?: any;
    notifyTimeout: boolean;
    createdDateTimeIso: string;
    app?: string;
    constructor(context: AsyncContext, dontAddS3FileTTL?: boolean);
    private ensureParamsAreValid;
    /**
     * Make sure context from xtrem is writable and not too big
     * @param context
     */
    getWritableContextXtrem(): string;
    getWritableContextInfra(): string;
    /**
     * Get persistable context object for infra as string, does not perform length control we assume cirrus will remain frugal on the object size
     * Static because used in update without an async context existing
     */
    static getWritableContextInfra(contextValue: string): string;
}
