import { Site, User, UserFunctionProfile } from '@sage/x3-system-api';

export async function getUserProfile(user: User | null): Promise<UserFunctionProfile | null> {
    if (user) {
        const functionProfile = await user.functionProfile;
        if (!functionProfile) {
            // eslint-disable-next-line prefer-destructuring
            const profession = await user.profession;
            if (profession) {
                return await profession.functionProfile;
            }
        } else {
            return functionProfile;
        }
    }
    return null;
}

export async function getSiteFromModule(moduleNumber: number, profile: UserFunctionProfile): Promise<Site | null> {
    const _edges = await profile.userProfileDefaultSites.query.edges;
    if (moduleNumber > 0 && moduleNumber < (_edges?.length ?? 0)) {
        return _edges[moduleNumber - 1].node.site;
    }
    return null;
}

export async function getDefaultSiteFromModule(user: User, moduleNumber: number): Promise<Site | null> {
    const userProfile = await getUserProfile(user);
    if (userProfile) {
        return await getSiteFromModule(moduleNumber, userProfile);
    }
    return null;
}
