// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/index.d.ts
declare module '@sage/x3-system/index' {
	export * from '@sage/x3-system/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/index.d.ts
declare module '@sage/x3-system/lib/index' {
	export * as enums from '@sage/x3-system/lib/enums/index';
	export * as nodeExtensions from '@sage/x3-system/lib/node-extensions/index';
	export * as nodes from '@sage/x3-system/lib/nodes/index';
	export * as serviceOptions from '@sage/x3-system/lib/service-options/index';
	export * as sharedFunctions from '@sage/x3-system/lib/shared-functions/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/shared-functions/pat-converter.d.ts
declare module '@sage/x3-system/lib/shared-functions/pat-converter' {
	/**
	 * Get the RegExp equivalent for the 4GL pattern given
	 *
	 * @param pattern The 4GL pattern you want to get the RegExp equivalent
	 * @returns The RegExp
	 */
	export function getRegExp(pattern: string): RegExp;
	export function getRegExpForMultiplePat(multiplePattern: string): RegExp;
	/**
	 * Perform a 4GL pattern check
	 *
	 * @param text The text to be tested
	 * @param pat The 4GL pattern to apply
	 * @returns The result of the test as a boolean
	 */
	export function pat(text: string, pattern: string): boolean;
	//# sourceMappingURL=pat-converter.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/shared-functions/parsed-element.d.ts
declare module '@sage/x3-system/lib/shared-functions/parsed-element' {
	import { DateValue } from '@sage/xtrem-date-time';
	export enum ElementTypeEnum {
	    string = "string",
	    number = "number",
	    date = "date"
	}
	export type ElementType = keyof typeof ElementTypeEnum;
	export enum DataTitle {
	    amount = "AMOUNT",
	    price = "PRICE",
	    prodDate = "PROD DATE",
	    batchLot = "BATCH/LOT",
	    dueDate = "DUE DATE",
	    packDate = "PACK DATE",
	    bestBefore = "BEST BEFORE or BEST BY",
	    expiryDate = "USE BY OR EXPIRY",
	    sellBy = "SELL BY",
	    sscc = "SSCC",
	    gtin = "GTIN",
	    ginc = "GINC",
	    gsin = "GSIN",
	    content = "CONTENT",
	    variant = "VARIANT",
	    serial = "SERIAL",
	    cpv = "CPV",
	    additionalId = "ADDITIONAL ID",
	    customPartNumber = "CUST. PART NO.",
	    mtoVariant = "MTO VARIAN",
	    pcn = "PCN",
	    varCount = "VAR. COUNT",
	    orderNumber = "ORDER NUMBER",
	    route = "ROUTE",
	    shipToLoc = "SHIP TO LOC",
	    billTo = "BILL TO",
	    purchaseFrom = "PURCHASE FROM",
	    shipForLoc = "SHIP FOR LOC",
	    shipToPost = "SHIP TO POST",
	    origin = "ORIGIN",
	    countryInitialProcess = "COUNTRY - INITIAL PROCESS.",
	    countryProcess = "COUNTRY - PROCESS.",
	    countryDisassembly = "COUNTRY - DISASSEMBLY",
	    countryFullProcess = "COUNTRY - FULL PROCESS",
	    countrySubdivision = "ORIGIN SUBDIVISION",
	    nsn = "NSN",
	    meatCut = "MEAT CUT",
	    expiryTime = "EXPIRY TIME",
	    activePotency = "ACTIVE POTENCY",
	    netWeight = "NET WEIGHT",
	    grossWeight = "GROSS WEIGHT",
	    length = "LENGTH",
	    width = "WIDTH",
	    height = "HEIGHT",
	    area = "AREA",
	    netVolume = "NET VOLUME",
	    volume = "VOLUME",
	    kgPerSquareMeter = "KG PER SQUARE METER"
	}
	export enum UnitOfMeasure {
	    EACH = "EACH",
	    MILLIMETER = "MILLIMETER",
	    CENTIMETER = "CENTIMETER",
	    METER = "METER",
	    KILOMETER = "KILOMETER",
	    INCH = "INCH",
	    FOOT = "FOOT",
	    YARD = "YARD",
	    MILE = "MILE",
	    MILLILITER = "MILLILITER",
	    LITER = "LITER",
	    CUBIC_METER = "CUBIC_METER",
	    FLUID_OUNCE = "FLUID_OUNCE",
	    CUP = "CUP",
	    PINT = "PINT",
	    QUART = "QUART",
	    GALLON = "GALLON",
	    CUBIC_INCH = "CUBIC_INCH",
	    CUBIC_FOOT = "CUBIC_FOOT",
	    CUBIC_YARD = "CUBIC_YARD",
	    GRAM = "GRAM",
	    KILOGRAM = "KILOGRAM",
	    METRIC_TON = "METRIC_TON",
	    OUNCE = "OUNCE",
	    POUND = "POUND",
	    STONE = "STONE",
	    HUNDREDWEIGHT = "HUNDREDWEIGHT",
	    SHORT_TON = "SHORT_TON",
	    SECOND = "SECOND",
	    MINUTE = "MINUTE",
	    HOUR = "HOUR",
	    DAY = "DAY",
	    SQUARE_MILLIMETER = "SQUARE_MILLIMETER",
	    SQUARE_CENTIMETER = "SQUARE_CENTIMETER",
	    SQUARE_METER = "SQUARE_METER",
	    SQUARE_INCH = "SQUARE_INCH",
	    SQUARE_FOOT = "SQUARE_FOOT",
	    SQUARE_YARD = "SQUARE_YARD",
	    TROY_OUNCES = "TROY_OUNCES",
	    _28 = "28"
	}
	export type DataTypeSupported = string | DateValue | number;
	export type UnitTypeSupported = string | undefined;
	export class ParsedElement {
	    readonly ai: string;
	    readonly elementDataTitle: DataTitle;
	    readonly elementType: ElementType;
	    private _data;
	    private _unit;
	    constructor(ai: string, elementDataTitle: DataTitle, elementType: ElementType);
	    set unit(unit: UnitTypeSupported);
	    get unit(): UnitTypeSupported;
	    set data(data: DataTypeSupported);
	    get data(): DataTypeSupported;
	}
	//# sourceMappingURL=parsed-element.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/shared-functions/index.d.ts
declare module '@sage/x3-system/lib/shared-functions/index' {
	export * from '@sage/x3-system/lib/shared-functions/barcode-parser';
	export * from '@sage/x3-system/lib/shared-functions/parsed-element';
	export * from '@sage/x3-system/lib/shared-functions/pat-converter';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/shared-functions/barcode-parser.d.ts
declare module '@sage/x3-system/lib/shared-functions/barcode-parser' {
	/**
	 * P. Brockfeld, 2014-02-05
	 *
	 * JavaScript for parsing GS1 barCodes, see
	 *
	 * https://github.com/hprange/BarcodeParser (active fork)
	 *
	 * https://github.com/PeterBrockfeld/BarcodeParser (original repo)
	 *
	 * for details.
	 */
	import { ParsedElement } from '@sage/x3-system/lib/shared-functions/parsed-element';
	export interface ParsedBarcode {
	    codeName: string;
	    parsedCodeItems: ParsedElement[];
	}
	export type ParsedBarcodeOrNever = ParsedBarcode | never;
	export class ParseBarCode {
	    constructor(codeString?: string);
	    /**
	     * Special separator of variable record
	     */
	    private get fncChar();
	    /**
	     * String before change
	     */
	    private get codeString();
	    private set codeString(value);
	    /**
	     * String length before change
	     */
	    private get codeStringLength();
	    /** Evaluate barcode received */
	    parseBarcode(barcode: string): ParsedBarcodeOrNever;
	    /**
	     * "ParsedElement" is the
	     *
	     * @constructor for ParsedElements, the components of the array returned by parseBarcode
	     * @param {String} elementAI        the AI of the recognized element
	     * @param {String} elementDataTitle the title of the element, i.e. its short description
	     * @param {String} elementType      a one-letter string describing the type of the element.
	     *                                  allowed values are
	     *                                  "string" for strings,
	     *                                  "numeric" for numbers and
	     *                                  "date" for dates
	     */
	    /**
	     *
	     * ================== BEGIN of identifyAI =======================
	     *
	     * does the main work:
	     *   what AI is in the beginning of the restOfBarcode?
	     *     If identified:
	     *       which function to call with
	     *       which parameters to parse the element?[Description]]
	     * @param   {String} codeString a string; the function tries to
	     *                   identify an AI in the beginning of this string
	     * @returns {Object} if it succeeds in identifying an AI the
	     *                   ParsedElement is returned with, together with the
	     *                   still unparsed rest of codeString.
	     */
	    private _identifyAI;
	    private _evaluateCodeStartWith0;
	    private _evaluateCodeStartWith1;
	    private _evaluateCodeStartWith2;
	    private _evaluateCodeStartWith24;
	    private _evaluateCodeStartWith25;
	    private _evaluateCodeStartWith3;
	    private _evaluateCodeStartWith31;
	    private _evaluateCodeStartWith32;
	    private _evaluateCodeStartWith33;
	    private _evaluateCodeStartWith34;
	    private _evaluateCodeStartWith35;
	    private _evaluateCodeStartWith36;
	    private _evaluateCodeStartWith39;
	    private _evaluateCodeStartWith4;
	    private _evaluateCodeStartWith40;
	    private _evaluateCodeStartWith41;
	    private _evaluateCodeStartWith42;
	    private _evaluateCodeStartWith7;
	    private _evaluateCodeStartWith70;
	    private _evaluateCodeStartWith700;
	    private _evaluateCodeStartWith71;
	    private _evaluateCodeStartWith8;
	    private _evaluateCodeStartWith80;
	    private _evaluateCodeStartWith800;
	    private _evaluateCodeStartWith801;
	    private _evaluateCodeStartWith802;
	    private _evaluateCodeStartWith81;
	    private _evaluateCodeStartWith810;
	    private _evaluateCodeStartWith811;
	    private _evaluateCodeStartWith82;
	    private _evaluateCodeStartWith9;
	    /**
	     *
	     * =========== END of identifyAI =======================
	     *
	     */
	    /**
	     * ============ auxiliary functions for identifyAI =============
	     */
	    /**
	     * some data items are followed by an ParsedElementAndCode  even in case of
	     * fixed length, so the codeStringToReturn may have
	     * leading FNCs.
	     *
	     * This function eliminates these leading FNCs.
	     *
	     * @param   {String} stringToClean string which has to be cleaned
	     * @returns {String} the cleaned string
	     */
	    private _cleanCodeString;
	    /**
	     * Used for calculating numbers which are given as string
	     * with a given number of fractional decimals.
	     *
	     * To avoid conversion errors binary decimal I _don't_
	     * just divide by 10 numberOfFractionals times.
	     *
	     * Parse a string with given fractional to float
	     * @param {string} stringToParse
	     * @param {number} numberOfFractionals
	     * @returns {number} value
	     */
	    private static _parseFloatingPoint;
	    /**
	     * ======== END of auxiliary function for identifyAI =======
	     */
	    /**
	     *
	     * ======== BEGIN of parsing privates in identifyAI =======
	     *
	     * Some privates to parse the various GS1 formats. They
	     * create a new ParsedElement and set its properties.
	     *
	     * They all modify the variables "elementToReturn" and
	     * "codeStringToReturn".
	     */
	    /**
	     * dates in GS1-elements have the format "YYMMDD".
	     * This private generates a new ParsedElement and tries to fill a
	     * JS-date into the "data"-part.
	     * @param {String} ai    the AI to use for the ParsedElement
	     * @param {String} title the title to use for the ParsedElement
	     */
	    private _parseDate;
	    /**
	     * simple: the element has a fixed length AND is not followed by an FNC1.
	     * @param {String} ai     the AI to use
	     * @param {String} title  its title, i.e. its short description
	     * @param {Number} length the fixed length
	     */
	    private _parseFixedLength;
	    /**
	     * tries to parse an element of variable length
	     * some fixed length AIs are terminated by FNC1, so this private
	     * is used even for fixed length items
	     * @param {String} ai           the AI to use
	     * @param {String} title        its title, i.e. its short description
	     * @param {number} maxLength    maximum data size allowed or 0
	     * @return parsed element
	     */
	    private _parseVariableLength;
	    /**
	     * the place of the decimal fraction is given by the fourth number, that's
	     * the first after the identifier itself.
	     *
	     * All of theses elements have a length of 6 characters.
	     * @param {String} aiStem       the first digits of the AI, _not_ the fourth digit
	     * @param {Number} currentFourthNumber the 4th number indicating the count of valid fractionals
	     * @param {String} title        the title of the AI
	     * @param {String} unit         often these elements have an implicit unit of measurement
	     */
	    private _parseFixedLengthMeasure;
	    /**
	     * parses data elements of variable length, which additionally have
	     *
	     * - an indicator for the number of valid decimals
	     * - an implicit unit of measurement
	     *
	     * These data elements contain e.g. a weight or length.
	     *
	     */
	    private _parseVariableLengthMeasure;
	    /**
	     * parses data elements of variable length, which additionally have
	     *
	     * - an indicator for the number of valid decimals
	     * - an explicit unit of measurement
	     *
	     * These data element contain amounts to pay or prices.
	     *
	     */
	    private _parseVariableLengthWithISONumbers;
	    /**
	     * parses data elements of variable length, which additionally have
	     *
	     * - an explicit unit of measurement or reference
	     *
	     * These data element contain countries, authorities within countries.
	     *
	     */
	    private _parseVariableLengthWithISOChars;
	}
	/**
	 * Function only for using class
	 * @param barcode bar code to translate
	 * @returns translated value(s)
	 */
	export function parseBarcode(barcode: string): ParsedBarcode;
	//# sourceMappingURL=barcode-parser.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/wrh-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/wrh-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const WrhActivityCode: ServiceOption;
	//# sourceMappingURL=wrh-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/vlt-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/vlt-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const VltActivityCode: ServiceOption;
	//# sourceMappingURL=vlt-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/vii-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/vii-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const ViiActivityCode: ServiceOption;
	//# sourceMappingURL=vii-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/vattn-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/vattn-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const VattnActivityCode: ServiceOption;
	//# sourceMappingURL=vattn-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/trsne-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/trsne-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const TrsneActivityCode: ServiceOption;
	//# sourceMappingURL=trsne-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/svc-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/svc-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const SvcActivityCode: ServiceOption;
	//# sourceMappingURL=svc-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/spd-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/spd-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const SpdActivityCode: ServiceOption;
	//# sourceMappingURL=spd-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/sp-9-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/sp-9-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Sp9ActivityCode: ServiceOption;
	//# sourceMappingURL=sp-9-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/sp-8-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/sp-8-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Sp8ActivityCode: ServiceOption;
	//# sourceMappingURL=sp-8-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/sp-7-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/sp-7-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Sp7ActivityCode: ServiceOption;
	//# sourceMappingURL=sp-7-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/sp-6-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/sp-6-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Sp6ActivityCode: ServiceOption;
	//# sourceMappingURL=sp-6-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/sp-5-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/sp-5-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Sp5ActivityCode: ServiceOption;
	//# sourceMappingURL=sp-5-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/sp-4-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/sp-4-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Sp4ActivityCode: ServiceOption;
	//# sourceMappingURL=sp-4-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/sp-3-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/sp-3-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Sp3ActivityCode: ServiceOption;
	//# sourceMappingURL=sp-3-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/sp-2-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/sp-2-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Sp2ActivityCode: ServiceOption;
	//# sourceMappingURL=sp-2-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/sp-1-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/sp-1-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Sp1ActivityCode: ServiceOption;
	//# sourceMappingURL=sp-1-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/sfd-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/sfd-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const SfdActivityCode: ServiceOption;
	//# sourceMappingURL=sfd-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/ser-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/ser-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const SerActivityCode: ServiceOption;
	//# sourceMappingURL=ser-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/sdd-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/sdd-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const SddActivityCode: ServiceOption;
	//# sourceMappingURL=sdd-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/salm-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/salm-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const SalmActivityCode: ServiceOption;
	//# sourceMappingURL=salm-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/saft-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/saft-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const SaftActivityCode: ServiceOption;
	//# sourceMappingURL=saft-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/rex-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/rex-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const RexActivityCode: ServiceOption;
	//# sourceMappingURL=rex-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/revrc-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/revrc-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const RevrcActivityCode: ServiceOption;
	//# sourceMappingURL=revrc-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/re-2-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/re-2-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Re2ActivityCode: ServiceOption;
	//# sourceMappingURL=re-2-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/re-1-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/re-1-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Re1ActivityCode: ServiceOption;
	//# sourceMappingURL=re-1-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/ptx-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/ptx-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const PtxActivityCode: ServiceOption;
	//# sourceMappingURL=ptx-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/prepm-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/prepm-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const PrepmActivityCode: ServiceOption;
	//# sourceMappingURL=prepm-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/prcsl-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/prcsl-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const PrcslActivityCode: ServiceOption;
	//# sourceMappingURL=prcsl-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/ppt-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/ppt-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const PptActivityCode: ServiceOption;
	//# sourceMappingURL=ppt-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/pp-9-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/pp-9-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Pp9ActivityCode: ServiceOption;
	//# sourceMappingURL=pp-9-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/pp-8-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/pp-8-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Pp8ActivityCode: ServiceOption;
	//# sourceMappingURL=pp-8-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/pp-7-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/pp-7-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Pp7ActivityCode: ServiceOption;
	//# sourceMappingURL=pp-7-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/pp-6-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/pp-6-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Pp6ActivityCode: ServiceOption;
	//# sourceMappingURL=pp-6-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/pp-5-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/pp-5-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Pp5ActivityCode: ServiceOption;
	//# sourceMappingURL=pp-5-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/pp-4-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/pp-4-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Pp4ActivityCode: ServiceOption;
	//# sourceMappingURL=pp-4-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/pp-3-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/pp-3-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Pp3ActivityCode: ServiceOption;
	//# sourceMappingURL=pp-3-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/pp-2-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/pp-2-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Pp2ActivityCode: ServiceOption;
	//# sourceMappingURL=pp-2-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/pp-1-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/pp-1-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Pp1ActivityCode: ServiceOption;
	//# sourceMappingURL=pp-1-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/pjm-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/pjm-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const PjmActivityCode: ServiceOption;
	//# sourceMappingURL=pjm-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/pbdpo-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/pbdpo-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const PbdpoActivityCode: ServiceOption;
	//# sourceMappingURL=pbdpo-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/npi-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/npi-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const NpiActivityCode: ServiceOption;
	//# sourceMappingURL=npi-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/mwm-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/mwm-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const MwmActivityCode: ServiceOption;
	//# sourceMappingURL=mwm-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/mwc-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/mwc-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const MwcActivityCode: ServiceOption;
	//# sourceMappingURL=mwc-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/mul-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/mul-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const MulActivityCode: ServiceOption;
	//# sourceMappingURL=mul-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/maxpd-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/maxpd-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const MaxpdActivityCode: ServiceOption;
	//# sourceMappingURL=maxpd-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/lta-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/lta-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const LtaActivityCode: ServiceOption;
	//# sourceMappingURL=lta-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/lpn-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/lpn-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const LpnActivityCode: ServiceOption;
	//# sourceMappingURL=lpn-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/lnd-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/lnd-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const LndActivityCode: ServiceOption;
	//# sourceMappingURL=lnd-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/kza-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/kza-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const KzaActivityCode: ServiceOption;
	//# sourceMappingURL=kza-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/kus-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/kus-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const KusActivityCode: ServiceOption;
	//# sourceMappingURL=kus-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/ksw-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/ksw-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const KswActivityCode: ServiceOption;
	//# sourceMappingURL=ksw-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/ksp-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/ksp-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const KspActivityCode: ServiceOption;
	//# sourceMappingURL=ksp-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/kpo-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/kpo-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const KpoActivityCode: ServiceOption;
	//# sourceMappingURL=kpo-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/kpl-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/kpl-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const KplActivityCode: ServiceOption;
	//# sourceMappingURL=kpl-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/kit-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/kit-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const KitActivityCode: ServiceOption;
	//# sourceMappingURL=kit-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/kfr-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/kfr-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const KfrActivityCode: ServiceOption;
	//# sourceMappingURL=kfr-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/kde-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/kde-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const KdeActivityCode: ServiceOption;
	//# sourceMappingURL=kde-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/kbe-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/kbe-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const KbeActivityCode: ServiceOption;
	//# sourceMappingURL=kbe-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/invca-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/invca-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const InvcaActivityCode: ServiceOption;
	//# sourceMappingURL=invca-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/index.d.ts
declare module '@sage/x3-system/lib/service-options/index' {
	export * from '@sage/x3-system/lib/service-options/abi-activity-code';
	export * from '@sage/x3-system/lib/service-options/adc-activity-code';
	export * from '@sage/x3-system/lib/service-options/ayt-activity-code';
	export * from '@sage/x3-system/lib/service-options/be-281-activity-code';
	export * from '@sage/x3-system/lib/service-options/ccn-activity-code';
	export * from '@sage/x3-system/lib/service-options/cfg-activity-code';
	export * from '@sage/x3-system/lib/service-options/cfom-activity-code';
	export * from '@sage/x3-system/lib/service-options/csl-activity-code';
	export * from '@sage/x3-system/lib/service-options/ctsw-activity-code';
	export * from '@sage/x3-system/lib/service-options/das-activity-code';
	export * from '@sage/x3-system/lib/service-options/deb-activity-code';
	export * from '@sage/x3-system/lib/service-options/debr-activity-code';
	export * from '@sage/x3-system/lib/service-options/dks-activity-code';
	export * from '@sage/x3-system/lib/service-options/ecc-activity-code';
	export * from '@sage/x3-system/lib/service-options/edix-3-activity-code';
	export * from '@sage/x3-system/lib/service-options/efat-activity-code';
	export * from '@sage/x3-system/lib/service-options/einv-activity-code';
	export * from '@sage/x3-system/lib/service-options/elinv-activity-code';
	export * from '@sage/x3-system/lib/service-options/eori-activity-code';
	export * from '@sage/x3-system/lib/service-options/fas-activity-code';
	export * from '@sage/x3-system/lib/service-options/fct-activity-code';
	export * from '@sage/x3-system/lib/service-options/fee-2-activity-code';
	export * from '@sage/x3-system/lib/service-options/foa-activity-code';
	export * from '@sage/x3-system/lib/service-options/fup-activity-code';
	export * from '@sage/x3-system/lib/service-options/gfsa-activity-code';
	export * from '@sage/x3-system/lib/service-options/invca-activity-code';
	export * from '@sage/x3-system/lib/service-options/kbe-activity-code';
	export * from '@sage/x3-system/lib/service-options/kde-activity-code';
	export * from '@sage/x3-system/lib/service-options/kfr-activity-code';
	export * from '@sage/x3-system/lib/service-options/kit-activity-code';
	export * from '@sage/x3-system/lib/service-options/kpl-activity-code';
	export * from '@sage/x3-system/lib/service-options/kpo-activity-code';
	export * from '@sage/x3-system/lib/service-options/ksp-activity-code';
	export * from '@sage/x3-system/lib/service-options/ksw-activity-code';
	export * from '@sage/x3-system/lib/service-options/kus-activity-code';
	export * from '@sage/x3-system/lib/service-options/kza-activity-code';
	export * from '@sage/x3-system/lib/service-options/lnd-activity-code';
	export * from '@sage/x3-system/lib/service-options/lpn-activity-code';
	export * from '@sage/x3-system/lib/service-options/lta-activity-code';
	export * from '@sage/x3-system/lib/service-options/maxpd-activity-code';
	export * from '@sage/x3-system/lib/service-options/mul-activity-code';
	export * from '@sage/x3-system/lib/service-options/mwc-activity-code';
	export * from '@sage/x3-system/lib/service-options/mwm-activity-code';
	export * from '@sage/x3-system/lib/service-options/npi-activity-code';
	export * from '@sage/x3-system/lib/service-options/pbdpo-activity-code';
	export * from '@sage/x3-system/lib/service-options/pjm-activity-code';
	export * from '@sage/x3-system/lib/service-options/pp-1-activity-code';
	export * from '@sage/x3-system/lib/service-options/pp-2-activity-code';
	export * from '@sage/x3-system/lib/service-options/pp-3-activity-code';
	export * from '@sage/x3-system/lib/service-options/pp-4-activity-code';
	export * from '@sage/x3-system/lib/service-options/pp-5-activity-code';
	export * from '@sage/x3-system/lib/service-options/pp-6-activity-code';
	export * from '@sage/x3-system/lib/service-options/pp-7-activity-code';
	export * from '@sage/x3-system/lib/service-options/pp-8-activity-code';
	export * from '@sage/x3-system/lib/service-options/pp-9-activity-code';
	export * from '@sage/x3-system/lib/service-options/ppt-activity-code';
	export * from '@sage/x3-system/lib/service-options/prcsl-activity-code';
	export * from '@sage/x3-system/lib/service-options/prepm-activity-code';
	export * from '@sage/x3-system/lib/service-options/ptx-activity-code';
	export * from '@sage/x3-system/lib/service-options/re-1-activity-code';
	export * from '@sage/x3-system/lib/service-options/re-2-activity-code';
	export * from '@sage/x3-system/lib/service-options/revrc-activity-code';
	export * from '@sage/x3-system/lib/service-options/rex-activity-code';
	export * from '@sage/x3-system/lib/service-options/saft-activity-code';
	export * from '@sage/x3-system/lib/service-options/salm-activity-code';
	export * from '@sage/x3-system/lib/service-options/sdd-activity-code';
	export * from '@sage/x3-system/lib/service-options/ser-activity-code';
	export * from '@sage/x3-system/lib/service-options/sfd-activity-code';
	export * from '@sage/x3-system/lib/service-options/sp-1-activity-code';
	export * from '@sage/x3-system/lib/service-options/sp-2-activity-code';
	export * from '@sage/x3-system/lib/service-options/sp-3-activity-code';
	export * from '@sage/x3-system/lib/service-options/sp-4-activity-code';
	export * from '@sage/x3-system/lib/service-options/sp-5-activity-code';
	export * from '@sage/x3-system/lib/service-options/sp-6-activity-code';
	export * from '@sage/x3-system/lib/service-options/sp-7-activity-code';
	export * from '@sage/x3-system/lib/service-options/sp-8-activity-code';
	export * from '@sage/x3-system/lib/service-options/sp-9-activity-code';
	export * from '@sage/x3-system/lib/service-options/spd-activity-code';
	export * from '@sage/x3-system/lib/service-options/svc-activity-code';
	export * from '@sage/x3-system/lib/service-options/trsne-activity-code';
	export * from '@sage/x3-system/lib/service-options/vattn-activity-code';
	export * from '@sage/x3-system/lib/service-options/vii-activity-code';
	export * from '@sage/x3-system/lib/service-options/vlt-activity-code';
	export * from '@sage/x3-system/lib/service-options/wrh-activity-code';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/gfsa-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/gfsa-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const GfsaActivityCode: ServiceOption;
	//# sourceMappingURL=gfsa-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/fup-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/fup-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const FupActivityCode: ServiceOption;
	//# sourceMappingURL=fup-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/foa-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/foa-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const FoaActivityCode: ServiceOption;
	//# sourceMappingURL=foa-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/fee-2-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/fee-2-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Fee2ActivityCode: ServiceOption;
	//# sourceMappingURL=fee-2-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/fct-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/fct-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const FctActivityCode: ServiceOption;
	//# sourceMappingURL=fct-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/fas-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/fas-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const FasActivityCode: ServiceOption;
	//# sourceMappingURL=fas-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/eori-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/eori-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const EoriActivityCode: ServiceOption;
	//# sourceMappingURL=eori-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/elinv-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/elinv-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const ElinvActivityCode: ServiceOption;
	//# sourceMappingURL=elinv-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/einv-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/einv-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const EinvActivityCode: ServiceOption;
	//# sourceMappingURL=einv-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/efat-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/efat-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const EfatActivityCode: ServiceOption;
	//# sourceMappingURL=efat-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/edix-3-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/edix-3-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Edix3ActivityCode: ServiceOption;
	//# sourceMappingURL=edix-3-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/ecc-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/ecc-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const EccActivityCode: ServiceOption;
	//# sourceMappingURL=ecc-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/dks-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/dks-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const DksActivityCode: ServiceOption;
	//# sourceMappingURL=dks-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/debr-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/debr-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const DebrActivityCode: ServiceOption;
	//# sourceMappingURL=debr-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/deb-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/deb-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const DebActivityCode: ServiceOption;
	//# sourceMappingURL=deb-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/das-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/das-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const DasActivityCode: ServiceOption;
	//# sourceMappingURL=das-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/ctsw-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/ctsw-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const CtswActivityCode: ServiceOption;
	//# sourceMappingURL=ctsw-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/csl-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/csl-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const CslActivityCode: ServiceOption;
	//# sourceMappingURL=csl-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/cfom-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/cfom-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const CfomActivityCode: ServiceOption;
	//# sourceMappingURL=cfom-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/cfg-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/cfg-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const CfgActivityCode: ServiceOption;
	//# sourceMappingURL=cfg-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/ccn-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/ccn-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const CcnActivityCode: ServiceOption;
	//# sourceMappingURL=ccn-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/be-281-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/be-281-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const Be281ActivityCode: ServiceOption;
	//# sourceMappingURL=be-281-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/ayt-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/ayt-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const AytActivityCode: ServiceOption;
	//# sourceMappingURL=ayt-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/adc-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/adc-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const AdcActivityCode: ServiceOption;
	//# sourceMappingURL=adc-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/service-options/abi-activity-code.d.ts
declare module '@sage/x3-system/lib/service-options/abi-activity-code' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const AbiActivityCode: ServiceOption;
	//# sourceMappingURL=abi-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/user.d.ts
declare module '@sage/x3-system/lib/nodes/user' {
	import { Node, Reference, BinaryStream, Collection } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class User extends Node {
	    readonly code: Promise<string>;
	    readonly activeInSelec: Promise<boolean>;
	    readonly name: Promise<string>;
	    readonly nameDescription: Promise<string>;
	    readonly profession: Reference<sageX3System.nodes.SyracusMethod | null>;
	    readonly menuProfile: Reference<sageX3System.nodes.UserProfileMenu | null>;
	    readonly functionProfile: Reference<sageX3System.nodes.UserFunctionProfile | null>;
	    readonly email: Promise<string>;
	    readonly login: Promise<string>;
	    readonly allAccessCodes: Promise<boolean>;
	    readonly externalUser: Promise<boolean>;
	    readonly x3Connection: Promise<boolean>;
	    readonly webServicesConnection: Promise<boolean>;
	    readonly defaultBankId: Promise<string>;
	    readonly access: Reference<sageX3System.nodes.Access | null>;
	    readonly bankIdNumber: Promise<string>;
	    readonly userModel: Reference<sageX3System.nodes.User | null>;
	    readonly profile: Promise<string>;
	    readonly image: Reference<sageX3System.nodes.Image | null>;
	    readonly picture: Promise<BinaryStream>;
	    readonly functions: Collection<sageX3System.nodes.UserFunctions>;
	    readonly supervisors: Collection<sageX3System.nodes.UserSupervisors>;
	    readonly userDestinations: Collection<sageX3System.nodes.UserUserDestinations>;
	}
	//# sourceMappingURL=user.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/user-user-destinations.d.ts
declare module '@sage/x3-system/lib/nodes/user-user-destinations' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class UserUserDestinations extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3System.nodes.User>;
	    readonly destination: Reference<sageX3System.nodes.Destination | null>;
	}
	//# sourceMappingURL=user-user-destinations.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/user-supervisors.d.ts
declare module '@sage/x3-system/lib/nodes/user-supervisors' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class UserSupervisors extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3System.nodes.User>;
	    readonly supervisor: Reference<sageX3System.nodes.User | null>;
	}
	//# sourceMappingURL=user-supervisors.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/user-profile-menu.d.ts
declare module '@sage/x3-system/lib/nodes/user-profile-menu' {
	import { Node, integer } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class UserProfileMenu extends Node {
	    readonly profile: Promise<string>;
	    readonly module: Promise<sageX3System.enums.ModuleTable | null>;
	    readonly profileType: Promise<sageX3System.enums.ProfileTypeFunction | null>;
	    readonly memory: Promise<integer | null>;
	    readonly profileDescription: Promise<string>;
	    readonly startMenu: Promise<string>;
	}
	//# sourceMappingURL=user-profile-menu.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/user-parameter-value.d.ts
declare module '@sage/x3-system/lib/nodes/user-parameter-value' {
	import { Node, Reference, Context, DateValue } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class UserParameterValue extends Node {
	    readonly description: Promise<string>;
	    readonly user: Reference<sageX3System.nodes.User | null>;
	    readonly value: Promise<string>;
	    readonly defaultSetOfValues: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    static readByUserParameterValueDate(context: Context, parameters: {
	        code: string;
	        user: string;
	    }): Promise<{
	        value: DateValue;
	    }>;
	    static readByUserParameterValueInteger(context: Context, parameters: {
	        code: string;
	        user: string;
	    }): Promise<{
	        value: number;
	    }>;
	    static readByUserParameterValueString(context: Context, parameters: {
	        code: string;
	        user: string;
	    }): Promise<{
	        value: string;
	    }>;
	    static readParameterValueDate(context: Context, parameters: {
	        code: string;
	    }): Promise<{
	        value: DateValue;
	    }>;
	    static readParameterValueInteger(context: Context, parameters: {
	        code: string;
	    }): Promise<{
	        value: number;
	    }>;
	    static readParameterValueString(context: Context, parameters: {
	        code: string;
	    }): Promise<{
	        value: string;
	    }>;
	}
	//# sourceMappingURL=user-parameter-value.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/user-functions.d.ts
declare module '@sage/x3-system/lib/nodes/user-functions' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class UserFunctions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3System.nodes.User>;
	    readonly function: Reference<sageX3System.nodes.Function | null>;
	    readonly parameter: Promise<string>;
	}
	//# sourceMappingURL=user-functions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/user-function-profile.d.ts
declare module '@sage/x3-system/lib/nodes/user-function-profile' {
	import { Node, Collection } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class UserFunctionProfile extends Node {
	    readonly profile: Promise<string>;
	    readonly description: Promise<string>;
	    readonly allAccessAllowed: Promise<boolean>;
	    readonly deferredPrint: Promise<boolean>;
	    readonly reportFilters: Promise<string>;
	    readonly allAuthorizedFunctions: Promise<boolean>;
	    readonly fixedDashboard: Promise<boolean>;
	    readonly userProfileDefaultSites: Collection<sageX3System.nodes.UserFunctionProfileUserProfileDefaultSites>;
	}
	//# sourceMappingURL=user-function-profile.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/user-function-profile-user-profile-default-sites.d.ts
declare module '@sage/x3-system/lib/nodes/user-function-profile-user-profile-default-sites' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class UserFunctionProfileUserProfileDefaultSites extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly profile: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3System.nodes.UserFunctionProfile>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	}
	//# sourceMappingURL=user-function-profile-user-profile-default-sites.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/user-access.d.ts
declare module '@sage/x3-system/lib/nodes/user-access' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class UserAccess extends Node {
	    readonly profile: Reference<sageX3System.nodes.UserFunctionProfile | null>;
	    readonly access: Reference<sageX3System.nodes.Access | null>;
	    readonly user: Reference<sageX3System.nodes.User | null>;
	    readonly inquiry: Promise<boolean>;
	    readonly execution: Promise<boolean>;
	    readonly modification: Promise<boolean>;
	}
	//# sourceMappingURL=user-access.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/syracus-method.d.ts
declare module '@sage/x3-system/lib/nodes/syracus-method' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class SyracusMethod extends Node {
	    readonly profession: Promise<string>;
	    readonly description: Promise<string>;
	    readonly menuProfile: Reference<sageX3System.nodes.UserProfileMenu | null>;
	    readonly functionProfile: Reference<sageX3System.nodes.UserFunctionProfile | null>;
	    readonly biUserProfile: Promise<string>;
	    readonly safeX3WasProfile: Promise<string>;
	}
	//# sourceMappingURL=syracus-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/site.d.ts
declare module '@sage/x3-system/lib/nodes/site' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class Site extends Node {
	    readonly code: Promise<string>;
	    readonly name: Promise<string>;
	    readonly isManufacturing: Promise<boolean>;
	    readonly isStockSite: Promise<boolean>;
	    readonly legalCompany: Reference<sageX3System.nodes.Company>;
	}
	//# sourceMappingURL=site.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/miscellaneous-tables.d.ts
declare module '@sage/x3-system/lib/nodes/miscellaneous-tables' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class MiscellaneousTables extends Node {
	    readonly glossaryId: Promise<integer | null>;
	    readonly tableNumber: Promise<string>;
	    readonly description: Promise<string>;
	    readonly shortDescription: Promise<string>;
	    readonly alpha1: Promise<string>;
	    readonly type1: Promise<string>;
	    readonly option1: Promise<string>;
	    readonly alpha2: Promise<string>;
	    readonly type2: Promise<string>;
	    readonly option2: Promise<string>;
	    readonly numeric1: Promise<string>;
	    readonly type3: Promise<string>;
	    readonly option3: Promise<string>;
	    readonly numeric2: Promise<string>;
	    readonly type4: Promise<string>;
	    readonly option4: Promise<string>;
	    readonly number: Promise<integer | null>;
	    readonly activityCode: Reference<sageX3System.nodes.ActivityCode | null>;
	    readonly access: Reference<sageX3System.nodes.Access | null>;
	    readonly module: Promise<sageX3System.enums.ModuleTable | null>;
	    readonly dependency: Reference<sageX3System.nodes.MiscellaneousTables | null>;
	    readonly modifiableLength: Promise<boolean>;
	    readonly length: Promise<integer | null>;
	    readonly companyFilter: Promise<boolean>;
	    readonly legislationMandatory: Promise<boolean>;
	    readonly filterLegislation: Promise<boolean>;
	    readonly activeFlag: Promise<boolean>;
	}
	//# sourceMappingURL=miscellaneous-tables.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/miscellaneous-table.d.ts
declare module '@sage/x3-system/lib/nodes/miscellaneous-table' {
	import { Node, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class MiscellaneousTable extends Node {
	    readonly glossaryId: Reference<sageX3System.nodes.MiscellaneousTables>;
	    readonly code: Promise<string>;
	    readonly alpha1: Promise<string>;
	    readonly alpha2: Promise<string>;
	    readonly alpha3: Promise<string>;
	    readonly alpha4: Promise<string>;
	    readonly alpha5: Promise<string>;
	    readonly alpha6: Promise<string>;
	    readonly alpha7: Promise<string>;
	    readonly alpha8: Promise<string>;
	    readonly alpha9: Promise<string>;
	    readonly alpha10: Promise<string>;
	    readonly alpha11: Promise<string>;
	    readonly alpha12: Promise<string>;
	    readonly alpha13: Promise<string>;
	    readonly alpha14: Promise<string>;
	    readonly alpha15: Promise<string>;
	    readonly numeric1: Promise<decimal | null>;
	    readonly numeric2: Promise<decimal | null>;
	    readonly numeric3: Promise<decimal | null>;
	    readonly numeric4: Promise<decimal | null>;
	    readonly numeric5: Promise<decimal | null>;
	    readonly numeric6: Promise<decimal | null>;
	    readonly numeric7: Promise<decimal | null>;
	    readonly numeric8: Promise<decimal | null>;
	    readonly numeric9: Promise<decimal | null>;
	    readonly numeric10: Promise<decimal | null>;
	    readonly numeric11: Promise<decimal | null>;
	    readonly numeric12: Promise<decimal | null>;
	    readonly numeric13: Promise<decimal | null>;
	    readonly numeric14: Promise<decimal | null>;
	    readonly numeric15: Promise<decimal | null>;
	    readonly description: Promise<string>;
	    readonly shortDescription: Promise<string>;
	    readonly defaultValue: Promise<boolean>;
	    readonly dependency: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly legislation: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly activeFlag: Promise<boolean>;
	}
	//# sourceMappingURL=miscellaneous-table.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/language.d.ts
declare module '@sage/x3-system/lib/nodes/language' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class Language extends Node {
	    readonly code: Promise<string>;
	    readonly conversion: Promise<sageX3System.enums.AmountConversionIntoLetters | null>;
	    readonly standardLanguage: Promise<boolean>;
	    readonly iso: Promise<string>;
	    readonly unicodeLanguage: Promise<boolean>;
	    readonly connectionLanguage: Promise<boolean>;
	    readonly backupLanguage: Reference<sageX3System.nodes.Language | null>;
	    readonly shortDescription: Promise<string>;
	    readonly description: Promise<string>;
	    readonly primaryLanguage: Reference<sageX3System.nodes.Language | null>;
	}
	//# sourceMappingURL=language.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/index.d.ts
declare module '@sage/x3-system/lib/nodes/index' {
	export * from '@sage/x3-system/lib/nodes/access';
	export * from '@sage/x3-system/lib/nodes/action-parameter';
	export * from '@sage/x3-system/lib/nodes/activity-code';
	export * from '@sage/x3-system/lib/nodes/company';
	export * from '@sage/x3-system/lib/nodes/destination';
	export * from '@sage/x3-system/lib/nodes/function-actions';
	export * from '@sage/x3-system/lib/nodes/function-options';
	export * from '@sage/x3-system/lib/nodes/function-variables';
	export * from '@sage/x3-system/lib/nodes/function';
	export * from '@sage/x3-system/lib/nodes/functional-profile-per-site';
	export * from '@sage/x3-system/lib/nodes/functional-profile';
	export * from '@sage/x3-system/lib/nodes/general-parameter-selectable-values';
	export * from '@sage/x3-system/lib/nodes/general-parameter';
	export * from '@sage/x3-system/lib/nodes/general-parameters-data';
	export * from '@sage/x3-system/lib/nodes/generic-print-report';
	export * from '@sage/x3-system/lib/nodes/image';
	export * from '@sage/x3-system/lib/nodes/language';
	export * from '@sage/x3-system/lib/nodes/miscellaneous-table';
	export * from '@sage/x3-system/lib/nodes/miscellaneous-tables';
	export * from '@sage/x3-system/lib/nodes/site';
	export * from '@sage/x3-system/lib/nodes/syracus-method';
	export * from '@sage/x3-system/lib/nodes/user-access';
	export * from '@sage/x3-system/lib/nodes/user-function-profile-user-profile-default-sites';
	export * from '@sage/x3-system/lib/nodes/user-function-profile';
	export * from '@sage/x3-system/lib/nodes/user-functions';
	export * from '@sage/x3-system/lib/nodes/user-parameter-value';
	export * from '@sage/x3-system/lib/nodes/user-profile-menu';
	export * from '@sage/x3-system/lib/nodes/user-supervisors';
	export * from '@sage/x3-system/lib/nodes/user-user-destinations';
	export * from '@sage/x3-system/lib/nodes/user';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/image.d.ts
declare module '@sage/x3-system/lib/nodes/image' {
	import { Node, BinaryStream } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class Image extends Node {
	    readonly code: Promise<string>;
	    readonly identifier1: Promise<string>;
	    readonly identifier2: Promise<string>;
	    readonly identifier3: Promise<string>;
	    readonly fileName: Promise<string>;
	    readonly data: Promise<BinaryStream>;
	    readonly specialFileType: Promise<sageX3System.enums.TypeOfNonStandardFile | null>;
	}
	//# sourceMappingURL=image.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/generic-print-report.d.ts
declare module '@sage/x3-system/lib/nodes/generic-print-report' {
	import { Node } from '@sage/xtrem-core';
	export class GenericPrintReport extends Node {
	    readonly reportName: Promise<string>;
	}
	//# sourceMappingURL=generic-print-report.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/general-parameters-data.d.ts
declare module '@sage/x3-system/lib/nodes/general-parameters-data' {
	import { Node, Reference, Context, DateValue } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class GeneralParametersData extends Node {
	    readonly code: Promise<string>;
	    readonly company: Reference<sageX3System.nodes.Company | null>;
	    readonly siteOrLegislationCode: Reference<sageX3System.nodes.Site | null>;
	    readonly value: Promise<string>;
	    readonly defaultSetOfValues: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    static readParameterValueDate(context: Context, parameters: {
	        company: string;
	        site: string;
	        code: string;
	    }): Promise<{
	        value: DateValue;
	    }>;
	    static readParameterValueInteger(context: Context, parameters: {
	        company: string;
	        site: string;
	        code: string;
	    }): Promise<{
	        value: number;
	    }>;
	    static readParameterValueString(context: Context, parameters: {
	        company: string;
	        site: string;
	        code: string;
	    }): Promise<{
	        value: string;
	    }>;
	}
	//# sourceMappingURL=general-parameters-data.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/general-parameter.d.ts
declare module '@sage/x3-system/lib/nodes/general-parameter' {
	import { Node, Reference, integer, Collection } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class GeneralParameter extends Node {
	    readonly code: Promise<string>;
	    readonly chapter: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly group: Reference<sageX3System.nodes.MiscellaneousTable>;
	    readonly description: Promise<integer | null>;
	    readonly activityCode: Reference<sageX3System.nodes.ActivityCode | null>;
	    readonly valueType: Promise<sageX3System.enums.FieldType | null>;
	    readonly isEditable: Promise<boolean>;
	    readonly localMenu: Promise<integer | null>;
	    readonly definitionLevel: Promise<sageX3System.enums.ParameterDefinitionLevel | null>;
	    readonly isOffValue: Promise<boolean>;
	    readonly processing: Promise<string>;
	    readonly selectionOptions: Promise<string>;
	    readonly canUserUpdate: Promise<boolean>;
	    readonly sequence: Promise<integer | null>;
	    readonly access: Reference<sageX3System.nodes.Access | null>;
	    readonly folderValue: Promise<boolean>;
	    readonly modifyingCondition: Promise<string>;
	    readonly selectableValues: Collection<sageX3System.nodes.GeneralParameterSelectableValues>;
	}
	//# sourceMappingURL=general-parameter.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/general-parameter-selectable-values.d.ts
declare module '@sage/x3-system/lib/nodes/general-parameter-selectable-values' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class GeneralParameterSelectableValues extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3System.nodes.GeneralParameter>;
	    readonly value: Promise<string>;
	}
	//# sourceMappingURL=general-parameter-selectable-values.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/functional-profile.d.ts
declare module '@sage/x3-system/lib/nodes/functional-profile' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class FunctionalProfile extends Node {
	    readonly profile: Reference<sageX3System.nodes.UserFunctionProfile>;
	    readonly function: Reference<sageX3System.nodes.Function>;
	    readonly siteGrouping: Reference<sageX3System.nodes.Company | null>;
	    readonly menu: Promise<sageX3System.enums.RegroupingSite | null>;
	    readonly access: Promise<boolean>;
	    readonly options: Promise<string>;
	}
	//# sourceMappingURL=functional-profile.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/functional-profile-per-site.d.ts
declare module '@sage/x3-system/lib/nodes/functional-profile-per-site' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class FunctionalProfilePerSite extends Node {
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	    readonly profile: Reference<sageX3System.nodes.UserFunctionProfile | null>;
	    readonly function: Reference<sageX3System.nodes.Function | null>;
	    readonly options: Promise<string>;
	}
	//# sourceMappingURL=functional-profile-per-site.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/function.d.ts
declare module '@sage/x3-system/lib/nodes/function' {
	import { Node, integer, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class Function extends Node {
	    readonly internal: Promise<string>;
	    readonly entryHelp: Promise<integer | null>;
	    readonly activityCode: Reference<sageX3System.nodes.ActivityCode | null>;
	    readonly module: Promise<sageX3System.enums.ModuleTable | null>;
	    readonly external: Promise<string>;
	    readonly number: Promise<integer | null>;
	    readonly menuTitle: Promise<integer | null>;
	    readonly parentMenu: Reference<sageX3System.nodes.Function | null>;
	    readonly description: Promise<integer | null>;
	    readonly noOfOptions: Promise<integer | null>;
	    readonly rowInMenu: Promise<integer | null>;
	    readonly menuProcess: Promise<string>;
	    readonly accessTypeObject: Promise<boolean>;
	    readonly numberOfVariables: Promise<integer | null>;
	    readonly entryPoints: Promise<string>;
	    readonly authorizationSite: Promise<boolean>;
	    readonly single: Promise<boolean>;
	    readonly actions: Collection<sageX3System.nodes.FunctionActions>;
	    readonly options: Collection<sageX3System.nodes.FunctionOptions>;
	    readonly variables: Collection<sageX3System.nodes.FunctionVariables>;
	}
	//# sourceMappingURL=function.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/function-variables.d.ts
declare module '@sage/x3-system/lib/nodes/function-variables' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class FunctionVariables extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly internal: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3System.nodes.Function>;
	    readonly activityCode: Reference<sageX3System.nodes.ActivityCode | null>;
	    readonly value: Promise<string>;
	    readonly variable: Promise<string>;
	}
	//# sourceMappingURL=function-variables.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/function-options.d.ts
declare module '@sage/x3-system/lib/nodes/function-options' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class FunctionOptions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly internal: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3System.nodes.Function>;
	    readonly code: Promise<string>;
	    readonly activityCode: Reference<sageX3System.nodes.ActivityCode | null>;
	    readonly title: Promise<integer | null>;
	    readonly function: Reference<sageX3System.nodes.Function | null>;
	}
	//# sourceMappingURL=function-options.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/function-actions.d.ts
declare module '@sage/x3-system/lib/nodes/function-actions' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class FunctionActions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly internal: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3System.nodes.Function>;
	    readonly value: Promise<string>;
	    readonly parameter: Reference<sageX3System.nodes.ActionParameter | null>;
	}
	//# sourceMappingURL=function-actions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/destination.d.ts
declare module '@sage/x3-system/lib/nodes/destination' {
	import { Node, Reference, integer } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class Destination extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly shortDescription: Promise<string>;
	    readonly isActive: Promise<boolean>;
	    readonly accessCode: Reference<sageX3System.nodes.Access | null>;
	    readonly destination: Promise<sageX3System.enums.DestinationTypes | null>;
	    readonly destinationFile: Promise<string>;
	    readonly server: Promise<string>;
	    readonly printerName: Promise<string>;
	    readonly driver: Promise<string>;
	    readonly port: Promise<string>;
	    readonly pageOrientation: Promise<sageX3System.enums.Orientation | null>;
	    readonly printerType: Promise<sageX3System.enums.PrinterType | null>;
	    readonly numberOfCopies: Promise<integer | null>;
	    readonly isAssembledCopies: Promise<boolean>;
	    readonly orientation: Promise<integer | null>;
	}
	//# sourceMappingURL=destination.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/company.d.ts
declare module '@sage/x3-system/lib/nodes/company' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class Company extends Node {
	    readonly code: Promise<string>;
	    readonly name: Promise<string>;
	    readonly shortDescription: Promise<string>;
	    readonly isLegalCompany: Promise<boolean>;
	    readonly legislation: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly logo: Reference<sageX3System.nodes.Image | null>;
	}
	//# sourceMappingURL=company.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/activity-code.d.ts
declare module '@sage/x3-system/lib/nodes/activity-code' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3System from '@sage/x3-system/lib/index';
	export class ActivityCode extends Node {
	    readonly code: Promise<string>;
	    readonly screenSize: Promise<integer | null>;
	    readonly databaseMinimumSize: Promise<integer | null>;
	    readonly maximumSize: Promise<integer | null>;
	    readonly activeFlag: Promise<boolean>;
	    readonly description: Promise<integer | null>;
	    readonly module: Promise<sageX3System.enums.ModuleTable | null>;
	    readonly sequence: Promise<integer | null>;
	    readonly order: Promise<integer | null>;
	    readonly type: Promise<sageX3System.enums.TypesOfActivityCode | null>;
	    readonly dependency: Promise<sageX3System.enums.TypeOfDependency | null>;
	    readonly activityCode: Reference<sageX3System.nodes.ActivityCode | null>;
	    readonly formula: Promise<string>;
	    readonly description1: Promise<string>;
	}
	//# sourceMappingURL=activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/action-parameter.d.ts
declare module '@sage/x3-system/lib/nodes/action-parameter' {
	import { Node } from '@sage/xtrem-core';
	export class ActionParameter extends Node {
	    readonly code: Promise<string>;
	}
	//# sourceMappingURL=action-parameter.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/nodes/access.d.ts
declare module '@sage/x3-system/lib/nodes/access' {
	import { Node } from '@sage/xtrem-core';
	export class Access extends Node {
	    readonly access: Promise<string>;
	    readonly description: Promise<string>;
	    readonly description1: Promise<string>;
	}
	//# sourceMappingURL=access.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/node-extensions/index.d.ts
declare module '@sage/x3-system/lib/node-extensions/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/xsl-type.d.ts
declare module '@sage/x3-system/lib/enums/xsl-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum XslTypeEnum {
	    miscellaneous = 1,
	    planning = 2,
	    bom = 3,
	    radar = 4
	}
	export interface XslType$EnumInterface {
	    miscellaneous: 1;
	    planning: 2;
	    bom: 3;
	    radar: 4;
	}
	export type XslType = keyof XslType$EnumInterface;
	export const xslTypeDatatype: X3EnumDataType<keyof XslType$EnumInterface, unknown>;
	//# sourceMappingURL=xsl-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/x-3-products.d.ts
declare module '@sage/x3-system/lib/enums/x-3-products' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum X3ProductsEnum {
	    all = 1,
	    supervisor = 2,
	    x3 = 3,
	    geode = 4,
	    payroll = 5
	}
	export interface X3Products$EnumInterface {
	    all: 1;
	    supervisor: 2;
	    x3: 3;
	    geode: 4;
	    payroll: 5;
	}
	export type X3Products = keyof X3Products$EnumInterface;
	export const x3ProductsDatatype: X3EnumDataType<keyof X3Products$EnumInterface, unknown>;
	//# sourceMappingURL=x-3-products.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/workflow-status.d.ts
declare module '@sage/x3-system/lib/enums/workflow-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WorkflowStatusEnum {
	    none = 1,
	    toProcess = 2,
	    processed = 3
	}
	export interface WorkflowStatus$EnumInterface {
	    none: 1;
	    toProcess: 2;
	    processed: 3;
	}
	export type WorkflowStatus = keyof WorkflowStatus$EnumInterface;
	export const workflowStatusDatatype: X3EnumDataType<keyof WorkflowStatus$EnumInterface, unknown>;
	//# sourceMappingURL=workflow-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/window-types.d.ts
declare module '@sage/x3-system/lib/enums/window-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WindowTypesEnum {
	    invalidWindows = 1,
	    timeStampInferiorTo = 2,
	    all = 3,
	    windowsPendingValidation = 4
	}
	export interface WindowTypes$EnumInterface {
	    invalidWindows: 1;
	    timeStampInferiorTo: 2;
	    all: 3;
	    windowsPendingValidation: 4;
	}
	export type WindowTypes = keyof WindowTypes$EnumInterface;
	export const windowTypesDatatype: X3EnumDataType<keyof WindowTypes$EnumInterface, unknown>;
	//# sourceMappingURL=window-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/window-type.d.ts
declare module '@sage/x3-system/lib/enums/window-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WindowTypeEnum {
	    fullScreen = 1,
	    dialogBox = 2,
	    messageBox = 3,
	    selecting = 4
	}
	export interface WindowType$EnumInterface {
	    fullScreen: 1;
	    dialogBox: 2;
	    messageBox: 3;
	    selecting: 4;
	}
	export type WindowType = keyof WindowType$EnumInterface;
	export const windowTypeDatatype: X3EnumDataType<keyof WindowType$EnumInterface, unknown>;
	//# sourceMappingURL=window-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/window-type-923.d.ts
declare module '@sage/x3-system/lib/enums/window-type-923' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WindowType923Enum {
	    miscellaneous = 1,
	    object = 2,
	    inquiry = 3,
	    inquiryCriteria = 4,
	    selectionTable = 5
	}
	export interface WindowType923$EnumInterface {
	    miscellaneous: 1;
	    object: 2;
	    inquiry: 3;
	    inquiryCriteria: 4;
	    selectionTable: 5;
	}
	export type WindowType923 = keyof WindowType923$EnumInterface;
	export const windowType923Datatype: X3EnumDataType<keyof WindowType923$EnumInterface, unknown>;
	//# sourceMappingURL=window-type-923.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/where-used.d.ts
declare module '@sage/x3-system/lib/enums/where-used' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WhereUsedEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3
	}
	export interface WhereUsed$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	}
	export type WhereUsed = keyof WhereUsed$EnumInterface;
	export const whereUsedDatatype: X3EnumDataType<keyof WhereUsed$EnumInterface, unknown>;
	//# sourceMappingURL=where-used.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/web-site-type.d.ts
declare module '@sage/x3-system/lib/enums/web-site-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WebSiteTypeEnum {
	    none = 1,
	    webSites = 2,
	    webPages = 3,
	    webSiteProfiles = 4,
	    fieldTokens = 5,
	    entity = 6,
	    blockTokens = 7,
	    conditionedBlockTokens = 8,
	    webAction = 9,
	    dynamicLinks = 10,
	    specialFieldTokens = 11,
	    webMessage = 12,
	    interface = 13,
	    advancedParam = 14,
	    listOfValues = 15
	}
	export interface WebSiteType$EnumInterface {
	    none: 1;
	    webSites: 2;
	    webPages: 3;
	    webSiteProfiles: 4;
	    fieldTokens: 5;
	    entity: 6;
	    blockTokens: 7;
	    conditionedBlockTokens: 8;
	    webAction: 9;
	    dynamicLinks: 10;
	    specialFieldTokens: 11;
	    webMessage: 12;
	    interface: 13;
	    advancedParam: 14;
	    listOfValues: 15;
	}
	export type WebSiteType = keyof WebSiteType$EnumInterface;
	export const webSiteTypeDatatype: X3EnumDataType<keyof WebSiteType$EnumInterface, unknown>;
	//# sourceMappingURL=web-site-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/web-site-field-type.d.ts
declare module '@sage/x3-system/lib/enums/web-site-field-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WebSiteFieldTypeEnum {
	    text = 1,
	    integer = 2,
	    decimal = 3,
	    currency = 4,
	    date = 5,
	    imageAccess = 6,
	    attachmentAccess = 7,
	    localMenu = 8,
	    flash = 9
	}
	export interface WebSiteFieldType$EnumInterface {
	    text: 1;
	    integer: 2;
	    decimal: 3;
	    currency: 4;
	    date: 5;
	    imageAccess: 6;
	    attachmentAccess: 7;
	    localMenu: 8;
	    flash: 9;
	}
	export type WebSiteFieldType = keyof WebSiteFieldType$EnumInterface;
	export const webSiteFieldTypeDatatype: X3EnumDataType<keyof WebSiteFieldType$EnumInterface, unknown>;
	//# sourceMappingURL=web-site-field-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/web-services-type.d.ts
declare module '@sage/x3-system/lib/enums/web-services-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WebServicesTypeEnum {
	    object = 1,
	    subProgram = 2
	}
	export interface WebServicesType$EnumInterface {
	    object: 1;
	    subProgram: 2;
	}
	export type WebServicesType = keyof WebServicesType$EnumInterface;
	export const webServicesTypeDatatype: X3EnumDataType<keyof WebServicesType$EnumInterface, unknown>;
	//# sourceMappingURL=web-services-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/web-services-message-severity.d.ts
declare module '@sage/x3-system/lib/enums/web-services-message-severity' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WebServicesMessageSeverityEnum {
	    message = 1,
	    warning = 2,
	    error = 3,
	    ok = 4
	}
	export interface WebServicesMessageSeverity$EnumInterface {
	    message: 1;
	    warning: 2;
	    error: 3;
	    ok: 4;
	}
	export type WebServicesMessageSeverity = keyof WebServicesMessageSeverity$EnumInterface;
	export const webServicesMessageSeverityDatatype: X3EnumDataType<keyof WebServicesMessageSeverity$EnumInterface, unknown>;
	//# sourceMappingURL=web-services-message-severity.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/web-service-element.d.ts
declare module '@sage/x3-system/lib/enums/web-service-element' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WebServiceElementEnum {
	    mask = 1,
	    element = 2,
	    group = 3,
	    table = 4
	}
	export interface WebServiceElement$EnumInterface {
	    mask: 1;
	    element: 2;
	    group: 3;
	    table: 4;
	}
	export type WebServiceElement = keyof WebServiceElement$EnumInterface;
	export const webServiceElementDatatype: X3EnumDataType<keyof WebServiceElement$EnumInterface, unknown>;
	//# sourceMappingURL=web-service-element.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/vocabulary-validation-options.d.ts
declare module '@sage/x3-system/lib/enums/vocabulary-validation-options' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VocabularyValidationOptionsEnum {
	    currentVersion = 1,
	    standardVersion = 2
	}
	export interface VocabularyValidationOptions$EnumInterface {
	    currentVersion: 1;
	    standardVersion: 2;
	}
	export type VocabularyValidationOptions = keyof VocabularyValidationOptions$EnumInterface;
	export const vocabularyValidationOptionsDatatype: X3EnumDataType<keyof VocabularyValidationOptions$EnumInterface, unknown>;
	//# sourceMappingURL=vocabulary-validation-options.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/verbs.d.ts
declare module '@sage/x3-system/lib/enums/verbs' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VerbsEnum {
	    get = 1,
	    head = 2,
	    post = 3,
	    options = 4,
	    connect = 5,
	    trace = 6,
	    put = 7,
	    delete = 8
	}
	export interface Verbs$EnumInterface {
	    get: 1;
	    head: 2;
	    post: 3;
	    options: 4;
	    connect: 5;
	    trace: 6;
	    put: 7;
	    delete: 8;
	}
	export type Verbs = keyof Verbs$EnumInterface;
	export const verbsDatatype: X3EnumDataType<keyof Verbs$EnumInterface, unknown>;
	//# sourceMappingURL=verbs.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/value-type-7925.d.ts
declare module '@sage/x3-system/lib/enums/value-type-7925' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ValueType7925Enum {
	    constant = 1,
	    fieldToken = 2,
	    webField = 3,
	    webFieldMandat = 4,
	    accessCode = 5,
	    entry = 6,
	    block = 7
	}
	export interface ValueType7925$EnumInterface {
	    constant: 1;
	    fieldToken: 2;
	    webField: 3;
	    webFieldMandat: 4;
	    accessCode: 5;
	    entry: 6;
	    block: 7;
	}
	export type ValueType7925 = keyof ValueType7925$EnumInterface;
	export const valueType7925Datatype: X3EnumDataType<keyof ValueType7925$EnumInterface, unknown>;
	//# sourceMappingURL=value-type-7925.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/validity-type.d.ts
declare module '@sage/x3-system/lib/enums/validity-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ValidityTypeEnum {
	    validated = 1,
	    notValidated = 2,
	    all = 3
	}
	export interface ValidityType$EnumInterface {
	    validated: 1;
	    notValidated: 2;
	    all: 3;
	}
	export type ValidityType = keyof ValidityType$EnumInterface;
	export const validityTypeDatatype: X3EnumDataType<keyof ValidityType$EnumInterface, unknown>;
	//# sourceMappingURL=validity-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/validation-type.d.ts
declare module '@sage/x3-system/lib/enums/validation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ValidationTypeEnum {
	    free = 1,
	    complete = 2,
	    additionalLanguage = 3
	}
	export interface ValidationType$EnumInterface {
	    free: 1;
	    complete: 2;
	    additionalLanguage: 3;
	}
	export type ValidationType = keyof ValidationType$EnumInterface;
	export const validationTypeDatatype: X3EnumDataType<keyof ValidationType$EnumInterface, unknown>;
	//# sourceMappingURL=validation-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/validation-type-7829.d.ts
declare module '@sage/x3-system/lib/enums/validation-type-7829' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ValidationType7829Enum {
	    list = 1,
	    all = 2
	}
	export interface ValidationType7829$EnumInterface {
	    list: 1;
	    all: 2;
	}
	export type ValidationType7829 = keyof ValidationType7829$EnumInterface;
	export const validationType7829Datatype: X3EnumDataType<keyof ValidationType7829$EnumInterface, unknown>;
	//# sourceMappingURL=validation-type-7829.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/utility-launch-status.d.ts
declare module '@sage/x3-system/lib/enums/utility-launch-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UtilityLaunchStatusEnum {
	    toLaunch = 1,
	    launched = 2,
	    inactive = 3,
	    error = 4
	}
	export interface UtilityLaunchStatus$EnumInterface {
	    toLaunch: 1;
	    launched: 2;
	    inactive: 3;
	    error: 4;
	}
	export type UtilityLaunchStatus = keyof UtilityLaunchStatus$EnumInterface;
	export const utilityLaunchStatusDatatype: X3EnumDataType<keyof UtilityLaunchStatus$EnumInterface, unknown>;
	//# sourceMappingURL=utility-launch-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/utility-execution.d.ts
declare module '@sage/x3-system/lib/enums/utility-execution' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UtilityExecutionEnum {
	    executedAtTheStart = 1,
	    executedAtTheEnd = 2,
	    deferredExecution = 3,
	    inactive = 4
	}
	export interface UtilityExecution$EnumInterface {
	    executedAtTheStart: 1;
	    executedAtTheEnd: 2;
	    deferredExecution: 3;
	    inactive: 4;
	}
	export type UtilityExecution = keyof UtilityExecution$EnumInterface;
	export const utilityExecutionDatatype: X3EnumDataType<keyof UtilityExecution$EnumInterface, unknown>;
	//# sourceMappingURL=utility-execution.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/utilities.d.ts
declare module '@sage/x3-system/lib/enums/utilities' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UtilitiesEnum {
	    singleUser = 1,
	    noLock = 2,
	    singleModule = 3
	}
	export interface Utilities$EnumInterface {
	    singleUser: 1;
	    noLock: 2;
	    singleModule: 3;
	}
	export type Utilities = keyof Utilities$EnumInterface;
	export const utilitiesDatatype: X3EnumDataType<keyof Utilities$EnumInterface, unknown>;
	//# sourceMappingURL=utilities.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/user-access-type.d.ts
declare module '@sage/x3-system/lib/enums/user-access-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UserAccessTypeEnum {
	    noAccess = 1,
	    inquiry = 2,
	    change = 3
	}
	export interface UserAccessType$EnumInterface {
	    noAccess: 1;
	    inquiry: 2;
	    change: 3;
	}
	export type UserAccessType = keyof UserAccessType$EnumInterface;
	export const userAccessTypeDatatype: X3EnumDataType<keyof UserAccessType$EnumInterface, unknown>;
	//# sourceMappingURL=user-access-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/url-location.d.ts
declare module '@sage/x3-system/lib/enums/url-location' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UrlLocationEnum {
	    worldWideWeb = 1,
	    publicFolder = 2,
	    currentFolder = 3
	}
	export interface UrlLocation$EnumInterface {
	    worldWideWeb: 1;
	    publicFolder: 2;
	    currentFolder: 3;
	}
	export type UrlLocation = keyof UrlLocation$EnumInterface;
	export const urlLocationDatatype: X3EnumDataType<keyof UrlLocation$EnumInterface, unknown>;
	//# sourceMappingURL=url-location.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/updating-type.d.ts
declare module '@sage/x3-system/lib/enums/updating-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UpdatingTypeEnum {
	    incremental = 1,
	    cancelsAndReplaces = 2,
	    incrementalAudit = 3
	}
	export interface UpdatingType$EnumInterface {
	    incremental: 1;
	    cancelsAndReplaces: 2;
	    incrementalAudit: 3;
	}
	export type UpdatingType = keyof UpdatingType$EnumInterface;
	export const updatingTypeDatatype: X3EnumDataType<keyof UpdatingType$EnumInterface, unknown>;
	//# sourceMappingURL=updating-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/updated-description.d.ts
declare module '@sage/x3-system/lib/enums/updated-description' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UpdatedDescriptionEnum {
	    lineMsgUpdated = 1,
	    line2 = 2
	}
	export interface UpdatedDescription$EnumInterface {
	    lineMsgUpdated: 1;
	    line2: 2;
	}
	export type UpdatedDescription = keyof UpdatedDescription$EnumInterface;
	export const updatedDescriptionDatatype: X3EnumDataType<keyof UpdatedDescription$EnumInterface, unknown>;
	//# sourceMappingURL=updated-description.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/update-type.d.ts
declare module '@sage/x3-system/lib/enums/update-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UpdateTypeEnum {
	    standard = 1,
	    hotfix = 2,
	    specific = 3,
	    addOn = 4,
	    internal = 5
	}
	export interface UpdateType$EnumInterface {
	    standard: 1;
	    hotfix: 2;
	    specific: 3;
	    addOn: 4;
	    internal: 5;
	}
	export type UpdateType = keyof UpdateType$EnumInterface;
	export const updateTypeDatatype: X3EnumDataType<keyof UpdateType$EnumInterface, unknown>;
	//# sourceMappingURL=update-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/update-status.d.ts
declare module '@sage/x3-system/lib/enums/update-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UpdateStatusEnum {
	    controlOk = 1,
	    inProgress = 2,
	    ended = 3,
	    notApplicable = 4,
	    error = 5,
	    endedWithWarnings = 6
	}
	export interface UpdateStatus$EnumInterface {
	    controlOk: 1;
	    inProgress: 2;
	    ended: 3;
	    notApplicable: 4;
	    error: 5;
	    endedWithWarnings: 6;
	}
	export type UpdateStatus = keyof UpdateStatus$EnumInterface;
	export const updateStatusDatatype: X3EnumDataType<keyof UpdateStatus$EnumInterface, unknown>;
	//# sourceMappingURL=update-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/update-operations.d.ts
declare module '@sage/x3-system/lib/enums/update-operations' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UpdateOperationsEnum {
	    creation = 1,
	    modification = 2,
	    deletion = 3
	}
	export interface UpdateOperations$EnumInterface {
	    creation: 1;
	    modification: 2;
	    deletion: 3;
	}
	export type UpdateOperations = keyof UpdateOperations$EnumInterface;
	export const updateOperationsDatatype: X3EnumDataType<keyof UpdateOperations$EnumInterface, unknown>;
	//# sourceMappingURL=update-operations.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/update-frequency.d.ts
declare module '@sage/x3-system/lib/enums/update-frequency' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UpdateFrequencyEnum {
	    atEachUse = 1,
	    everyHour = 2,
	    everyDay = 3,
	    everyWeek = 4,
	    everyMonth = 5,
	    theFirstTime = 6,
	    substituteValue7 = 7,
	    everyMinute = 8,
	    every10Seconds = 9
	}
	export interface UpdateFrequency$EnumInterface {
	    atEachUse: 1;
	    everyHour: 2;
	    everyDay: 3;
	    everyWeek: 4;
	    everyMonth: 5;
	    theFirstTime: 6;
	    substituteValue7: 7;
	    everyMinute: 8;
	    every10Seconds: 9;
	}
	export type UpdateFrequency = keyof UpdateFrequency$EnumInterface;
	export const updateFrequencyDatatype: X3EnumDataType<keyof UpdateFrequency$EnumInterface, unknown>;
	//# sourceMappingURL=update-frequency.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/unit-type.d.ts
declare module '@sage/x3-system/lib/enums/unit-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UnitTypeEnum {
	    length = 1,
	    area = 2,
	    volume = 3,
	    weight = 4,
	    time = 5,
	    each = 6,
	    packing = 7,
	    other = 8
	}
	export interface UnitType$EnumInterface {
	    length: 1;
	    area: 2;
	    volume: 3;
	    weight: 4;
	    time: 5;
	    each: 6;
	    packing: 7;
	    other: 8;
	}
	export type UnitType = keyof UnitType$EnumInterface;
	export const unitTypeDatatype: X3EnumDataType<keyof UnitType$EnumInterface, unknown>;
	//# sourceMappingURL=unit-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/types-of-activity-code.d.ts
declare module '@sage/x3-system/lib/enums/types-of-activity-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypesOfActivityCodeEnum {
	    functional = 1,
	    sizing = 2,
	    localization = 3
	}
	export interface TypesOfActivityCode$EnumInterface {
	    functional: 1;
	    sizing: 2;
	    localization: 3;
	}
	export type TypesOfActivityCode = keyof TypesOfActivityCode$EnumInterface;
	export const typesOfActivityCodeDatatype: X3EnumDataType<keyof TypesOfActivityCode$EnumInterface, unknown>;
	//# sourceMappingURL=types-of-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/type-of-statistic.d.ts
declare module '@sage/x3-system/lib/enums/type-of-statistic' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfStatisticEnum {
	    normal = 1,
	    rollingTotal = 2,
	    ofTotal = 3,
	    accumulated = 4
	}
	export interface TypeOfStatistic$EnumInterface {
	    normal: 1;
	    rollingTotal: 2;
	    ofTotal: 3;
	    accumulated: 4;
	}
	export type TypeOfStatistic = keyof TypeOfStatistic$EnumInterface;
	export const typeOfStatisticDatatype: X3EnumDataType<keyof TypeOfStatistic$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-statistic.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/type-of-session.d.ts
declare module '@sage/x3-system/lib/enums/type-of-session' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfSessionEnum {
	    primary1 = 1,
	    secondary2 = 2,
	    batch3 = 3,
	    webServices4 = 4,
	    terminal5 = 5,
	    eclipse6 = 6,
	    javaBridge7 = 7,
	    substituteValue8 = 8,
	    primary = 9,
	    secondary = 10,
	    batch11 = 11,
	    webServices12 = 12,
	    terminal13 = 13,
	    eclipse14 = 14,
	    javaBridge = 15,
	    substituteValue16 = 16,
	    console = 17,
	    substituteValue18 = 18,
	    substituteValue19 = 19,
	    webServices = 20,
	    terminal = 21,
	    substituteValue22 = 22,
	    substituteValue23 = 23,
	    substituteValue24 = 24,
	    classicPage = 25,
	    substituteValue26 = 26,
	    substituteValue27 = 27,
	    substituteValue28 = 28,
	    substituteValue29 = 29,
	    eclipse = 30,
	    substituteValue31 = 31,
	    substituteValue32 = 32,
	    webPage = 33,
	    remoteClassicCall = 34,
	    batch = 35
	}
	export interface TypeOfSession$EnumInterface {
	    primary1: 1;
	    secondary2: 2;
	    batch3: 3;
	    webServices4: 4;
	    terminal5: 5;
	    eclipse6: 6;
	    javaBridge7: 7;
	    substituteValue8: 8;
	    primary: 9;
	    secondary: 10;
	    batch11: 11;
	    webServices12: 12;
	    terminal13: 13;
	    eclipse14: 14;
	    javaBridge: 15;
	    substituteValue16: 16;
	    console: 17;
	    substituteValue18: 18;
	    substituteValue19: 19;
	    webServices: 20;
	    terminal: 21;
	    substituteValue22: 22;
	    substituteValue23: 23;
	    substituteValue24: 24;
	    classicPage: 25;
	    substituteValue26: 26;
	    substituteValue27: 27;
	    substituteValue28: 28;
	    substituteValue29: 29;
	    eclipse: 30;
	    substituteValue31: 31;
	    substituteValue32: 32;
	    webPage: 33;
	    remoteClassicCall: 34;
	    batch: 35;
	}
	export type TypeOfSession = keyof TypeOfSession$EnumInterface;
	export const typeOfSessionDatatype: X3EnumDataType<keyof TypeOfSession$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-session.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/type-of-quick-select-list.d.ts
declare module '@sage/x3-system/lib/enums/type-of-quick-select-list' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfQuickSelectListEnum {
	    simple = 1,
	    hierarchical = 2,
	    selection = 3,
	    recursive = 4,
	    simpleSelection = 5
	}
	export interface TypeOfQuickSelectList$EnumInterface {
	    simple: 1;
	    hierarchical: 2;
	    selection: 3;
	    recursive: 4;
	    simpleSelection: 5;
	}
	export type TypeOfQuickSelectList = keyof TypeOfQuickSelectList$EnumInterface;
	export const typeOfQuickSelectListDatatype: X3EnumDataType<keyof TypeOfQuickSelectList$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-quick-select-list.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/type-of-parameters.d.ts
declare module '@sage/x3-system/lib/enums/type-of-parameters' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfParametersEnum {
	    character = 1,
	    integer = 2,
	    boolean = 3,
	    numeric = 4,
	    date = 5,
	    text = 6,
	    enumeration = 7
	}
	export interface TypeOfParameters$EnumInterface {
	    character: 1;
	    integer: 2;
	    boolean: 3;
	    numeric: 4;
	    date: 5;
	    text: 6;
	    enumeration: 7;
	}
	export type TypeOfParameters = keyof TypeOfParameters$EnumInterface;
	export const typeOfParametersDatatype: X3EnumDataType<keyof TypeOfParameters$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-parameters.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/type-of-non-standard-file.d.ts
declare module '@sage/x3-system/lib/enums/type-of-non-standard-file' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfNonStandardFileEnum {
	    unspecified = 1,
	    text = 2,
	    image = 3,
	    office = 4,
	    word = 5,
	    excel = 6,
	    powerPoint = 7
	}
	export interface TypeOfNonStandardFile$EnumInterface {
	    unspecified: 1;
	    text: 2;
	    image: 3;
	    office: 4;
	    word: 5;
	    excel: 6;
	    powerPoint: 7;
	}
	export type TypeOfNonStandardFile = keyof TypeOfNonStandardFile$EnumInterface;
	export const typeOfNonStandardFileDatatype: X3EnumDataType<keyof TypeOfNonStandardFile$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-non-standard-file.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/type-of-gadget.d.ts
declare module '@sage/x3-system/lib/enums/type-of-gadget' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfGadgetEnum {
	    gadget = 1,
	    menu = 2,
	    separator = 3
	}
	export interface TypeOfGadget$EnumInterface {
	    gadget: 1;
	    menu: 2;
	    separator: 3;
	}
	export type TypeOfGadget = keyof TypeOfGadget$EnumInterface;
	export const typeOfGadgetDatatype: X3EnumDataType<keyof TypeOfGadget$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-gadget.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/type-of-dependency.d.ts
declare module '@sage/x3-system/lib/enums/type-of-dependency' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfDependencyEnum {
	    none = 1,
	    reverse = 2,
	    sizing = 3,
	    formula = 4
	}
	export interface TypeOfDependency$EnumInterface {
	    none: 1;
	    reverse: 2;
	    sizing: 3;
	    formula: 4;
	}
	export type TypeOfDependency = keyof TypeOfDependency$EnumInterface;
	export const typeOfDependencyDatatype: X3EnumDataType<keyof TypeOfDependency$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-dependency.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/type-of-day.d.ts
declare module '@sage/x3-system/lib/enums/type-of-day' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfDayEnum {
	    workingDay = 1,
	    weekEnd = 2,
	    holiday = 3
	}
	export interface TypeOfDay$EnumInterface {
	    workingDay: 1;
	    weekEnd: 2;
	    holiday: 3;
	}
	export type TypeOfDay = keyof TypeOfDay$EnumInterface;
	export const typeOfDayDatatype: X3EnumDataType<keyof TypeOfDay$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-day.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/type-of-date.d.ts
declare module '@sage/x3-system/lib/enums/type-of-date' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfDateEnum {
	    currentDate = 1,
	    startOfMonth = 2,
	    endOfMonth = 3,
	    startOfYear = 4,
	    endOfYear = 5,
	    startOfQuarter = 6,
	    endOfQuarter = 7,
	    startOfWeek = 8,
	    endOfWeek = 9,
	    startOfFortnight = 10,
	    endOfFortnight = 11,
	    startOf10DayPeriod = 12,
	    endOf10DayPeriod = 13,
	    formula = 14,
	    absoluteDate = 15
	}
	export interface TypeOfDate$EnumInterface {
	    currentDate: 1;
	    startOfMonth: 2;
	    endOfMonth: 3;
	    startOfYear: 4;
	    endOfYear: 5;
	    startOfQuarter: 6;
	    endOfQuarter: 7;
	    startOfWeek: 8;
	    endOfWeek: 9;
	    startOfFortnight: 10;
	    endOfFortnight: 11;
	    startOf10DayPeriod: 12;
	    endOf10DayPeriod: 13;
	    formula: 14;
	    absoluteDate: 15;
	}
	export type TypeOfDate = keyof TypeOfDate$EnumInterface;
	export const typeOfDateDatatype: X3EnumDataType<keyof TypeOfDate$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-date.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/type-of-date-913.d.ts
declare module '@sage/x3-system/lib/enums/type-of-date-913' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfDate913Enum {
	    days = 1,
	    weeks = 2,
	    months = 3,
	    years = 4
	}
	export interface TypeOfDate913$EnumInterface {
	    days: 1;
	    weeks: 2;
	    months: 3;
	    years: 4;
	}
	export type TypeOfDate913 = keyof TypeOfDate913$EnumInterface;
	export const typeOfDate913Datatype: X3EnumDataType<keyof TypeOfDate913$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-date-913.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/type-of-activity.d.ts
declare module '@sage/x3-system/lib/enums/type-of-activity' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfActivityEnum {
	    work = 1,
	    paidHolidays = 2,
	    recuperationTime = 3,
	    sickness = 4,
	    training = 5
	}
	export interface TypeOfActivity$EnumInterface {
	    work: 1;
	    paidHolidays: 2;
	    recuperationTime: 3;
	    sickness: 4;
	    training: 5;
	}
	export type TypeOfActivity = keyof TypeOfActivity$EnumInterface;
	export const typeOfActivityDatatype: X3EnumDataType<keyof TypeOfActivity$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-activity.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/type-de-mise-au-point.d.ts
declare module '@sage/x3-system/lib/enums/type-de-mise-au-point' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeDeMiseAuPointEnum {
	    inProgress = 1,
	    debug = 2,
	    otherSession = 3
	}
	export interface TypeDeMiseAuPoint$EnumInterface {
	    inProgress: 1;
	    debug: 2;
	    otherSession: 3;
	}
	export type TypeDeMiseAuPoint = keyof TypeDeMiseAuPoint$EnumInterface;
	export const typeDeMiseAuPointDatatype: X3EnumDataType<keyof TypeDeMiseAuPoint$EnumInterface, unknown>;
	//# sourceMappingURL=type-de-mise-au-point.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/type-7882.d.ts
declare module '@sage/x3-system/lib/enums/type-7882' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Type7882Enum {
	    char = 1,
	    integer = 2,
	    decimal = 3,
	    date = 4
	}
	export interface Type7882$EnumInterface {
	    char: 1;
	    integer: 2;
	    decimal: 3;
	    date: 4;
	}
	export type Type7882 = keyof Type7882$EnumInterface;
	export const type7882Datatype: X3EnumDataType<keyof Type7882$EnumInterface, unknown>;
	//# sourceMappingURL=type-7882.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/type-7881.d.ts
declare module '@sage/x3-system/lib/enums/type-7881' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Type7881Enum {
	    simple = 1,
	    reference = 2,
	    richMedia = 3
	}
	export interface Type7881$EnumInterface {
	    simple: 1;
	    reference: 2;
	    richMedia: 3;
	}
	export type Type7881 = keyof Type7881$EnumInterface;
	export const type7881Datatype: X3EnumDataType<keyof Type7881$EnumInterface, unknown>;
	//# sourceMappingURL=type-7881.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/translation-priority-level.d.ts
declare module '@sage/x3-system/lib/enums/translation-priority-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TranslationPriorityLevelEnum {
	    normal = 1,
	    high = 2,
	    maximum = 3,
	    doNotTranslate = 4
	}
	export interface TranslationPriorityLevel$EnumInterface {
	    normal: 1;
	    high: 2;
	    maximum: 3;
	    doNotTranslate: 4;
	}
	export type TranslationPriorityLevel = keyof TranslationPriorityLevel$EnumInterface;
	export const translationPriorityLevelDatatype: X3EnumDataType<keyof TranslationPriorityLevel$EnumInterface, unknown>;
	//# sourceMappingURL=translation-priority-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/transfer-type.d.ts
declare module '@sage/x3-system/lib/enums/transfer-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransferTypeEnum {
	    file = 1,
	    imageFileTable = 2,
	    textFileTable = 3
	}
	export interface TransferType$EnumInterface {
	    file: 1;
	    imageFileTable: 2;
	    textFileTable: 3;
	}
	export type TransferType = keyof TransferType$EnumInterface;
	export const transferTypeDatatype: X3EnumDataType<keyof TransferType$EnumInterface, unknown>;
	//# sourceMappingURL=transfer-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/trace-presentation.d.ts
declare module '@sage/x3-system/lib/enums/trace-presentation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TracePresentationEnum {
	    listOfAllTracedSqlOrders = 1,
	    listRestrictedToTheSpecifiedNumberOfSqlOrders = 2
	}
	export interface TracePresentation$EnumInterface {
	    listOfAllTracedSqlOrders: 1;
	    listRestrictedToTheSpecifiedNumberOfSqlOrders: 2;
	}
	export type TracePresentation = keyof TracePresentation$EnumInterface;
	export const tracePresentationDatatype: X3EnumDataType<keyof TracePresentation$EnumInterface, unknown>;
	//# sourceMappingURL=trace-presentation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/title.d.ts
declare module '@sage/x3-system/lib/enums/title' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TitleEnum {
	    mr = 1,
	    mrs = 2,
	    ms = 3
	}
	export interface Title$EnumInterface {
	    mr: 1;
	    mrs: 2;
	    ms: 3;
	}
	export type Title = keyof Title$EnumInterface;
	export const titleDatatype: X3EnumDataType<keyof Title$EnumInterface, unknown>;
	//# sourceMappingURL=title.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/timestamp-management.d.ts
declare module '@sage/x3-system/lib/enums/timestamp-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TimestampManagementEnum {
	    yes = 1,
	    no = 2,
	    periodic = 3
	}
	export interface TimestampManagement$EnumInterface {
	    yes: 1;
	    no: 2;
	    periodic: 3;
	}
	export type TimestampManagement = keyof TimestampManagement$EnumInterface;
	export const timestampManagementDatatype: X3EnumDataType<keyof TimestampManagement$EnumInterface, unknown>;
	//# sourceMappingURL=timestamp-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/text-type.d.ts
declare module '@sage/x3-system/lib/enums/text-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TextTypeEnum {
	    text = 1,
	    message = 2
	}
	export interface TextType$EnumInterface {
	    text: 1;
	    message: 2;
	}
	export type TextType = keyof TextType$EnumInterface;
	export const textTypeDatatype: X3EnumDataType<keyof TextType$EnumInterface, unknown>;
	//# sourceMappingURL=text-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/text-type-944.d.ts
declare module '@sage/x3-system/lib/enums/text-type-944' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TextType944Enum {
	    undetermined = 1,
	    richText = 2,
	    rawText = 3
	}
	export interface TextType944$EnumInterface {
	    undetermined: 1;
	    richText: 2;
	    rawText: 3;
	}
	export type TextType944 = keyof TextType944$EnumInterface;
	export const textType944Datatype: X3EnumDataType<keyof TextType944$EnumInterface, unknown>;
	//# sourceMappingURL=text-type-944.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/text-roles.d.ts
declare module '@sage/x3-system/lib/enums/text-roles' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TextRolesEnum {
	    confidential = 1,
	    internal = 2,
	    external = 3,
	    external2 = 4
	}
	export interface TextRoles$EnumInterface {
	    confidential: 1;
	    internal: 2;
	    external: 3;
	    external2: 4;
	}
	export type TextRoles = keyof TextRoles$EnumInterface;
	export const textRolesDatatype: X3EnumDataType<keyof TextRoles$EnumInterface, unknown>;
	//# sourceMappingURL=text-roles.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/test-queries.d.ts
declare module '@sage/x3-system/lib/enums/test-queries' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TestQueriesEnum {
	    query1 = 1,
	    query2 = 2,
	    query3 = 3
	}
	export interface TestQueries$EnumInterface {
	    query1: 1;
	    query2: 2;
	    query3: 3;
	}
	export type TestQueries = keyof TestQueries$EnumInterface;
	export const testQueriesDatatype: X3EnumDataType<keyof TestQueries$EnumInterface, unknown>;
	//# sourceMappingURL=test-queries.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/template-type.d.ts
declare module '@sage/x3-system/lib/enums/template-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TemplateTypeEnum {
	    structures = 1,
	    mask = 2
	}
	export interface TemplateType$EnumInterface {
	    structures: 1;
	    mask: 2;
	}
	export type TemplateType = keyof TemplateType$EnumInterface;
	export const templateTypeDatatype: X3EnumDataType<keyof TemplateType$EnumInterface, unknown>;
	//# sourceMappingURL=template-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/telephone-type.d.ts
declare module '@sage/x3-system/lib/enums/telephone-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TelephoneTypeEnum {
	    landline = 1,
	    fax = 2,
	    tollfree = 3,
	    other = 4,
	    mobile = 5
	}
	export interface TelephoneType$EnumInterface {
	    landline: 1;
	    fax: 2;
	    tollfree: 3;
	    other: 4;
	    mobile: 5;
	}
	export type TelephoneType = keyof TelephoneType$EnumInterface;
	export const telephoneTypeDatatype: X3EnumDataType<keyof TelephoneType$EnumInterface, unknown>;
	//# sourceMappingURL=telephone-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/telephone-number-control.d.ts
declare module '@sage/x3-system/lib/enums/telephone-number-control' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TelephoneNumberControlEnum {
	    none = 1,
	    onlyInModificationMode = 2,
	    always = 3
	}
	export interface TelephoneNumberControl$EnumInterface {
	    none: 1;
	    onlyInModificationMode: 2;
	    always: 3;
	}
	export type TelephoneNumberControl = keyof TelephoneNumberControl$EnumInterface;
	export const telephoneNumberControlDatatype: X3EnumDataType<keyof TelephoneNumberControl$EnumInterface, unknown>;
	//# sourceMappingURL=telephone-number-control.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/technical-type-field.d.ts
declare module '@sage/x3-system/lib/enums/technical-type-field' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TechnicalTypeFieldEnum {
	    miscellaneous = 1,
	    mimeType = 2,
	    exclusion = 3,
	    xsl = 4,
	    menu = 5
	}
	export interface TechnicalTypeField$EnumInterface {
	    miscellaneous: 1;
	    mimeType: 2;
	    exclusion: 3;
	    xsl: 4;
	    menu: 5;
	}
	export type TechnicalTypeField = keyof TechnicalTypeField$EnumInterface;
	export const technicalTypeFieldDatatype: X3EnumDataType<keyof TechnicalTypeField$EnumInterface, unknown>;
	//# sourceMappingURL=technical-type-field.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/technical-origin.d.ts
declare module '@sage/x3-system/lib/enums/technical-origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TechnicalOriginEnum {
	    classicPages = 1,
	    classes = 2
	}
	export interface TechnicalOrigin$EnumInterface {
	    classicPages: 1;
	    classes: 2;
	}
	export type TechnicalOrigin = keyof TechnicalOrigin$EnumInterface;
	export const technicalOriginDatatype: X3EnumDataType<keyof TechnicalOrigin$EnumInterface, unknown>;
	//# sourceMappingURL=technical-origin.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/tax-basis.d.ts
declare module '@sage/x3-system/lib/enums/tax-basis' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TaxBasisEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2
	}
	export interface TaxBasis$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	}
	export type TaxBasis = keyof TaxBasis$EnumInterface;
	export const taxBasisDatatype: X3EnumDataType<keyof TaxBasis$EnumInterface, unknown>;
	//# sourceMappingURL=tax-basis.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/table-type.d.ts
declare module '@sage/x3-system/lib/enums/table-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TableTypeEnum {
	    application = 1,
	    supervisor = 2,
	    sageX3System = 3,
	    dictionary = 4,
	    internal = 5
	}
	export interface TableType$EnumInterface {
	    application: 1;
	    supervisor: 2;
	    sageX3System: 3;
	    dictionary: 4;
	    internal: 5;
	}
	export type TableType = keyof TableType$EnumInterface;
	export const tableTypeDatatype: X3EnumDataType<keyof TableType$EnumInterface, unknown>;
	//# sourceMappingURL=table-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/table-type-80.d.ts
declare module '@sage/x3-system/lib/enums/table-type-80' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TableType80Enum {
	    neutral = 1,
	    cisam = 2,
	    oracle = 3,
	    system = 4,
	    sqlServer = 5,
	    db2Udb = 6,
	    fileInMemoryVtb = 7
	}
	export interface TableType80$EnumInterface {
	    neutral: 1;
	    cisam: 2;
	    oracle: 3;
	    system: 4;
	    sqlServer: 5;
	    db2Udb: 6;
	    fileInMemoryVtb: 7;
	}
	export type TableType80 = keyof TableType80$EnumInterface;
	export const tableType80Datatype: X3EnumDataType<keyof TableType80$EnumInterface, unknown>;
	//# sourceMappingURL=table-type-80.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/table-type-2930.d.ts
declare module '@sage/x3-system/lib/enums/table-type-2930' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TableType2930Enum {
	    character = 1,
	    characterOrGraph = 2,
	    characterAndGraph = 3,
	    graph = 4
	}
	export interface TableType2930$EnumInterface {
	    character: 1;
	    characterOrGraph: 2;
	    characterAndGraph: 3;
	    graph: 4;
	}
	export type TableType2930 = keyof TableType2930$EnumInterface;
	export const tableType2930Datatype: X3EnumDataType<keyof TableType2930$EnumInterface, unknown>;
	//# sourceMappingURL=table-type-2930.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/system-transaction-type.d.ts
declare module '@sage/x3-system/lib/enums/system-transaction-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SystemTransactionTypeEnum {
	    modification = 1,
	    deletion = 2,
	    creation = 3
	}
	export interface SystemTransactionType$EnumInterface {
	    modification: 1;
	    deletion: 2;
	    creation: 3;
	}
	export type SystemTransactionType = keyof SystemTransactionType$EnumInterface;
	export const systemTransactionTypeDatatype: X3EnumDataType<keyof SystemTransactionType$EnumInterface, unknown>;
	//# sourceMappingURL=system-transaction-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/syracuse-test.d.ts
declare module '@sage/x3-system/lib/enums/syracuse-test' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SyracuseTestEnum {
	    insertsBefore = 1,
	    insertsAfter = 2,
	    deletesFrom = 3
	}
	export interface SyracuseTest$EnumInterface {
	    insertsBefore: 1;
	    insertsAfter: 2;
	    deletesFrom: 3;
	}
	export type SyracuseTest = keyof SyracuseTest$EnumInterface;
	export const syracuseTestDatatype: X3EnumDataType<keyof SyracuseTest$EnumInterface, unknown>;
	//# sourceMappingURL=syracuse-test.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/syracuse-format.d.ts
declare module '@sage/x3-system/lib/enums/syracuse-format' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SyracuseFormatEnum {
	    boolean = 1,
	    integer = 2,
	    decimal = 3,
	    real = 4,
	    date = 5,
	    time = 6,
	    string = 7,
	    text = 8,
	    binaryData = 9,
	    enumeration = 10,
	    datetime = 11
	}
	export interface SyracuseFormat$EnumInterface {
	    boolean: 1;
	    integer: 2;
	    decimal: 3;
	    real: 4;
	    date: 5;
	    time: 6;
	    string: 7;
	    text: 8;
	    binaryData: 9;
	    enumeration: 10;
	    datetime: 11;
	}
	export type SyracuseFormat = keyof SyracuseFormat$EnumInterface;
	export const syracuseFormatDatatype: X3EnumDataType<keyof SyracuseFormat$EnumInterface, unknown>;
	//# sourceMappingURL=syracuse-format.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/synthesis-operators.d.ts
declare module '@sage/x3-system/lib/enums/synthesis-operators' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SynthesisOperatorsEnum {
	    mini = 1,
	    maxi = 2,
	    sum = 3,
	    average = 4
	}
	export interface SynthesisOperators$EnumInterface {
	    mini: 1;
	    maxi: 2;
	    sum: 3;
	    average: 4;
	}
	export type SynthesisOperators = keyof SynthesisOperators$EnumInterface;
	export const synthesisOperatorsDatatype: X3EnumDataType<keyof SynthesisOperators$EnumInterface, unknown>;
	//# sourceMappingURL=synthesis-operators.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/supervisor-counters.d.ts
declare module '@sage/x3-system/lib/enums/supervisor-counters' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SupervisorCountersEnum {
	    workflowGroupSequenceNumber = 1,
	    workflowLineSequenceNumber = 2,
	    lotNbOfImportTempStorageSpace = 3,
	    xtendForm = 4
	}
	export interface SupervisorCounters$EnumInterface {
	    workflowGroupSequenceNumber: 1;
	    workflowLineSequenceNumber: 2;
	    lotNbOfImportTempStorageSpace: 3;
	    xtendForm: 4;
	}
	export type SupervisorCounters = keyof SupervisorCounters$EnumInterface;
	export const supervisorCountersDatatype: X3EnumDataType<keyof SupervisorCounters$EnumInterface, unknown>;
	//# sourceMappingURL=supervisor-counters.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/subdivision-entry.d.ts
declare module '@sage/x3-system/lib/enums/subdivision-entry' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SubdivisionEntryEnum {
	    none = 1,
	    subdivision1 = 2,
	    subdivision2 = 3
	}
	export interface SubdivisionEntry$EnumInterface {
	    none: 1;
	    subdivision1: 2;
	    subdivision2: 3;
	}
	export type SubdivisionEntry = keyof SubdivisionEntry$EnumInterface;
	export const subdivisionEntryDatatype: X3EnumDataType<keyof SubdivisionEntry$EnumInterface, unknown>;
	//# sourceMappingURL=subdivision-entry.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/sub-program-types.d.ts
declare module '@sage/x3-system/lib/enums/sub-program-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SubProgramTypesEnum {
	    miscellaneous = 1,
	    control = 2,
	    entry = 3,
	    selection = 4,
	    update = 5,
	    xsl = 6,
	    status = 7,
	    infoSearch = 8,
	    calculation = 9
	}
	export interface SubProgramTypes$EnumInterface {
	    miscellaneous: 1;
	    control: 2;
	    entry: 3;
	    selection: 4;
	    update: 5;
	    xsl: 6;
	    status: 7;
	    infoSearch: 8;
	    calculation: 9;
	}
	export type SubProgramTypes = keyof SubProgramTypes$EnumInterface;
	export const subProgramTypesDatatype: X3EnumDataType<keyof SubProgramTypes$EnumInterface, unknown>;
	//# sourceMappingURL=sub-program-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/status-doc.d.ts
declare module '@sage/x3-system/lib/enums/status-doc' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StatusDocEnum {
	    deliverable = 1,
	    setupKit = 2
	}
	export interface StatusDoc$EnumInterface {
	    deliverable: 1;
	    setupKit: 2;
	}
	export type StatusDoc = keyof StatusDoc$EnumInterface;
	export const statusDocDatatype: X3EnumDataType<keyof StatusDoc$EnumInterface, unknown>;
	//# sourceMappingURL=status-doc.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/statistical-update.d.ts
declare module '@sage/x3-system/lib/enums/statistical-update' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StatisticalUpdateEnum {
	    incremental = 1,
	    recovery = 2
	}
	export interface StatisticalUpdate$EnumInterface {
	    incremental: 1;
	    recovery: 2;
	}
	export type StatisticalUpdate = keyof StatisticalUpdate$EnumInterface;
	export const statisticalUpdateDatatype: X3EnumDataType<keyof StatisticalUpdate$EnumInterface, unknown>;
	//# sourceMappingURL=statistical-update.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/statistical-type.d.ts
declare module '@sage/x3-system/lib/enums/statistical-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StatisticalTypeEnum {
	    realTime = 1,
	    batch = 2
	}
	export interface StatisticalType$EnumInterface {
	    realTime: 1;
	    batch: 2;
	}
	export type StatisticalType = keyof StatisticalType$EnumInterface;
	export const statisticalTypeDatatype: X3EnumDataType<keyof StatisticalType$EnumInterface, unknown>;
	//# sourceMappingURL=statistical-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/statistical-frequency.d.ts
declare module '@sage/x3-system/lib/enums/statistical-frequency' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StatisticalFrequencyEnum {
	    daily = 1,
	    weekly = 2,
	    substituteValue3 = 3,
	    monthly = 4,
	    quarterly = 5,
	    yearly = 6,
	    substituteValue7 = 7
	}
	export interface StatisticalFrequency$EnumInterface {
	    daily: 1;
	    weekly: 2;
	    substituteValue3: 3;
	    monthly: 4;
	    quarterly: 5;
	    yearly: 6;
	    substituteValue7: 7;
	}
	export type StatisticalFrequency = keyof StatisticalFrequency$EnumInterface;
	export const statisticalFrequencyDatatype: X3EnumDataType<keyof StatisticalFrequency$EnumInterface, unknown>;
	//# sourceMappingURL=statistical-frequency.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/standard-methods.d.ts
declare module '@sage/x3-system/lib/enums/standard-methods' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StandardMethodsEnum {
	    creation = 1,
	    deletion = 2,
	    attachments = 3,
	    comments = 4,
	    browsing = 5,
	    print = 6,
	    read = 7,
	    selection = 8,
	    duplication = 9,
	    modification = 10,
	    executable = 11
	}
	export interface StandardMethods$EnumInterface {
	    creation: 1;
	    deletion: 2;
	    attachments: 3;
	    comments: 4;
	    browsing: 5;
	    print: 6;
	    read: 7;
	    selection: 8;
	    duplication: 9;
	    modification: 10;
	    executable: 11;
	}
	export type StandardMethods = keyof StandardMethods$EnumInterface;
	export const standardMethodsDatatype: X3EnumDataType<keyof StandardMethods$EnumInterface, unknown>;
	//# sourceMappingURL=standard-methods.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/standard-bottom-of-page-codes.d.ts
declare module '@sage/x3-system/lib/enums/standard-bottom-of-page-codes' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StandardBottomOfPageCodesEnum {
	    search = 1,
	    create = 2,
	    change = 3,
	    cancel = 4,
	    copy = 5,
	    next = 6,
	    previous7 = 7,
	    list = 8,
	    validate = 9,
	    print = 10,
	    previous = 11,
	    last = 12,
	    xSel = 13,
	    table = 14,
	    code = 15,
	    page16 = 16,
	    page = 17,
	    end = 18
	}
	export interface StandardBottomOfPageCodes$EnumInterface {
	    search: 1;
	    create: 2;
	    change: 3;
	    cancel: 4;
	    copy: 5;
	    next: 6;
	    previous7: 7;
	    list: 8;
	    validate: 9;
	    print: 10;
	    previous: 11;
	    last: 12;
	    xSel: 13;
	    table: 14;
	    code: 15;
	    page16: 16;
	    page: 17;
	    end: 18;
	}
	export type StandardBottomOfPageCodes = keyof StandardBottomOfPageCodes$EnumInterface;
	export const standardBottomOfPageCodesDatatype: X3EnumDataType<keyof StandardBottomOfPageCodes$EnumInterface, unknown>;
	//# sourceMappingURL=standard-bottom-of-page-codes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/sql-server-trace-options.d.ts
declare module '@sage/x3-system/lib/enums/sql-server-trace-options' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SqlServerTraceOptionsEnum {
	    standardChronological = 1,
	    durationTimeInMilliseconds = 2,
	    cpuTimeConsumedInMilliseconds = 3,
	    writesNumberOfPhysicalWritesPerformed = 4,
	    readsNumberOfPhysicalReadsPerformed = 5
	}
	export interface SqlServerTraceOptions$EnumInterface {
	    standardChronological: 1;
	    durationTimeInMilliseconds: 2;
	    cpuTimeConsumedInMilliseconds: 3;
	    writesNumberOfPhysicalWritesPerformed: 4;
	    readsNumberOfPhysicalReadsPerformed: 5;
	}
	export type SqlServerTraceOptions = keyof SqlServerTraceOptions$EnumInterface;
	export const sqlServerTraceOptionsDatatype: X3EnumDataType<keyof SqlServerTraceOptions$EnumInterface, unknown>;
	//# sourceMappingURL=sql-server-trace-options.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/sql-server-process-sorting.d.ts
declare module '@sage/x3-system/lib/enums/sql-server-process-sorting' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SqlServerProcessSortingEnum {
	    processId = 1,
	    database = 2,
	    connectionUser = 3,
	    logonDate = 4,
	    status = 5,
	    application = 6,
	    command = 7,
	    lastExecution = 8,
	    hostProcess = 9,
	    hostMachine = 10,
	    cpu = 11,
	    memory = 12,
	    ioPhys = 13
	}
	export interface SqlServerProcessSorting$EnumInterface {
	    processId: 1;
	    database: 2;
	    connectionUser: 3;
	    logonDate: 4;
	    status: 5;
	    application: 6;
	    command: 7;
	    lastExecution: 8;
	    hostProcess: 9;
	    hostMachine: 10;
	    cpu: 11;
	    memory: 12;
	    ioPhys: 13;
	}
	export type SqlServerProcessSorting = keyof SqlServerProcessSorting$EnumInterface;
	export const sqlServerProcessSortingDatatype: X3EnumDataType<keyof SqlServerProcessSorting$EnumInterface, unknown>;
	//# sourceMappingURL=sql-server-process-sorting.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/specifics-compliance.d.ts
declare module '@sage/x3-system/lib/enums/specifics-compliance' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SpecificsComplianceEnum {
	    risks = 1,
	    errors = 2,
	    fatalErrors = 3,
	    impacts = 4
	}
	export interface SpecificsCompliance$EnumInterface {
	    risks: 1;
	    errors: 2;
	    fatalErrors: 3;
	    impacts: 4;
	}
	export type SpecificsCompliance = keyof SpecificsCompliance$EnumInterface;
	export const specificsComplianceDatatype: X3EnumDataType<keyof SpecificsCompliance$EnumInterface, unknown>;
	//# sourceMappingURL=specifics-compliance.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/specific-flag.d.ts
declare module '@sage/x3-system/lib/enums/specific-flag' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SpecificFlagEnum {
	    standard = 1,
	    vertical = 2,
	    specific = 3
	}
	export interface SpecificFlag$EnumInterface {
	    standard: 1;
	    vertical: 2;
	    specific: 3;
	}
	export type SpecificFlag = keyof SpecificFlag$EnumInterface;
	export const specificFlagDatatype: X3EnumDataType<keyof SpecificFlag$EnumInterface, unknown>;
	//# sourceMappingURL=specific-flag.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/sort-type.d.ts
declare module '@sage/x3-system/lib/enums/sort-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortTypeEnum {
	    none = 1,
	    ascending = 2,
	    descending = 3
	}
	export interface SortType$EnumInterface {
	    none: 1;
	    ascending: 2;
	    descending: 3;
	}
	export type SortType = keyof SortType$EnumInterface;
	export const sortTypeDatatype: X3EnumDataType<keyof SortType$EnumInterface, unknown>;
	//# sourceMappingURL=sort-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/sort-type-7917.d.ts
declare module '@sage/x3-system/lib/enums/sort-type-7917' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortType7917Enum {
	    none = 1,
	    field = 2,
	    random = 3
	}
	export interface SortType7917$EnumInterface {
	    none: 1;
	    field: 2;
	    random: 3;
	}
	export type SortType7917 = keyof SortType7917$EnumInterface;
	export const sortType7917Datatype: X3EnumDataType<keyof SortType7917$EnumInterface, unknown>;
	//# sourceMappingURL=sort-type-7917.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/sort-order.d.ts
declare module '@sage/x3-system/lib/enums/sort-order' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortOrderEnum {
	    ascending = 1,
	    descending = 2
	}
	export interface SortOrder$EnumInterface {
	    ascending: 1;
	    descending: 2;
	}
	export type SortOrder = keyof SortOrder$EnumInterface;
	export const sortOrderDatatype: X3EnumDataType<keyof SortOrder$EnumInterface, unknown>;
	//# sourceMappingURL=sort-order.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/sort-open-items.d.ts
declare module '@sage/x3-system/lib/enums/sort-open-items' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortOpenItemsEnum {
	    payByBp = 1,
	    dueDate = 2
	}
	export interface SortOpenItems$EnumInterface {
	    payByBp: 1;
	    dueDate: 2;
	}
	export type SortOpenItems = keyof SortOpenItems$EnumInterface;
	export const sortOpenItemsDatatype: X3EnumDataType<keyof SortOpenItems$EnumInterface, unknown>;
	//# sourceMappingURL=sort-open-items.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/sort-functions.d.ts
declare module '@sage/x3-system/lib/enums/sort-functions' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortFunctionsEnum {
	    byCode = 1,
	    byMenu = 2
	}
	export interface SortFunctions$EnumInterface {
	    byCode: 1;
	    byMenu: 2;
	}
	export type SortFunctions = keyof SortFunctions$EnumInterface;
	export const sortFunctionsDatatype: X3EnumDataType<keyof SortFunctions$EnumInterface, unknown>;
	//# sourceMappingURL=sort-functions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/sizing.d.ts
declare module '@sage/x3-system/lib/enums/sizing' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SizingEnum {
	    from1 = 1,
	    from0 = 2
	}
	export interface Sizing$EnumInterface {
	    from1: 1;
	    from0: 2;
	}
	export type Sizing = keyof Sizing$EnumInterface;
	export const sizingDatatype: X3EnumDataType<keyof Sizing$EnumInterface, unknown>;
	//# sourceMappingURL=sizing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/size.d.ts
declare module '@sage/x3-system/lib/enums/size' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SizeEnum {
	    none = 1,
	    from1 = 2,
	    from0 = 3
	}
	export interface Size$EnumInterface {
	    none: 1;
	    from1: 2;
	    from0: 3;
	}
	export type Size = keyof Size$EnumInterface;
	export const sizeDatatype: X3EnumDataType<keyof Size$EnumInterface, unknown>;
	//# sourceMappingURL=size.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/signature-2922.d.ts
declare module '@sage/x3-system/lib/enums/signature-2922' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Signature2922Enum {
	    cancelled = 1,
	    toBeRead = 2,
	    toBeSigned = 3,
	    read = 4,
	    signed = 5
	}
	export interface Signature2922$EnumInterface {
	    cancelled: 1;
	    toBeRead: 2;
	    toBeSigned: 3;
	    read: 4;
	    signed: 5;
	}
	export type Signature2922 = keyof Signature2922$EnumInterface;
	export const signature2922Datatype: X3EnumDataType<keyof Signature2922$EnumInterface, unknown>;
	//# sourceMappingURL=signature-2922.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/setup-elements.d.ts
declare module '@sage/x3-system/lib/enums/setup-elements' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SetupElementsEnum {
	    all = 1,
	    selected = 2,
	    notSelected = 3
	}
	export interface SetupElements$EnumInterface {
	    all: 1;
	    selected: 2;
	    notSelected: 3;
	}
	export type SetupElements = keyof SetupElements$EnumInterface;
	export const setupElementsDatatype: X3EnumDataType<keyof SetupElements$EnumInterface, unknown>;
	//# sourceMappingURL=setup-elements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/server-status.d.ts
declare module '@sage/x3-system/lib/enums/server-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ServerStatusEnum {
	    inactive = 1,
	    active = 2,
	    shuttingDown = 3,
	    restartInProgress = 4
	}
	export interface ServerStatus$EnumInterface {
	    inactive: 1;
	    active: 2;
	    shuttingDown: 3;
	    restartInProgress: 4;
	}
	export type ServerStatus = keyof ServerStatus$EnumInterface;
	export const serverStatusDatatype: X3EnumDataType<keyof ServerStatus$EnumInterface, unknown>;
	//# sourceMappingURL=server-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/sequence-type.d.ts
declare module '@sage/x3-system/lib/enums/sequence-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SequenceTypeEnum {
	    normal = 1,
	    databaseSequence = 2,
	    grouped = 3
	}
	export interface SequenceType$EnumInterface {
	    normal: 1;
	    databaseSequence: 2;
	    grouped: 3;
	}
	export type SequenceType = keyof SequenceType$EnumInterface;
	export const sequenceTypeDatatype: X3EnumDataType<keyof SequenceType$EnumInterface, unknown>;
	//# sourceMappingURL=sequence-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/sequence-number-type.d.ts
declare module '@sage/x3-system/lib/enums/sequence-number-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SequenceNumberTypeEnum {
	    alphanumeric = 1,
	    numeric = 2
	}
	export interface SequenceNumberType$EnumInterface {
	    alphanumeric: 1;
	    numeric: 2;
	}
	export type SequenceNumberType = keyof SequenceNumberType$EnumInterface;
	export const sequenceNumberTypeDatatype: X3EnumDataType<keyof SequenceNumberType$EnumInterface, unknown>;
	//# sourceMappingURL=sequence-number-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/sequence-number-fields.d.ts
declare module '@sage/x3-system/lib/enums/sequence-number-fields' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SequenceNumberFieldsEnum {
	    constant = 1,
	    year = 2,
	    month = 3,
	    week = 4,
	    day = 5,
	    company = 6,
	    site = 7,
	    sequenceNumber = 8,
	    complement = 9,
	    fiscalYear = 10,
	    period = 11,
	    formula = 12
	}
	export interface SequenceNumberFields$EnumInterface {
	    constant: 1;
	    year: 2;
	    month: 3;
	    week: 4;
	    day: 5;
	    company: 6;
	    site: 7;
	    sequenceNumber: 8;
	    complement: 9;
	    fiscalYear: 10;
	    period: 11;
	    formula: 12;
	}
	export type SequenceNumberFields = keyof SequenceNumberFields$EnumInterface;
	export const sequenceNumberFieldsDatatype: X3EnumDataType<keyof SequenceNumberFields$EnumInterface, unknown>;
	//# sourceMappingURL=sequence-number-fields.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/send-type.d.ts
declare module '@sage/x3-system/lib/enums/send-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SendTypeEnum {
	    any = 1,
	    server = 2,
	    client = 3
	}
	export interface SendType$EnumInterface {
	    any: 1;
	    server: 2;
	    client: 3;
	}
	export type SendType = keyof SendType$EnumInterface;
	export const sendTypeDatatype: X3EnumDataType<keyof SendType$EnumInterface, unknown>;
	//# sourceMappingURL=send-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/selective-assembly.d.ts
declare module '@sage/x3-system/lib/enums/selective-assembly' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectiveAssemblyEnum {
	    allTypes = 1,
	    cS = 2,
	    web = 3
	}
	export interface SelectiveAssembly$EnumInterface {
	    allTypes: 1;
	    cS: 2;
	    web: 3;
	}
	export type SelectiveAssembly = keyof SelectiveAssembly$EnumInterface;
	export const selectiveAssemblyDatatype: X3EnumDataType<keyof SelectiveAssembly$EnumInterface, unknown>;
	//# sourceMappingURL=selective-assembly.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/selection-type.d.ts
declare module '@sage/x3-system/lib/enums/selection-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectionTypeEnum {
	    none = 1,
	    code = 2,
	    query = 3,
	    lastLinkClicked = 4,
	    detail = 5
	}
	export interface SelectionType$EnumInterface {
	    none: 1;
	    code: 2;
	    query: 3;
	    lastLinkClicked: 4;
	    detail: 5;
	}
	export type SelectionType = keyof SelectionType$EnumInterface;
	export const selectionTypeDatatype: X3EnumDataType<keyof SelectionType$EnumInterface, unknown>;
	//# sourceMappingURL=selection-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/selection-opt-main-block.d.ts
declare module '@sage/x3-system/lib/enums/selection-opt-main-block' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectionOptMainBlockEnum {
	    replacesTheSelectionOfTheMainBlock = 1,
	    isAddedToTheSelectionOfTheMainBlock = 2,
	    isAddedToAllTheCurrentSelections = 3
	}
	export interface SelectionOptMainBlock$EnumInterface {
	    replacesTheSelectionOfTheMainBlock: 1;
	    isAddedToTheSelectionOfTheMainBlock: 2;
	    isAddedToAllTheCurrentSelections: 3;
	}
	export type SelectionOptMainBlock = keyof SelectionOptMainBlock$EnumInterface;
	export const selectionOptMainBlockDatatype: X3EnumDataType<keyof SelectionOptMainBlock$EnumInterface, unknown>;
	//# sourceMappingURL=selection-opt-main-block.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/selection-operators.d.ts
declare module '@sage/x3-system/lib/enums/selection-operators' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectionOperatorsEnum {
	    all = 1,
	    equal = 2,
	    notEqualTo = 3,
	    greaterThan = 4,
	    greaterThanOrEqualTo = 5,
	    lessThan = 6,
	    lessThanOrEqualTo = 7,
	    like = 8
	}
	export interface SelectionOperators$EnumInterface {
	    all: 1;
	    equal: 2;
	    notEqualTo: 3;
	    greaterThan: 4;
	    greaterThanOrEqualTo: 5;
	    lessThan: 6;
	    lessThanOrEqualTo: 7;
	    like: 8;
	}
	export type SelectionOperators = keyof SelectionOperators$EnumInterface;
	export const selectionOperatorsDatatype: X3EnumDataType<keyof SelectionOperators$EnumInterface, unknown>;
	//# sourceMappingURL=selection-operators.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/selection-operators-7926.d.ts
declare module '@sage/x3-system/lib/enums/selection-operators-7926' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectionOperators7926Enum {
	    indifferent = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4,
	    substituteValue5 = 5,
	    substituteValue6 = 6,
	    substituteValue7 = 7,
	    startsWith = 8,
	    contains = 9,
	    doesNotContain = 10
	}
	export interface SelectionOperators7926$EnumInterface {
	    indifferent: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	    substituteValue5: 5;
	    substituteValue6: 6;
	    substituteValue7: 7;
	    startsWith: 8;
	    contains: 9;
	    doesNotContain: 10;
	}
	export type SelectionOperators7926 = keyof SelectionOperators7926$EnumInterface;
	export const selectionOperators7926Datatype: X3EnumDataType<keyof SelectionOperators7926$EnumInterface, unknown>;
	//# sourceMappingURL=selection-operators-7926.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/selection-operators-7815.d.ts
declare module '@sage/x3-system/lib/enums/selection-operators-7815' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectionOperators7815Enum {
	    indifferent = 1,
	    equalTo = 2,
	    different = 3,
	    greaterThan = 4,
	    greaterThanOrEqualTo = 5,
	    lessThan = 6,
	    lessThanOrEqualTo = 7,
	    like = 8,
	    modified = 9,
	    increased = 10,
	    reduced = 11
	}
	export interface SelectionOperators7815$EnumInterface {
	    indifferent: 1;
	    equalTo: 2;
	    different: 3;
	    greaterThan: 4;
	    greaterThanOrEqualTo: 5;
	    lessThan: 6;
	    lessThanOrEqualTo: 7;
	    like: 8;
	    modified: 9;
	    increased: 10;
	    reduced: 11;
	}
	export type SelectionOperators7815 = keyof SelectionOperators7815$EnumInterface;
	export const selectionOperators7815Datatype: X3EnumDataType<keyof SelectionOperators7815$EnumInterface, unknown>;
	//# sourceMappingURL=selection-operators-7815.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/security-level.d.ts
declare module '@sage/x3-system/lib/enums/security-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SecurityLevelEnum {
	    high = 1,
	    medium = 2,
	    low = 3
	}
	export interface SecurityLevel$EnumInterface {
	    high: 1;
	    medium: 2;
	    low: 3;
	}
	export type SecurityLevel = keyof SecurityLevel$EnumInterface;
	export const securityLevelDatatype: X3EnumDataType<keyof SecurityLevel$EnumInterface, unknown>;
	//# sourceMappingURL=security-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/search-operators.d.ts
declare module '@sage/x3-system/lib/enums/search-operators' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SearchOperatorsEnum {
	    equal = 1,
	    greaterThan = 2,
	    lessThan = 3,
	    different = 4
	}
	export interface SearchOperators$EnumInterface {
	    equal: 1;
	    greaterThan: 2;
	    lessThan: 3;
	    different: 4;
	}
	export type SearchOperators = keyof SearchOperators$EnumInterface;
	export const searchOperatorsDatatype: X3EnumDataType<keyof SearchOperators$EnumInterface, unknown>;
	//# sourceMappingURL=search-operators.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/screen-type.d.ts
declare module '@sage/x3-system/lib/enums/screen-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ScreenTypeEnum {
	    tab = 1,
	    dialogueBox = 2,
	    fullScreen = 3,
	    fullScreenWithList = 4,
	    header = 5,
	    vtScreen = 6
	}
	export interface ScreenType$EnumInterface {
	    tab: 1;
	    dialogueBox: 2;
	    fullScreen: 3;
	    fullScreenWithList: 4;
	    header: 5;
	    vtScreen: 6;
	}
	export type ScreenType = keyof ScreenType$EnumInterface;
	export const screenTypeDatatype: X3EnumDataType<keyof ScreenType$EnumInterface, unknown>;
	//# sourceMappingURL=screen-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/screen-resolution.d.ts
declare module '@sage/x3-system/lib/enums/screen-resolution' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ScreenResolutionEnum {
	    lowResolution = 1,
	    highResolution = 2
	}
	export interface ScreenResolution$EnumInterface {
	    lowResolution: 1;
	    highResolution: 2;
	}
	export type ScreenResolution = keyof ScreenResolution$EnumInterface;
	export const screenResolutionDatatype: X3EnumDataType<keyof ScreenResolution$EnumInterface, unknown>;
	//# sourceMappingURL=screen-resolution.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/rule-types.d.ts
declare module '@sage/x3-system/lib/enums/rule-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RuleTypesEnum {
	    init = 1,
	    control = 2,
	    propagate = 3,
	    getvalue = 4,
	    format = 5,
	    readMedia = 6,
	    updateMedia = 7,
	    deleteMedia = 8,
	    insertMedia = 9,
	    readMediaCnt = 10,
	    existMedia = 11
	}
	export interface RuleTypes$EnumInterface {
	    init: 1;
	    control: 2;
	    propagate: 3;
	    getvalue: 4;
	    format: 5;
	    readMedia: 6;
	    updateMedia: 7;
	    deleteMedia: 8;
	    insertMedia: 9;
	    readMediaCnt: 10;
	    existMedia: 11;
	}
	export type RuleTypes = keyof RuleTypes$EnumInterface;
	export const ruleTypesDatatype: X3EnumDataType<keyof RuleTypes$EnumInterface, unknown>;
	//# sourceMappingURL=rule-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/root-directory.d.ts
declare module '@sage/x3-system/lib/enums/root-directory' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RootDirectoryEnum {
	    none = 1,
	    htmlDesign = 2,
	    xFilapp = 3,
	    xFiles = 4,
	    xTend = 5
	}
	export interface RootDirectory$EnumInterface {
	    none: 1;
	    htmlDesign: 2;
	    xFilapp: 3;
	    xFiles: 4;
	    xTend: 5;
	}
	export type RootDirectory = keyof RootDirectory$EnumInterface;
	export const rootDirectoryDatatype: X3EnumDataType<keyof RootDirectory$EnumInterface, unknown>;
	//# sourceMappingURL=root-directory.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/retreival-of-sql-server-trace.d.ts
declare module '@sage/x3-system/lib/enums/retreival-of-sql-server-trace' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RetreivalOfSqlServerTraceEnum {
	    standard = 1,
	    tuning = 2,
	    advanced = 3
	}
	export interface RetreivalOfSqlServerTrace$EnumInterface {
	    standard: 1;
	    tuning: 2;
	    advanced: 3;
	}
	export type RetreivalOfSqlServerTrace = keyof RetreivalOfSqlServerTrace$EnumInterface;
	export const retreivalOfSqlServerTraceDatatype: X3EnumDataType<keyof RetreivalOfSqlServerTrace$EnumInterface, unknown>;
	//# sourceMappingURL=retreival-of-sql-server-trace.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/reset-sequence-number-to-zero.d.ts
declare module '@sage/x3-system/lib/enums/reset-sequence-number-to-zero' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ResetSequenceNumberToZeroEnum {
	    noRtz = 1,
	    annual = 2,
	    monthly = 3,
	    fiscalYear = 4,
	    period = 5
	}
	export interface ResetSequenceNumberToZero$EnumInterface {
	    noRtz: 1;
	    annual: 2;
	    monthly: 3;
	    fiscalYear: 4;
	    period: 5;
	}
	export type ResetSequenceNumberToZero = keyof ResetSequenceNumberToZero$EnumInterface;
	export const resetSequenceNumberToZeroDatatype: X3EnumDataType<keyof ResetSequenceNumberToZero$EnumInterface, unknown>;
	//# sourceMappingURL=reset-sequence-number-to-zero.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/representation.d.ts
declare module '@sage/x3-system/lib/enums/representation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RepresentationEnum {
	    default = 1,
	    bar = 2,
	    line = 3
	}
	export interface Representation$EnumInterface {
	    default: 1;
	    bar: 2;
	    line: 3;
	}
	export type Representation = keyof Representation$EnumInterface;
	export const representationDatatype: X3EnumDataType<keyof Representation$EnumInterface, unknown>;
	//# sourceMappingURL=representation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/representation-type.d.ts
declare module '@sage/x3-system/lib/enums/representation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RepresentationTypeEnum {
	    desktop = 1,
	    mobilePhone = 2,
	    tablet = 3
	}
	export interface RepresentationType$EnumInterface {
	    desktop: 1;
	    mobilePhone: 2;
	    tablet: 3;
	}
	export type RepresentationType = keyof RepresentationType$EnumInterface;
	export const representationTypeDatatype: X3EnumDataType<keyof RepresentationType$EnumInterface, unknown>;
	//# sourceMappingURL=representation-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/representation-type-7967.d.ts
declare module '@sage/x3-system/lib/enums/representation-type-7967' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RepresentationType7967Enum {
	    main = 1,
	    child = 2
	}
	export interface RepresentationType7967$EnumInterface {
	    main: 1;
	    child: 2;
	}
	export type RepresentationType7967 = keyof RepresentationType7967$EnumInterface;
	export const representationType7967Datatype: X3EnumDataType<keyof RepresentationType7967$EnumInterface, unknown>;
	//# sourceMappingURL=representation-type-7967.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/representation-parameter-type.d.ts
declare module '@sage/x3-system/lib/enums/representation-parameter-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RepresentationParameterTypeEnum {
	    propertyParameter = 1,
	    displayedPropertyParameter = 2,
	    linkParameter = 3
	}
	export interface RepresentationParameterType$EnumInterface {
	    propertyParameter: 1;
	    displayedPropertyParameter: 2;
	    linkParameter: 3;
	}
	export type RepresentationParameterType = keyof RepresentationParameterType$EnumInterface;
	export const representationParameterTypeDatatype: X3EnumDataType<keyof RepresentationParameterType$EnumInterface, unknown>;
	//# sourceMappingURL=representation-parameter-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/representation-facets.d.ts
declare module '@sage/x3-system/lib/enums/representation-facets' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RepresentationFacetsEnum {
	    detail = 1,
	    edit = 2,
	    query = 3,
	    lookup = 4,
	    summary = 5
	}
	export interface RepresentationFacets$EnumInterface {
	    detail: 1;
	    edit: 2;
	    query: 3;
	    lookup: 4;
	    summary: 5;
	}
	export type RepresentationFacets = keyof RepresentationFacets$EnumInterface;
	export const representationFacetsDatatype: X3EnumDataType<keyof RepresentationFacets$EnumInterface, unknown>;
	//# sourceMappingURL=representation-facets.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/report-group.d.ts
declare module '@sage/x3-system/lib/enums/report-group' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReportGroupEnum {
	    supervisor = 1,
	    masterData = 2,
	    generalAccounting = 3,
	    analyticalAccounting = 4,
	    aRAndAP = 5,
	    legalReports = 6,
	    vat = 7,
	    treasury = 8,
	    openItems = 9,
	    payments = 10,
	    customerReminders = 11,
	    salesExternalDocuments = 12,
	    salesInternalDocuments = 13,
	    salesPrices = 14,
	    salesAnalysis = 15,
	    salesListings = 16,
	    purchasingParameters = 17,
	    purchasingExternalDocuments = 18,
	    purchasingInternalDocuments = 19,
	    purchasingPrices = 20,
	    purchasingAnalysis = 21,
	    purchasingListings = 22,
	    helpDesk = 23,
	    commercialActivity = 24,
	    stockCounts = 25,
	    stockReordering = 26,
	    listOfStockToMove = 27,
	    stockAnalysis = 28,
	    stockInternalDocuments = 29,
	    manufacturingWeighing = 30,
	    manufacturingReordering = 31,
	    manufacturingWorkOrderDocuments = 32,
	    manufacturingTechnicalData = 33,
	    manufacturingValuation = 34,
	    manufacturingAnalysis = 35,
	    substituteValue36 = 36,
	    iasReports = 37,
	    fixedAssets = 38,
	    specific = 39,
	    fixedAssetsSetupAndCoreData = 40,
	    fixedAssetsFixedAssets = 41,
	    fixedAssetsMiscellaneous = 42,
	    fixedAssetsPhysicalManagement = 43,
	    fixedAssetsFunding = 44,
	    operatingBudgets = 45,
	    stockExternalDocuments = 46,
	    hrPayrollManagement = 47,
	    hrCharges = 48,
	    hrHistorical = 49,
	    hrLegalReports = 50,
	    hrDadsU = 51,
	    hrMiscellaneous = 52,
	    hrProfitSharing = 53,
	    hrTraining = 54,
	    hrCareers = 55,
	    hrTotalPayroll = 56,
	    hrTimeManagement = 57,
	    hrPayments = 58,
	    hrStaffManagement = 59,
	    vatOthers = 60,
	    vatGermany = 61,
	    vatSpain = 62,
	    vatPortugal = 63,
	    feesFrance = 64,
	    feesBelgium = 65,
	    feesUnitedStates = 66,
	    vatAustria = 67,
	    feesOthers = 68,
	    vatBelgium = 69,
	    assetManagementGermanyAndAustria = 70,
	    assetManagementPortugal = 71,
	    assetManagementItaly = 72,
	    assetManagementUki = 73,
	    assetManagementFrance = 74,
	    notUsed = 75,
	    vatFrance = 76,
	    employee = 77,
	    vatBoxesManagement = 78
	}
	export interface ReportGroup$EnumInterface {
	    supervisor: 1;
	    masterData: 2;
	    generalAccounting: 3;
	    analyticalAccounting: 4;
	    aRAndAP: 5;
	    legalReports: 6;
	    vat: 7;
	    treasury: 8;
	    openItems: 9;
	    payments: 10;
	    customerReminders: 11;
	    salesExternalDocuments: 12;
	    salesInternalDocuments: 13;
	    salesPrices: 14;
	    salesAnalysis: 15;
	    salesListings: 16;
	    purchasingParameters: 17;
	    purchasingExternalDocuments: 18;
	    purchasingInternalDocuments: 19;
	    purchasingPrices: 20;
	    purchasingAnalysis: 21;
	    purchasingListings: 22;
	    helpDesk: 23;
	    commercialActivity: 24;
	    stockCounts: 25;
	    stockReordering: 26;
	    listOfStockToMove: 27;
	    stockAnalysis: 28;
	    stockInternalDocuments: 29;
	    manufacturingWeighing: 30;
	    manufacturingReordering: 31;
	    manufacturingWorkOrderDocuments: 32;
	    manufacturingTechnicalData: 33;
	    manufacturingValuation: 34;
	    manufacturingAnalysis: 35;
	    substituteValue36: 36;
	    iasReports: 37;
	    fixedAssets: 38;
	    specific: 39;
	    fixedAssetsSetupAndCoreData: 40;
	    fixedAssetsFixedAssets: 41;
	    fixedAssetsMiscellaneous: 42;
	    fixedAssetsPhysicalManagement: 43;
	    fixedAssetsFunding: 44;
	    operatingBudgets: 45;
	    stockExternalDocuments: 46;
	    hrPayrollManagement: 47;
	    hrCharges: 48;
	    hrHistorical: 49;
	    hrLegalReports: 50;
	    hrDadsU: 51;
	    hrMiscellaneous: 52;
	    hrProfitSharing: 53;
	    hrTraining: 54;
	    hrCareers: 55;
	    hrTotalPayroll: 56;
	    hrTimeManagement: 57;
	    hrPayments: 58;
	    hrStaffManagement: 59;
	    vatOthers: 60;
	    vatGermany: 61;
	    vatSpain: 62;
	    vatPortugal: 63;
	    feesFrance: 64;
	    feesBelgium: 65;
	    feesUnitedStates: 66;
	    vatAustria: 67;
	    feesOthers: 68;
	    vatBelgium: 69;
	    assetManagementGermanyAndAustria: 70;
	    assetManagementPortugal: 71;
	    assetManagementItaly: 72;
	    assetManagementUki: 73;
	    assetManagementFrance: 74;
	    notUsed: 75;
	    vatFrance: 76;
	    employee: 77;
	    vatBoxesManagement: 78;
	}
	export type ReportGroup = keyof ReportGroup$EnumInterface;
	export const reportGroupDatatype: X3EnumDataType<keyof ReportGroup$EnumInterface, unknown>;
	//# sourceMappingURL=report-group.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/report-development-status.d.ts
declare module '@sage/x3-system/lib/enums/report-development-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReportDevelopmentStatusEnum {
	    shared = 1,
	    transferRequest = 2,
	    sandbox = 3,
	    commitRequest = 4,
	    revertRequest = 5,
	    crDesignerLoading = 6
	}
	export interface ReportDevelopmentStatus$EnumInterface {
	    shared: 1;
	    transferRequest: 2;
	    sandbox: 3;
	    commitRequest: 4;
	    revertRequest: 5;
	    crDesignerLoading: 6;
	}
	export type ReportDevelopmentStatus = keyof ReportDevelopmentStatus$EnumInterface;
	export const reportDevelopmentStatusDatatype: X3EnumDataType<keyof ReportDevelopmentStatus$EnumInterface, unknown>;
	//# sourceMappingURL=report-development-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/report-developer-options.d.ts
declare module '@sage/x3-system/lib/enums/report-developer-options' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReportDeveloperOptionsEnum {
	    no = 1,
	    yes = 2,
	    administrator = 3
	}
	export interface ReportDeveloperOptions$EnumInterface {
	    no: 1;
	    yes: 2;
	    administrator: 3;
	}
	export type ReportDeveloperOptions = keyof ReportDeveloperOptions$EnumInterface;
	export const reportDeveloperOptionsDatatype: X3EnumDataType<keyof ReportDeveloperOptions$EnumInterface, unknown>;
	//# sourceMappingURL=report-developer-options.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/reorder-type.d.ts
declare module '@sage/x3-system/lib/enums/reorder-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReorderTypeEnum {
	    crystalReport = 1,
	    disabledSinceV5InterchangeDataFormat = 2,
	    wordForWindows = 3,
	    disabledSinceV5ValueColumns = 4,
	    richTextRtf = 5,
	    disabledSinceV5ValuesSeparatedByCommasCsv = 6,
	    disabledSinceV5ValuesSeparatedByTabs = 7,
	    disabledSinceV5ValuesSeparatedByACharacter = 8,
	    asciiText = 9,
	    paginatedAsciiText = 10,
	    disabledSinceV5AsciiTextSeparatedByTabs = 11,
	    disabledSince136Release12 = 12,
	    disabledSince136Release13 = 13,
	    disabledSince136Release14 = 14,
	    disabledSince136Release15 = 15,
	    disabledSince136Release16 = 16,
	    disabledSince136Release17 = 17,
	    disabledSince136Release18 = 18,
	    disabledSince136Release19 = 19,
	    disabledSince140Odbc = 20,
	    disabledSince140Html32 = 21,
	    disabledSince136Release22 = 22,
	    disabledSince136Release23 = 23,
	    disabledSince140Html4 = 24,
	    disabledSince136Release25 = 25,
	    disabledSince136Release = 26,
	    excel972000 = 27,
	    excel972000Extended = 28,
	    pdf = 29,
	    substituteValue30 = 30,
	    workbookExtended = 31
	}
	export interface ReorderType$EnumInterface {
	    crystalReport: 1;
	    disabledSinceV5InterchangeDataFormat: 2;
	    wordForWindows: 3;
	    disabledSinceV5ValueColumns: 4;
	    richTextRtf: 5;
	    disabledSinceV5ValuesSeparatedByCommasCsv: 6;
	    disabledSinceV5ValuesSeparatedByTabs: 7;
	    disabledSinceV5ValuesSeparatedByACharacter: 8;
	    asciiText: 9;
	    paginatedAsciiText: 10;
	    disabledSinceV5AsciiTextSeparatedByTabs: 11;
	    disabledSince136Release12: 12;
	    disabledSince136Release13: 13;
	    disabledSince136Release14: 14;
	    disabledSince136Release15: 15;
	    disabledSince136Release16: 16;
	    disabledSince136Release17: 17;
	    disabledSince136Release18: 18;
	    disabledSince136Release19: 19;
	    disabledSince140Odbc: 20;
	    disabledSince140Html32: 21;
	    disabledSince136Release22: 22;
	    disabledSince136Release23: 23;
	    disabledSince140Html4: 24;
	    disabledSince136Release25: 25;
	    disabledSince136Release: 26;
	    excel972000: 27;
	    excel972000Extended: 28;
	    pdf: 29;
	    substituteValue30: 30;
	    workbookExtended: 31;
	}
	export type ReorderType = keyof ReorderType$EnumInterface;
	export const reorderTypeDatatype: X3EnumDataType<keyof ReorderType$EnumInterface, unknown>;
	//# sourceMappingURL=reorder-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/regrouping-site.d.ts
declare module '@sage/x3-system/lib/enums/regrouping-site' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RegroupingSiteEnum {
	    siteGrouping = 1,
	    site = 2
	}
	export interface RegroupingSite$EnumInterface {
	    siteGrouping: 1;
	    site: 2;
	}
	export type RegroupingSite = keyof RegroupingSite$EnumInterface;
	export const regroupingSiteDatatype: X3EnumDataType<keyof RegroupingSite$EnumInterface, unknown>;
	//# sourceMappingURL=regrouping-site.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/reference-type.d.ts
declare module '@sage/x3-system/lib/enums/reference-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReferenceTypeEnum {
	    property = 1,
	    string = 2,
	    integer = 3,
	    date = 4,
	    decimal = 5,
	    enums = 6,
	    propertyPath = 7,
	    globalVariable = 8,
	    expression = 9
	}
	export interface ReferenceType$EnumInterface {
	    property: 1;
	    string: 2;
	    integer: 3;
	    date: 4;
	    decimal: 5;
	    enums: 6;
	    propertyPath: 7;
	    globalVariable: 8;
	    expression: 9;
	}
	export type ReferenceType = keyof ReferenceType$EnumInterface;
	export const referenceTypeDatatype: X3EnumDataType<keyof ReferenceType$EnumInterface, unknown>;
	//# sourceMappingURL=reference-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/record-type-7868.d.ts
declare module '@sage/x3-system/lib/enums/record-type-7868' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RecordType7868Enum {
	    header = 1,
	    line = 2,
	    footer = 3
	}
	export interface RecordType7868$EnumInterface {
	    header: 1;
	    line: 2;
	    footer: 3;
	}
	export type RecordType7868 = keyof RecordType7868$EnumInterface;
	export const recordType7868Datatype: X3EnumDataType<keyof RecordType7868$EnumInterface, unknown>;
	//# sourceMappingURL=record-type-7868.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/recipient-type.d.ts
declare module '@sage/x3-system/lib/enums/recipient-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RecipientTypeEnum {
	    user = 1,
	    businessPartner = 2,
	    employee = 3,
	    manager = 4,
	    hierarchicalCircuit = 5
	}
	export interface RecipientType$EnumInterface {
	    user: 1;
	    businessPartner: 2;
	    employee: 3;
	    manager: 4;
	    hierarchicalCircuit: 5;
	}
	export type RecipientType = keyof RecipientType$EnumInterface;
	export const recipientTypeDatatype: X3EnumDataType<keyof RecipientType$EnumInterface, unknown>;
	//# sourceMappingURL=recipient-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/rate-date.d.ts
declare module '@sage/x3-system/lib/enums/rate-date' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RateDateEnum {
	    journalEntryDate = 1,
	    sourceDocumentDate = 2
	}
	export interface RateDate$EnumInterface {
	    journalEntryDate: 1;
	    sourceDocumentDate: 2;
	}
	export type RateDate = keyof RateDate$EnumInterface;
	export const rateDateDatatype: X3EnumDataType<keyof RateDate$EnumInterface, unknown>;
	//# sourceMappingURL=rate-date.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/range.d.ts
declare module '@sage/x3-system/lib/enums/range' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RangeEnum {
	    no = 1,
	    startRange = 2,
	    endRange = 3
	}
	export interface Range$EnumInterface {
	    no: 1;
	    startRange: 2;
	    endRange: 3;
	}
	export type Range = keyof Range$EnumInterface;
	export const rangeDatatype: X3EnumDataType<keyof Range$EnumInterface, unknown>;
	//# sourceMappingURL=range.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/range-type.d.ts
declare module '@sage/x3-system/lib/enums/range-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RangeTypeEnum {
	    object = 1,
	    message = 2,
	    miscellaneousTable = 3,
	    field = 4
	}
	export interface RangeType$EnumInterface {
	    object: 1;
	    message: 2;
	    miscellaneousTable: 3;
	    field: 4;
	}
	export type RangeType = keyof RangeType$EnumInterface;
	export const rangeTypeDatatype: X3EnumDataType<keyof RangeType$EnumInterface, unknown>;
	//# sourceMappingURL=range-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/query-type.d.ts
declare module '@sage/x3-system/lib/enums/query-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum QueryTypeEnum {
	    normal = 1,
	    shared = 2,
	    recalculated = 3
	}
	export interface QueryType$EnumInterface {
	    normal: 1;
	    shared: 2;
	    recalculated: 3;
	}
	export type QueryType = keyof QueryType$EnumInterface;
	export const queryTypeDatatype: X3EnumDataType<keyof QueryType$EnumInterface, unknown>;
	//# sourceMappingURL=query-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/query-progress-status.d.ts
declare module '@sage/x3-system/lib/enums/query-progress-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum QueryProgressStatusEnum {
	    standby = 1,
	    inProgress = 2,
	    finished = 3,
	    held = 4,
	    kill = 5,
	    canceled = 6,
	    error = 7,
	    overdue = 8,
	    warning = 9
	}
	export interface QueryProgressStatus$EnumInterface {
	    standby: 1;
	    inProgress: 2;
	    finished: 3;
	    held: 4;
	    kill: 5;
	    canceled: 6;
	    error: 7;
	    overdue: 8;
	    warning: 9;
	}
	export type QueryProgressStatus = keyof QueryProgressStatus$EnumInterface;
	export const queryProgressStatusDatatype: X3EnumDataType<keyof QueryProgressStatus$EnumInterface, unknown>;
	//# sourceMappingURL=query-progress-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/prototype-type.d.ts
declare module '@sage/x3-system/lib/enums/prototype-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PrototypeTypeEnum {
	    applicationXChoice = 1,
	    applicationXInteger = 2,
	    applicationXDecimal = 3,
	    applicationXReal = 4,
	    applicationXString = 5,
	    applicationXDate = 6,
	    applicationXDatime = 7,
	    applicationXBoolean = 8
	}
	export interface PrototypeType$EnumInterface {
	    applicationXChoice: 1;
	    applicationXInteger: 2;
	    applicationXDecimal: 3;
	    applicationXReal: 4;
	    applicationXString: 5;
	    applicationXDate: 6;
	    applicationXDatime: 7;
	    applicationXBoolean: 8;
	}
	export type PrototypeType = keyof PrototypeType$EnumInterface;
	export const prototypeTypeDatatype: X3EnumDataType<keyof PrototypeType$EnumInterface, unknown>;
	//# sourceMappingURL=prototype-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/prototype-format.d.ts
declare module '@sage/x3-system/lib/enums/prototype-format' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PrototypeFormatEnum {
	    aucun = 1,
	    email = 2,
	    phone = 3,
	    combo = 4,
	    radios = 5,
	    tt = 6,
	    password = 7
	}
	export interface PrototypeFormat$EnumInterface {
	    aucun: 1;
	    email: 2;
	    phone: 3;
	    combo: 4;
	    radios: 5;
	    tt: 6;
	    password: 7;
	}
	export type PrototypeFormat = keyof PrototypeFormat$EnumInterface;
	export const prototypeFormatDatatype: X3EnumDataType<keyof PrototypeFormat$EnumInterface, unknown>;
	//# sourceMappingURL=prototype-format.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/protocol.d.ts
declare module '@sage/x3-system/lib/enums/protocol' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProtocolEnum {
	    httpStandard = 1,
	    httpsSecure = 2,
	    webSite = 3
	}
	export interface Protocol$EnumInterface {
	    httpStandard: 1;
	    httpsSecure: 2;
	    webSite: 3;
	}
	export type Protocol = keyof Protocol$EnumInterface;
	export const protocolDatatype: X3EnumDataType<keyof Protocol$EnumInterface, unknown>;
	//# sourceMappingURL=protocol.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/propagation-rule.d.ts
declare module '@sage/x3-system/lib/enums/propagation-rule' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PropagationRuleEnum {
	    no = 1,
	    yes = 2,
	    uponRequest = 3
	}
	export interface PropagationRule$EnumInterface {
	    no: 1;
	    yes: 2;
	    uponRequest: 3;
	}
	export type PropagationRule = keyof PropagationRule$EnumInterface;
	export const propagationRuleDatatype: X3EnumDataType<keyof PropagationRule$EnumInterface, unknown>;
	//# sourceMappingURL=propagation-rule.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/profile-type-function.d.ts
declare module '@sage/x3-system/lib/enums/profile-type-function' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProfileTypeFunctionEnum {
	    standard = 1,
	    administrator = 2,
	    developer = 3
	}
	export interface ProfileTypeFunction$EnumInterface {
	    standard: 1;
	    administrator: 2;
	    developer: 3;
	}
	export type ProfileTypeFunction = keyof ProfileTypeFunction$EnumInterface;
	export const profileTypeFunctionDatatype: X3EnumDataType<keyof ProfileTypeFunction$EnumInterface, unknown>;
	//# sourceMappingURL=profile-type-function.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/products.d.ts
declare module '@sage/x3-system/lib/enums/products' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductsEnum {
	    enterpriseManagement = 1,
	    x3HrPayroll = 2,
	    enterpriseManagementWarehousing = 3,
	    enterpriseManagementFixedAssets = 4,
	    substituteValue5 = 5,
	    substituteValue6 = 6
	}
	export interface Products$EnumInterface {
	    enterpriseManagement: 1;
	    x3HrPayroll: 2;
	    enterpriseManagementWarehousing: 3;
	    enterpriseManagementFixedAssets: 4;
	    substituteValue5: 5;
	    substituteValue6: 6;
	}
	export type Products = keyof Products$EnumInterface;
	export const productsDatatype: X3EnumDataType<keyof Products$EnumInterface, unknown>;
	//# sourceMappingURL=products.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/products-7884.d.ts
declare module '@sage/x3-system/lib/enums/products-7884' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Products7884Enum {
	    sageX3 = 1,
	    sageX3Warehousing = 2,
	    sageX3HrPayroll = 3,
	    sageX3FixedAssets = 4
	}
	export interface Products7884$EnumInterface {
	    sageX3: 1;
	    sageX3Warehousing: 2;
	    sageX3HrPayroll: 3;
	    sageX3FixedAssets: 4;
	}
	export type Products7884 = keyof Products7884$EnumInterface;
	export const products7884Datatype: X3EnumDataType<keyof Products7884$EnumInterface, unknown>;
	//# sourceMappingURL=products-7884.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/products-7857.d.ts
declare module '@sage/x3-system/lib/enums/products-7857' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Products7857Enum {
	    x3 = 1,
	    sprh = 2,
	    geode = 3,
	    abel = 4
	}
	export interface Products7857$EnumInterface {
	    x3: 1;
	    sprh: 2;
	    geode: 3;
	    abel: 4;
	}
	export type Products7857 = keyof Products7857$EnumInterface;
	export const products7857Datatype: X3EnumDataType<keyof Products7857$EnumInterface, unknown>;
	//# sourceMappingURL=products-7857.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/product-edition.d.ts
declare module '@sage/x3-system/lib/enums/product-edition' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductEditionEnum {
	    substituteValue1 = 1,
	    premium = 2,
	    standard = 3,
	    standardNa = 4,
	    standardUk = 5,
	    standardSpain = 6,
	    standardPortugal = 7,
	    standardGermany = 8,
	    standardSwitzerland = 9,
	    standardChina = 10,
	    standardSouthAfricaAndAsean = 11,
	    standardAustralia = 12
	}
	export interface ProductEdition$EnumInterface {
	    substituteValue1: 1;
	    premium: 2;
	    standard: 3;
	    standardNa: 4;
	    standardUk: 5;
	    standardSpain: 6;
	    standardPortugal: 7;
	    standardGermany: 8;
	    standardSwitzerland: 9;
	    standardChina: 10;
	    standardSouthAfricaAndAsean: 11;
	    standardAustralia: 12;
	}
	export type ProductEdition = keyof ProductEdition$EnumInterface;
	export const productEditionDatatype: X3EnumDataType<keyof ProductEdition$EnumInterface, unknown>;
	//# sourceMappingURL=product-edition.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/processing-type.d.ts
declare module '@sage/x3-system/lib/enums/processing-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProcessingTypeEnum {
	    list = 1,
	    assembly = 2,
	    validation = 3
	}
	export interface ProcessingType$EnumInterface {
	    list: 1;
	    assembly: 2;
	    validation: 3;
	}
	export type ProcessingType = keyof ProcessingType$EnumInterface;
	export const processingTypeDatatype: X3EnumDataType<keyof ProcessingType$EnumInterface, unknown>;
	//# sourceMappingURL=processing-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/processes.d.ts
declare module '@sage/x3-system/lib/enums/processes' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProcessesEnum {
	    process = 1,
	    menu = 2
	}
	export interface Processes$EnumInterface {
	    process: 1;
	    menu: 2;
	}
	export type Processes = keyof Processes$EnumInterface;
	export const processesDatatype: X3EnumDataType<keyof Processes$EnumInterface, unknown>;
	//# sourceMappingURL=processes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/process-type-78.d.ts
declare module '@sage/x3-system/lib/enums/process-type-78' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProcessType78Enum {
	    noInitialEntry = 1,
	    yesNoConfirmation = 2,
	    dialogBox = 3,
	    windowEntry = 4,
	    listSelection = 5,
	    tableSelection = 6
	}
	export interface ProcessType78$EnumInterface {
	    noInitialEntry: 1;
	    yesNoConfirmation: 2;
	    dialogBox: 3;
	    windowEntry: 4;
	    listSelection: 5;
	    tableSelection: 6;
	}
	export type ProcessType78 = keyof ProcessType78$EnumInterface;
	export const processType78Datatype: X3EnumDataType<keyof ProcessType78$EnumInterface, unknown>;
	//# sourceMappingURL=process-type-78.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/process-filter.d.ts
declare module '@sage/x3-system/lib/enums/process-filter' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProcessFilterEnum {
	    currentFolder = 1,
	    allFolders = 2
	}
	export interface ProcessFilter$EnumInterface {
	    currentFolder: 1;
	    allFolders: 2;
	}
	export type ProcessFilter = keyof ProcessFilter$EnumInterface;
	export const processFilterDatatype: X3EnumDataType<keyof ProcessFilter$EnumInterface, unknown>;
	//# sourceMappingURL=process-filter.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/process-archive.d.ts
declare module '@sage/x3-system/lib/enums/process-archive' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProcessArchiveEnum {
	    extraction = 1,
	    integration = 2,
	    deletion = 3
	}
	export interface ProcessArchive$EnumInterface {
	    extraction: 1;
	    integration: 2;
	    deletion: 3;
	}
	export type ProcessArchive = keyof ProcessArchive$EnumInterface;
	export const processArchiveDatatype: X3EnumDataType<keyof ProcessArchive$EnumInterface, unknown>;
	//# sourceMappingURL=process-archive.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/printer-type.d.ts
declare module '@sage/x3-system/lib/enums/printer-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PrinterTypeEnum {
	    normal = 1,
	    fax = 2,
	    thermal = 3,
	    color = 4
	}
	export interface PrinterType$EnumInterface {
	    normal: 1;
	    fax: 2;
	    thermal: 3;
	    color: 4;
	}
	export type PrinterType = keyof PrinterType$EnumInterface;
	export const printerTypeDatatype: X3EnumDataType<keyof PrinterType$EnumInterface, unknown>;
	//# sourceMappingURL=printer-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/print-types.d.ts
declare module '@sage/x3-system/lib/enums/print-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PrintTypesEnum {
	    reports = 1,
	    queries = 2,
	    sqlQueries = 3,
	    exports = 4,
	    businessObjects = 5
	}
	export interface PrintTypes$EnumInterface {
	    reports: 1;
	    queries: 2;
	    sqlQueries: 3;
	    exports: 4;
	    businessObjects: 5;
	}
	export type PrintTypes = keyof PrintTypes$EnumInterface;
	export const printTypesDatatype: X3EnumDataType<keyof PrintTypes$EnumInterface, unknown>;
	//# sourceMappingURL=print-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/preloading.d.ts
declare module '@sage/x3-system/lib/enums/preloading' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PreloadingEnum {
	    no = 1,
	    partial = 2,
	    total = 3
	}
	export interface Preloading$EnumInterface {
	    no: 1;
	    partial: 2;
	    total: 3;
	}
	export type Preloading = keyof Preloading$EnumInterface;
	export const preloadingDatatype: X3EnumDataType<keyof Preloading$EnumInterface, unknown>;
	//# sourceMappingURL=preloading.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/patch-type.d.ts
declare module '@sage/x3-system/lib/enums/patch-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PatchTypeEnum {
	    standard = 1,
	    supervisor = 2,
	    specific = 3,
	    vertical = 4,
	    addOn = 5
	}
	export interface PatchType$EnumInterface {
	    standard: 1;
	    supervisor: 2;
	    specific: 3;
	    vertical: 4;
	    addOn: 5;
	}
	export type PatchType = keyof PatchType$EnumInterface;
	export const patchTypeDatatype: X3EnumDataType<keyof PatchType$EnumInterface, unknown>;
	//# sourceMappingURL=patch-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/patch-status.d.ts
declare module '@sage/x3-system/lib/enums/patch-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PatchStatusEnum {
	    pending = 1,
	    inProgress = 2,
	    completed = 3,
	    notInstalled = 4,
	    error = 5,
	    completedWithErrors = 6
	}
	export interface PatchStatus$EnumInterface {
	    pending: 1;
	    inProgress: 2;
	    completed: 3;
	    notInstalled: 4;
	    error: 5;
	    completedWithErrors: 6;
	}
	export type PatchStatus = keyof PatchStatus$EnumInterface;
	export const patchStatusDatatype: X3EnumDataType<keyof PatchStatus$EnumInterface, unknown>;
	//# sourceMappingURL=patch-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/patch-integration.d.ts
declare module '@sage/x3-system/lib/enums/patch-integration' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PatchIntegrationEnum {
	    normalIntegration = 1,
	    completeIntegrationOfUpdate = 2,
	    recoveryFromNextPatch = 3,
	    recoveryFromCurrentPatch = 4
	}
	export interface PatchIntegration$EnumInterface {
	    normalIntegration: 1;
	    completeIntegrationOfUpdate: 2;
	    recoveryFromNextPatch: 3;
	    recoveryFromCurrentPatch: 4;
	}
	export type PatchIntegration = keyof PatchIntegration$EnumInterface;
	export const patchIntegrationDatatype: X3EnumDataType<keyof PatchIntegration$EnumInterface, unknown>;
	//# sourceMappingURL=patch-integration.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/parameter-types.d.ts
declare module '@sage/x3-system/lib/enums/parameter-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ParameterTypesEnum {
	    parameter = 1,
	    key = 2,
	    endParameter = 3
	}
	export interface ParameterTypes$EnumInterface {
	    parameter: 1;
	    key: 2;
	    endParameter: 3;
	}
	export type ParameterTypes = keyof ParameterTypes$EnumInterface;
	export const parameterTypesDatatype: X3EnumDataType<keyof ParameterTypes$EnumInterface, unknown>;
	//# sourceMappingURL=parameter-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/parameter-types-10030.d.ts
declare module '@sage/x3-system/lib/enums/parameter-types-10030' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ParameterTypes10030Enum {
	    tinyInt = 1,
	    shortInteger = 2,
	    longInteger = 3,
	    decimal = 4,
	    floating = 5,
	    double = 6,
	    alphanumeric = 7,
	    date = 8,
	    blob = 9,
	    clob = 10,
	    uuid = 11,
	    datetime = 12,
	    instance = 13
	}
	export interface ParameterTypes10030$EnumInterface {
	    tinyInt: 1;
	    shortInteger: 2;
	    longInteger: 3;
	    decimal: 4;
	    floating: 5;
	    double: 6;
	    alphanumeric: 7;
	    date: 8;
	    blob: 9;
	    clob: 10;
	    uuid: 11;
	    datetime: 12;
	    instance: 13;
	}
	export type ParameterTypes10030 = keyof ParameterTypes10030$EnumInterface;
	export const parameterTypes10030Datatype: X3EnumDataType<keyof ParameterTypes10030$EnumInterface, unknown>;
	//# sourceMappingURL=parameter-types-10030.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/parameter-type.d.ts
declare module '@sage/x3-system/lib/enums/parameter-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ParameterTypeEnum {
	    char = 1,
	    integer = 2,
	    decimal = 3,
	    date = 4,
	    libelle = 5,
	    clbfile = 6,
	    blbfile = 7,
	    instance = 8,
	    uuident = 9,
	    datetime = 10
	}
	export interface ParameterType$EnumInterface {
	    char: 1;
	    integer: 2;
	    decimal: 3;
	    date: 4;
	    libelle: 5;
	    clbfile: 6;
	    blbfile: 7;
	    instance: 8;
	    uuident: 9;
	    datetime: 10;
	}
	export type ParameterType = keyof ParameterType$EnumInterface;
	export const parameterTypeDatatype: X3EnumDataType<keyof ParameterType$EnumInterface, unknown>;
	//# sourceMappingURL=parameter-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/parameter-type-7800.d.ts
declare module '@sage/x3-system/lib/enums/parameter-type-7800' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ParameterType7800Enum {
	    single = 1,
	    range = 2,
	    multiple = 3
	}
	export interface ParameterType7800$EnumInterface {
	    single: 1;
	    range: 2;
	    multiple: 3;
	}
	export type ParameterType7800 = keyof ParameterType7800$EnumInterface;
	export const parameterType7800Datatype: X3EnumDataType<keyof ParameterType7800$EnumInterface, unknown>;
	//# sourceMappingURL=parameter-type-7800.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/parameter-definition-level.d.ts
declare module '@sage/x3-system/lib/enums/parameter-definition-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ParameterDefinitionLevelEnum {
	    folder = 1,
	    company = 2,
	    site = 3,
	    user = 4,
	    legislation = 5
	}
	export interface ParameterDefinitionLevel$EnumInterface {
	    folder: 1;
	    company: 2;
	    site: 3;
	    user: 4;
	    legislation: 5;
	}
	export type ParameterDefinitionLevel = keyof ParameterDefinitionLevel$EnumInterface;
	export const parameterDefinitionLevelDatatype: X3EnumDataType<keyof ParameterDefinitionLevel$EnumInterface, unknown>;
	//# sourceMappingURL=parameter-definition-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/paper-sizes.d.ts
declare module '@sage/x3-system/lib/enums/paper-sizes' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PaperSizesEnum {
	    default = 1,
	    reportPreference = 2,
	    printerPreference = 3,
	    reserved4 = 4,
	    reserved5 = 5,
	    reserved6 = 6,
	    reserved = 7,
	    letter812X11In = 8,
	    letterSmall812X11In = 9,
	    tabloid11X17In = 10,
	    ledger17X11In = 11,
	    legal812X14In = 12,
	    statement512X812In = 13,
	    executive714X1012In = 14,
	    a3297X420Mm = 15,
	    a4210X297Mm = 16,
	    a4Small210X297Mm = 17,
	    a5148X210Mm = 18,
	    b4Jis250X354 = 19,
	    b5Jis182X257Mm = 20,
	    folio812X13In = 21,
	    quarto215X275Mm = 22,
	    substituteValue23 = 23,
	    substituteValue24 = 24,
	    note812X11In = 25,
	    envelope9378X878 = 26,
	    envelope10418X912 = 27,
	    envelope11412X1038 = 28,
	    envelope124276X11 = 29,
	    envelope145X1112 = 30,
	    cSizeSheet = 31,
	    dSizeSheet = 32,
	    eSizeSheet = 33,
	    envelopeDl110X220Mm = 34,
	    envelopeC5162X229Mm = 35,
	    envelopeC3324X458Mm = 36,
	    envelopeC4229X324Mm = 37,
	    envelopeC6114X162Mm = 38,
	    envelopeC65114X229Mm = 39,
	    envelopeB4250X353Mm = 40,
	    envelopeB5176X250Mm = 41,
	    envelopeB6176X125Mm = 42,
	    envelope110X230Mm = 43,
	    envelopeMonarch3875X75In = 44,
	    substituteValue45 = 45,
	    usStdFanfold1478X11In = 46,
	    germanStdFanfold812X12In = 47,
	    germanLegalFanfold812X13In = 48
	}
	export interface PaperSizes$EnumInterface {
	    default: 1;
	    reportPreference: 2;
	    printerPreference: 3;
	    reserved4: 4;
	    reserved5: 5;
	    reserved6: 6;
	    reserved: 7;
	    letter812X11In: 8;
	    letterSmall812X11In: 9;
	    tabloid11X17In: 10;
	    ledger17X11In: 11;
	    legal812X14In: 12;
	    statement512X812In: 13;
	    executive714X1012In: 14;
	    a3297X420Mm: 15;
	    a4210X297Mm: 16;
	    a4Small210X297Mm: 17;
	    a5148X210Mm: 18;
	    b4Jis250X354: 19;
	    b5Jis182X257Mm: 20;
	    folio812X13In: 21;
	    quarto215X275Mm: 22;
	    substituteValue23: 23;
	    substituteValue24: 24;
	    note812X11In: 25;
	    envelope9378X878: 26;
	    envelope10418X912: 27;
	    envelope11412X1038: 28;
	    envelope124276X11: 29;
	    envelope145X1112: 30;
	    cSizeSheet: 31;
	    dSizeSheet: 32;
	    eSizeSheet: 33;
	    envelopeDl110X220Mm: 34;
	    envelopeC5162X229Mm: 35;
	    envelopeC3324X458Mm: 36;
	    envelopeC4229X324Mm: 37;
	    envelopeC6114X162Mm: 38;
	    envelopeC65114X229Mm: 39;
	    envelopeB4250X353Mm: 40;
	    envelopeB5176X250Mm: 41;
	    envelopeB6176X125Mm: 42;
	    envelope110X230Mm: 43;
	    envelopeMonarch3875X75In: 44;
	    substituteValue45: 45;
	    usStdFanfold1478X11In: 46;
	    germanStdFanfold812X12In: 47;
	    germanLegalFanfold812X13In: 48;
	}
	export type PaperSizes = keyof PaperSizes$EnumInterface;
	export const paperSizesDatatype: X3EnumDataType<keyof PaperSizes$EnumInterface, unknown>;
	//# sourceMappingURL=paper-sizes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/pages.d.ts
declare module '@sage/x3-system/lib/enums/pages' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PagesEnum {
	    xml = 1,
	    html = 2
	}
	export interface Pages$EnumInterface {
	    xml: 1;
	    html: 2;
	}
	export type Pages = keyof Pages$EnumInterface;
	export const pagesDatatype: X3EnumDataType<keyof Pages$EnumInterface, unknown>;
	//# sourceMappingURL=pages.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/os-type.d.ts
declare module '@sage/x3-system/lib/enums/os-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OsTypeEnum {
	    unix = 1,
	    windows = 2,
	    linux = 3
	}
	export interface OsType$EnumInterface {
	    unix: 1;
	    windows: 2;
	    linux: 3;
	}
	export type OsType = keyof OsType$EnumInterface;
	export const osTypeDatatype: X3EnumDataType<keyof OsType$EnumInterface, unknown>;
	//# sourceMappingURL=os-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/orientation.d.ts
declare module '@sage/x3-system/lib/enums/orientation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OrientationEnum {
	    portrait = 1,
	    landscape = 2
	}
	export interface Orientation$EnumInterface {
	    portrait: 1;
	    landscape: 2;
	}
	export type Orientation = keyof Orientation$EnumInterface;
	export const orientationDatatype: X3EnumDataType<keyof Orientation$EnumInterface, unknown>;
	//# sourceMappingURL=orientation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/oracle-trace-sort-options.d.ts
declare module '@sage/x3-system/lib/enums/oracle-trace-sort-options' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OracleTraceSortOptionsEnum {
	    standardChronological = 1,
	    elapsedTime = 2,
	    costOfSqlInstructions = 3,
	    cpuUse = 4,
	    diskUse = 5,
	    advanced = 6
	}
	export interface OracleTraceSortOptions$EnumInterface {
	    standardChronological: 1;
	    elapsedTime: 2;
	    costOfSqlInstructions: 3;
	    cpuUse: 4;
	    diskUse: 5;
	    advanced: 6;
	}
	export type OracleTraceSortOptions = keyof OracleTraceSortOptions$EnumInterface;
	export const oracleTraceSortOptionsDatatype: X3EnumDataType<keyof OracleTraceSortOptions$EnumInterface, unknown>;
	//# sourceMappingURL=oracle-trace-sort-options.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/oracle-process-sorting.d.ts
declare module '@sage/x3-system/lib/enums/oracle-process-sorting' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OracleProcessSortingEnum {
	    sid = 1,
	    oracleUser = 2,
	    logonDate = 3,
	    status = 4,
	    application = 5,
	    osUser = 6,
	    osProcess = 7,
	    machine = 8,
	    cpu = 9,
	    pgaMemory = 10,
	    iOPhysReads = 11,
	    logicalReads = 12,
	    hardParses = 13,
	    background = 14,
	    lastExecution = 15
	}
	export interface OracleProcessSorting$EnumInterface {
	    sid: 1;
	    oracleUser: 2;
	    logonDate: 3;
	    status: 4;
	    application: 5;
	    osUser: 6;
	    osProcess: 7;
	    machine: 8;
	    cpu: 9;
	    pgaMemory: 10;
	    iOPhysReads: 11;
	    logicalReads: 12;
	    hardParses: 13;
	    background: 14;
	    lastExecution: 15;
	}
	export type OracleProcessSorting = keyof OracleProcessSorting$EnumInterface;
	export const oracleProcessSortingDatatype: X3EnumDataType<keyof OracleProcessSorting$EnumInterface, unknown>;
	//# sourceMappingURL=oracle-process-sorting.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/operation-type-7822.d.ts
declare module '@sage/x3-system/lib/enums/operation-type-7822' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OperationType7822Enum {
	    sum = 1,
	    average = 2,
	    minimum = 3
	}
	export interface OperationType7822$EnumInterface {
	    sum: 1;
	    average: 2;
	    minimum: 3;
	}
	export type OperationType7822 = keyof OperationType7822$EnumInterface;
	export const operationType7822Datatype: X3EnumDataType<keyof OperationType7822$EnumInterface, unknown>;
	//# sourceMappingURL=operation-type-7822.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/operation-tracking.d.ts
declare module '@sage/x3-system/lib/enums/operation-tracking' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OperationTrackingEnum {
	    no = 1,
	    yes = 2,
	    cancellationAndChangeOfCode = 3
	}
	export interface OperationTracking$EnumInterface {
	    no: 1;
	    yes: 2;
	    cancellationAndChangeOfCode: 3;
	}
	export type OperationTracking = keyof OperationTracking$EnumInterface;
	export const operationTrackingDatatype: X3EnumDataType<keyof OperationTracking$EnumInterface, unknown>;
	//# sourceMappingURL=operation-tracking.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/operation-account-for-spy-fi.d.ts
declare module '@sage/x3-system/lib/enums/operation-account-for-spy-fi' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OperationAccountForSpyFiEnum {
	    create = 1,
	    change = 2,
	    cancel = 3,
	    validate = 4,
	    edit = 5,
	    code = 6,
	    pass = 7
	}
	export interface OperationAccountForSpyFi$EnumInterface {
	    create: 1;
	    change: 2;
	    cancel: 3;
	    validate: 4;
	    edit: 5;
	    code: 6;
	    pass: 7;
	}
	export type OperationAccountForSpyFi = keyof OperationAccountForSpyFi$EnumInterface;
	export const operationAccountForSpyFiDatatype: X3EnumDataType<keyof OperationAccountForSpyFi$EnumInterface, unknown>;
	//# sourceMappingURL=operation-account-for-spy-fi.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/office-document-type.d.ts
declare module '@sage/x3-system/lib/enums/office-document-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OfficeDocumentTypeEnum {
	    word = 1,
	    excel = 2,
	    powerPoint = 3,
	    universal = 4
	}
	export interface OfficeDocumentType$EnumInterface {
	    word: 1;
	    excel: 2;
	    powerPoint: 3;
	    universal: 4;
	}
	export type OfficeDocumentType = keyof OfficeDocumentType$EnumInterface;
	export const officeDocumentTypeDatatype: X3EnumDataType<keyof OfficeDocumentType$EnumInterface, unknown>;
	//# sourceMappingURL=office-document-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/object-ws-action.d.ts
declare module '@sage/x3-system/lib/enums/object-ws-action' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ObjectWsActionEnum {
	    read = 1,
	    create = 2,
	    delete = 3,
	    save = 4,
	    other = 5
	}
	export interface ObjectWsAction$EnumInterface {
	    read: 1;
	    create: 2;
	    delete: 3;
	    save: 4;
	    other: 5;
	}
	export type ObjectWsAction = keyof ObjectWsAction$EnumInterface;
	export const objectWsActionDatatype: X3EnumDataType<keyof ObjectWsAction$EnumInterface, unknown>;
	//# sourceMappingURL=object-ws-action.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/object-update-type.d.ts
declare module '@sage/x3-system/lib/enums/object-update-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ObjectUpdateTypeEnum {
	    no = 1,
	    validation = 2,
	    recording = 3
	}
	export interface ObjectUpdateType$EnumInterface {
	    no: 1;
	    validation: 2;
	    recording: 3;
	}
	export type ObjectUpdateType = keyof ObjectUpdateType$EnumInterface;
	export const objectUpdateTypeDatatype: X3EnumDataType<keyof ObjectUpdateType$EnumInterface, unknown>;
	//# sourceMappingURL=object-update-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/object-type.d.ts
declare module '@sage/x3-system/lib/enums/object-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ObjectTypeEnum {
	    process = 1,
	    menu = 2
	}
	export interface ObjectType$EnumInterface {
	    process: 1;
	    menu: 2;
	}
	export type ObjectType = keyof ObjectType$EnumInterface;
	export const objectTypeDatatype: X3EnumDataType<keyof ObjectType$EnumInterface, unknown>;
	//# sourceMappingURL=object-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/object-type-42.d.ts
declare module '@sage/x3-system/lib/enums/object-type-42' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ObjectType42Enum {
	    table = 1,
	    screen = 2,
	    document = 3,
	    object = 4,
	    dataType = 5,
	    action = 6,
	    parameter = 7,
	    activityCode = 8,
	    function = 9,
	    miscellaneous = 10,
	    window11 = 11,
	    inquiry = 12,
	    batchTask = 13,
	    dashboard = 14,
	    window = 15,
	    free16 = 16,
	    free17 = 17,
	    free18 = 18,
	    free = 19,
	    dimensionElement = 20,
	    report = 21,
	    transactionType = 22,
	    style = 23,
	    reportRpt = 24,
	    reportBo = 25,
	    gdprSetup = 26,
	    utility = 27,
	    package = 28
	}
	export interface ObjectType42$EnumInterface {
	    table: 1;
	    screen: 2;
	    document: 3;
	    object: 4;
	    dataType: 5;
	    action: 6;
	    parameter: 7;
	    activityCode: 8;
	    function: 9;
	    miscellaneous: 10;
	    window11: 11;
	    inquiry: 12;
	    batchTask: 13;
	    dashboard: 14;
	    window: 15;
	    free16: 16;
	    free17: 17;
	    free18: 18;
	    free: 19;
	    dimensionElement: 20;
	    report: 21;
	    transactionType: 22;
	    style: 23;
	    reportRpt: 24;
	    reportBo: 25;
	    gdprSetup: 26;
	    utility: 27;
	    package: 28;
	}
	export type ObjectType42 = keyof ObjectType42$EnumInterface;
	export const objectType42Datatype: X3EnumDataType<keyof ObjectType42$EnumInterface, unknown>;
	//# sourceMappingURL=object-type-42.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/object-parameter-type.d.ts
declare module '@sage/x3-system/lib/enums/object-parameter-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ObjectParameterTypeEnum {
	    keys = 1,
	    data = 2
	}
	export interface ObjectParameterType$EnumInterface {
	    keys: 1;
	    data: 2;
	}
	export type ObjectParameterType = keyof ObjectParameterType$EnumInterface;
	export const objectParameterTypeDatatype: X3EnumDataType<keyof ObjectParameterType$EnumInterface, unknown>;
	//# sourceMappingURL=object-parameter-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/object-management-type.d.ts
declare module '@sage/x3-system/lib/enums/object-management-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ObjectManagementTypeEnum {
	    simple = 1,
	    table = 2,
	    combined = 3,
	    browser = 4
	}
	export interface ObjectManagementType$EnumInterface {
	    simple: 1;
	    table: 2;
	    combined: 3;
	    browser: 4;
	}
	export type ObjectManagementType = keyof ObjectManagementType$EnumInterface;
	export const objectManagementTypeDatatype: X3EnumDataType<keyof ObjectManagementType$EnumInterface, unknown>;
	//# sourceMappingURL=object-management-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/normal-and-multiple-graphs.d.ts
declare module '@sage/x3-system/lib/enums/normal-and-multiple-graphs' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NormalAndMultipleGraphsEnum {
	    bars = 1,
	    lines = 2,
	    areas = 3,
	    sectors = 4,
	    multipleBars = 5,
	    multipleLines = 6,
	    multipleAreas = 7,
	    multipleSectors = 8,
	    cumulativeBars = 9,
	    cumulativeLines = 10,
	    cumulativeSectors = 11,
	    cumulativeAreas = 12,
	    comparativeBars = 13,
	    comparativeLines = 14,
	    comparativeAreas = 15,
	    comparativeSectors = 16
	}
	export interface NormalAndMultipleGraphs$EnumInterface {
	    bars: 1;
	    lines: 2;
	    areas: 3;
	    sectors: 4;
	    multipleBars: 5;
	    multipleLines: 6;
	    multipleAreas: 7;
	    multipleSectors: 8;
	    cumulativeBars: 9;
	    cumulativeLines: 10;
	    cumulativeSectors: 11;
	    cumulativeAreas: 12;
	    comparativeBars: 13;
	    comparativeLines: 14;
	    comparativeAreas: 15;
	    comparativeSectors: 16;
	}
	export type NormalAndMultipleGraphs = keyof NormalAndMultipleGraphs$EnumInterface;
	export const normalAndMultipleGraphsDatatype: X3EnumDataType<keyof NormalAndMultipleGraphs$EnumInterface, unknown>;
	//# sourceMappingURL=normal-and-multiple-graphs.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/node-type.d.ts
declare module '@sage/x3-system/lib/enums/node-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NodeTypeEnum {
	    booleen = 1,
	    integer = 2,
	    decimal = 3,
	    string = 4,
	    date = 5,
	    node = 6,
	    translatableText = 7,
	    enum = 8,
	    object = 9,
	    imageFile = 10,
	    textFile = 11,
	    dateTime = 12
	}
	export interface NodeType$EnumInterface {
	    booleen: 1;
	    integer: 2;
	    decimal: 3;
	    string: 4;
	    date: 5;
	    node: 6;
	    translatableText: 7;
	    enum: 8;
	    object: 9;
	    imageFile: 10;
	    textFile: 11;
	    dateTime: 12;
	}
	export type NodeType = keyof NodeType$EnumInterface;
	export const nodeTypeDatatype: X3EnumDataType<keyof NodeType$EnumInterface, unknown>;
	//# sourceMappingURL=node-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/node-direction.d.ts
declare module '@sage/x3-system/lib/enums/node-direction' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NodeDirectionEnum {
	    input = 1,
	    output = 2,
	    both = 3
	}
	export interface NodeDirection$EnumInterface {
	    input: 1;
	    output: 2;
	    both: 3;
	}
	export type NodeDirection = keyof NodeDirection$EnumInterface;
	export const nodeDirectionDatatype: X3EnumDataType<keyof NodeDirection$EnumInterface, unknown>;
	//# sourceMappingURL=node-direction.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/node-binding-type.d.ts
declare module '@sage/x3-system/lib/enums/node-binding-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NodeBindingTypeEnum {
	    windows = 1,
	    dataModel = 2,
	    import = 3,
	    script = 4,
	    view = 5
	}
	export interface NodeBindingType$EnumInterface {
	    windows: 1;
	    dataModel: 2;
	    import: 3;
	    script: 4;
	    view: 5;
	}
	export type NodeBindingType = keyof NodeBindingType$EnumInterface;
	export const nodeBindingTypeDatatype: X3EnumDataType<keyof NodeBindingType$EnumInterface, unknown>;
	//# sourceMappingURL=node-binding-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/no-yes-criteria-not-displayed.d.ts
declare module '@sage/x3-system/lib/enums/no-yes-criteria-not-displayed' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NoYesCriteriaNotDisplayedEnum {
	    no = 1,
	    yes = 2,
	    criteriaNotDisplayed = 3
	}
	export interface NoYesCriteriaNotDisplayed$EnumInterface {
	    no: 1;
	    yes: 2;
	    criteriaNotDisplayed: 3;
	}
	export type NoYesCriteriaNotDisplayed = keyof NoYesCriteriaNotDisplayed$EnumInterface;
	export const noYesCriteriaNotDisplayedDatatype: X3EnumDataType<keyof NoYesCriteriaNotDisplayed$EnumInterface, unknown>;
	//# sourceMappingURL=no-yes-criteria-not-displayed.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/nature-of-session.d.ts
declare module '@sage/x3-system/lib/enums/nature-of-session' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NatureOfSessionEnum {
	    internal = 1,
	    external = 2
	}
	export interface NatureOfSession$EnumInterface {
	    internal: 1;
	    external: 2;
	}
	export type NatureOfSession = keyof NatureOfSession$EnumInterface;
	export const natureOfSessionDatatype: X3EnumDataType<keyof NatureOfSession$EnumInterface, unknown>;
	//# sourceMappingURL=nature-of-session.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/mutation-typ.d.ts
declare module '@sage/x3-system/lib/enums/mutation-typ' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MutationTypEnum {
	    custom = 1,
	    create = 2,
	    update = 3,
	    delete = 4,
	    createUpdateDelete = 5
	}
	export interface MutationTyp$EnumInterface {
	    custom: 1;
	    create: 2;
	    update: 3;
	    delete: 4;
	    createUpdateDelete: 5;
	}
	export type MutationTyp = keyof MutationTyp$EnumInterface;
	export const mutationTypDatatype: X3EnumDataType<keyof MutationTyp$EnumInterface, unknown>;
	//# sourceMappingURL=mutation-typ.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/multiple-graphs.d.ts
declare module '@sage/x3-system/lib/enums/multiple-graphs' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MultipleGraphsEnum {
	    curves = 1,
	    sectors = 2
	}
	export interface MultipleGraphs$EnumInterface {
	    curves: 1;
	    sectors: 2;
	}
	export type MultipleGraphs = keyof MultipleGraphs$EnumInterface;
	export const multipleGraphsDatatype: X3EnumDataType<keyof MultipleGraphs$EnumInterface, unknown>;
	//# sourceMappingURL=multiple-graphs.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/months-of-the-year-9001.d.ts
declare module '@sage/x3-system/lib/enums/months-of-the-year-9001' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MonthsOfTheYear9001Enum {
	    january = 1,
	    february = 2,
	    march = 3,
	    april = 4,
	    may = 5,
	    june = 6,
	    july = 7,
	    august = 8,
	    september = 9,
	    october = 10,
	    november = 11,
	    december = 12
	}
	export interface MonthsOfTheYear9001$EnumInterface {
	    january: 1;
	    february: 2;
	    march: 3;
	    april: 4;
	    may: 5;
	    june: 6;
	    july: 7;
	    august: 8;
	    september: 9;
	    october: 10;
	    november: 11;
	    december: 12;
	}
	export type MonthsOfTheYear9001 = keyof MonthsOfTheYear9001$EnumInterface;
	export const monthsOfTheYear9001Datatype: X3EnumDataType<keyof MonthsOfTheYear9001$EnumInterface, unknown>;
	//# sourceMappingURL=months-of-the-year-9001.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/module-table.d.ts
declare module '@sage/x3-system/lib/enums/module-table' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ModuleTableEnum {
	    supervisor = 1,
	    financials = 2,
	    aPARAccounting = 3,
	    sageX3External = 4,
	    sales = 5,
	    purchasing = 6,
	    stock = 7,
	    manufacturing = 8,
	    commonData = 9,
	    development = 10,
	    sageX3Internal = 11,
	    helpDesk = 12,
	    crmActivities = 13,
	    fixedAssets = 14,
	    humanResourcesAdministration = 15,
	    customModule1 = 16,
	    customModule2 = 17,
	    customModule3 = 18,
	    customModule4 = 19,
	    humanCapitalManagement = 20
	}
	export interface ModuleTable$EnumInterface {
	    supervisor: 1;
	    financials: 2;
	    aPARAccounting: 3;
	    sageX3External: 4;
	    sales: 5;
	    purchasing: 6;
	    stock: 7;
	    manufacturing: 8;
	    commonData: 9;
	    development: 10;
	    sageX3Internal: 11;
	    helpDesk: 12;
	    crmActivities: 13;
	    fixedAssets: 14;
	    humanResourcesAdministration: 15;
	    customModule1: 16;
	    customModule2: 17;
	    customModule3: 18;
	    customModule4: 19;
	    humanCapitalManagement: 20;
	}
	export type ModuleTable = keyof ModuleTable$EnumInterface;
	export const moduleTableDatatype: X3EnumDataType<keyof ModuleTable$EnumInterface, unknown>;
	//# sourceMappingURL=module-table.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/migration-statuses.d.ts
declare module '@sage/x3-system/lib/enums/migration-statuses' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MigrationStatusesEnum {
	    pending = 1,
	    inProgress = 2,
	    completed = 3,
	    completedWithErrors = 4,
	    interrupted = 5,
	    pendingInterruption = 6,
	    pendingStop = 7,
	    launched = 8,
	    stopped = 9,
	    blocked = 10,
	    bypassed = 11
	}
	export interface MigrationStatuses$EnumInterface {
	    pending: 1;
	    inProgress: 2;
	    completed: 3;
	    completedWithErrors: 4;
	    interrupted: 5;
	    pendingInterruption: 6;
	    pendingStop: 7;
	    launched: 8;
	    stopped: 9;
	    blocked: 10;
	    bypassed: 11;
	}
	export type MigrationStatuses = keyof MigrationStatuses$EnumInterface;
	export const migrationStatusesDatatype: X3EnumDataType<keyof MigrationStatuses$EnumInterface, unknown>;
	//# sourceMappingURL=migration-statuses.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/migration-stages.d.ts
declare module '@sage/x3-system/lib/enums/migration-stages' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MigrationStagesEnum {
	    initialization = 1,
	    commonData = 2,
	    module = 3,
	    postMigration = 4
	}
	export interface MigrationStages$EnumInterface {
	    initialization: 1;
	    commonData: 2;
	    module: 3;
	    postMigration: 4;
	}
	export type MigrationStages = keyof MigrationStages$EnumInterface;
	export const migrationStagesDatatype: X3EnumDataType<keyof MigrationStages$EnumInterface, unknown>;
	//# sourceMappingURL=migration-stages.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/method-operation.d.ts
declare module '@sage/x3-system/lib/enums/method-operation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MethodOperationEnum {
	    window = 1,
	    import = 2,
	    class = 3,
	    query = 4,
	    script = 5
	}
	export interface MethodOperation$EnumInterface {
	    window: 1;
	    import: 2;
	    class: 3;
	    query: 4;
	    script: 5;
	}
	export type MethodOperation = keyof MethodOperation$EnumInterface;
	export const methodOperationDatatype: X3EnumDataType<keyof MethodOperation$EnumInterface, unknown>;
	//# sourceMappingURL=method-operation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/method-category.d.ts
declare module '@sage/x3-system/lib/enums/method-category' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MethodCategoryEnum {
	    method = 1,
	    function = 2,
	    subprogram = 3
	}
	export interface MethodCategory$EnumInterface {
	    method: 1;
	    function: 2;
	    subprogram: 3;
	}
	export type MethodCategory = keyof MethodCategory$EnumInterface;
	export const methodCategoryDatatype: X3EnumDataType<keyof MethodCategory$EnumInterface, unknown>;
	//# sourceMappingURL=method-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/method-assignment.d.ts
declare module '@sage/x3-system/lib/enums/method-assignment' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MethodAssignmentEnum {
	    property = 1,
	    collectionLine = 2,
	    collection = 3,
	    page = 4,
	    record = 5
	}
	export interface MethodAssignment$EnumInterface {
	    property: 1;
	    collectionLine: 2;
	    collection: 3;
	    page: 4;
	    record: 5;
	}
	export type MethodAssignment = keyof MethodAssignment$EnumInterface;
	export const methodAssignmentDatatype: X3EnumDataType<keyof MethodAssignment$EnumInterface, unknown>;
	//# sourceMappingURL=method-assignment.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/message-importance.d.ts
declare module '@sage/x3-system/lib/enums/message-importance' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MessageImportanceEnum {
	    low = 1,
	    normal = 2,
	    high = 3
	}
	export interface MessageImportance$EnumInterface {
	    low: 1;
	    normal: 2;
	    high: 3;
	}
	export type MessageImportance = keyof MessageImportance$EnumInterface;
	export const messageImportanceDatatype: X3EnumDataType<keyof MessageImportance$EnumInterface, unknown>;
	//# sourceMappingURL=message-importance.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/mapping-selection.d.ts
declare module '@sage/x3-system/lib/enums/mapping-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MappingSelectionEnum {
	    textTranslation = 1,
	    objectMapping = 2
	}
	export interface MappingSelection$EnumInterface {
	    textTranslation: 1;
	    objectMapping: 2;
	}
	export type MappingSelection = keyof MappingSelection$EnumInterface;
	export const mappingSelectionDatatype: X3EnumDataType<keyof MappingSelection$EnumInterface, unknown>;
	//# sourceMappingURL=mapping-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/manager-type.d.ts
declare module '@sage/x3-system/lib/enums/manager-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ManagerTypeEnum {
	    supervisor = 1,
	    departmentHead = 2,
	    director = 3,
	    hrManager = 4,
	    expenseNoteManager = 5,
	    assistant = 6,
	    payrollManager = 7,
	    operatingManager = 8,
	    trainingManager = 9,
	    interviewManager = 10,
	    employee = 11
	}
	export interface ManagerType$EnumInterface {
	    supervisor: 1;
	    departmentHead: 2;
	    director: 3;
	    hrManager: 4;
	    expenseNoteManager: 5;
	    assistant: 6;
	    payrollManager: 7;
	    operatingManager: 8;
	    trainingManager: 9;
	    interviewManager: 10;
	    employee: 11;
	}
	export type ManagerType = keyof ManagerType$EnumInterface;
	export const managerTypeDatatype: X3EnumDataType<keyof ManagerType$EnumInterface, unknown>;
	//# sourceMappingURL=manager-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/management-type-button.d.ts
declare module '@sage/x3-system/lib/enums/management-type-button' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ManagementTypeButtonEnum {
	    nonValidating = 1,
	    validating = 2
	}
	export interface ManagementTypeButton$EnumInterface {
	    nonValidating: 1;
	    validating: 2;
	}
	export type ManagementTypeButton = keyof ManagementTypeButton$EnumInterface;
	export const managementTypeButtonDatatype: X3EnumDataType<keyof ManagementTypeButton$EnumInterface, unknown>;
	//# sourceMappingURL=management-type-button.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/lv-test.d.ts
declare module '@sage/x3-system/lib/enums/lv-test' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LvTestEnum {
	    tan = 1,
	    red = 2,
	    navy = 3,
	    pink = 4,
	    aqua = 5,
	    teal = 6,
	    gold = 7,
	    lime = 8,
	    grey = 9,
	    plum = 10,
	    blue = 11,
	    peru = 12,
	    snow = 13,
	    cyan = 14,
	    rosyBrown = 15,
	    darkBlue = 16,
	    fireBrick = 17,
	    darkCyan = 18,
	    mintCream = 19,
	    darkGoldenRod = 20,
	    paleGoldenRod = 21,
	    darkGrey = 22,
	    paleGreen = 23,
	    darkGreen = 24,
	    lawnGreen = 25,
	    limeGreen = 26,
	    darkKhaki = 27,
	    darkMagenta = 28,
	    darkOliveGreen = 29,
	    darkOrchid = 30,
	    deepPink = 31,
	    darkRed = 32,
	    deepSkyBlue = 33,
	    darkSlateGrey = 34,
	    darkSalmon = 35,
	    darkSeaGreen = 36,
	    darkSlateBlue = 37,
	    paleTurquoise = 38,
	    darkTurquoise = 39,
	    paleVioletRed = 40,
	    darkViolet = 41,
	    blueViolet = 42,
	    indianRed = 43,
	    floralWhite = 44,
	    moccasin = 45,
	    oldLace = 46,
	    blancheAlmond = 47,
	    whiteSmoke = 48,
	    slateGrey = 49,
	    azure = 50
	}
	export interface LvTest$EnumInterface {
	    tan: 1;
	    red: 2;
	    navy: 3;
	    pink: 4;
	    aqua: 5;
	    teal: 6;
	    gold: 7;
	    lime: 8;
	    grey: 9;
	    plum: 10;
	    blue: 11;
	    peru: 12;
	    snow: 13;
	    cyan: 14;
	    rosyBrown: 15;
	    darkBlue: 16;
	    fireBrick: 17;
	    darkCyan: 18;
	    mintCream: 19;
	    darkGoldenRod: 20;
	    paleGoldenRod: 21;
	    darkGrey: 22;
	    paleGreen: 23;
	    darkGreen: 24;
	    lawnGreen: 25;
	    limeGreen: 26;
	    darkKhaki: 27;
	    darkMagenta: 28;
	    darkOliveGreen: 29;
	    darkOrchid: 30;
	    deepPink: 31;
	    darkRed: 32;
	    deepSkyBlue: 33;
	    darkSlateGrey: 34;
	    darkSalmon: 35;
	    darkSeaGreen: 36;
	    darkSlateBlue: 37;
	    paleTurquoise: 38;
	    darkTurquoise: 39;
	    paleVioletRed: 40;
	    darkViolet: 41;
	    blueViolet: 42;
	    indianRed: 43;
	    floralWhite: 44;
	    moccasin: 45;
	    oldLace: 46;
	    blancheAlmond: 47;
	    whiteSmoke: 48;
	    slateGrey: 49;
	    azure: 50;
	}
	export type LvTest = keyof LvTest$EnumInterface;
	export const lvTestDatatype: X3EnumDataType<keyof LvTest$EnumInterface, unknown>;
	//# sourceMappingURL=lv-test.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/log-file-level.d.ts
declare module '@sage/x3-system/lib/enums/log-file-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LogFileLevelEnum {
	    noLogFile = 1,
	    fieldLogFile = 2,
	    blockAndFieldLogFile = 3
	}
	export interface LogFileLevel$EnumInterface {
	    noLogFile: 1;
	    fieldLogFile: 2;
	    blockAndFieldLogFile: 3;
	}
	export type LogFileLevel = keyof LogFileLevel$EnumInterface;
	export const logFileLevelDatatype: X3EnumDataType<keyof LogFileLevel$EnumInterface, unknown>;
	//# sourceMappingURL=log-file-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/local-menu-9002.d.ts
declare module '@sage/x3-system/lib/enums/local-menu-9002' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LocalMenu9002Enum {
	    sunday = 1,
	    monday = 2,
	    tuesday = 3,
	    wednesday = 4,
	    thursday = 5,
	    friday = 6,
	    saturday = 7
	}
	export interface LocalMenu9002$EnumInterface {
	    sunday: 1;
	    monday: 2;
	    tuesday: 3;
	    wednesday: 4;
	    thursday: 5;
	    friday: 6;
	    saturday: 7;
	}
	export type LocalMenu9002 = keyof LocalMenu9002$EnumInterface;
	export const localMenu9002Datatype: X3EnumDataType<keyof LocalMenu9002$EnumInterface, unknown>;
	//# sourceMappingURL=local-menu-9002.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/list-type.d.ts
declare module '@sage/x3-system/lib/enums/list-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ListTypeEnum {
	    list = 1,
	    xml = 2
	}
	export interface ListType$EnumInterface {
	    list: 1;
	    xml: 2;
	}
	export type ListType = keyof ListType$EnumInterface;
	export const listTypeDatatype: X3EnumDataType<keyof ListType$EnumInterface, unknown>;
	//# sourceMappingURL=list-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/list-of-values-management.d.ts
declare module '@sage/x3-system/lib/enums/list-of-values-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ListOfValuesManagementEnum {
	    manual = 1,
	    automatic = 2,
	    batch = 3
	}
	export interface ListOfValuesManagement$EnumInterface {
	    manual: 1;
	    automatic: 2;
	    batch: 3;
	}
	export type ListOfValuesManagement = keyof ListOfValuesManagement$EnumInterface;
	export const listOfValuesManagementDatatype: X3EnumDataType<keyof ListOfValuesManagement$EnumInterface, unknown>;
	//# sourceMappingURL=list-of-values-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/list-of-values-description.d.ts
declare module '@sage/x3-system/lib/enums/list-of-values-description' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ListOfValuesDescriptionEnum {
	    message = 1,
	    miscellaneousTable = 2
	}
	export interface ListOfValuesDescription$EnumInterface {
	    message: 1;
	    miscellaneousTable: 2;
	}
	export type ListOfValuesDescription = keyof ListOfValuesDescription$EnumInterface;
	export const listOfValuesDescriptionDatatype: X3EnumDataType<keyof ListOfValuesDescription$EnumInterface, unknown>;
	//# sourceMappingURL=list-of-values-description.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/linked-field-type.d.ts
declare module '@sage/x3-system/lib/enums/linked-field-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LinkedFieldTypeEnum {
	    no = 1,
	    long = 2,
	    short = 3
	}
	export interface LinkedFieldType$EnumInterface {
	    no: 1;
	    long: 2;
	    short: 3;
	}
	export type LinkedFieldType = keyof LinkedFieldType$EnumInterface;
	export const linkedFieldTypeDatatype: X3EnumDataType<keyof LinkedFieldType$EnumInterface, unknown>;
	//# sourceMappingURL=linked-field-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/link-type-920.d.ts
declare module '@sage/x3-system/lib/enums/link-type-920' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LinkType920Enum {
	    miscellaneous = 1,
	    toAccounting = 2,
	    toFixedAssets = 3,
	    toPayroll = 4,
	    toLogistics = 5
	}
	export interface LinkType920$EnumInterface {
	    miscellaneous: 1;
	    toAccounting: 2;
	    toFixedAssets: 3;
	    toPayroll: 4;
	    toLogistics: 5;
	}
	export type LinkType920 = keyof LinkType920$EnumInterface;
	export const linkType920Datatype: X3EnumDataType<keyof LinkType920$EnumInterface, unknown>;
	//# sourceMappingURL=link-type-920.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/link-type-7974.d.ts
declare module '@sage/x3-system/lib/enums/link-type-7974' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LinkType7974Enum {
	    representation = 1,
	    method = 2,
	    operation = 3,
	    x3Convergence = 4,
	    free = 5,
	    crystalReport = 6
	}
	export interface LinkType7974$EnumInterface {
	    representation: 1;
	    method: 2;
	    operation: 3;
	    x3Convergence: 4;
	    free: 5;
	    crystalReport: 6;
	}
	export type LinkType7974 = keyof LinkType7974$EnumInterface;
	export const linkType7974Datatype: X3EnumDataType<keyof LinkType7974$EnumInterface, unknown>;
	//# sourceMappingURL=link-type-7974.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/link-type-7971.d.ts
declare module '@sage/x3-system/lib/enums/link-type-7971' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LinkType7971Enum {
	    createRecord = 1,
	    displayDetail = 2,
	    modifyRecord = 3,
	    deleteRecord = 4,
	    displayList = 5,
	    duplicateRecord = 6,
	    displayAsExcel = 7,
	    listInExcel = 8,
	    selection = 9,
	    displaySummary = 10,
	    displayAsPdf = 11,
	    listAsPdf = 12,
	    displayInWord = 13,
	    listInWord = 14,
	    massMailRecord = 15,
	    massMailList = 16,
	    save = 17,
	    cancel = 18,
	    lobManagement = 19,
	    print = 20,
	    directPrint = 21,
	    help = 22
	}
	export interface LinkType7971$EnumInterface {
	    createRecord: 1;
	    displayDetail: 2;
	    modifyRecord: 3;
	    deleteRecord: 4;
	    displayList: 5;
	    duplicateRecord: 6;
	    displayAsExcel: 7;
	    listInExcel: 8;
	    selection: 9;
	    displaySummary: 10;
	    displayAsPdf: 11;
	    listAsPdf: 12;
	    displayInWord: 13;
	    listInWord: 14;
	    massMailRecord: 15;
	    massMailList: 16;
	    save: 17;
	    cancel: 18;
	    lobManagement: 19;
	    print: 20;
	    directPrint: 21;
	    help: 22;
	}
	export type LinkType7971 = keyof LinkType7971$EnumInterface;
	export const linkType7971Datatype: X3EnumDataType<keyof LinkType7971$EnumInterface, unknown>;
	//# sourceMappingURL=link-type-7971.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/link-type-2934.d.ts
declare module '@sage/x3-system/lib/enums/link-type-2934' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LinkType2934Enum {
	    url = 1,
	    xsl = 2,
	    html = 3
	}
	export interface LinkType2934$EnumInterface {
	    url: 1;
	    xsl: 2;
	    html: 3;
	}
	export type LinkType2934 = keyof LinkType2934$EnumInterface;
	export const linkType2934Datatype: X3EnumDataType<keyof LinkType2934$EnumInterface, unknown>;
	//# sourceMappingURL=link-type-2934.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/link-type-2916.d.ts
declare module '@sage/x3-system/lib/enums/link-type-2916' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LinkType2916Enum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4
	}
	export interface LinkType2916$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	}
	export type LinkType2916 = keyof LinkType2916$EnumInterface;
	export const linkType2916Datatype: X3EnumDataType<keyof LinkType2916$EnumInterface, unknown>;
	//# sourceMappingURL=link-type-2916.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/link-target.d.ts
declare module '@sage/x3-system/lib/enums/link-target' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LinkTargetEnum {
	    default = 1,
	    newPage = 2,
	    embedded = 3
	}
	export interface LinkTarget$EnumInterface {
	    default: 1;
	    newPage: 2;
	    embedded: 3;
	}
	export type LinkTarget = keyof LinkTarget$EnumInterface;
	export const linkTargetDatatype: X3EnumDataType<keyof LinkTarget$EnumInterface, unknown>;
	//# sourceMappingURL=link-target.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/link-order-for-helps.d.ts
declare module '@sage/x3-system/lib/enums/link-order-for-helps' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LinkOrderForHelpsEnum {
	    before = 1,
	    after = 2
	}
	export interface LinkOrderForHelps$EnumInterface {
	    before: 1;
	    after: 2;
	}
	export type LinkOrderForHelps = keyof LinkOrderForHelps$EnumInterface;
	export const linkOrderForHelpsDatatype: X3EnumDataType<keyof LinkOrderForHelps$EnumInterface, unknown>;
	//# sourceMappingURL=link-order-for-helps.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/link-attributes.d.ts
declare module '@sage/x3-system/lib/enums/link-attributes' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LinkAttributesEnum {
	    simpleLink = 1,
	    detail = 2,
	    lookup = 3,
	    summary = 4
	}
	export interface LinkAttributes$EnumInterface {
	    simpleLink: 1;
	    detail: 2;
	    lookup: 3;
	    summary: 4;
	}
	export type LinkAttributes = keyof LinkAttributes$EnumInterface;
	export const linkAttributesDatatype: X3EnumDataType<keyof LinkAttributes$EnumInterface, unknown>;
	//# sourceMappingURL=link-attributes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/line-minimum-in-a-grid.d.ts
declare module '@sage/x3-system/lib/enums/line-minimum-in-a-grid' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LineMinimumInAGridEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    maximum = 3
	}
	export interface LineMinimumInAGrid$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    maximum: 3;
	}
	export type LineMinimumInAGrid = keyof LineMinimumInAGrid$EnumInterface;
	export const lineMinimumInAGridDatatype: X3EnumDataType<keyof LineMinimumInAGrid$EnumInterface, unknown>;
	//# sourceMappingURL=line-minimum-in-a-grid.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/levels.d.ts
declare module '@sage/x3-system/lib/enums/levels' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LevelsEnum {
	    level1 = 1,
	    level2 = 2,
	    level3 = 3
	}
	export interface Levels$EnumInterface {
	    level1: 1;
	    level2: 2;
	    level3: 3;
	}
	export type Levels = keyof Levels$EnumInterface;
	export const levelsDatatype: X3EnumDataType<keyof Levels$EnumInterface, unknown>;
	//# sourceMappingURL=levels.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/ldap-connection-type.d.ts
declare module '@sage/x3-system/lib/enums/ldap-connection-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LdapConnectionTypeEnum {
	    no = 1,
	    interactive = 2,
	    interactiveAndWebServices = 3
	}
	export interface LdapConnectionType$EnumInterface {
	    no: 1;
	    interactive: 2;
	    interactiveAndWebServices: 3;
	}
	export type LdapConnectionType = keyof LdapConnectionType$EnumInterface;
	export const ldapConnectionTypeDatatype: X3EnumDataType<keyof LdapConnectionType$EnumInterface, unknown>;
	//# sourceMappingURL=ldap-connection-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/kind-of-reference.d.ts
declare module '@sage/x3-system/lib/enums/kind-of-reference' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum KindOfReferenceEnum {
	    reference = 1,
	    localization = 2,
	    collection = 3
	}
	export interface KindOfReference$EnumInterface {
	    reference: 1;
	    localization: 2;
	    collection: 3;
	}
	export type KindOfReference = keyof KindOfReference$EnumInterface;
	export const kindOfReferenceDatatype: X3EnumDataType<keyof KindOfReference$EnumInterface, unknown>;
	//# sourceMappingURL=kind-of-reference.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/join-type.d.ts
declare module '@sage/x3-system/lib/enums/join-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum JoinTypeEnum {
	    mandatory = 1,
	    shortcut = 2
	}
	export interface JoinType$EnumInterface {
	    mandatory: 1;
	    shortcut: 2;
	}
	export type JoinType = keyof JoinType$EnumInterface;
	export const joinTypeDatatype: X3EnumDataType<keyof JoinType$EnumInterface, unknown>;
	//# sourceMappingURL=join-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/join-option.d.ts
declare module '@sage/x3-system/lib/enums/join-option' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum JoinOptionEnum {
	    inner = 1,
	    leftOuter = 2,
	    rightOuter = 3
	}
	export interface JoinOption$EnumInterface {
	    inner: 1;
	    leftOuter: 2;
	    rightOuter: 3;
	}
	export type JoinOption = keyof JoinOption$EnumInterface;
	export const joinOptionDatatype: X3EnumDataType<keyof JoinOption$EnumInterface, unknown>;
	//# sourceMappingURL=join-option.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/interface-type.d.ts
declare module '@sage/x3-system/lib/enums/interface-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InterfaceTypeEnum {
	    generatedAccessToTable = 1,
	    subProgramAccess = 2,
	    leftListAccess = 3,
	    generatedAccessToView = 4,
	    free5 = 5,
	    free6 = 6,
	    free7 = 7,
	    free8 = 8,
	    free9 = 9,
	    free10 = 10,
	    free11 = 11,
	    free12 = 12,
	    free13 = 13,
	    free14 = 14,
	    free15 = 15,
	    free16 = 16,
	    free17 = 17,
	    free18 = 18,
	    free = 19,
	    subProgramAction = 20,
	    objectAction = 21
	}
	export interface InterfaceType$EnumInterface {
	    generatedAccessToTable: 1;
	    subProgramAccess: 2;
	    leftListAccess: 3;
	    generatedAccessToView: 4;
	    free5: 5;
	    free6: 6;
	    free7: 7;
	    free8: 8;
	    free9: 9;
	    free10: 10;
	    free11: 11;
	    free12: 12;
	    free13: 13;
	    free14: 14;
	    free15: 15;
	    free16: 16;
	    free17: 17;
	    free18: 18;
	    free: 19;
	    subProgramAction: 20;
	    objectAction: 21;
	}
	export type InterfaceType = keyof InterfaceType$EnumInterface;
	export const interfaceTypeDatatype: X3EnumDataType<keyof InterfaceType$EnumInterface, unknown>;
	//# sourceMappingURL=interface-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/interface-optimization.d.ts
declare module '@sage/x3-system/lib/enums/interface-optimization' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InterfaceOptimizationEnum {
	    none = 1,
	    noTextFile = 2,
	    noImageFile = 3,
	    neitherTextFileNorImageFile = 4,
	    gadget = 5,
	    photo = 6,
	    reserved7 = 7,
	    reserved8 = 8,
	    reserved9 = 9,
	    reserved10 = 10,
	    reserved11 = 11,
	    reserved12 = 12,
	    reserved13 = 13,
	    reserved14 = 14,
	    reserved15 = 15,
	    reserved16 = 16,
	    reserved17 = 17,
	    reserved18 = 18,
	    reserved = 19
	}
	export interface InterfaceOptimization$EnumInterface {
	    none: 1;
	    noTextFile: 2;
	    noImageFile: 3;
	    neitherTextFileNorImageFile: 4;
	    gadget: 5;
	    photo: 6;
	    reserved7: 7;
	    reserved8: 8;
	    reserved9: 9;
	    reserved10: 10;
	    reserved11: 11;
	    reserved12: 12;
	    reserved13: 13;
	    reserved14: 14;
	    reserved15: 15;
	    reserved16: 16;
	    reserved17: 17;
	    reserved18: 18;
	    reserved: 19;
	}
	export type InterfaceOptimization = keyof InterfaceOptimization$EnumInterface;
	export const interfaceOptimizationDatatype: X3EnumDataType<keyof InterfaceOptimization$EnumInterface, unknown>;
	//# sourceMappingURL=interface-optimization.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/initial-status.d.ts
declare module '@sage/x3-system/lib/enums/initial-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InitialStatusEnum {
	    visible = 1,
	    invisible = 2,
	    technical = 3
	}
	export interface InitialStatus$EnumInterface {
	    visible: 1;
	    invisible: 2;
	    technical: 3;
	}
	export type InitialStatus = keyof InitialStatus$EnumInterface;
	export const initialStatusDatatype: X3EnumDataType<keyof InitialStatus$EnumInterface, unknown>;
	//# sourceMappingURL=initial-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/index.d.ts
declare module '@sage/x3-system/lib/enums/index' {
	export * from '@sage/x3-system/lib/enums/abbreviations-of-the-weekdays';
	export * from '@sage/x3-system/lib/enums/action-deactivation';
	export * from '@sage/x3-system/lib/enums/action-field-type';
	export * from '@sage/x3-system/lib/enums/action-flow-management';
	export * from '@sage/x3-system/lib/enums/action-models';
	export * from '@sage/x3-system/lib/enums/action-type-7936';
	export * from '@sage/x3-system/lib/enums/action-type-7960';
	export * from '@sage/x3-system/lib/enums/action-type';
	export * from '@sage/x3-system/lib/enums/actual-forecast';
	export * from '@sage/x3-system/lib/enums/address-type';
	export * from '@sage/x3-system/lib/enums/aggregation-level-7825';
	export * from '@sage/x3-system/lib/enums/amount-conversion-into-letters';
	export * from '@sage/x3-system/lib/enums/and-or';
	export * from '@sage/x3-system/lib/enums/api-loading-type';
	export * from '@sage/x3-system/lib/enums/api-package-type';
	export * from '@sage/x3-system/lib/enums/appointment-type';
	export * from '@sage/x3-system/lib/enums/approval-request';
	export * from '@sage/x3-system/lib/enums/archive-management';
	export * from '@sage/x3-system/lib/enums/archiving-event-type';
	export * from '@sage/x3-system/lib/enums/argument-type';
	export * from '@sage/x3-system/lib/enums/attachment-type';
	export * from '@sage/x3-system/lib/enums/authentication-mode';
	export * from '@sage/x3-system/lib/enums/authorizations-between-folders';
	export * from '@sage/x3-system/lib/enums/backup-integration-reason';
	export * from '@sage/x3-system/lib/enums/base-type-57';
	export * from '@sage/x3-system/lib/enums/base-type';
	export * from '@sage/x3-system/lib/enums/batch-frequency';
	export * from '@sage/x3-system/lib/enums/batch-task-type';
	export * from '@sage/x3-system/lib/enums/behaviors';
	export * from '@sage/x3-system/lib/enums/block-type-7914';
	export * from '@sage/x3-system/lib/enums/block-type';
	export * from '@sage/x3-system/lib/enums/bo-prompt-type';
	export * from '@sage/x3-system/lib/enums/brackets-7932';
	export * from '@sage/x3-system/lib/enums/brackets';
	export * from '@sage/x3-system/lib/enums/button-type';
	export * from '@sage/x3-system/lib/enums/cancellation-code';
	export * from '@sage/x3-system/lib/enums/character-coding';
	export * from '@sage/x3-system/lib/enums/character-format';
	export * from '@sage/x3-system/lib/enums/class-type';
	export * from '@sage/x3-system/lib/enums/code-types';
	export * from '@sage/x3-system/lib/enums/coding-mode';
	export * from '@sage/x3-system/lib/enums/coding-of-the-base';
	export * from '@sage/x3-system/lib/enums/collection-type';
	export * from '@sage/x3-system/lib/enums/color-alternative';
	export * from '@sage/x3-system/lib/enums/conditioned-block-action';
	export * from '@sage/x3-system/lib/enums/conditioned-block-criteria';
	export * from '@sage/x3-system/lib/enums/conditioned-block-page-crit';
	export * from '@sage/x3-system/lib/enums/connection-failure-reason';
	export * from '@sage/x3-system/lib/enums/contact-type';
	export * from '@sage/x3-system/lib/enums/containment-type';
	export * from '@sage/x3-system/lib/enums/control-type';
	export * from '@sage/x3-system/lib/enums/conversion-sense';
	export * from '@sage/x3-system/lib/enums/copy-option';
	export * from '@sage/x3-system/lib/enums/copy-options';
	export * from '@sage/x3-system/lib/enums/copy-type-7816';
	export * from '@sage/x3-system/lib/enums/copy-type-7950';
	export * from '@sage/x3-system/lib/enums/copy-type';
	export * from '@sage/x3-system/lib/enums/creation-assistance';
	export * from '@sage/x3-system/lib/enums/customization-version';
	export * from '@sage/x3-system/lib/enums/dashboard-framework';
	export * from '@sage/x3-system/lib/enums/dashboard-parameter-type';
	export * from '@sage/x3-system/lib/enums/dashboard-type-to-recover';
	export * from '@sage/x3-system/lib/enums/data-file-type';
	export * from '@sage/x3-system/lib/enums/data-filter';
	export * from '@sage/x3-system/lib/enums/data-type-7843';
	export * from '@sage/x3-system/lib/enums/data-types-7947';
	export * from '@sage/x3-system/lib/enums/data-types-9028';
	export * from '@sage/x3-system/lib/enums/data-types';
	export * from '@sage/x3-system/lib/enums/database-status';
	export * from '@sage/x3-system/lib/enums/dates-for-status-generator';
	export * from '@sage/x3-system/lib/enums/days-of-the-week';
	export * from '@sage/x3-system/lib/enums/default-display';
	export * from '@sage/x3-system/lib/enums/default-graph';
	export * from '@sage/x3-system/lib/enums/definition-level-7809';
	export * from '@sage/x3-system/lib/enums/definition-level';
	export * from '@sage/x3-system/lib/enums/delegate-options';
	export * from '@sage/x3-system/lib/enums/delegation-type';
	export * from '@sage/x3-system/lib/enums/deletion-type';
	export * from '@sage/x3-system/lib/enums/delivery-type';
	export * from '@sage/x3-system/lib/enums/density';
	export * from '@sage/x3-system/lib/enums/destination-level';
	export * from '@sage/x3-system/lib/enums/destination-types';
	export * from '@sage/x3-system/lib/enums/development-level';
	export * from '@sage/x3-system/lib/enums/dimension-type-enum';
	export * from '@sage/x3-system/lib/enums/directory-location';
	export * from '@sage/x3-system/lib/enums/diskette-type';
	export * from '@sage/x3-system/lib/enums/display-options-wo-rec';
	export * from '@sage/x3-system/lib/enums/document-generation';
	export * from '@sage/x3-system/lib/enums/documentation-contents';
	export * from '@sage/x3-system/lib/enums/documentation-deletion';
	export * from '@sage/x3-system/lib/enums/documentation-extraction';
	export * from '@sage/x3-system/lib/enums/documentation-html-editor';
	export * from '@sage/x3-system/lib/enums/documentation-paragraphs';
	export * from '@sage/x3-system/lib/enums/download';
	export * from '@sage/x3-system/lib/enums/dynamic-cross-tables';
	export * from '@sage/x3-system/lib/enums/e-mail-transmission';
	export * from '@sage/x3-system/lib/enums/e-mail-type';
	export * from '@sage/x3-system/lib/enums/email-address-type';
	export * from '@sage/x3-system/lib/enums/entity-type-7913';
	export * from '@sage/x3-system/lib/enums/entry-method';
	export * from '@sage/x3-system/lib/enums/entry-mode';
	export * from '@sage/x3-system/lib/enums/entry-point-environment';
	export * from '@sage/x3-system/lib/enums/error-type-7878';
	export * from '@sage/x3-system/lib/enums/error-type';
	export * from '@sage/x3-system/lib/enums/event-type-7814';
	export * from '@sage/x3-system/lib/enums/event-type-7887';
	export * from '@sage/x3-system/lib/enums/event-type';
	export * from '@sage/x3-system/lib/enums/events';
	export * from '@sage/x3-system/lib/enums/excel-export-7839';
	export * from '@sage/x3-system/lib/enums/excel-reports';
	export * from '@sage/x3-system/lib/enums/exception-type-2911';
	export * from '@sage/x3-system/lib/enums/exchange-rate-type';
	export * from '@sage/x3-system/lib/enums/execution-type-2923';
	export * from '@sage/x3-system/lib/enums/execution-type';
	export * from '@sage/x3-system/lib/enums/export-format';
	export * from '@sage/x3-system/lib/enums/field-mask-type';
	export * from '@sage/x3-system/lib/enums/field-origin';
	export * from '@sage/x3-system/lib/enums/field-type-7821';
	export * from '@sage/x3-system/lib/enums/field-type-7826';
	export * from '@sage/x3-system/lib/enums/field-type-7846';
	export * from '@sage/x3-system/lib/enums/field-type-89';
	export * from '@sage/x3-system/lib/enums/field-type';
	export * from '@sage/x3-system/lib/enums/field-use-type';
	export * from '@sage/x3-system/lib/enums/field-use';
	export * from '@sage/x3-system/lib/enums/final-document-generation';
	export * from '@sage/x3-system/lib/enums/first-day-of-week';
	export * from '@sage/x3-system/lib/enums/folder-type-44';
	export * from '@sage/x3-system/lib/enums/folder-type';
	export * from '@sage/x3-system/lib/enums/font-type';
	export * from '@sage/x3-system/lib/enums/form-or-table-entry-mode';
	export * from '@sage/x3-system/lib/enums/form-status';
	export * from '@sage/x3-system/lib/enums/formula-environments';
	export * from '@sage/x3-system/lib/enums/function-access-type';
	export * from '@sage/x3-system/lib/enums/function-contact-942';
	export * from '@sage/x3-system/lib/enums/function-enum';
	export * from '@sage/x3-system/lib/enums/function-navigation';
	export * from '@sage/x3-system/lib/enums/graphic-object-type';
	export * from '@sage/x3-system/lib/enums/graphical-field-type';
	export * from '@sage/x3-system/lib/enums/graphical-position';
	export * from '@sage/x3-system/lib/enums/graphical-representation';
	export * from '@sage/x3-system/lib/enums/graphical-representations';
	export * from '@sage/x3-system/lib/enums/graphical-themes';
	export * from '@sage/x3-system/lib/enums/graphical-type';
	export * from '@sage/x3-system/lib/enums/header-line-3689';
	export * from '@sage/x3-system/lib/enums/header-line';
	export * from '@sage/x3-system/lib/enums/help-key-word-field-type';
	export * from '@sage/x3-system/lib/enums/http-cache-expires';
	export * from '@sage/x3-system/lib/enums/image-type';
	export * from '@sage/x3-system/lib/enums/initial-status';
	export * from '@sage/x3-system/lib/enums/interface-optimization';
	export * from '@sage/x3-system/lib/enums/interface-type';
	export * from '@sage/x3-system/lib/enums/join-option';
	export * from '@sage/x3-system/lib/enums/join-type';
	export * from '@sage/x3-system/lib/enums/kind-of-reference';
	export * from '@sage/x3-system/lib/enums/ldap-connection-type';
	export * from '@sage/x3-system/lib/enums/levels';
	export * from '@sage/x3-system/lib/enums/line-minimum-in-a-grid';
	export * from '@sage/x3-system/lib/enums/link-attributes';
	export * from '@sage/x3-system/lib/enums/link-order-for-helps';
	export * from '@sage/x3-system/lib/enums/link-target';
	export * from '@sage/x3-system/lib/enums/link-type-2916';
	export * from '@sage/x3-system/lib/enums/link-type-2934';
	export * from '@sage/x3-system/lib/enums/link-type-7971';
	export * from '@sage/x3-system/lib/enums/link-type-7974';
	export * from '@sage/x3-system/lib/enums/link-type-920';
	export * from '@sage/x3-system/lib/enums/linked-field-type';
	export * from '@sage/x3-system/lib/enums/list-of-values-description';
	export * from '@sage/x3-system/lib/enums/list-of-values-management';
	export * from '@sage/x3-system/lib/enums/list-type';
	export * from '@sage/x3-system/lib/enums/local-menu-9002';
	export * from '@sage/x3-system/lib/enums/log-file-level';
	export * from '@sage/x3-system/lib/enums/lv-test';
	export * from '@sage/x3-system/lib/enums/management-type-button';
	export * from '@sage/x3-system/lib/enums/manager-type';
	export * from '@sage/x3-system/lib/enums/mapping-selection';
	export * from '@sage/x3-system/lib/enums/message-importance';
	export * from '@sage/x3-system/lib/enums/method-assignment';
	export * from '@sage/x3-system/lib/enums/method-category';
	export * from '@sage/x3-system/lib/enums/method-operation';
	export * from '@sage/x3-system/lib/enums/migration-stages';
	export * from '@sage/x3-system/lib/enums/migration-statuses';
	export * from '@sage/x3-system/lib/enums/module-table';
	export * from '@sage/x3-system/lib/enums/months-of-the-year-9001';
	export * from '@sage/x3-system/lib/enums/multiple-graphs';
	export * from '@sage/x3-system/lib/enums/mutation-typ';
	export * from '@sage/x3-system/lib/enums/nature-of-session';
	export * from '@sage/x3-system/lib/enums/no-yes-criteria-not-displayed';
	export * from '@sage/x3-system/lib/enums/node-binding-type';
	export * from '@sage/x3-system/lib/enums/node-direction';
	export * from '@sage/x3-system/lib/enums/node-type';
	export * from '@sage/x3-system/lib/enums/normal-and-multiple-graphs';
	export * from '@sage/x3-system/lib/enums/object-management-type';
	export * from '@sage/x3-system/lib/enums/object-parameter-type';
	export * from '@sage/x3-system/lib/enums/object-type-42';
	export * from '@sage/x3-system/lib/enums/object-type';
	export * from '@sage/x3-system/lib/enums/object-update-type';
	export * from '@sage/x3-system/lib/enums/object-ws-action';
	export * from '@sage/x3-system/lib/enums/office-document-type';
	export * from '@sage/x3-system/lib/enums/operation-account-for-spy-fi';
	export * from '@sage/x3-system/lib/enums/operation-tracking';
	export * from '@sage/x3-system/lib/enums/operation-type-7822';
	export * from '@sage/x3-system/lib/enums/oracle-process-sorting';
	export * from '@sage/x3-system/lib/enums/oracle-trace-sort-options';
	export * from '@sage/x3-system/lib/enums/orientation';
	export * from '@sage/x3-system/lib/enums/os-type';
	export * from '@sage/x3-system/lib/enums/pages';
	export * from '@sage/x3-system/lib/enums/paper-sizes';
	export * from '@sage/x3-system/lib/enums/parameter-definition-level';
	export * from '@sage/x3-system/lib/enums/parameter-type-7800';
	export * from '@sage/x3-system/lib/enums/parameter-type';
	export * from '@sage/x3-system/lib/enums/parameter-types-10030';
	export * from '@sage/x3-system/lib/enums/parameter-types';
	export * from '@sage/x3-system/lib/enums/patch-integration';
	export * from '@sage/x3-system/lib/enums/patch-status';
	export * from '@sage/x3-system/lib/enums/patch-type';
	export * from '@sage/x3-system/lib/enums/preloading';
	export * from '@sage/x3-system/lib/enums/print-types';
	export * from '@sage/x3-system/lib/enums/printer-type';
	export * from '@sage/x3-system/lib/enums/process-archive';
	export * from '@sage/x3-system/lib/enums/process-filter';
	export * from '@sage/x3-system/lib/enums/process-type-78';
	export * from '@sage/x3-system/lib/enums/processes';
	export * from '@sage/x3-system/lib/enums/processing-type';
	export * from '@sage/x3-system/lib/enums/product-edition';
	export * from '@sage/x3-system/lib/enums/products-7857';
	export * from '@sage/x3-system/lib/enums/products-7884';
	export * from '@sage/x3-system/lib/enums/products';
	export * from '@sage/x3-system/lib/enums/profile-type-function';
	export * from '@sage/x3-system/lib/enums/propagation-rule';
	export * from '@sage/x3-system/lib/enums/protocol';
	export * from '@sage/x3-system/lib/enums/prototype-format';
	export * from '@sage/x3-system/lib/enums/prototype-type';
	export * from '@sage/x3-system/lib/enums/query-progress-status';
	export * from '@sage/x3-system/lib/enums/query-type';
	export * from '@sage/x3-system/lib/enums/range-type';
	export * from '@sage/x3-system/lib/enums/range';
	export * from '@sage/x3-system/lib/enums/rate-date';
	export * from '@sage/x3-system/lib/enums/recipient-type';
	export * from '@sage/x3-system/lib/enums/record-type-7868';
	export * from '@sage/x3-system/lib/enums/reference-type';
	export * from '@sage/x3-system/lib/enums/regrouping-site';
	export * from '@sage/x3-system/lib/enums/reorder-type';
	export * from '@sage/x3-system/lib/enums/report-developer-options';
	export * from '@sage/x3-system/lib/enums/report-development-status';
	export * from '@sage/x3-system/lib/enums/report-group';
	export * from '@sage/x3-system/lib/enums/representation-facets';
	export * from '@sage/x3-system/lib/enums/representation-parameter-type';
	export * from '@sage/x3-system/lib/enums/representation-type-7967';
	export * from '@sage/x3-system/lib/enums/representation-type';
	export * from '@sage/x3-system/lib/enums/representation';
	export * from '@sage/x3-system/lib/enums/reset-sequence-number-to-zero';
	export * from '@sage/x3-system/lib/enums/retreival-of-sql-server-trace';
	export * from '@sage/x3-system/lib/enums/root-directory';
	export * from '@sage/x3-system/lib/enums/rule-types';
	export * from '@sage/x3-system/lib/enums/screen-resolution';
	export * from '@sage/x3-system/lib/enums/screen-type';
	export * from '@sage/x3-system/lib/enums/search-operators';
	export * from '@sage/x3-system/lib/enums/security-level';
	export * from '@sage/x3-system/lib/enums/selection-operators-7815';
	export * from '@sage/x3-system/lib/enums/selection-operators-7926';
	export * from '@sage/x3-system/lib/enums/selection-operators';
	export * from '@sage/x3-system/lib/enums/selection-opt-main-block';
	export * from '@sage/x3-system/lib/enums/selection-type';
	export * from '@sage/x3-system/lib/enums/selective-assembly';
	export * from '@sage/x3-system/lib/enums/send-type';
	export * from '@sage/x3-system/lib/enums/sequence-number-fields';
	export * from '@sage/x3-system/lib/enums/sequence-number-type';
	export * from '@sage/x3-system/lib/enums/sequence-type';
	export * from '@sage/x3-system/lib/enums/server-status';
	export * from '@sage/x3-system/lib/enums/setup-elements';
	export * from '@sage/x3-system/lib/enums/signature-2922';
	export * from '@sage/x3-system/lib/enums/size';
	export * from '@sage/x3-system/lib/enums/sizing';
	export * from '@sage/x3-system/lib/enums/sort-functions';
	export * from '@sage/x3-system/lib/enums/sort-open-items';
	export * from '@sage/x3-system/lib/enums/sort-order';
	export * from '@sage/x3-system/lib/enums/sort-type-7917';
	export * from '@sage/x3-system/lib/enums/sort-type';
	export * from '@sage/x3-system/lib/enums/specific-flag';
	export * from '@sage/x3-system/lib/enums/specifics-compliance';
	export * from '@sage/x3-system/lib/enums/sql-server-process-sorting';
	export * from '@sage/x3-system/lib/enums/sql-server-trace-options';
	export * from '@sage/x3-system/lib/enums/standard-bottom-of-page-codes';
	export * from '@sage/x3-system/lib/enums/standard-methods';
	export * from '@sage/x3-system/lib/enums/statistical-frequency';
	export * from '@sage/x3-system/lib/enums/statistical-type';
	export * from '@sage/x3-system/lib/enums/statistical-update';
	export * from '@sage/x3-system/lib/enums/status-doc';
	export * from '@sage/x3-system/lib/enums/sub-program-types';
	export * from '@sage/x3-system/lib/enums/subdivision-entry';
	export * from '@sage/x3-system/lib/enums/supervisor-counters';
	export * from '@sage/x3-system/lib/enums/synthesis-operators';
	export * from '@sage/x3-system/lib/enums/syracuse-format';
	export * from '@sage/x3-system/lib/enums/syracuse-test';
	export * from '@sage/x3-system/lib/enums/system-transaction-type';
	export * from '@sage/x3-system/lib/enums/table-type-2930';
	export * from '@sage/x3-system/lib/enums/table-type-80';
	export * from '@sage/x3-system/lib/enums/table-type';
	export * from '@sage/x3-system/lib/enums/tax-basis';
	export * from '@sage/x3-system/lib/enums/technical-origin';
	export * from '@sage/x3-system/lib/enums/technical-type-field';
	export * from '@sage/x3-system/lib/enums/telephone-number-control';
	export * from '@sage/x3-system/lib/enums/telephone-type';
	export * from '@sage/x3-system/lib/enums/template-type';
	export * from '@sage/x3-system/lib/enums/test-queries';
	export * from '@sage/x3-system/lib/enums/text-roles';
	export * from '@sage/x3-system/lib/enums/text-type-944';
	export * from '@sage/x3-system/lib/enums/text-type';
	export * from '@sage/x3-system/lib/enums/timestamp-management';
	export * from '@sage/x3-system/lib/enums/title';
	export * from '@sage/x3-system/lib/enums/trace-presentation';
	export * from '@sage/x3-system/lib/enums/transfer-type';
	export * from '@sage/x3-system/lib/enums/translation-priority-level';
	export * from '@sage/x3-system/lib/enums/type-7881';
	export * from '@sage/x3-system/lib/enums/type-7882';
	export * from '@sage/x3-system/lib/enums/type-de-mise-au-point';
	export * from '@sage/x3-system/lib/enums/type-of-activity';
	export * from '@sage/x3-system/lib/enums/type-of-date-913';
	export * from '@sage/x3-system/lib/enums/type-of-date';
	export * from '@sage/x3-system/lib/enums/type-of-day';
	export * from '@sage/x3-system/lib/enums/type-of-dependency';
	export * from '@sage/x3-system/lib/enums/type-of-gadget';
	export * from '@sage/x3-system/lib/enums/type-of-non-standard-file';
	export * from '@sage/x3-system/lib/enums/type-of-parameters';
	export * from '@sage/x3-system/lib/enums/type-of-quick-select-list';
	export * from '@sage/x3-system/lib/enums/type-of-session';
	export * from '@sage/x3-system/lib/enums/type-of-statistic';
	export * from '@sage/x3-system/lib/enums/types-of-activity-code';
	export * from '@sage/x3-system/lib/enums/unit-type';
	export * from '@sage/x3-system/lib/enums/update-frequency';
	export * from '@sage/x3-system/lib/enums/update-operations';
	export * from '@sage/x3-system/lib/enums/update-status';
	export * from '@sage/x3-system/lib/enums/update-type';
	export * from '@sage/x3-system/lib/enums/updated-description';
	export * from '@sage/x3-system/lib/enums/updating-type';
	export * from '@sage/x3-system/lib/enums/url-location';
	export * from '@sage/x3-system/lib/enums/user-access-type';
	export * from '@sage/x3-system/lib/enums/utilities';
	export * from '@sage/x3-system/lib/enums/utility-execution';
	export * from '@sage/x3-system/lib/enums/utility-launch-status';
	export * from '@sage/x3-system/lib/enums/validation-type-7829';
	export * from '@sage/x3-system/lib/enums/validation-type';
	export * from '@sage/x3-system/lib/enums/validity-type';
	export * from '@sage/x3-system/lib/enums/value-type-7925';
	export * from '@sage/x3-system/lib/enums/verbs';
	export * from '@sage/x3-system/lib/enums/vocabulary-validation-options';
	export * from '@sage/x3-system/lib/enums/web-service-element';
	export * from '@sage/x3-system/lib/enums/web-services-message-severity';
	export * from '@sage/x3-system/lib/enums/web-services-type';
	export * from '@sage/x3-system/lib/enums/web-site-field-type';
	export * from '@sage/x3-system/lib/enums/web-site-type';
	export * from '@sage/x3-system/lib/enums/where-used';
	export * from '@sage/x3-system/lib/enums/window-type-923';
	export * from '@sage/x3-system/lib/enums/window-type';
	export * from '@sage/x3-system/lib/enums/window-types';
	export * from '@sage/x3-system/lib/enums/workflow-status';
	export * from '@sage/x3-system/lib/enums/x-3-products';
	export * from '@sage/x3-system/lib/enums/xsl-type';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/image-type.d.ts
declare module '@sage/x3-system/lib/enums/image-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ImageTypeEnum {
	    normal = 1,
	    stretched = 2,
	    proportional = 3
	}
	export interface ImageType$EnumInterface {
	    normal: 1;
	    stretched: 2;
	    proportional: 3;
	}
	export type ImageType = keyof ImageType$EnumInterface;
	export const imageTypeDatatype: X3EnumDataType<keyof ImageType$EnumInterface, unknown>;
	//# sourceMappingURL=image-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/http-cache-expires.d.ts
declare module '@sage/x3-system/lib/enums/http-cache-expires' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum HttpCacheExpiresEnum {
	    never = 1,
	    always = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4,
	    substituteValue5 = 5,
	    substituteValue6 = 6,
	    substituteValue7 = 7,
	    substituteValue8 = 8,
	    substituteValue9 = 9,
	    substituteValue10 = 10,
	    substituteValue11 = 11
	}
	export interface HttpCacheExpires$EnumInterface {
	    never: 1;
	    always: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	    substituteValue5: 5;
	    substituteValue6: 6;
	    substituteValue7: 7;
	    substituteValue8: 8;
	    substituteValue9: 9;
	    substituteValue10: 10;
	    substituteValue11: 11;
	}
	export type HttpCacheExpires = keyof HttpCacheExpires$EnumInterface;
	export const httpCacheExpiresDatatype: X3EnumDataType<keyof HttpCacheExpires$EnumInterface, unknown>;
	//# sourceMappingURL=http-cache-expires.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/help-key-word-field-type.d.ts
declare module '@sage/x3-system/lib/enums/help-key-word-field-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum HelpKeyWordFieldTypeEnum {
	    table = 1,
	    screen = 2,
	    class = 3,
	    representation = 4
	}
	export interface HelpKeyWordFieldType$EnumInterface {
	    table: 1;
	    screen: 2;
	    class: 3;
	    representation: 4;
	}
	export type HelpKeyWordFieldType = keyof HelpKeyWordFieldType$EnumInterface;
	export const helpKeyWordFieldTypeDatatype: X3EnumDataType<keyof HelpKeyWordFieldType$EnumInterface, unknown>;
	//# sourceMappingURL=help-key-word-field-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/header-line.d.ts
declare module '@sage/x3-system/lib/enums/header-line' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum HeaderLineEnum {
	    substituteValue1 = 1,
	    header = 2,
	    line = 3
	}
	export interface HeaderLine$EnumInterface {
	    substituteValue1: 1;
	    header: 2;
	    line: 3;
	}
	export type HeaderLine = keyof HeaderLine$EnumInterface;
	export const headerLineDatatype: X3EnumDataType<keyof HeaderLine$EnumInterface, unknown>;
	//# sourceMappingURL=header-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/header-line-3689.d.ts
declare module '@sage/x3-system/lib/enums/header-line-3689' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum HeaderLine3689Enum {
	    lineDetail = 1,
	    header = 2,
	    line = 3
	}
	export interface HeaderLine3689$EnumInterface {
	    lineDetail: 1;
	    header: 2;
	    line: 3;
	}
	export type HeaderLine3689 = keyof HeaderLine3689$EnumInterface;
	export const headerLine3689Datatype: X3EnumDataType<keyof HeaderLine3689$EnumInterface, unknown>;
	//# sourceMappingURL=header-line-3689.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/graphical-type.d.ts
declare module '@sage/x3-system/lib/enums/graphical-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GraphicalTypeEnum {
	    simpleGraph = 1,
	    multipleGraph = 2,
	    planningCalendar = 3,
	    xsl = 4,
	    gantt = 5,
	    queryTool = 6
	}
	export interface GraphicalType$EnumInterface {
	    simpleGraph: 1;
	    multipleGraph: 2;
	    planningCalendar: 3;
	    xsl: 4;
	    gantt: 5;
	    queryTool: 6;
	}
	export type GraphicalType = keyof GraphicalType$EnumInterface;
	export const graphicalTypeDatatype: X3EnumDataType<keyof GraphicalType$EnumInterface, unknown>;
	//# sourceMappingURL=graphical-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/graphical-themes.d.ts
declare module '@sage/x3-system/lib/enums/graphical-themes' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GraphicalThemesEnum {
	    x3 = 1,
	    sprh = 2,
	    geode = 3,
	    abel = 4,
	    diapasonX = 5,
	    x2 = 6
	}
	export interface GraphicalThemes$EnumInterface {
	    x3: 1;
	    sprh: 2;
	    geode: 3;
	    abel: 4;
	    diapasonX: 5;
	    x2: 6;
	}
	export type GraphicalThemes = keyof GraphicalThemes$EnumInterface;
	export const graphicalThemesDatatype: X3EnumDataType<keyof GraphicalThemes$EnumInterface, unknown>;
	//# sourceMappingURL=graphical-themes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/graphical-representations.d.ts
declare module '@sage/x3-system/lib/enums/graphical-representations' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GraphicalRepresentationsEnum {
	    multipleBars = 1,
	    cumulationBars = 2,
	    comparisonBars = 3,
	    multipleLines = 4,
	    cumulationLines = 5,
	    comparisonLines = 6,
	    multipleAreas = 7,
	    cumulationAreas = 8,
	    comparisonAreas = 9
	}
	export interface GraphicalRepresentations$EnumInterface {
	    multipleBars: 1;
	    cumulationBars: 2;
	    comparisonBars: 3;
	    multipleLines: 4;
	    cumulationLines: 5;
	    comparisonLines: 6;
	    multipleAreas: 7;
	    cumulationAreas: 8;
	    comparisonAreas: 9;
	}
	export type GraphicalRepresentations = keyof GraphicalRepresentations$EnumInterface;
	export const graphicalRepresentationsDatatype: X3EnumDataType<keyof GraphicalRepresentations$EnumInterface, unknown>;
	//# sourceMappingURL=graphical-representations.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/graphical-representation.d.ts
declare module '@sage/x3-system/lib/enums/graphical-representation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GraphicalRepresentationEnum {
	    multiple = 1,
	    cumulation = 2,
	    comparison = 3,
	    month = 4,
	    week = 5,
	    day = 6
	}
	export interface GraphicalRepresentation$EnumInterface {
	    multiple: 1;
	    cumulation: 2;
	    comparison: 3;
	    month: 4;
	    week: 5;
	    day: 6;
	}
	export type GraphicalRepresentation = keyof GraphicalRepresentation$EnumInterface;
	export const graphicalRepresentationDatatype: X3EnumDataType<keyof GraphicalRepresentation$EnumInterface, unknown>;
	//# sourceMappingURL=graphical-representation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/graphical-position.d.ts
declare module '@sage/x3-system/lib/enums/graphical-position' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GraphicalPositionEnum {
	    toTheRight = 1,
	    toTheLeft = 2,
	    above = 3,
	    below = 4
	}
	export interface GraphicalPosition$EnumInterface {
	    toTheRight: 1;
	    toTheLeft: 2;
	    above: 3;
	    below: 4;
	}
	export type GraphicalPosition = keyof GraphicalPosition$EnumInterface;
	export const graphicalPositionDatatype: X3EnumDataType<keyof GraphicalPosition$EnumInterface, unknown>;
	//# sourceMappingURL=graphical-position.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/graphical-field-type.d.ts
declare module '@sage/x3-system/lib/enums/graphical-field-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GraphicalFieldTypeEnum {
	    value = 1,
	    default = 2,
	    description = 3,
	    none = 4
	}
	export interface GraphicalFieldType$EnumInterface {
	    value: 1;
	    default: 2;
	    description: 3;
	    none: 4;
	}
	export type GraphicalFieldType = keyof GraphicalFieldType$EnumInterface;
	export const graphicalFieldTypeDatatype: X3EnumDataType<keyof GraphicalFieldType$EnumInterface, unknown>;
	//# sourceMappingURL=graphical-field-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/graphic-object-type.d.ts
declare module '@sage/x3-system/lib/enums/graphic-object-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GraphicObjectTypeEnum {
	    none = 1,
	    checkBox = 2,
	    buttonsVc = 3,
	    buttonsVs = 4,
	    buttonsHc = 5,
	    buttonsHs = 6,
	    spinEdit = 7,
	    programBar = 8,
	    photo = 9,
	    multilineText = 10,
	    relativeRtfFile = 11,
	    absoluteTextFileRtf = 12,
	    icon = 13
	}
	export interface GraphicObjectType$EnumInterface {
	    none: 1;
	    checkBox: 2;
	    buttonsVc: 3;
	    buttonsVs: 4;
	    buttonsHc: 5;
	    buttonsHs: 6;
	    spinEdit: 7;
	    programBar: 8;
	    photo: 9;
	    multilineText: 10;
	    relativeRtfFile: 11;
	    absoluteTextFileRtf: 12;
	    icon: 13;
	}
	export type GraphicObjectType = keyof GraphicObjectType$EnumInterface;
	export const graphicObjectTypeDatatype: X3EnumDataType<keyof GraphicObjectType$EnumInterface, unknown>;
	//# sourceMappingURL=graphic-object-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/function-navigation.d.ts
declare module '@sage/x3-system/lib/enums/function-navigation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FunctionNavigationEnum {
	    authorized = 1,
	    prohibitedToThisFunction = 2,
	    prohibitedFromThisFunction = 3,
	    prohibitedInAllCases = 4
	}
	export interface FunctionNavigation$EnumInterface {
	    authorized: 1;
	    prohibitedToThisFunction: 2;
	    prohibitedFromThisFunction: 3;
	    prohibitedInAllCases: 4;
	}
	export type FunctionNavigation = keyof FunctionNavigation$EnumInterface;
	export const functionNavigationDatatype: X3EnumDataType<keyof FunctionNavigation$EnumInterface, unknown>;
	//# sourceMappingURL=function-navigation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/function-enum.d.ts
declare module '@sage/x3-system/lib/enums/function-enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FunctionEnumEnum {
	    activation = 1,
	    deactivation = 2
	}
	export interface FunctionEnum$EnumInterface {
	    activation: 1;
	    deactivation: 2;
	}
	export type FunctionEnum = keyof FunctionEnum$EnumInterface;
	export const functionEnumDatatype: X3EnumDataType<keyof FunctionEnum$EnumInterface, unknown>;
	//# sourceMappingURL=function-enum.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/function-contact-942.d.ts
declare module '@sage/x3-system/lib/enums/function-contact-942' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FunctionContact942Enum {
	    small = 1,
	    average = 2,
	    large = 3
	}
	export interface FunctionContact942$EnumInterface {
	    small: 1;
	    average: 2;
	    large: 3;
	}
	export type FunctionContact942 = keyof FunctionContact942$EnumInterface;
	export const functionContact942Datatype: X3EnumDataType<keyof FunctionContact942$EnumInterface, unknown>;
	//# sourceMappingURL=function-contact-942.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/function-access-type.d.ts
declare module '@sage/x3-system/lib/enums/function-access-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FunctionAccessTypeEnum {
	    yesNo = 1,
	    totalInquiry = 2,
	    object = 3
	}
	export interface FunctionAccessType$EnumInterface {
	    yesNo: 1;
	    totalInquiry: 2;
	    object: 3;
	}
	export type FunctionAccessType = keyof FunctionAccessType$EnumInterface;
	export const functionAccessTypeDatatype: X3EnumDataType<keyof FunctionAccessType$EnumInterface, unknown>;
	//# sourceMappingURL=function-access-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/formula-environments.d.ts
declare module '@sage/x3-system/lib/enums/formula-environments' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FormulaEnvironmentsEnum {
	    globalVariables = 1,
	    localVariables = 2,
	    functions = 3
	}
	export interface FormulaEnvironments$EnumInterface {
	    globalVariables: 1;
	    localVariables: 2;
	    functions: 3;
	}
	export type FormulaEnvironments = keyof FormulaEnvironments$EnumInterface;
	export const formulaEnvironmentsDatatype: X3EnumDataType<keyof FormulaEnvironments$EnumInterface, unknown>;
	//# sourceMappingURL=formula-environments.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/form-status.d.ts
declare module '@sage/x3-system/lib/enums/form-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FormStatusEnum {
	    toBeProcessed = 1,
	    processed = 2,
	    reserved3 = 3,
	    reserved4 = 4,
	    reserved5 = 5,
	    reserved6 = 6,
	    reserved7 = 7,
	    reserved8 = 8,
	    reserved9 = 9,
	    reserved10 = 10,
	    reserved11 = 11,
	    reserved12 = 12,
	    reserved13 = 13,
	    reserved14 = 14,
	    reserved15 = 15,
	    reserved16 = 16,
	    reserved17 = 17,
	    reserved18 = 18,
	    reserved = 19
	}
	export interface FormStatus$EnumInterface {
	    toBeProcessed: 1;
	    processed: 2;
	    reserved3: 3;
	    reserved4: 4;
	    reserved5: 5;
	    reserved6: 6;
	    reserved7: 7;
	    reserved8: 8;
	    reserved9: 9;
	    reserved10: 10;
	    reserved11: 11;
	    reserved12: 12;
	    reserved13: 13;
	    reserved14: 14;
	    reserved15: 15;
	    reserved16: 16;
	    reserved17: 17;
	    reserved18: 18;
	    reserved: 19;
	}
	export type FormStatus = keyof FormStatus$EnumInterface;
	export const formStatusDatatype: X3EnumDataType<keyof FormStatus$EnumInterface, unknown>;
	//# sourceMappingURL=form-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/form-or-table-entry-mode.d.ts
declare module '@sage/x3-system/lib/enums/form-or-table-entry-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FormOrTableEntryModeEnum {
	    formAndTable = 1,
	    form = 2,
	    table = 3
	}
	export interface FormOrTableEntryMode$EnumInterface {
	    formAndTable: 1;
	    form: 2;
	    table: 3;
	}
	export type FormOrTableEntryMode = keyof FormOrTableEntryMode$EnumInterface;
	export const formOrTableEntryModeDatatype: X3EnumDataType<keyof FormOrTableEntryMode$EnumInterface, unknown>;
	//# sourceMappingURL=form-or-table-entry-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/font-type.d.ts
declare module '@sage/x3-system/lib/enums/font-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FontTypeEnum {
	    standard = 1,
	    arial = 2,
	    timesNewRoman = 3
	}
	export interface FontType$EnumInterface {
	    standard: 1;
	    arial: 2;
	    timesNewRoman: 3;
	}
	export type FontType = keyof FontType$EnumInterface;
	export const fontTypeDatatype: X3EnumDataType<keyof FontType$EnumInterface, unknown>;
	//# sourceMappingURL=font-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/folder-type.d.ts
declare module '@sage/x3-system/lib/enums/folder-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FolderTypeEnum {
	    application = 1,
	    development = 2
	}
	export interface FolderType$EnumInterface {
	    application: 1;
	    development: 2;
	}
	export type FolderType = keyof FolderType$EnumInterface;
	export const folderTypeDatatype: X3EnumDataType<keyof FolderType$EnumInterface, unknown>;
	//# sourceMappingURL=folder-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/folder-type-44.d.ts
declare module '@sage/x3-system/lib/enums/folder-type-44' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FolderType44Enum {
	    application = 1,
	    development = 2
	}
	export interface FolderType44$EnumInterface {
	    application: 1;
	    development: 2;
	}
	export type FolderType44 = keyof FolderType44$EnumInterface;
	export const folderType44Datatype: X3EnumDataType<keyof FolderType44$EnumInterface, unknown>;
	//# sourceMappingURL=folder-type-44.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/first-day-of-week.d.ts
declare module '@sage/x3-system/lib/enums/first-day-of-week' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FirstDayOfWeekEnum {
	    monday = 1,
	    tuesday = 2,
	    wednesday = 3,
	    thursday = 4,
	    friday = 5,
	    saturday = 6,
	    sunday = 7
	}
	export interface FirstDayOfWeek$EnumInterface {
	    monday: 1;
	    tuesday: 2;
	    wednesday: 3;
	    thursday: 4;
	    friday: 5;
	    saturday: 6;
	    sunday: 7;
	}
	export type FirstDayOfWeek = keyof FirstDayOfWeek$EnumInterface;
	export const firstDayOfWeekDatatype: X3EnumDataType<keyof FirstDayOfWeek$EnumInterface, unknown>;
	//# sourceMappingURL=first-day-of-week.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/final-document-generation.d.ts
declare module '@sage/x3-system/lib/enums/final-document-generation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FinalDocumentGenerationEnum {
	    no = 1,
	    complete = 2,
	    accordingToActivityCode = 3
	}
	export interface FinalDocumentGeneration$EnumInterface {
	    no: 1;
	    complete: 2;
	    accordingToActivityCode: 3;
	}
	export type FinalDocumentGeneration = keyof FinalDocumentGeneration$EnumInterface;
	export const finalDocumentGenerationDatatype: X3EnumDataType<keyof FinalDocumentGeneration$EnumInterface, unknown>;
	//# sourceMappingURL=final-document-generation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/field-use.d.ts
declare module '@sage/x3-system/lib/enums/field-use' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FieldUseEnum {
	    queryRecord = 1,
	    query = 2,
	    record = 3
	}
	export interface FieldUse$EnumInterface {
	    queryRecord: 1;
	    query: 2;
	    record: 3;
	}
	export type FieldUse = keyof FieldUse$EnumInterface;
	export const fieldUseDatatype: X3EnumDataType<keyof FieldUse$EnumInterface, unknown>;
	//# sourceMappingURL=field-use.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/field-use-type.d.ts
declare module '@sage/x3-system/lib/enums/field-use-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FieldUseTypeEnum {
	    standard = 1,
	    constant = 2,
	    description = 3
	}
	export interface FieldUseType$EnumInterface {
	    standard: 1;
	    constant: 2;
	    description: 3;
	}
	export type FieldUseType = keyof FieldUseType$EnumInterface;
	export const fieldUseTypeDatatype: X3EnumDataType<keyof FieldUseType$EnumInterface, unknown>;
	//# sourceMappingURL=field-use-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/field-type.d.ts
declare module '@sage/x3-system/lib/enums/field-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FieldTypeEnum {
	    alphanumeric = 1,
	    numeric = 2,
	    date = 3,
	    localMenu = 4
	}
	export interface FieldType$EnumInterface {
	    alphanumeric: 1;
	    numeric: 2;
	    date: 3;
	    localMenu: 4;
	}
	export type FieldType = keyof FieldType$EnumInterface;
	export const fieldTypeDatatype: X3EnumDataType<keyof FieldType$EnumInterface, unknown>;
	//# sourceMappingURL=field-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/field-type-89.d.ts
declare module '@sage/x3-system/lib/enums/field-type-89' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FieldType89Enum {
	    field = 1,
	    expression = 2
	}
	export interface FieldType89$EnumInterface {
	    field: 1;
	    expression: 2;
	}
	export type FieldType89 = keyof FieldType89$EnumInterface;
	export const fieldType89Datatype: X3EnumDataType<keyof FieldType89$EnumInterface, unknown>;
	//# sourceMappingURL=field-type-89.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/field-type-7846.d.ts
declare module '@sage/x3-system/lib/enums/field-type-7846' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FieldType7846Enum {
	    identifier = 1,
	    identifier2 = 2,
	    record = 3,
	    parameter = 4
	}
	export interface FieldType7846$EnumInterface {
	    identifier: 1;
	    identifier2: 2;
	    record: 3;
	    parameter: 4;
	}
	export type FieldType7846 = keyof FieldType7846$EnumInterface;
	export const fieldType7846Datatype: X3EnumDataType<keyof FieldType7846$EnumInterface, unknown>;
	//# sourceMappingURL=field-type-7846.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/field-type-7826.d.ts
declare module '@sage/x3-system/lib/enums/field-type-7826' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FieldType7826Enum {
	    dimension = 1,
	    information = 2,
	    parentDimension = 3,
	    technical = 4
	}
	export interface FieldType7826$EnumInterface {
	    dimension: 1;
	    information: 2;
	    parentDimension: 3;
	    technical: 4;
	}
	export type FieldType7826 = keyof FieldType7826$EnumInterface;
	export const fieldType7826Datatype: X3EnumDataType<keyof FieldType7826$EnumInterface, unknown>;
	//# sourceMappingURL=field-type-7826.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/field-type-7821.d.ts
declare module '@sage/x3-system/lib/enums/field-type-7821' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FieldType7821Enum {
	    measurement = 1,
	    information = 2,
	    dimension = 3,
	    technical = 4
	}
	export interface FieldType7821$EnumInterface {
	    measurement: 1;
	    information: 2;
	    dimension: 3;
	    technical: 4;
	}
	export type FieldType7821 = keyof FieldType7821$EnumInterface;
	export const fieldType7821Datatype: X3EnumDataType<keyof FieldType7821$EnumInterface, unknown>;
	//# sourceMappingURL=field-type-7821.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/field-origin.d.ts
declare module '@sage/x3-system/lib/enums/field-origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FieldOriginEnum {
	    representation = 1,
	    class = 2
	}
	export interface FieldOrigin$EnumInterface {
	    representation: 1;
	    class: 2;
	}
	export type FieldOrigin = keyof FieldOrigin$EnumInterface;
	export const fieldOriginDatatype: X3EnumDataType<keyof FieldOrigin$EnumInterface, unknown>;
	//# sourceMappingURL=field-origin.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/field-mask-type.d.ts
declare module '@sage/x3-system/lib/enums/field-mask-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FieldMaskTypeEnum {
	    abbreviation = 1,
	    row = 2,
	    pageNumber = 3,
	    abscissa = 4,
	    ordinate = 5,
	    dimension = 6,
	    format = 7,
	    valueDefault = 8,
	    control = 9,
	    selection = 10,
	    link = 11,
	    mandatoryHelp = 12,
	    errorHelp = 13,
	    help = 14,
	    buttons = 15,
	    numberOfLines = 16,
	    highTable = 17,
	    lowTable = 18,
	    covering = 19,
	    options = 20,
	    beforeLine = 21,
	    afterLine = 22
	}
	export interface FieldMaskType$EnumInterface {
	    abbreviation: 1;
	    row: 2;
	    pageNumber: 3;
	    abscissa: 4;
	    ordinate: 5;
	    dimension: 6;
	    format: 7;
	    valueDefault: 8;
	    control: 9;
	    selection: 10;
	    link: 11;
	    mandatoryHelp: 12;
	    errorHelp: 13;
	    help: 14;
	    buttons: 15;
	    numberOfLines: 16;
	    highTable: 17;
	    lowTable: 18;
	    covering: 19;
	    options: 20;
	    beforeLine: 21;
	    afterLine: 22;
	}
	export type FieldMaskType = keyof FieldMaskType$EnumInterface;
	export const fieldMaskTypeDatatype: X3EnumDataType<keyof FieldMaskType$EnumInterface, unknown>;
	//# sourceMappingURL=field-mask-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/export-format.d.ts
declare module '@sage/x3-system/lib/enums/export-format' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExportFormatEnum {
	    utf8 = 1,
	    ucs2 = 2,
	    ascii = 3
	}
	export interface ExportFormat$EnumInterface {
	    utf8: 1;
	    ucs2: 2;
	    ascii: 3;
	}
	export type ExportFormat = keyof ExportFormat$EnumInterface;
	export const exportFormatDatatype: X3EnumDataType<keyof ExportFormat$EnumInterface, unknown>;
	//# sourceMappingURL=export-format.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/execution-type.d.ts
declare module '@sage/x3-system/lib/enums/execution-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExecutionTypeEnum {
	    interactive = 1,
	    importBatch = 2,
	    always = 3
	}
	export interface ExecutionType$EnumInterface {
	    interactive: 1;
	    importBatch: 2;
	    always: 3;
	}
	export type ExecutionType = keyof ExecutionType$EnumInterface;
	export const executionTypeDatatype: X3EnumDataType<keyof ExecutionType$EnumInterface, unknown>;
	//# sourceMappingURL=execution-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/execution-type-2923.d.ts
declare module '@sage/x3-system/lib/enums/execution-type-2923' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExecutionType2923Enum {
	    workflowStart = 1,
	    workflowEnd = 2,
	    duringSignature = 3,
	    line = 4,
	    beforeLine = 5,
	    beforeGroup = 6
	}
	export interface ExecutionType2923$EnumInterface {
	    workflowStart: 1;
	    workflowEnd: 2;
	    duringSignature: 3;
	    line: 4;
	    beforeLine: 5;
	    beforeGroup: 6;
	}
	export type ExecutionType2923 = keyof ExecutionType2923$EnumInterface;
	export const executionType2923Datatype: X3EnumDataType<keyof ExecutionType2923$EnumInterface, unknown>;
	//# sourceMappingURL=execution-type-2923.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/exchange-rate-type.d.ts
declare module '@sage/x3-system/lib/enums/exchange-rate-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExchangeRateTypeEnum {
	    dailyRate = 1,
	    monthlyRate = 2,
	    averageRate = 3,
	    customsDocFileExchange = 4,
	    ueRate = 5
	}
	export interface ExchangeRateType$EnumInterface {
	    dailyRate: 1;
	    monthlyRate: 2;
	    averageRate: 3;
	    customsDocFileExchange: 4;
	    ueRate: 5;
	}
	export type ExchangeRateType = keyof ExchangeRateType$EnumInterface;
	export const exchangeRateTypeDatatype: X3EnumDataType<keyof ExchangeRateType$EnumInterface, unknown>;
	//# sourceMappingURL=exchange-rate-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/exception-type-2911.d.ts
declare module '@sage/x3-system/lib/enums/exception-type-2911' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExceptionType2911Enum {
	    withoutCorrespondence = 1,
	    multipleCorrespondence = 2
	}
	export interface ExceptionType2911$EnumInterface {
	    withoutCorrespondence: 1;
	    multipleCorrespondence: 2;
	}
	export type ExceptionType2911 = keyof ExceptionType2911$EnumInterface;
	export const exceptionType2911Datatype: X3EnumDataType<keyof ExceptionType2911$EnumInterface, unknown>;
	//# sourceMappingURL=exception-type-2911.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/excel-reports.d.ts
declare module '@sage/x3-system/lib/enums/excel-reports' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExcelReportsEnum {
	    report1 = 1,
	    report2 = 2,
	    report3 = 3,
	    report4 = 4,
	    report5 = 5,
	    report6 = 6,
	    report7 = 7,
	    report8 = 8,
	    report9 = 9,
	    report10 = 10,
	    table1 = 11,
	    table2 = 12,
	    table3 = 13,
	    table4 = 14,
	    table515 = 15,
	    table516 = 16,
	    table5 = 17,
	    table8 = 18,
	    table9 = 19,
	    table10 = 20,
	    standard = 21,
	    none = 22
	}
	export interface ExcelReports$EnumInterface {
	    report1: 1;
	    report2: 2;
	    report3: 3;
	    report4: 4;
	    report5: 5;
	    report6: 6;
	    report7: 7;
	    report8: 8;
	    report9: 9;
	    report10: 10;
	    table1: 11;
	    table2: 12;
	    table3: 13;
	    table4: 14;
	    table515: 15;
	    table516: 16;
	    table5: 17;
	    table8: 18;
	    table9: 19;
	    table10: 20;
	    standard: 21;
	    none: 22;
	}
	export type ExcelReports = keyof ExcelReports$EnumInterface;
	export const excelReportsDatatype: X3EnumDataType<keyof ExcelReports$EnumInterface, unknown>;
	//# sourceMappingURL=excel-reports.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/excel-export-7839.d.ts
declare module '@sage/x3-system/lib/enums/excel-export-7839' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExcelExport7839Enum {
	    saveOnTheClientWorkstation = 1,
	    exportInCsvFormat = 2,
	    exportToExcel = 3
	}
	export interface ExcelExport7839$EnumInterface {
	    saveOnTheClientWorkstation: 1;
	    exportInCsvFormat: 2;
	    exportToExcel: 3;
	}
	export type ExcelExport7839 = keyof ExcelExport7839$EnumInterface;
	export const excelExport7839Datatype: X3EnumDataType<keyof ExcelExport7839$EnumInterface, unknown>;
	//# sourceMappingURL=excel-export-7839.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/events.d.ts
declare module '@sage/x3-system/lib/enums/events' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EventsEnum {
	    connection = 1,
	    function = 2,
	    others = 3
	}
	export interface Events$EnumInterface {
	    connection: 1;
	    function: 2;
	    others: 3;
	}
	export type Events = keyof Events$EnumInterface;
	export const eventsDatatype: X3EnumDataType<keyof Events$EnumInterface, unknown>;
	//# sourceMappingURL=events.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/event-type.d.ts
declare module '@sage/x3-system/lib/enums/event-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EventTypeEnum {
	    miscellaneous = 1,
	    object = 2,
	    functionStart = 3,
	    report = 4,
	    endOfTask = 5,
	    taskCancellation = 6,
	    timeManagement = 7,
	    importExport = 8,
	    signature = 9,
	    manual = 10
	}
	export interface EventType$EnumInterface {
	    miscellaneous: 1;
	    object: 2;
	    functionStart: 3;
	    report: 4;
	    endOfTask: 5;
	    taskCancellation: 6;
	    timeManagement: 7;
	    importExport: 8;
	    signature: 9;
	    manual: 10;
	}
	export type EventType = keyof EventType$EnumInterface;
	export const eventTypeDatatype: X3EnumDataType<keyof EventType$EnumInterface, unknown>;
	//# sourceMappingURL=event-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/event-type-7887.d.ts
declare module '@sage/x3-system/lib/enums/event-type-7887' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EventType7887Enum {
	    computeValue = 1,
	    getValue = 2
	}
	export interface EventType7887$EnumInterface {
	    computeValue: 1;
	    getValue: 2;
	}
	export type EventType7887 = keyof EventType7887$EnumInterface;
	export const eventType7887Datatype: X3EnumDataType<keyof EventType7887$EnumInterface, unknown>;
	//# sourceMappingURL=event-type-7887.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/event-type-7814.d.ts
declare module '@sage/x3-system/lib/enums/event-type-7814' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EventType7814Enum {
	    object = 1,
	    functionEntry = 2,
	    report = 3,
	    taskEnd = 4
	}
	export interface EventType7814$EnumInterface {
	    object: 1;
	    functionEntry: 2;
	    report: 3;
	    taskEnd: 4;
	}
	export type EventType7814 = keyof EventType7814$EnumInterface;
	export const eventType7814Datatype: X3EnumDataType<keyof EventType7814$EnumInterface, unknown>;
	//# sourceMappingURL=event-type-7814.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/error-type.d.ts
declare module '@sage/x3-system/lib/enums/error-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ErrorTypeEnum {
	    textDoesNotExist = 1,
	    textWithoutItsTranslation = 2,
	    duplicates = 3,
	    translatedText = 4
	}
	export interface ErrorType$EnumInterface {
	    textDoesNotExist: 1;
	    textWithoutItsTranslation: 2;
	    duplicates: 3;
	    translatedText: 4;
	}
	export type ErrorType = keyof ErrorType$EnumInterface;
	export const errorTypeDatatype: X3EnumDataType<keyof ErrorType$EnumInterface, unknown>;
	//# sourceMappingURL=error-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/error-type-7878.d.ts
declare module '@sage/x3-system/lib/enums/error-type-7878' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ErrorType7878Enum {
	    info = 1,
	    warning = 2,
	    error = 3,
	    fatalError4 = 4,
	    fatalError = 5
	}
	export interface ErrorType7878$EnumInterface {
	    info: 1;
	    warning: 2;
	    error: 3;
	    fatalError4: 4;
	    fatalError: 5;
	}
	export type ErrorType7878 = keyof ErrorType7878$EnumInterface;
	export const errorType7878Datatype: X3EnumDataType<keyof ErrorType7878$EnumInterface, unknown>;
	//# sourceMappingURL=error-type-7878.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/entry-point-environment.d.ts
declare module '@sage/x3-system/lib/enums/entry-point-environment' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EntryPointEnvironmentEnum {
	    entryPoint = 1,
	    object = 2
	}
	export interface EntryPointEnvironment$EnumInterface {
	    entryPoint: 1;
	    object: 2;
	}
	export type EntryPointEnvironment = keyof EntryPointEnvironment$EnumInterface;
	export const entryPointEnvironmentDatatype: X3EnumDataType<keyof EntryPointEnvironment$EnumInterface, unknown>;
	//# sourceMappingURL=entry-point-environment.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/entry-mode.d.ts
declare module '@sage/x3-system/lib/enums/entry-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EntryModeEnum {
	    entered = 1,
	    displayed = 2,
	    hidden = 3
	}
	export interface EntryMode$EnumInterface {
	    entered: 1;
	    displayed: 2;
	    hidden: 3;
	}
	export type EntryMode = keyof EntryMode$EnumInterface;
	export const entryModeDatatype: X3EnumDataType<keyof EntryMode$EnumInterface, unknown>;
	//# sourceMappingURL=entry-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/entry-method.d.ts
declare module '@sage/x3-system/lib/enums/entry-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EntryMethodEnum {
	    enter = 1,
	    display = 2,
	    hidden = 3,
	    technical = 4
	}
	export interface EntryMethod$EnumInterface {
	    enter: 1;
	    display: 2;
	    hidden: 3;
	    technical: 4;
	}
	export type EntryMethod = keyof EntryMethod$EnumInterface;
	export const entryMethodDatatype: X3EnumDataType<keyof EntryMethod$EnumInterface, unknown>;
	//# sourceMappingURL=entry-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/entity-type-7913.d.ts
declare module '@sage/x3-system/lib/enums/entity-type-7913' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EntityType7913Enum {
	    action = 1,
	    session = 2,
	    dataAccess = 3
	}
	export interface EntityType7913$EnumInterface {
	    action: 1;
	    session: 2;
	    dataAccess: 3;
	}
	export type EntityType7913 = keyof EntityType7913$EnumInterface;
	export const entityType7913Datatype: X3EnumDataType<keyof EntityType7913$EnumInterface, unknown>;
	//# sourceMappingURL=entity-type-7913.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/email-address-type.d.ts
declare module '@sage/x3-system/lib/enums/email-address-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EmailAddressTypeEnum {
	    email = 1,
	    otherEmail2 = 2,
	    otherEmail3 = 3,
	    otherEmail4 = 4,
	    otherEmail5 = 5
	}
	export interface EmailAddressType$EnumInterface {
	    email: 1;
	    otherEmail2: 2;
	    otherEmail3: 3;
	    otherEmail4: 4;
	    otherEmail5: 5;
	}
	export type EmailAddressType = keyof EmailAddressType$EnumInterface;
	export const emailAddressTypeDatatype: X3EnumDataType<keyof EmailAddressType$EnumInterface, unknown>;
	//# sourceMappingURL=email-address-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/e-mail-type.d.ts
declare module '@sage/x3-system/lib/enums/e-mail-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EMailTypeEnum {
	    client = 1,
	    server = 2
	}
	export interface EMailType$EnumInterface {
	    client: 1;
	    server: 2;
	}
	export type EMailType = keyof EMailType$EnumInterface;
	export const eMailTypeDatatype: X3EnumDataType<keyof EMailType$EnumInterface, unknown>;
	//# sourceMappingURL=e-mail-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/e-mail-transmission.d.ts
declare module '@sage/x3-system/lib/enums/e-mail-transmission' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EMailTransmissionEnum {
	    no = 1,
	    yes = 2,
	    copy = 3
	}
	export interface EMailTransmission$EnumInterface {
	    no: 1;
	    yes: 2;
	    copy: 3;
	}
	export type EMailTransmission = keyof EMailTransmission$EnumInterface;
	export const eMailTransmissionDatatype: X3EnumDataType<keyof EMailTransmission$EnumInterface, unknown>;
	//# sourceMappingURL=e-mail-transmission.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/dynamic-cross-tables.d.ts
declare module '@sage/x3-system/lib/enums/dynamic-cross-tables' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DynamicCrossTablesEnum {
	    none = 1,
	    page = 2,
	    line = 3,
	    column = 4,
	    value = 5
	}
	export interface DynamicCrossTables$EnumInterface {
	    none: 1;
	    page: 2;
	    line: 3;
	    column: 4;
	    value: 5;
	}
	export type DynamicCrossTables = keyof DynamicCrossTables$EnumInterface;
	export const dynamicCrossTablesDatatype: X3EnumDataType<keyof DynamicCrossTables$EnumInterface, unknown>;
	//# sourceMappingURL=dynamic-cross-tables.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/download.d.ts
declare module '@sage/x3-system/lib/enums/download' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DownloadEnum {
	    notDownloaded = 1,
	    allClients = 2,
	    webServices = 3
	}
	export interface Download$EnumInterface {
	    notDownloaded: 1;
	    allClients: 2;
	    webServices: 3;
	}
	export type Download = keyof Download$EnumInterface;
	export const downloadDatatype: X3EnumDataType<keyof Download$EnumInterface, unknown>;
	//# sourceMappingURL=download.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/documentation-paragraphs.d.ts
declare module '@sage/x3-system/lib/enums/documentation-paragraphs' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DocumentationParagraphsEnum {
	    allParagraphs = 1,
	    onlyOneParagraph = 2
	}
	export interface DocumentationParagraphs$EnumInterface {
	    allParagraphs: 1;
	    onlyOneParagraph: 2;
	}
	export type DocumentationParagraphs = keyof DocumentationParagraphs$EnumInterface;
	export const documentationParagraphsDatatype: X3EnumDataType<keyof DocumentationParagraphs$EnumInterface, unknown>;
	//# sourceMappingURL=documentation-paragraphs.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/documentation-html-editor.d.ts
declare module '@sage/x3-system/lib/enums/documentation-html-editor' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DocumentationHtmlEditorEnum {
	    insertLine = 1,
	    deleteLine = 2,
	    insertColumn = 3,
	    deleteColumn = 4,
	    addColumn = 5,
	    paragraph = 6,
	    title4 = 7,
	    title5 = 8,
	    bold = 9,
	    italic = 10,
	    underline = 11,
	    leftAlignment = 12,
	    center = 13,
	    rightAlignment = 14,
	    list = 15,
	    rightShift = 16,
	    leftShift = 17,
	    createModifyAnHttpLink = 18,
	    insertAnImage = 19,
	    createAButton = 20,
	    createModifyATable = 21,
	    deleteUnauthorizedTags = 22,
	    viewModifyTheHtmlSource = 23,
	    colorTheSelectedText = 24,
	    defaultColor = 25,
	    changeTheFontOfTheSelectedText = 26,
	    normal = 27,
	    sourceCode = 28
	}
	export interface DocumentationHtmlEditor$EnumInterface {
	    insertLine: 1;
	    deleteLine: 2;
	    insertColumn: 3;
	    deleteColumn: 4;
	    addColumn: 5;
	    paragraph: 6;
	    title4: 7;
	    title5: 8;
	    bold: 9;
	    italic: 10;
	    underline: 11;
	    leftAlignment: 12;
	    center: 13;
	    rightAlignment: 14;
	    list: 15;
	    rightShift: 16;
	    leftShift: 17;
	    createModifyAnHttpLink: 18;
	    insertAnImage: 19;
	    createAButton: 20;
	    createModifyATable: 21;
	    deleteUnauthorizedTags: 22;
	    viewModifyTheHtmlSource: 23;
	    colorTheSelectedText: 24;
	    defaultColor: 25;
	    changeTheFontOfTheSelectedText: 26;
	    normal: 27;
	    sourceCode: 28;
	}
	export type DocumentationHtmlEditor = keyof DocumentationHtmlEditor$EnumInterface;
	export const documentationHtmlEditorDatatype: X3EnumDataType<keyof DocumentationHtmlEditor$EnumInterface, unknown>;
	//# sourceMappingURL=documentation-html-editor.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/documentation-extraction.d.ts
declare module '@sage/x3-system/lib/enums/documentation-extraction' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DocumentationExtractionEnum {
	    extractionByLanguage = 1,
	    extractionForTranslation = 2,
	    extractionForReTranslation = 3
	}
	export interface DocumentationExtraction$EnumInterface {
	    extractionByLanguage: 1;
	    extractionForTranslation: 2;
	    extractionForReTranslation: 3;
	}
	export type DocumentationExtraction = keyof DocumentationExtraction$EnumInterface;
	export const documentationExtractionDatatype: X3EnumDataType<keyof DocumentationExtraction$EnumInterface, unknown>;
	//# sourceMappingURL=documentation-extraction.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/documentation-deletion.d.ts
declare module '@sage/x3-system/lib/enums/documentation-deletion' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DocumentationDeletionEnum {
	    allParagraphs = 1,
	    onlyOneParagraphAllExistingLanguages = 2
	}
	export interface DocumentationDeletion$EnumInterface {
	    allParagraphs: 1;
	    onlyOneParagraphAllExistingLanguages: 2;
	}
	export type DocumentationDeletion = keyof DocumentationDeletion$EnumInterface;
	export const documentationDeletionDatatype: X3EnumDataType<keyof DocumentationDeletion$EnumInterface, unknown>;
	//# sourceMappingURL=documentation-deletion.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/documentation-contents.d.ts
declare module '@sage/x3-system/lib/enums/documentation-contents' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DocumentationContentsEnum {
	    implementation = 1,
	    functional = 2,
	    setup = 3,
	    development = 4,
	    data = 5,
	    userGuides = 6
	}
	export interface DocumentationContents$EnumInterface {
	    implementation: 1;
	    functional: 2;
	    setup: 3;
	    development: 4;
	    data: 5;
	    userGuides: 6;
	}
	export type DocumentationContents = keyof DocumentationContents$EnumInterface;
	export const documentationContentsDatatype: X3EnumDataType<keyof DocumentationContents$EnumInterface, unknown>;
	//# sourceMappingURL=documentation-contents.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/document-generation.d.ts
declare module '@sage/x3-system/lib/enums/document-generation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DocumentGenerationEnum {
	    no = 1,
	    all = 2,
	    existingDocumentations = 3
	}
	export interface DocumentGeneration$EnumInterface {
	    no: 1;
	    all: 2;
	    existingDocumentations: 3;
	}
	export type DocumentGeneration = keyof DocumentGeneration$EnumInterface;
	export const documentGenerationDatatype: X3EnumDataType<keyof DocumentGeneration$EnumInterface, unknown>;
	//# sourceMappingURL=document-generation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/display-options-wo-rec.d.ts
declare module '@sage/x3-system/lib/enums/display-options-wo-rec' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DisplayOptionsWORecEnum {
	    doNotDisplayAnything = 1,
	    htmlCodeWithoutToken = 2,
	    htmlCodeWithToken = 3
	}
	export interface DisplayOptionsWORec$EnumInterface {
	    doNotDisplayAnything: 1;
	    htmlCodeWithoutToken: 2;
	    htmlCodeWithToken: 3;
	}
	export type DisplayOptionsWORec = keyof DisplayOptionsWORec$EnumInterface;
	export const displayOptionsWoRecDatatype: X3EnumDataType<keyof DisplayOptionsWORec$EnumInterface, unknown>;
	//# sourceMappingURL=display-options-wo-rec.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/diskette-type.d.ts
declare module '@sage/x3-system/lib/enums/diskette-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DisketteTypeEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2
	}
	export interface DisketteType$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	}
	export type DisketteType = keyof DisketteType$EnumInterface;
	export const disketteTypeDatatype: X3EnumDataType<keyof DisketteType$EnumInterface, unknown>;
	//# sourceMappingURL=diskette-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/directory-location.d.ts
declare module '@sage/x3-system/lib/enums/directory-location' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DirectoryLocationEnum {
	    x3Server = 1,
	    webX3Server = 2
	}
	export interface DirectoryLocation$EnumInterface {
	    x3Server: 1;
	    webX3Server: 2;
	}
	export type DirectoryLocation = keyof DirectoryLocation$EnumInterface;
	export const directoryLocationDatatype: X3EnumDataType<keyof DirectoryLocation$EnumInterface, unknown>;
	//# sourceMappingURL=directory-location.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/dimension-type-enum.d.ts
declare module '@sage/x3-system/lib/enums/dimension-type-enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DimensionTypeEnumEnum {
	    date = 1,
	    localMenu = 2,
	    miscellaneousTable = 3,
	    others = 4
	}
	export interface DimensionTypeEnum$EnumInterface {
	    date: 1;
	    localMenu: 2;
	    miscellaneousTable: 3;
	    others: 4;
	}
	export type DimensionTypeEnum = keyof DimensionTypeEnum$EnumInterface;
	export const dimensionTypeEnumDatatype: X3EnumDataType<keyof DimensionTypeEnum$EnumInterface, unknown>;
	//# sourceMappingURL=dimension-type-enum.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/development-level.d.ts
declare module '@sage/x3-system/lib/enums/development-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DevelopmentLevelEnum {
	    standard = 1,
	    addOn = 2,
	    vertical = 3,
	    specific = 4
	}
	export interface DevelopmentLevel$EnumInterface {
	    standard: 1;
	    addOn: 2;
	    vertical: 3;
	    specific: 4;
	}
	export type DevelopmentLevel = keyof DevelopmentLevel$EnumInterface;
	export const developmentLevelDatatype: X3EnumDataType<keyof DevelopmentLevel$EnumInterface, unknown>;
	//# sourceMappingURL=development-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/destination-types.d.ts
declare module '@sage/x3-system/lib/enums/destination-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DestinationTypesEnum {
	    preview = 1,
	    printer = 2,
	    message = 3,
	    file = 4,
	    printerFile = 5,
	    zplPrinter = 6,
	    archiving = 7
	}
	export interface DestinationTypes$EnumInterface {
	    preview: 1;
	    printer: 2;
	    message: 3;
	    file: 4;
	    printerFile: 5;
	    zplPrinter: 6;
	    archiving: 7;
	}
	export type DestinationTypes = keyof DestinationTypes$EnumInterface;
	export const destinationTypesDatatype: X3EnumDataType<keyof DestinationTypes$EnumInterface, unknown>;
	//# sourceMappingURL=destination-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/destination-level.d.ts
declare module '@sage/x3-system/lib/enums/destination-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DestinationLevelEnum {
	    range = 1,
	    template = 2,
	    list = 3
	}
	export interface DestinationLevel$EnumInterface {
	    range: 1;
	    template: 2;
	    list: 3;
	}
	export type DestinationLevel = keyof DestinationLevel$EnumInterface;
	export const destinationLevelDatatype: X3EnumDataType<keyof DestinationLevel$EnumInterface, unknown>;
	//# sourceMappingURL=destination-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/density.d.ts
declare module '@sage/x3-system/lib/enums/density' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DensityEnum {
	    high = 1,
	    low = 2
	}
	export interface Density$EnumInterface {
	    high: 1;
	    low: 2;
	}
	export type Density = keyof Density$EnumInterface;
	export const densityDatatype: X3EnumDataType<keyof Density$EnumInterface, unknown>;
	//# sourceMappingURL=density.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/delivery-type.d.ts
declare module '@sage/x3-system/lib/enums/delivery-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DeliveryTypeEnum {
	    notDelivered = 1,
	    deliveredEmpty = 2,
	    deliveredWithIndusData = 3,
	    commonData = 4,
	    dataByCountry = 5
	}
	export interface DeliveryType$EnumInterface {
	    notDelivered: 1;
	    deliveredEmpty: 2;
	    deliveredWithIndusData: 3;
	    commonData: 4;
	    dataByCountry: 5;
	}
	export type DeliveryType = keyof DeliveryType$EnumInterface;
	export const deliveryTypeDatatype: X3EnumDataType<keyof DeliveryType$EnumInterface, unknown>;
	//# sourceMappingURL=delivery-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/deletion-type.d.ts
declare module '@sage/x3-system/lib/enums/deletion-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DeletionTypeEnum {
	    function = 1,
	    functionProfile = 2,
	    module = 3
	}
	export interface DeletionType$EnumInterface {
	    function: 1;
	    functionProfile: 2;
	    module: 3;
	}
	export type DeletionType = keyof DeletionType$EnumInterface;
	export const deletionTypeDatatype: X3EnumDataType<keyof DeletionType$EnumInterface, unknown>;
	//# sourceMappingURL=deletion-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/delegation-type.d.ts
declare module '@sage/x3-system/lib/enums/delegation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DelegationTypeEnum {
	    copyForInformation = 1,
	    withAuthority = 2,
	    exceptional = 3
	}
	export interface DelegationType$EnumInterface {
	    copyForInformation: 1;
	    withAuthority: 2;
	    exceptional: 3;
	}
	export type DelegationType = keyof DelegationType$EnumInterface;
	export const delegationTypeDatatype: X3EnumDataType<keyof DelegationType$EnumInterface, unknown>;
	//# sourceMappingURL=delegation-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/delegate-options.d.ts
declare module '@sage/x3-system/lib/enums/delegate-options' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DelegateOptionsEnum {
	    no = 1,
	    all = 2,
	    cascade = 3,
	    firstAvailable = 4
	}
	export interface DelegateOptions$EnumInterface {
	    no: 1;
	    all: 2;
	    cascade: 3;
	    firstAvailable: 4;
	}
	export type DelegateOptions = keyof DelegateOptions$EnumInterface;
	export const delegateOptionsDatatype: X3EnumDataType<keyof DelegateOptions$EnumInterface, unknown>;
	//# sourceMappingURL=delegate-options.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/definition-level.d.ts
declare module '@sage/x3-system/lib/enums/definition-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DefinitionLevelEnum {
	    folder = 1,
	    company = 2,
	    site = 3
	}
	export interface DefinitionLevel$EnumInterface {
	    folder: 1;
	    company: 2;
	    site: 3;
	}
	export type DefinitionLevel = keyof DefinitionLevel$EnumInterface;
	export const definitionLevelDatatype: X3EnumDataType<keyof DefinitionLevel$EnumInterface, unknown>;
	//# sourceMappingURL=definition-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/definition-level-7809.d.ts
declare module '@sage/x3-system/lib/enums/definition-level-7809' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DefinitionLevel7809Enum {
	    company = 1,
	    site = 2,
	    user = 3,
	    legislation = 4
	}
	export interface DefinitionLevel7809$EnumInterface {
	    company: 1;
	    site: 2;
	    user: 3;
	    legislation: 4;
	}
	export type DefinitionLevel7809 = keyof DefinitionLevel7809$EnumInterface;
	export const definitionLevel7809Datatype: X3EnumDataType<keyof DefinitionLevel7809$EnumInterface, unknown>;
	//# sourceMappingURL=definition-level-7809.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/default-graph.d.ts
declare module '@sage/x3-system/lib/enums/default-graph' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DefaultGraphEnum {
	    bars = 1,
	    lines = 2,
	    areas = 3,
	    sectors = 4
	}
	export interface DefaultGraph$EnumInterface {
	    bars: 1;
	    lines: 2;
	    areas: 3;
	    sectors: 4;
	}
	export type DefaultGraph = keyof DefaultGraph$EnumInterface;
	export const defaultGraphDatatype: X3EnumDataType<keyof DefaultGraph$EnumInterface, unknown>;
	//# sourceMappingURL=default-graph.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/default-display.d.ts
declare module '@sage/x3-system/lib/enums/default-display' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DefaultDisplayEnum {
	    table = 1,
	    graph = 2
	}
	export interface DefaultDisplay$EnumInterface {
	    table: 1;
	    graph: 2;
	}
	export type DefaultDisplay = keyof DefaultDisplay$EnumInterface;
	export const defaultDisplayDatatype: X3EnumDataType<keyof DefaultDisplay$EnumInterface, unknown>;
	//# sourceMappingURL=default-display.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/days-of-the-week.d.ts
declare module '@sage/x3-system/lib/enums/days-of-the-week' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DaysOfTheWeekEnum {
	    monday = 1,
	    tuesday = 2,
	    wednesday = 3,
	    thursday = 4,
	    friday = 5,
	    saturday = 6,
	    sunday = 7
	}
	export interface DaysOfTheWeek$EnumInterface {
	    monday: 1;
	    tuesday: 2;
	    wednesday: 3;
	    thursday: 4;
	    friday: 5;
	    saturday: 6;
	    sunday: 7;
	}
	export type DaysOfTheWeek = keyof DaysOfTheWeek$EnumInterface;
	export const daysOfTheWeekDatatype: X3EnumDataType<keyof DaysOfTheWeek$EnumInterface, unknown>;
	//# sourceMappingURL=days-of-the-week.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/dates-for-status-generator.d.ts
declare module '@sage/x3-system/lib/enums/dates-for-status-generator' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DatesForStatusGeneratorEnum {
	    dzMmDdYy = 1,
	    dzMmDdYyyy = 2,
	    dzMmmDdYyyy = 3,
	    dZMmmmmmmmmDdYyyy = 4,
	    dzMmDd = 5,
	    dzMmYy = 6,
	    dzMmYyyy = 7
	}
	export interface DatesForStatusGenerator$EnumInterface {
	    dzMmDdYy: 1;
	    dzMmDdYyyy: 2;
	    dzMmmDdYyyy: 3;
	    dZMmmmmmmmmDdYyyy: 4;
	    dzMmDd: 5;
	    dzMmYy: 6;
	    dzMmYyyy: 7;
	}
	export type DatesForStatusGenerator = keyof DatesForStatusGenerator$EnumInterface;
	export const datesForStatusGeneratorDatatype: X3EnumDataType<keyof DatesForStatusGenerator$EnumInterface, unknown>;
	//# sourceMappingURL=dates-for-status-generator.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/database-status.d.ts
declare module '@sage/x3-system/lib/enums/database-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DatabaseStatusEnum {
	    normal = 1,
	    extensionDictionary = 2,
	    dictionary = 3,
	    aESystem = 4,
	    other = 5
	}
	export interface DatabaseStatus$EnumInterface {
	    normal: 1;
	    extensionDictionary: 2;
	    dictionary: 3;
	    aESystem: 4;
	    other: 5;
	}
	export type DatabaseStatus = keyof DatabaseStatus$EnumInterface;
	export const databaseStatusDatatype: X3EnumDataType<keyof DatabaseStatus$EnumInterface, unknown>;
	//# sourceMappingURL=database-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/data-types.d.ts
declare module '@sage/x3-system/lib/enums/data-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DataTypesEnum {
	    localMenu = 1,
	    shortInteger = 2,
	    longInteger = 3,
	    decimal = 4,
	    floating = 5,
	    double = 6,
	    alphanumeric = 7,
	    date = 8,
	    imageFile = 9,
	    textFile = 10,
	    uuid = 11,
	    datetime = 12
	}
	export interface DataTypes$EnumInterface {
	    localMenu: 1;
	    shortInteger: 2;
	    longInteger: 3;
	    decimal: 4;
	    floating: 5;
	    double: 6;
	    alphanumeric: 7;
	    date: 8;
	    imageFile: 9;
	    textFile: 10;
	    uuid: 11;
	    datetime: 12;
	}
	export type DataTypes = keyof DataTypes$EnumInterface;
	export const dataTypesDatatype: X3EnumDataType<keyof DataTypes$EnumInterface, unknown>;
	//# sourceMappingURL=data-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/data-types-9028.d.ts
declare module '@sage/x3-system/lib/enums/data-types-9028' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DataTypes9028Enum {
	    descriptions = 1,
	    shortInteger = 2,
	    longInteger = 3,
	    decimalDcb = 4,
	    floatingNumber = 5,
	    doublePrecision = 6,
	    alphanumeric = 7,
	    date = 8
	}
	export interface DataTypes9028$EnumInterface {
	    descriptions: 1;
	    shortInteger: 2;
	    longInteger: 3;
	    decimalDcb: 4;
	    floatingNumber: 5;
	    doublePrecision: 6;
	    alphanumeric: 7;
	    date: 8;
	}
	export type DataTypes9028 = keyof DataTypes9028$EnumInterface;
	export const dataTypes9028Datatype: X3EnumDataType<keyof DataTypes9028$EnumInterface, unknown>;
	//# sourceMappingURL=data-types-9028.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/data-types-7947.d.ts
declare module '@sage/x3-system/lib/enums/data-types-7947' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DataTypes7947Enum {
	    reference = 1,
	    eMail = 2,
	    phone = 3
	}
	export interface DataTypes7947$EnumInterface {
	    reference: 1;
	    eMail: 2;
	    phone: 3;
	}
	export type DataTypes7947 = keyof DataTypes7947$EnumInterface;
	export const dataTypes7947Datatype: X3EnumDataType<keyof DataTypes7947$EnumInterface, unknown>;
	//# sourceMappingURL=data-types-7947.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/data-type-7843.d.ts
declare module '@sage/x3-system/lib/enums/data-type-7843' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DataType7843Enum {
	    date = 1,
	    char = 2,
	    integer = 3,
	    decimal = 4,
	    textFile = 5,
	    imageFile = 6
	}
	export interface DataType7843$EnumInterface {
	    date: 1;
	    char: 2;
	    integer: 3;
	    decimal: 4;
	    textFile: 5;
	    imageFile: 6;
	}
	export type DataType7843 = keyof DataType7843$EnumInterface;
	export const dataType7843Datatype: X3EnumDataType<keyof DataType7843$EnumInterface, unknown>;
	//# sourceMappingURL=data-type-7843.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/data-filter.d.ts
declare module '@sage/x3-system/lib/enums/data-filter' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DataFilterEnum {
	    filtered = 1,
	    none = 2
	}
	export interface DataFilter$EnumInterface {
	    filtered: 1;
	    none: 2;
	}
	export type DataFilter = keyof DataFilter$EnumInterface;
	export const dataFilterDatatype: X3EnumDataType<keyof DataFilter$EnumInterface, unknown>;
	//# sourceMappingURL=data-filter.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/data-file-type.d.ts
declare module '@sage/x3-system/lib/enums/data-file-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DataFileTypeEnum {
	    ascii1 = 1,
	    ascii2 = 2,
	    delimited = 3,
	    fixedLength = 4,
	    xml = 5,
	    flat = 6,
	    withHeader = 7,
	    jsonApi = 8
	}
	export interface DataFileType$EnumInterface {
	    ascii1: 1;
	    ascii2: 2;
	    delimited: 3;
	    fixedLength: 4;
	    xml: 5;
	    flat: 6;
	    withHeader: 7;
	    jsonApi: 8;
	}
	export type DataFileType = keyof DataFileType$EnumInterface;
	export const dataFileTypeDatatype: X3EnumDataType<keyof DataFileType$EnumInterface, unknown>;
	//# sourceMappingURL=data-file-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/dashboard-type-to-recover.d.ts
declare module '@sage/x3-system/lib/enums/dashboard-type-to-recover' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DashboardTypeToRecoverEnum {
	    professionCode = 1,
	    user = 2
	}
	export interface DashboardTypeToRecover$EnumInterface {
	    professionCode: 1;
	    user: 2;
	}
	export type DashboardTypeToRecover = keyof DashboardTypeToRecover$EnumInterface;
	export const dashboardTypeToRecoverDatatype: X3EnumDataType<keyof DashboardTypeToRecover$EnumInterface, unknown>;
	//# sourceMappingURL=dashboard-type-to-recover.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/dashboard-parameter-type.d.ts
declare module '@sage/x3-system/lib/enums/dashboard-parameter-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DashboardParameterTypeEnum {
	    dataSource = 1,
	    visualComponent = 2
	}
	export interface DashboardParameterType$EnumInterface {
	    dataSource: 1;
	    visualComponent: 2;
	}
	export type DashboardParameterType = keyof DashboardParameterType$EnumInterface;
	export const dashboardParameterTypeDatatype: X3EnumDataType<keyof DashboardParameterType$EnumInterface, unknown>;
	//# sourceMappingURL=dashboard-parameter-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/dashboard-framework.d.ts
declare module '@sage/x3-system/lib/enums/dashboard-framework' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DashboardFrameworkEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4,
	    substituteValue5 = 5,
	    substituteValue6 = 6,
	    substituteValue7 = 7,
	    substituteValue8 = 8
	}
	export interface DashboardFramework$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	    substituteValue5: 5;
	    substituteValue6: 6;
	    substituteValue7: 7;
	    substituteValue8: 8;
	}
	export type DashboardFramework = keyof DashboardFramework$EnumInterface;
	export const dashboardFrameworkDatatype: X3EnumDataType<keyof DashboardFramework$EnumInterface, unknown>;
	//# sourceMappingURL=dashboard-framework.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/customization-version.d.ts
declare module '@sage/x3-system/lib/enums/customization-version' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CustomizationVersionEnum {
	    version1 = 1,
	    version2 = 2,
	    version3 = 3
	}
	export interface CustomizationVersion$EnumInterface {
	    version1: 1;
	    version2: 2;
	    version3: 3;
	}
	export type CustomizationVersion = keyof CustomizationVersion$EnumInterface;
	export const customizationVersionDatatype: X3EnumDataType<keyof CustomizationVersion$EnumInterface, unknown>;
	//# sourceMappingURL=customization-version.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/creation-assistance.d.ts
declare module '@sage/x3-system/lib/enums/creation-assistance' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CreationAssistanceEnum {
	    none = 1,
	    all = 2,
	    one = 3
	}
	export interface CreationAssistance$EnumInterface {
	    none: 1;
	    all: 2;
	    one: 3;
	}
	export type CreationAssistance = keyof CreationAssistance$EnumInterface;
	export const creationAssistanceDatatype: X3EnumDataType<keyof CreationAssistance$EnumInterface, unknown>;
	//# sourceMappingURL=creation-assistance.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/copy-type.d.ts
declare module '@sage/x3-system/lib/enums/copy-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CopyTypeEnum {
	    noCopy = 1,
	    automaticCopy = 2,
	    conditionalCopy = 3
	}
	export interface CopyType$EnumInterface {
	    noCopy: 1;
	    automaticCopy: 2;
	    conditionalCopy: 3;
	}
	export type CopyType = keyof CopyType$EnumInterface;
	export const copyTypeDatatype: X3EnumDataType<keyof CopyType$EnumInterface, unknown>;
	//# sourceMappingURL=copy-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/copy-type-7950.d.ts
declare module '@sage/x3-system/lib/enums/copy-type-7950' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CopyType7950Enum {
	    copy = 1,
	    patch = 2
	}
	export interface CopyType7950$EnumInterface {
	    copy: 1;
	    patch: 2;
	}
	export type CopyType7950 = keyof CopyType7950$EnumInterface;
	export const copyType7950Datatype: X3EnumDataType<keyof CopyType7950$EnumInterface, unknown>;
	//# sourceMappingURL=copy-type-7950.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/copy-type-7816.d.ts
declare module '@sage/x3-system/lib/enums/copy-type-7816' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CopyType7816Enum {
	    automaticCopy = 1,
	    conditionalCopy = 2
	}
	export interface CopyType7816$EnumInterface {
	    automaticCopy: 1;
	    conditionalCopy: 2;
	}
	export type CopyType7816 = keyof CopyType7816$EnumInterface;
	export const copyType7816Datatype: X3EnumDataType<keyof CopyType7816$EnumInterface, unknown>;
	//# sourceMappingURL=copy-type-7816.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/copy-options.d.ts
declare module '@sage/x3-system/lib/enums/copy-options' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CopyOptionsEnum {
	    creationOrUpdate = 1,
	    cancelsAndReplaces = 2
	}
	export interface CopyOptions$EnumInterface {
	    creationOrUpdate: 1;
	    cancelsAndReplaces: 2;
	}
	export type CopyOptions = keyof CopyOptions$EnumInterface;
	export const copyOptionsDatatype: X3EnumDataType<keyof CopyOptions$EnumInterface, unknown>;
	//# sourceMappingURL=copy-options.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/copy-option.d.ts
declare module '@sage/x3-system/lib/enums/copy-option' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CopyOptionEnum {
	    usersAndProfiles = 1,
	    miscellaneousTables = 2,
	    sequenceNumbers = 3,
	    parameters = 4,
	    controlTables = 5,
	    companiesSites = 6,
	    statistics = 7,
	    importExport = 8,
	    generalChartOfAccounts = 9,
	    analyticalChartOfAccounts = 10,
	    accountingTransactions = 11,
	    budgetParameters = 12,
	    bpReferenceSystem = 13,
	    banks = 14,
	    fixedAssetParameters = 15,
	    fixedAssetData = 16,
	    financialDataExtraction = 17,
	    payrollPlan = 18,
	    timeParameters = 19,
	    expenses = 20
	}
	export interface CopyOption$EnumInterface {
	    usersAndProfiles: 1;
	    miscellaneousTables: 2;
	    sequenceNumbers: 3;
	    parameters: 4;
	    controlTables: 5;
	    companiesSites: 6;
	    statistics: 7;
	    importExport: 8;
	    generalChartOfAccounts: 9;
	    analyticalChartOfAccounts: 10;
	    accountingTransactions: 11;
	    budgetParameters: 12;
	    bpReferenceSystem: 13;
	    banks: 14;
	    fixedAssetParameters: 15;
	    fixedAssetData: 16;
	    financialDataExtraction: 17;
	    payrollPlan: 18;
	    timeParameters: 19;
	    expenses: 20;
	}
	export type CopyOption = keyof CopyOption$EnumInterface;
	export const copyOptionDatatype: X3EnumDataType<keyof CopyOption$EnumInterface, unknown>;
	//# sourceMappingURL=copy-option.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/conversion-sense.d.ts
declare module '@sage/x3-system/lib/enums/conversion-sense' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConversionSenseEnum {
	    asciiUtf8 = 1,
	    asciiUcs2 = 2,
	    utf8Ascii = 3,
	    utf8Ucs2 = 4,
	    ucs2Ascii = 5,
	    ucs2Utf8 = 6
	}
	export interface ConversionSense$EnumInterface {
	    asciiUtf8: 1;
	    asciiUcs2: 2;
	    utf8Ascii: 3;
	    utf8Ucs2: 4;
	    ucs2Ascii: 5;
	    ucs2Utf8: 6;
	}
	export type ConversionSense = keyof ConversionSense$EnumInterface;
	export const conversionSenseDatatype: X3EnumDataType<keyof ConversionSense$EnumInterface, unknown>;
	//# sourceMappingURL=conversion-sense.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/control-type.d.ts
declare module '@sage/x3-system/lib/enums/control-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ControlTypeEnum {
	    mandatoryValues = 1,
	    prohibitedValues = 2,
	    rangeOfValues = 3,
	    tableReference = 4,
	    expression = 5,
	    other = 6
	}
	export interface ControlType$EnumInterface {
	    mandatoryValues: 1;
	    prohibitedValues: 2;
	    rangeOfValues: 3;
	    tableReference: 4;
	    expression: 5;
	    other: 6;
	}
	export type ControlType = keyof ControlType$EnumInterface;
	export const controlTypeDatatype: X3EnumDataType<keyof ControlType$EnumInterface, unknown>;
	//# sourceMappingURL=control-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/containment-type.d.ts
declare module '@sage/x3-system/lib/enums/containment-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ContainmentTypeEnum {
	    none = 1,
	    partial = 2,
	    fullElasticPool = 3
	}
	export interface ContainmentType$EnumInterface {
	    none: 1;
	    partial: 2;
	    fullElasticPool: 3;
	}
	export type ContainmentType = keyof ContainmentType$EnumInterface;
	export const containmentTypeDatatype: X3EnumDataType<keyof ContainmentType$EnumInterface, unknown>;
	//# sourceMappingURL=containment-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/contact-type.d.ts
declare module '@sage/x3-system/lib/enums/contact-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ContactTypeEnum {
	    standard = 1,
	    lead = 2
	}
	export interface ContactType$EnumInterface {
	    standard: 1;
	    lead: 2;
	}
	export type ContactType = keyof ContactType$EnumInterface;
	export const contactTypeDatatype: X3EnumDataType<keyof ContactType$EnumInterface, unknown>;
	//# sourceMappingURL=contact-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/connection-failure-reason.d.ts
declare module '@sage/x3-system/lib/enums/connection-failure-reason' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConnectionFailureReasonEnum {
	    incorrectUser = 1,
	    tooManySessions = 2,
	    numberOfAttemptsExceeded = 3,
	    incorrectPassword = 4,
	    noStartMenu = 5,
	    tooManyUsers = 6,
	    singleModeFolder = 7,
	    menuDoesNotExist = 8,
	    refusalByEntryPoint = 9,
	    incorrectLanguage = 10,
	    programError = 11,
	    passwordChangeRefusal = 12
	}
	export interface ConnectionFailureReason$EnumInterface {
	    incorrectUser: 1;
	    tooManySessions: 2;
	    numberOfAttemptsExceeded: 3;
	    incorrectPassword: 4;
	    noStartMenu: 5;
	    tooManyUsers: 6;
	    singleModeFolder: 7;
	    menuDoesNotExist: 8;
	    refusalByEntryPoint: 9;
	    incorrectLanguage: 10;
	    programError: 11;
	    passwordChangeRefusal: 12;
	}
	export type ConnectionFailureReason = keyof ConnectionFailureReason$EnumInterface;
	export const connectionFailureReasonDatatype: X3EnumDataType<keyof ConnectionFailureReason$EnumInterface, unknown>;
	//# sourceMappingURL=connection-failure-reason.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/conditioned-block-page-crit.d.ts
declare module '@sage/x3-system/lib/enums/conditioned-block-page-crit' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConditionedBlockPageCritEnum {
	    firstPage = 1,
	    lastPage = 2,
	    otherPages = 3
	}
	export interface ConditionedBlockPageCrit$EnumInterface {
	    firstPage: 1;
	    lastPage: 2;
	    otherPages: 3;
	}
	export type ConditionedBlockPageCrit = keyof ConditionedBlockPageCrit$EnumInterface;
	export const conditionedBlockPageCritDatatype: X3EnumDataType<keyof ConditionedBlockPageCrit$EnumInterface, unknown>;
	//# sourceMappingURL=conditioned-block-page-crit.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/conditioned-block-criteria.d.ts
declare module '@sage/x3-system/lib/enums/conditioned-block-criteria' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConditionedBlockCriteriaEnum {
	    formula = 1,
	    emptyBlock = 2,
	    pagingOfABlock = 3,
	    lastDynamicLinkUsed = 4,
	    previousPage = 5,
	    userLoggedIn = 6,
	    profile = 7,
	    emptyGadget = 8,
	    selectedLine = 9,
	    currentPage = 10
	}
	export interface ConditionedBlockCriteria$EnumInterface {
	    formula: 1;
	    emptyBlock: 2;
	    pagingOfABlock: 3;
	    lastDynamicLinkUsed: 4;
	    previousPage: 5;
	    userLoggedIn: 6;
	    profile: 7;
	    emptyGadget: 8;
	    selectedLine: 9;
	    currentPage: 10;
	}
	export type ConditionedBlockCriteria = keyof ConditionedBlockCriteria$EnumInterface;
	export const conditionedBlockCriteriaDatatype: X3EnumDataType<keyof ConditionedBlockCriteria$EnumInterface, unknown>;
	//# sourceMappingURL=conditioned-block-criteria.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/conditioned-block-action.d.ts
declare module '@sage/x3-system/lib/enums/conditioned-block-action' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConditionedBlockActionEnum {
	    hideBlock = 1,
	    dispalyBlock = 2
	}
	export interface ConditionedBlockAction$EnumInterface {
	    hideBlock: 1;
	    dispalyBlock: 2;
	}
	export type ConditionedBlockAction = keyof ConditionedBlockAction$EnumInterface;
	export const conditionedBlockActionDatatype: X3EnumDataType<keyof ConditionedBlockAction$EnumInterface, unknown>;
	//# sourceMappingURL=conditioned-block-action.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/color-alternative.d.ts
declare module '@sage/x3-system/lib/enums/color-alternative' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ColorAlternativeEnum {
	    none = 1,
	    every2Lines = 2,
	    every3Lines = 3
	}
	export interface ColorAlternative$EnumInterface {
	    none: 1;
	    every2Lines: 2;
	    every3Lines: 3;
	}
	export type ColorAlternative = keyof ColorAlternative$EnumInterface;
	export const colorAlternativeDatatype: X3EnumDataType<keyof ColorAlternative$EnumInterface, unknown>;
	//# sourceMappingURL=color-alternative.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/collection-type.d.ts
declare module '@sage/x3-system/lib/enums/collection-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CollectionTypeEnum {
	    instances = 1,
	    variables = 2
	}
	export interface CollectionType$EnumInterface {
	    instances: 1;
	    variables: 2;
	}
	export type CollectionType = keyof CollectionType$EnumInterface;
	export const collectionTypeDatatype: X3EnumDataType<keyof CollectionType$EnumInterface, unknown>;
	//# sourceMappingURL=collection-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/coding-of-the-base.d.ts
declare module '@sage/x3-system/lib/enums/coding-of-the-base' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CodingOfTheBaseEnum {
	    ascii = 1,
	    unicode = 2
	}
	export interface CodingOfTheBase$EnumInterface {
	    ascii: 1;
	    unicode: 2;
	}
	export type CodingOfTheBase = keyof CodingOfTheBase$EnumInterface;
	export const codingOfTheBaseDatatype: X3EnumDataType<keyof CodingOfTheBase$EnumInterface, unknown>;
	//# sourceMappingURL=coding-of-the-base.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/coding-mode.d.ts
declare module '@sage/x3-system/lib/enums/coding-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CodingModeEnum {
	    decimal = 1,
	    octal = 2,
	    hexadecimal = 3
	}
	export interface CodingMode$EnumInterface {
	    decimal: 1;
	    octal: 2;
	    hexadecimal: 3;
	}
	export type CodingMode = keyof CodingMode$EnumInterface;
	export const codingModeDatatype: X3EnumDataType<keyof CodingMode$EnumInterface, unknown>;
	//# sourceMappingURL=coding-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/code-types.d.ts
declare module '@sage/x3-system/lib/enums/code-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CodeTypesEnum {
	    reports = 1,
	    reportParameters = 2
	}
	export interface CodeTypes$EnumInterface {
	    reports: 1;
	    reportParameters: 2;
	}
	export type CodeTypes = keyof CodeTypes$EnumInterface;
	export const codeTypesDatatype: X3EnumDataType<keyof CodeTypes$EnumInterface, unknown>;
	//# sourceMappingURL=code-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/class-type.d.ts
declare module '@sage/x3-system/lib/enums/class-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ClassTypeEnum {
	    basic = 1,
	    persistent = 2,
	    technical = 3,
	    system = 4,
	    interface = 5
	}
	export interface ClassType$EnumInterface {
	    basic: 1;
	    persistent: 2;
	    technical: 3;
	    system: 4;
	    interface: 5;
	}
	export type ClassType = keyof ClassType$EnumInterface;
	export const classTypeDatatype: X3EnumDataType<keyof ClassType$EnumInterface, unknown>;
	//# sourceMappingURL=class-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/character-format.d.ts
declare module '@sage/x3-system/lib/enums/character-format' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CharacterFormatEnum {
	    iso8859 = 1,
	    ibmPc = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4,
	    macIntosh = 5,
	    hpRoman8 = 6
	}
	export interface CharacterFormat$EnumInterface {
	    iso8859: 1;
	    ibmPc: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	    macIntosh: 5;
	    hpRoman8: 6;
	}
	export type CharacterFormat = keyof CharacterFormat$EnumInterface;
	export const characterFormatDatatype: X3EnumDataType<keyof CharacterFormat$EnumInterface, unknown>;
	//# sourceMappingURL=character-format.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/character-coding.d.ts
declare module '@sage/x3-system/lib/enums/character-coding' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CharacterCodingEnum {
	    ascii = 1,
	    utf8 = 2,
	    ucs2 = 3
	}
	export interface CharacterCoding$EnumInterface {
	    ascii: 1;
	    utf8: 2;
	    ucs2: 3;
	}
	export type CharacterCoding = keyof CharacterCoding$EnumInterface;
	export const characterCodingDatatype: X3EnumDataType<keyof CharacterCoding$EnumInterface, unknown>;
	//# sourceMappingURL=character-coding.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/cancellation-code.d.ts
declare module '@sage/x3-system/lib/enums/cancellation-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CancellationCodeEnum {
	    block = 1,
	    delete = 2,
	    rtz = 3,
	    other = 4
	}
	export interface CancellationCode$EnumInterface {
	    block: 1;
	    delete: 2;
	    rtz: 3;
	    other: 4;
	}
	export type CancellationCode = keyof CancellationCode$EnumInterface;
	export const cancellationCodeDatatype: X3EnumDataType<keyof CancellationCode$EnumInterface, unknown>;
	//# sourceMappingURL=cancellation-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/button-type.d.ts
declare module '@sage/x3-system/lib/enums/button-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ButtonTypeEnum {
	    button = 1,
	    menu = 2,
	    line = 3
	}
	export interface ButtonType$EnumInterface {
	    button: 1;
	    menu: 2;
	    line: 3;
	}
	export type ButtonType = keyof ButtonType$EnumInterface;
	export const buttonTypeDatatype: X3EnumDataType<keyof ButtonType$EnumInterface, unknown>;
	//# sourceMappingURL=button-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/brackets.d.ts
declare module '@sage/x3-system/lib/enums/brackets' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BracketsEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4,
	    substituteValue5 = 5
	}
	export interface Brackets$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	    substituteValue5: 5;
	}
	export type Brackets = keyof Brackets$EnumInterface;
	export const bracketsDatatype: X3EnumDataType<keyof Brackets$EnumInterface, unknown>;
	//# sourceMappingURL=brackets.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/brackets-7932.d.ts
declare module '@sage/x3-system/lib/enums/brackets-7932' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Brackets7932Enum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4,
	    substituteValue5 = 5
	}
	export interface Brackets7932$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	    substituteValue5: 5;
	}
	export type Brackets7932 = keyof Brackets7932$EnumInterface;
	export const brackets7932Datatype: X3EnumDataType<keyof Brackets7932$EnumInterface, unknown>;
	//# sourceMappingURL=brackets-7932.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/bo-prompt-type.d.ts
declare module '@sage/x3-system/lib/enums/bo-prompt-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BoPromptTypeEnum {
	    simple = 1,
	    multiple = 2
	}
	export interface BoPromptType$EnumInterface {
	    simple: 1;
	    multiple: 2;
	}
	export type BoPromptType = keyof BoPromptType$EnumInterface;
	export const boPromptTypeDatatype: X3EnumDataType<keyof BoPromptType$EnumInterface, unknown>;
	//# sourceMappingURL=bo-prompt-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/block-type.d.ts
declare module '@sage/x3-system/lib/enums/block-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BlockTypeEnum {
	    table = 1,
	    list = 2,
	    photo = 3,
	    text = 4,
	    hidden = 5,
	    flash = 6,
	    office = 7,
	    browser = 8,
	    htmlEditor = 9,
	    technique = 10,
	    businessIntelligence = 11
	}
	export interface BlockType$EnumInterface {
	    table: 1;
	    list: 2;
	    photo: 3;
	    text: 4;
	    hidden: 5;
	    flash: 6;
	    office: 7;
	    browser: 8;
	    htmlEditor: 9;
	    technique: 10;
	    businessIntelligence: 11;
	}
	export type BlockType = keyof BlockType$EnumInterface;
	export const blockTypeDatatype: X3EnumDataType<keyof BlockType$EnumInterface, unknown>;
	//# sourceMappingURL=block-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/block-type-7914.d.ts
declare module '@sage/x3-system/lib/enums/block-type-7914' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BlockType7914Enum {
	    singleRecord = 1,
	    multiRecord = 2
	}
	export interface BlockType7914$EnumInterface {
	    singleRecord: 1;
	    multiRecord: 2;
	}
	export type BlockType7914 = keyof BlockType7914$EnumInterface;
	export const blockType7914Datatype: X3EnumDataType<keyof BlockType7914$EnumInterface, unknown>;
	//# sourceMappingURL=block-type-7914.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/behaviors.d.ts
declare module '@sage/x3-system/lib/enums/behaviors' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BehaviorsEnum {
	    creation = 1,
	    update = 2,
	    deletion = 3,
	    pdfPrinting = 4,
	    excelReporting = 5,
	    wordReporting = 6,
	    wordMailMerge = 7,
	    quickEdit = 8
	}
	export interface Behaviors$EnumInterface {
	    creation: 1;
	    update: 2;
	    deletion: 3;
	    pdfPrinting: 4;
	    excelReporting: 5;
	    wordReporting: 6;
	    wordMailMerge: 7;
	    quickEdit: 8;
	}
	export type Behaviors = keyof Behaviors$EnumInterface;
	export const behaviorsDatatype: X3EnumDataType<keyof Behaviors$EnumInterface, unknown>;
	//# sourceMappingURL=behaviors.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/batch-task-type.d.ts
declare module '@sage/x3-system/lib/enums/batch-task-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BatchTaskTypeEnum {
	    processing = 1,
	    script = 2
	}
	export interface BatchTaskType$EnumInterface {
	    processing: 1;
	    script: 2;
	}
	export type BatchTaskType = keyof BatchTaskType$EnumInterface;
	export const batchTaskTypeDatatype: X3EnumDataType<keyof BatchTaskType$EnumInterface, unknown>;
	//# sourceMappingURL=batch-task-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/batch-frequency.d.ts
declare module '@sage/x3-system/lib/enums/batch-frequency' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BatchFrequencyEnum {
	    weekly = 1,
	    monthly = 2
	}
	export interface BatchFrequency$EnumInterface {
	    weekly: 1;
	    monthly: 2;
	}
	export type BatchFrequency = keyof BatchFrequency$EnumInterface;
	export const batchFrequencyDatatype: X3EnumDataType<keyof BatchFrequency$EnumInterface, unknown>;
	//# sourceMappingURL=batch-frequency.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/base-type.d.ts
declare module '@sage/x3-system/lib/enums/base-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BaseTypeEnum {
	    cIsam = 1,
	    oracle = 2,
	    folder = 3,
	    sqlServer = 4,
	    db2 = 5
	}
	export interface BaseType$EnumInterface {
	    cIsam: 1;
	    oracle: 2;
	    folder: 3;
	    sqlServer: 4;
	    db2: 5;
	}
	export type BaseType = keyof BaseType$EnumInterface;
	export const baseTypeDatatype: X3EnumDataType<keyof BaseType$EnumInterface, unknown>;
	//# sourceMappingURL=base-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/base-type-57.d.ts
declare module '@sage/x3-system/lib/enums/base-type-57' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BaseType57Enum {
	    oracle = 1,
	    sqlServer = 2
	}
	export interface BaseType57$EnumInterface {
	    oracle: 1;
	    sqlServer: 2;
	}
	export type BaseType57 = keyof BaseType57$EnumInterface;
	export const baseType57Datatype: X3EnumDataType<keyof BaseType57$EnumInterface, unknown>;
	//# sourceMappingURL=base-type-57.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/backup-integration-reason.d.ts
declare module '@sage/x3-system/lib/enums/backup-integration-reason' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BackupIntegrationReasonEnum {
	    backupOfProductionEnvironment = 1,
	    backupOfTestEnvironment = 2,
	    otherNotAffectingDocumentSequenceNumbers = 3
	}
	export interface BackupIntegrationReason$EnumInterface {
	    backupOfProductionEnvironment: 1;
	    backupOfTestEnvironment: 2;
	    otherNotAffectingDocumentSequenceNumbers: 3;
	}
	export type BackupIntegrationReason = keyof BackupIntegrationReason$EnumInterface;
	export const backupIntegrationReasonDatatype: X3EnumDataType<keyof BackupIntegrationReason$EnumInterface, unknown>;
	//# sourceMappingURL=backup-integration-reason.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/authorizations-between-folders.d.ts
declare module '@sage/x3-system/lib/enums/authorizations-between-folders' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AuthorizationsBetweenFoldersEnum {
	    none = 1,
	    read = 2,
	    all = 3
	}
	export interface AuthorizationsBetweenFolders$EnumInterface {
	    none: 1;
	    read: 2;
	    all: 3;
	}
	export type AuthorizationsBetweenFolders = keyof AuthorizationsBetweenFolders$EnumInterface;
	export const authorizationsBetweenFoldersDatatype: X3EnumDataType<keyof AuthorizationsBetweenFolders$EnumInterface, unknown>;
	//# sourceMappingURL=authorizations-between-folders.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/authentication-mode.d.ts
declare module '@sage/x3-system/lib/enums/authentication-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AuthenticationModeEnum {
	    enterprise = 1,
	    ldap = 2,
	    windowsAd = 3,
	    windowsNt = 4
	}
	export interface AuthenticationMode$EnumInterface {
	    enterprise: 1;
	    ldap: 2;
	    windowsAd: 3;
	    windowsNt: 4;
	}
	export type AuthenticationMode = keyof AuthenticationMode$EnumInterface;
	export const authenticationModeDatatype: X3EnumDataType<keyof AuthenticationMode$EnumInterface, unknown>;
	//# sourceMappingURL=authentication-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/attachment-type.d.ts
declare module '@sage/x3-system/lib/enums/attachment-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AttachmentTypeEnum {
	    file = 1,
	    imageFileInDatabase = 2,
	    textFileInDatabase = 3
	}
	export interface AttachmentType$EnumInterface {
	    file: 1;
	    imageFileInDatabase: 2;
	    textFileInDatabase: 3;
	}
	export type AttachmentType = keyof AttachmentType$EnumInterface;
	export const attachmentTypeDatatype: X3EnumDataType<keyof AttachmentType$EnumInterface, unknown>;
	//# sourceMappingURL=attachment-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/argument-type.d.ts
declare module '@sage/x3-system/lib/enums/argument-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ArgumentTypeEnum {
	    address = 1,
	    value = 2,
	    constant = 3
	}
	export interface ArgumentType$EnumInterface {
	    address: 1;
	    value: 2;
	    constant: 3;
	}
	export type ArgumentType = keyof ArgumentType$EnumInterface;
	export const argumentTypeDatatype: X3EnumDataType<keyof ArgumentType$EnumInterface, unknown>;
	//# sourceMappingURL=argument-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/archiving-event-type.d.ts
declare module '@sage/x3-system/lib/enums/archiving-event-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ArchivingEventTypeEnum {
	    object = 1,
	    report = 2,
	    export = 3,
	    log = 4,
	    excel = 5,
	    manual = 6
	}
	export interface ArchivingEventType$EnumInterface {
	    object: 1;
	    report: 2;
	    export: 3;
	    log: 4;
	    excel: 5;
	    manual: 6;
	}
	export type ArchivingEventType = keyof ArchivingEventType$EnumInterface;
	export const archivingEventTypeDatatype: X3EnumDataType<keyof ArchivingEventType$EnumInterface, unknown>;
	//# sourceMappingURL=archiving-event-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/archive-management.d.ts
declare module '@sage/x3-system/lib/enums/archive-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ArchiveManagementEnum {
	    archiveDesign = 1,
	    restoreDesign = 2,
	    deleteArchive = 3
	}
	export interface ArchiveManagement$EnumInterface {
	    archiveDesign: 1;
	    restoreDesign: 2;
	    deleteArchive: 3;
	}
	export type ArchiveManagement = keyof ArchiveManagement$EnumInterface;
	export const archiveManagementDatatype: X3EnumDataType<keyof ArchiveManagement$EnumInterface, unknown>;
	//# sourceMappingURL=archive-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/approval-request.d.ts
declare module '@sage/x3-system/lib/enums/approval-request' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ApprovalRequestEnum {
	    no = 1,
	    yes = 2,
	    withSignature = 3
	}
	export interface ApprovalRequest$EnumInterface {
	    no: 1;
	    yes: 2;
	    withSignature: 3;
	}
	export type ApprovalRequest = keyof ApprovalRequest$EnumInterface;
	export const approvalRequestDatatype: X3EnumDataType<keyof ApprovalRequest$EnumInterface, unknown>;
	//# sourceMappingURL=approval-request.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/appointment-type.d.ts
declare module '@sage/x3-system/lib/enums/appointment-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AppointmentTypeEnum {
	    pending = 1,
	    underProgress = 2,
	    ended = 3,
	    canceled = 4,
	    error = 5
	}
	export interface AppointmentType$EnumInterface {
	    pending: 1;
	    underProgress: 2;
	    ended: 3;
	    canceled: 4;
	    error: 5;
	}
	export type AppointmentType = keyof AppointmentType$EnumInterface;
	export const appointmentTypeDatatype: X3EnumDataType<keyof AppointmentType$EnumInterface, unknown>;
	//# sourceMappingURL=appointment-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/api-package-type.d.ts
declare module '@sage/x3-system/lib/enums/api-package-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ApiPackageTypeEnum {
	    main = 1,
	    linked = 2
	}
	export interface ApiPackageType$EnumInterface {
	    main: 1;
	    linked: 2;
	}
	export type ApiPackageType = keyof ApiPackageType$EnumInterface;
	export const apiPackageTypeDatatype: X3EnumDataType<keyof ApiPackageType$EnumInterface, unknown>;
	//# sourceMappingURL=api-package-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/api-loading-type.d.ts
declare module '@sage/x3-system/lib/enums/api-loading-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ApiLoadingTypeEnum {
	    application = 1,
	    shared = 2
	}
	export interface ApiLoadingType$EnumInterface {
	    application: 1;
	    shared: 2;
	}
	export type ApiLoadingType = keyof ApiLoadingType$EnumInterface;
	export const apiLoadingTypeDatatype: X3EnumDataType<keyof ApiLoadingType$EnumInterface, unknown>;
	//# sourceMappingURL=api-loading-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/and-or.d.ts
declare module '@sage/x3-system/lib/enums/and-or' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AndOrEnum {
	    and = 1,
	    or = 2
	}
	export interface AndOr$EnumInterface {
	    and: 1;
	    or: 2;
	}
	export type AndOr = keyof AndOr$EnumInterface;
	export const andOrDatatype: X3EnumDataType<keyof AndOr$EnumInterface, unknown>;
	//# sourceMappingURL=and-or.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/amount-conversion-into-letters.d.ts
declare module '@sage/x3-system/lib/enums/amount-conversion-into-letters' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AmountConversionIntoLettersEnum {
	    noConversion = 1,
	    french = 2,
	    english = 3,
	    german = 4,
	    italian = 5,
	    spanish = 6,
	    portuguese = 7,
	    turkish = 8
	}
	export interface AmountConversionIntoLetters$EnumInterface {
	    noConversion: 1;
	    french: 2;
	    english: 3;
	    german: 4;
	    italian: 5;
	    spanish: 6;
	    portuguese: 7;
	    turkish: 8;
	}
	export type AmountConversionIntoLetters = keyof AmountConversionIntoLetters$EnumInterface;
	export const amountConversionIntoLettersDatatype: X3EnumDataType<keyof AmountConversionIntoLetters$EnumInterface, unknown>;
	//# sourceMappingURL=amount-conversion-into-letters.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/aggregation-level-7825.d.ts
declare module '@sage/x3-system/lib/enums/aggregation-level-7825' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AggregationLevel7825Enum {
	    day = 1,
	    week = 2,
	    substituteValue3 = 3,
	    halfMonth = 4,
	    month = 5,
	    quarter = 6,
	    halfYear = 7,
	    year = 8
	}
	export interface AggregationLevel7825$EnumInterface {
	    day: 1;
	    week: 2;
	    substituteValue3: 3;
	    halfMonth: 4;
	    month: 5;
	    quarter: 6;
	    halfYear: 7;
	    year: 8;
	}
	export type AggregationLevel7825 = keyof AggregationLevel7825$EnumInterface;
	export const aggregationLevel7825Datatype: X3EnumDataType<keyof AggregationLevel7825$EnumInterface, unknown>;
	//# sourceMappingURL=aggregation-level-7825.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/address-type.d.ts
declare module '@sage/x3-system/lib/enums/address-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AddressTypeEnum {
	    absolute = 1,
	    relativeSolutionPublication = 2,
	    relativeFolder = 3
	}
	export interface AddressType$EnumInterface {
	    absolute: 1;
	    relativeSolutionPublication: 2;
	    relativeFolder: 3;
	}
	export type AddressType = keyof AddressType$EnumInterface;
	export const addressTypeDatatype: X3EnumDataType<keyof AddressType$EnumInterface, unknown>;
	//# sourceMappingURL=address-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/actual-forecast.d.ts
declare module '@sage/x3-system/lib/enums/actual-forecast' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActualForecastEnum {
	    actual = 1,
	    forecast = 2
	}
	export interface ActualForecast$EnumInterface {
	    actual: 1;
	    forecast: 2;
	}
	export type ActualForecast = keyof ActualForecast$EnumInterface;
	export const actualForecastDatatype: X3EnumDataType<keyof ActualForecast$EnumInterface, unknown>;
	//# sourceMappingURL=actual-forecast.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/action-type.d.ts
declare module '@sage/x3-system/lib/enums/action-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActionTypeEnum {
	    miscellaneous = 1,
	    control = 2,
	    entry = 3,
	    selection = 4,
	    update = 5,
	    informationSearch = 6,
	    calculation = 7
	}
	export interface ActionType$EnumInterface {
	    miscellaneous: 1;
	    control: 2;
	    entry: 3;
	    selection: 4;
	    update: 5;
	    informationSearch: 6;
	    calculation: 7;
	}
	export type ActionType = keyof ActionType$EnumInterface;
	export const actionTypeDatatype: X3EnumDataType<keyof ActionType$EnumInterface, unknown>;
	//# sourceMappingURL=action-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/action-type-7960.d.ts
declare module '@sage/x3-system/lib/enums/action-type-7960' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActionType7960Enum {
	    record = 1,
	    list = 2,
	    subprogram = 3,
	    dialogBox = 4
	}
	export interface ActionType7960$EnumInterface {
	    record: 1;
	    list: 2;
	    subprogram: 3;
	    dialogBox: 4;
	}
	export type ActionType7960 = keyof ActionType7960$EnumInterface;
	export const actionType7960Datatype: X3EnumDataType<keyof ActionType7960$EnumInterface, unknown>;
	//# sourceMappingURL=action-type-7960.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/action-type-7936.d.ts
declare module '@sage/x3-system/lib/enums/action-type-7936' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActionType7936Enum {
	    standard = 1,
	    login = 2,
	    logout = 3
	}
	export interface ActionType7936$EnumInterface {
	    standard: 1;
	    login: 2;
	    logout: 3;
	}
	export type ActionType7936 = keyof ActionType7936$EnumInterface;
	export const actionType7936Datatype: X3EnumDataType<keyof ActionType7936$EnumInterface, unknown>;
	//# sourceMappingURL=action-type-7936.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/action-models.d.ts
declare module '@sage/x3-system/lib/enums/action-models' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActionModelsEnum {
	    objectManagement = 1,
	    inquiry = 2,
	    standardProcessing = 3,
	    windowEntry = 4,
	    listSelection = 5,
	    tableSelection = 6,
	    miscellaneousDisplay = 7,
	    outsideModel = 8
	}
	export interface ActionModels$EnumInterface {
	    objectManagement: 1;
	    inquiry: 2;
	    standardProcessing: 3;
	    windowEntry: 4;
	    listSelection: 5;
	    tableSelection: 6;
	    miscellaneousDisplay: 7;
	    outsideModel: 8;
	}
	export type ActionModels = keyof ActionModels$EnumInterface;
	export const actionModelsDatatype: X3EnumDataType<keyof ActionModels$EnumInterface, unknown>;
	//# sourceMappingURL=action-models.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/action-flow-management.d.ts
declare module '@sage/x3-system/lib/enums/action-flow-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActionFlowManagementEnum {
	    webSiteField = 1,
	    customization = 2,
	    xslProcessor = 3
	}
	export interface ActionFlowManagement$EnumInterface {
	    webSiteField: 1;
	    customization: 2;
	    xslProcessor: 3;
	}
	export type ActionFlowManagement = keyof ActionFlowManagement$EnumInterface;
	export const actionFlowManagementDatatype: X3EnumDataType<keyof ActionFlowManagement$EnumInterface, unknown>;
	//# sourceMappingURL=action-flow-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/action-field-type.d.ts
declare module '@sage/x3-system/lib/enums/action-field-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActionFieldTypeEnum {
	    initButton = 1,
	    beforeField = 2,
	    initialization = 3,
	    beforeEntry = 4,
	    control = 5,
	    afterField = 6,
	    afterChange = 7,
	    selection = 8,
	    button1 = 9,
	    button2 = 10,
	    button3 = 11,
	    button4 = 12,
	    beforeLine = 13,
	    afterLine = 14,
	    button5 = 15,
	    button6 = 16,
	    button7 = 17,
	    button8 = 18,
	    button9 = 19,
	    button10 = 20,
	    button11 = 21,
	    button12 = 22,
	    button13 = 23,
	    button14 = 24,
	    button15 = 25,
	    button16 = 26,
	    button17 = 27,
	    button18 = 28,
	    button19 = 29,
	    button20 = 30,
	    click = 31
	}
	export interface ActionFieldType$EnumInterface {
	    initButton: 1;
	    beforeField: 2;
	    initialization: 3;
	    beforeEntry: 4;
	    control: 5;
	    afterField: 6;
	    afterChange: 7;
	    selection: 8;
	    button1: 9;
	    button2: 10;
	    button3: 11;
	    button4: 12;
	    beforeLine: 13;
	    afterLine: 14;
	    button5: 15;
	    button6: 16;
	    button7: 17;
	    button8: 18;
	    button9: 19;
	    button10: 20;
	    button11: 21;
	    button12: 22;
	    button13: 23;
	    button14: 24;
	    button15: 25;
	    button16: 26;
	    button17: 27;
	    button18: 28;
	    button19: 29;
	    button20: 30;
	    click: 31;
	}
	export type ActionFieldType = keyof ActionFieldType$EnumInterface;
	export const actionFieldTypeDatatype: X3EnumDataType<keyof ActionFieldType$EnumInterface, unknown>;
	//# sourceMappingURL=action-field-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/action-deactivation.d.ts
declare module '@sage/x3-system/lib/enums/action-deactivation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActionDeactivationEnum {
	    none = 1,
	    standard = 2,
	    vertical = 3,
	    all = 4
	}
	export interface ActionDeactivation$EnumInterface {
	    none: 1;
	    standard: 2;
	    vertical: 3;
	    all: 4;
	}
	export type ActionDeactivation = keyof ActionDeactivation$EnumInterface;
	export const actionDeactivationDatatype: X3EnumDataType<keyof ActionDeactivation$EnumInterface, unknown>;
	//# sourceMappingURL=action-deactivation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-system/build/lib/enums/abbreviations-of-the-weekdays.d.ts
declare module '@sage/x3-system/lib/enums/abbreviations-of-the-weekdays' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AbbreviationsOfTheWeekdaysEnum {
	    mo = 1,
	    tu = 2,
	    we = 3,
	    th = 4,
	    fr = 5,
	    sa = 6,
	    su = 7
	}
	export interface AbbreviationsOfTheWeekdays$EnumInterface {
	    mo: 1;
	    tu: 2;
	    we: 3;
	    th: 4;
	    fr: 5;
	    sa: 6;
	    su: 7;
	}
	export type AbbreviationsOfTheWeekdays = keyof AbbreviationsOfTheWeekdays$EnumInterface;
	export const abbreviationsOfTheWeekdaysDatatype: X3EnumDataType<keyof AbbreviationsOfTheWeekdays$EnumInterface, unknown>;
	//# sourceMappingURL=abbreviations-of-the-weekdays.d.ts.map
}
declare module '@sage/x3-system' {
	export * from '@sage/x3-system/index';
}
