"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pat = exports.getRegExpForMultiplePat = exports.getRegExp = void 0;
/**
 * Get the RegExp equivalent for the 4GL pattern given
 *
 * @param pattern The 4GL pattern you want to get the RegExp equivalent
 * @returns The RegExp
 */
function getRegExp(pattern) {
    const rule = 
    // escape RegExp spécial chars
    pattern
        .replace(/[-[\]{}()+.,\\^$|\s]/g, '\\$&')
        // translate the pattern
        .replace(/\*/g, '.*')
        .replace(/\?/g, '.')
        .replace(/#/g, '\\d')
        .replace(/!/g, '[A-Za-z]');
    return new RegExp(`^${rule}$`);
}
exports.getRegExp = getRegExp;
function getRegExpForMultiplePat(multiplePattern) {
    // const str1 = '(';
    const rule = `${`(${
    // convert each pattern individually and join them using |
    multiplePattern
        .split(',')
        .map(multPat => getRegExp(multPat).source.replace(/\^/g, '').replace(/\$/g, ''))
        .join('|')}`})`;
    return new RegExp(`^${rule}$`);
}
exports.getRegExpForMultiplePat = getRegExpForMultiplePat;
/**
 * Perform a 4GL pattern check
 *
 * @param text The text to be tested
 * @param pat The 4GL pattern to apply
 * @returns The result of the test as a boolean
 */
function pat(text, pattern) {
    return getRegExp(pattern).test(text);
}
exports.pat = pat;
//# sourceMappingURL=pat-converter.js.map