"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParsedElement = exports.UnitOfMeasure = exports.DataTitle = exports.ElementTypeEnum = void 0;
var ElementTypeEnum;
(function (ElementTypeEnum) {
    ElementTypeEnum["string"] = "string";
    ElementTypeEnum["number"] = "number";
    ElementTypeEnum["date"] = "date";
})(ElementTypeEnum || (exports.ElementTypeEnum = ElementTypeEnum = {}));
var DataTitle;
(function (DataTitle) {
    // Applicable Amount Payable
    DataTitle["amount"] = "AMOUNT";
    DataTitle["price"] = "PRICE";
    // Production Date (YYMMDD)
    DataTitle["prodDate"] = "PROD DATE";
    // Batch or Lot Number
    DataTitle["batchLot"] = "BATCH/LOT";
    // Due Date (YYMMDD)
    DataTitle["dueDate"] = "DUE DATE";
    // Packaging Date (YYMMDD)
    DataTitle["packDate"] = "PACK DATE";
    // Best Before Date (YYMMDD)
    DataTitle["bestBefore"] = "BEST BEFORE or BEST BY";
    // Expiration Date (YYMMDD)
    DataTitle["expiryDate"] = "USE BY OR EXPIRY";
    // Sell By Date (YYMMDD)
    DataTitle["sellBy"] = "SELL BY";
    // SSCC (Serial Shipping Container Code)
    DataTitle["sscc"] = "SSCC";
    // Global Trade Item Number (GTIN)
    DataTitle["gtin"] = "GTIN";
    // Global Identification Number for Consignment (GINC)
    DataTitle["ginc"] = "GINC";
    // Global Shipment Identification Number (GSIN)
    DataTitle["gsin"] = "GSIN";
    // GTIN of Contained Trade Items
    DataTitle["content"] = "CONTENT";
    // Variant Number
    DataTitle["variant"] = "VARIANT";
    // Serial Number
    DataTitle["serial"] = "SERIAL";
    // Consumer product variant
    DataTitle["cpv"] = "CPV";
    // Additional Item Identification
    DataTitle["additionalId"] = "ADDITIONAL ID";
    // Customer Part Number
    DataTitle["customPartNumber"] = "CUST. PART NO.";
    // Made-to-Order Variation Number
    DataTitle["mtoVariant"] = "MTO VARIAN";
    // Made-to-Order Variation Number
    DataTitle["pcn"] = "PCN";
    // Count of Items (Variable Measure Trade Item)
    DataTitle["varCount"] = "VAR. COUNT";
    // Customer's Purchase Order Number
    DataTitle["orderNumber"] = "ORDER NUMBER";
    // Routing code
    DataTitle["route"] = "ROUTE";
    // Ship to - Deliver to Global Location Number
    DataTitle["shipToLoc"] = "SHIP TO LOC";
    // Bill to - Invoice to Global Location Number
    DataTitle["billTo"] = "BILL TO";
    // Purchased from Global Location Number
    DataTitle["purchaseFrom"] = "PURCHASE FROM";
    // Ship for - Deliver for - Forward to Global Location Number
    DataTitle["shipForLoc"] = "SHIP FOR LOC";
    // Ship to - Deliver to Postal Code Within a Single Postal Authority
    DataTitle["shipToPost"] = "SHIP TO POST";
    // Country of Origin of a Trade Item
    DataTitle["origin"] = "ORIGIN";
    // Country of Initial Processing
    // Up to 5 3-digit ISO-countrycodes
    DataTitle["countryInitialProcess"] = "COUNTRY - INITIAL PROCESS.";
    // Country of Processing
    DataTitle["countryProcess"] = "COUNTRY - PROCESS.";
    // Country of disassembly
    DataTitle["countryDisassembly"] = "COUNTRY - DISASSEMBLY";
    // Country Covering full Process Chain
    DataTitle["countryFullProcess"] = "COUNTRY - FULL PROCESS";
    // Country subdivision of origin
    DataTitle["countrySubdivision"] = "ORIGIN SUBDIVISION";
    // NATO Stock Number (NSN)
    DataTitle["nsn"] = "NSN";
    // UN/ECE Meat Carcasses and Cuts Classification
    DataTitle["meatCut"] = "MEAT CUT";
    // Expiration Date and Time
    DataTitle["expiryTime"] = "EXPIRY TIME";
    // Active Potency
    DataTitle["activePotency"] = "ACTIVE POTENCY";
    // Net weight (Variable Measure Trade Item)
    DataTitle["netWeight"] = "NET WEIGHT";
    // Net weight (Variable Measure Trade Item)
    DataTitle["grossWeight"] = "GROSS WEIGHT";
    // Length or first dimension (Variable Measure Trade Item)
    DataTitle["length"] = "LENGTH";
    // Width, diameter, or second dimension (Variable Measure Trade Item)
    DataTitle["width"] = "WIDTH";
    // Depth, thickness, height, or third dimension (Variable Measure Trade Item)
    DataTitle["height"] = "HEIGHT";
    // Area (Variable Measure Trade Item)
    DataTitle["area"] = "AREA";
    DataTitle["netVolume"] = "NET VOLUME";
    DataTitle["volume"] = "VOLUME";
    DataTitle["kgPerSquareMeter"] = "KG PER SQUARE METER";
})(DataTitle || (exports.DataTitle = DataTitle = {}));
var UnitOfMeasure;
(function (UnitOfMeasure) {
    UnitOfMeasure["EACH"] = "EACH";
    UnitOfMeasure["MILLIMETER"] = "MILLIMETER";
    UnitOfMeasure["CENTIMETER"] = "CENTIMETER";
    UnitOfMeasure["METER"] = "METER";
    UnitOfMeasure["KILOMETER"] = "KILOMETER";
    UnitOfMeasure["INCH"] = "INCH";
    UnitOfMeasure["FOOT"] = "FOOT";
    UnitOfMeasure["YARD"] = "YARD";
    UnitOfMeasure["MILE"] = "MILE";
    UnitOfMeasure["MILLILITER"] = "MILLILITER";
    UnitOfMeasure["LITER"] = "LITER";
    UnitOfMeasure["CUBIC_METER"] = "CUBIC_METER";
    UnitOfMeasure["FLUID_OUNCE"] = "FLUID_OUNCE";
    UnitOfMeasure["CUP"] = "CUP";
    UnitOfMeasure["PINT"] = "PINT";
    UnitOfMeasure["QUART"] = "QUART";
    UnitOfMeasure["GALLON"] = "GALLON";
    UnitOfMeasure["CUBIC_INCH"] = "CUBIC_INCH";
    UnitOfMeasure["CUBIC_FOOT"] = "CUBIC_FOOT";
    UnitOfMeasure["CUBIC_YARD"] = "CUBIC_YARD";
    UnitOfMeasure["GRAM"] = "GRAM";
    UnitOfMeasure["KILOGRAM"] = "KILOGRAM";
    UnitOfMeasure["METRIC_TON"] = "METRIC_TON";
    UnitOfMeasure["OUNCE"] = "OUNCE";
    UnitOfMeasure["POUND"] = "POUND";
    UnitOfMeasure["STONE"] = "STONE";
    UnitOfMeasure["HUNDREDWEIGHT"] = "HUNDREDWEIGHT";
    UnitOfMeasure["SHORT_TON"] = "SHORT_TON";
    UnitOfMeasure["SECOND"] = "SECOND";
    UnitOfMeasure["MINUTE"] = "MINUTE";
    UnitOfMeasure["HOUR"] = "HOUR";
    UnitOfMeasure["DAY"] = "DAY";
    UnitOfMeasure["SQUARE_MILLIMETER"] = "SQUARE_MILLIMETER";
    UnitOfMeasure["SQUARE_CENTIMETER"] = "SQUARE_CENTIMETER";
    UnitOfMeasure["SQUARE_METER"] = "SQUARE_METER";
    UnitOfMeasure["SQUARE_INCH"] = "SQUARE_INCH";
    UnitOfMeasure["SQUARE_FOOT"] = "SQUARE_FOOT";
    UnitOfMeasure["SQUARE_YARD"] = "SQUARE_YARD";
    UnitOfMeasure["TROY_OUNCES"] = "TROY_OUNCES";
    // Kilograms per square metre, yes, the ISO code for this _is_ "28".
    UnitOfMeasure["_28"] = "28";
})(UnitOfMeasure || (exports.UnitOfMeasure = UnitOfMeasure = {}));
class ParsedElement {
    constructor(ai, elementDataTitle, elementType) {
        this.ai = ai;
        this.elementDataTitle = elementDataTitle;
        this.elementType = elementType;
        /* defines the object which represents a single element
         */
        switch (elementType) {
            case ElementTypeEnum.string:
                this._data = '';
                break;
            case ElementTypeEnum.number:
                this._data = 0;
                break;
            case ElementTypeEnum.date:
                this._data = '';
                break;
            default:
                this._data = '';
                break;
        }
        this.unit = undefined; // some elements are accompanied by an unit of
    }
    set unit(unit) {
        this._unit = unit;
    }
    get unit() {
        return this._unit;
    }
    set data(data) {
        this._data = data;
    }
    get data() {
        return this._data;
    }
}
exports.ParsedElement = ParsedElement;
//# sourceMappingURL=parsed-element.js.map