/**
 * P. Brockfeld, 2014-02-05
 *
 * JavaScript for parsing GS1 barCodes, see
 *
 * https://github.com/hprange/BarcodeParser (active fork)
 *
 * https://github.com/PeterBrockfeld/BarcodeParser (original repo)
 *
 * for details.
 */
import { ParsedElement } from './parsed-element';
export interface ParsedBarcode {
    codeName: string;
    parsedCodeItems: ParsedElement[];
}
export type ParsedBarcodeOrNever = ParsedBarcode | never;
export declare class ParseBarCode {
    constructor(codeString?: string);
    /**
     * Special separator of variable record
     */
    private get fncChar();
    /**
     * String before change
     */
    private get codeString();
    private set codeString(value);
    /**
     * String length before change
     */
    private get codeStringLength();
    /** Evaluate barcode received */
    parseBarcode(barcode: string): ParsedBarcodeOrNever;
    /**
     * "ParsedElement" is the
     *
     * @constructor for ParsedElements, the components of the array returned by parseBarcode
     * @param {String} elementAI        the AI of the recognized element
     * @param {String} elementDataTitle the title of the element, i.e. its short description
     * @param {String} elementType      a one-letter string describing the type of the element.
     *                                  allowed values are
     *                                  "string" for strings,
     *                                  "numeric" for numbers and
     *                                  "date" for dates
     */
    /**
     *
     * ================== BEGIN of identifyAI =======================
     *
     * does the main work:
     *   what AI is in the beginning of the restOfBarcode?
     *     If identified:
     *       which function to call with
     *       which parameters to parse the element?[Description]]
     * @param   {String} codeString a string; the function tries to
     *                   identify an AI in the beginning of this string
     * @returns {Object} if it succeeds in identifying an AI the
     *                   ParsedElement is returned with, together with the
     *                   still unparsed rest of codeString.
     */
    private _identifyAI;
    private _evaluateCodeStartWith0;
    private _evaluateCodeStartWith1;
    private _evaluateCodeStartWith2;
    private _evaluateCodeStartWith24;
    private _evaluateCodeStartWith25;
    private _evaluateCodeStartWith3;
    private _evaluateCodeStartWith31;
    private _evaluateCodeStartWith32;
    private _evaluateCodeStartWith33;
    private _evaluateCodeStartWith34;
    private _evaluateCodeStartWith35;
    private _evaluateCodeStartWith36;
    private _evaluateCodeStartWith39;
    private _evaluateCodeStartWith4;
    private _evaluateCodeStartWith40;
    private _evaluateCodeStartWith41;
    private _evaluateCodeStartWith42;
    private _evaluateCodeStartWith7;
    private _evaluateCodeStartWith70;
    private _evaluateCodeStartWith700;
    private _evaluateCodeStartWith71;
    private _evaluateCodeStartWith8;
    private _evaluateCodeStartWith80;
    private _evaluateCodeStartWith800;
    private _evaluateCodeStartWith801;
    private _evaluateCodeStartWith802;
    private _evaluateCodeStartWith81;
    private _evaluateCodeStartWith810;
    private _evaluateCodeStartWith811;
    private _evaluateCodeStartWith82;
    private _evaluateCodeStartWith9;
    /**
     *
     * =========== END of identifyAI =======================
     *
     */
    /**
     * ============ auxiliary functions for identifyAI =============
     */
    /**
     * some data items are followed by an ParsedElementAndCode  even in case of
     * fixed length, so the codeStringToReturn may have
     * leading FNCs.
     *
     * This function eliminates these leading FNCs.
     *
     * @param   {String} stringToClean string which has to be cleaned
     * @returns {String} the cleaned string
     */
    private _cleanCodeString;
    /**
     * Used for calculating numbers which are given as string
     * with a given number of fractional decimals.
     *
     * To avoid conversion errors binary decimal I _don't_
     * just divide by 10 numberOfFractionals times.
     *
     * Parse a string with given fractional to float
     * @param {string} stringToParse
     * @param {number} numberOfFractionals
     * @returns {number} value
     */
    private static _parseFloatingPoint;
    /**
     * ======== END of auxiliary function for identifyAI =======
     */
    /**
     *
     * ======== BEGIN of parsing privates in identifyAI =======
     *
     * Some privates to parse the various GS1 formats. They
     * create a new ParsedElement and set its properties.
     *
     * They all modify the variables "elementToReturn" and
     * "codeStringToReturn".
     */
    /**
     * dates in GS1-elements have the format "YYMMDD".
     * This private generates a new ParsedElement and tries to fill a
     * JS-date into the "data"-part.
     * @param {String} ai    the AI to use for the ParsedElement
     * @param {String} title the title to use for the ParsedElement
     */
    private _parseDate;
    /**
     * simple: the element has a fixed length AND is not followed by an FNC1.
     * @param {String} ai     the AI to use
     * @param {String} title  its title, i.e. its short description
     * @param {Number} length the fixed length
     */
    private _parseFixedLength;
    /**
     * tries to parse an element of variable length
     * some fixed length AIs are terminated by FNC1, so this private
     * is used even for fixed length items
     * @param {String} ai           the AI to use
     * @param {String} title        its title, i.e. its short description
     * @param {number} maxLength    maximum data size allowed or 0
     * @return parsed element
     */
    private _parseVariableLength;
    /**
     * the place of the decimal fraction is given by the fourth number, that's
     * the first after the identifier itself.
     *
     * All of theses elements have a length of 6 characters.
     * @param {String} aiStem       the first digits of the AI, _not_ the fourth digit
     * @param {Number} currentFourthNumber the 4th number indicating the count of valid fractionals
     * @param {String} title        the title of the AI
     * @param {String} unit         often these elements have an implicit unit of measurement
     */
    private _parseFixedLengthMeasure;
    /**
     * parses data elements of variable length, which additionally have
     *
     * - an indicator for the number of valid decimals
     * - an implicit unit of measurement
     *
     * These data elements contain e.g. a weight or length.
     *
     */
    private _parseVariableLengthMeasure;
    /**
     * parses data elements of variable length, which additionally have
     *
     * - an indicator for the number of valid decimals
     * - an explicit unit of measurement
     *
     * These data element contain amounts to pay or prices.
     *
     */
    private _parseVariableLengthWithISONumbers;
    /**
     * parses data elements of variable length, which additionally have
     *
     * - an explicit unit of measurement or reference
     *
     * These data element contain countries, authorities within countries.
     *
     */
    private _parseVariableLengthWithISOChars;
}
/**
 * Function only for using class
 * @param barcode bar code to translate
 * @returns translated value(s)
 */
export declare function parseBarcode(barcode: string): ParsedBarcode;
//# sourceMappingURL=barcode-parser.d.ts.map