"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserAccess = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageX3System = require("..");
const joins = {
    referenceJoins: {
        profile: {
            profile: 'profile',
        },
        access: {
            access: 'access',
        },
        user: {
            code: 'user',
        },
    },
};
let UserAccess = class UserAccess extends xtrem_core_1.Node {
};
exports.UserAccess = UserAccess;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRFCOD',
        columnType: 'string',
        node: () => sageX3System.nodes.UserFunctionProfile,
    })
], UserAccess.prototype, "profile", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CODACC',
        columnType: 'string',
        node: () => sageX3System.nodes.Access,
    })
], UserAccess.prototype, "access", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'USR',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], UserAccess.prototype, "user", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CONSUL',
    })
], UserAccess.prototype, "inquiry", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EXEC',
    })
], UserAccess.prototype, "execution", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MODIF',
    })
], UserAccess.prototype, "modification", void 0);
exports.UserAccess = UserAccess = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ACCES',
        keyPropertyNames: ['profile', 'access', 'user'],
        indexes: [
            {
                orderBy: {
                    profile: 1,
                    access: 1,
                    user: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['profile', 'access', 'user'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], UserAccess);
//# sourceMappingURL=user-access.js.map