"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionalProfile = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3System = require("..");
const joins = {
    referenceJoins: {
        profile: {
            profile: 'profile',
        },
        function: {
            internal: 'function',
        },
        siteGrouping: {
            code: 'siteGrouping',
        },
    },
};
let FunctionalProfile = class FunctionalProfile extends xtrem_core_1.Node {
};
exports.FunctionalProfile = FunctionalProfile;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRFCOD',
        columnType: 'string',
        node: () => sageX3System.nodes.UserFunctionProfile,
    })
], FunctionalProfile.prototype, "profile", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FNC',
        columnType: 'string',
        node: () => sageX3System.nodes.Function,
    })
], FunctionalProfile.prototype, "function", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCYGRU',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], FunctionalProfile.prototype, "siteGrouping", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCYGRUCOD',
        dataType: () => sageX3System.enums.regroupingSiteDatatype,
    })
], FunctionalProfile.prototype, "menu", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ACS',
    })
], FunctionalProfile.prototype, "access", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], FunctionalProfile.prototype, "options", void 0);
exports.FunctionalProfile = FunctionalProfile = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'AFCTPRF',
        keyPropertyNames: ['profile', 'function', 'siteGrouping'],
        indexes: [
            {
                orderBy: {
                    profile: 1,
                    function: 1,
                    siteGrouping: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['siteGrouping'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], FunctionalProfile);
//# sourceMappingURL=functional-profile.js.map