"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Company = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3System = require("..");
const joins = {
    referenceJoins: {
        legislation: {
            glossaryId() {
                return 909;
            },
            code: 'legislation',
        },
        logo: {
            code() {
                return 'LOGO';
            },
            identifier1: 'code',
            identifier2() {
                return null;
            },
            identifier3() {
                return null;
            },
        },
    },
};
let Company = class Company extends xtrem_core_1.Node {
};
exports.Company = Company;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Company.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Company.prototype, "name", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPYSHO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Company.prototype, "shortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPYLEGFLG',
    })
], Company.prototype, "isLegalCompany", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LEG',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 909,
            },
            control: {
                glossaryId: 909,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], Company.prototype, "legislation", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'LOGO',
                identifier2: null,
                identifier3: null,
            },
            control: {
                code: 'LOGO',
                identifier2: null,
                identifier3: null,
            },
        },
        node: () => sageX3System.nodes.Image,
    })
], Company.prototype, "logo", void 0);
exports.Company = Company = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'COMPANY',
        keyPropertyNames: ['code'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], Company);
//# sourceMappingURL=company.js.map