import * as ui from '@sage/xtrem-ui';
import { AsyncCompositeAllowed, BarcodeManagerSupportedFields, DictionaryDataComposite, DictionaryFieldSupported } from './screen-management-gs-1';
import { ManagementServiceGs1 } from './management-service-gs-1';
export declare class SupportServiceManagementGs1Page<TGraphqlApi = any, TNodeType extends ui.ClientNode = any> extends ui.Page<TGraphqlApi, TNodeType> {
    /**
     * Internal only
     */
    constructor();
    /**
     * Protected only
     */
    /**
     * Return current state of service
     */
    /** @protected */
    protected get isServiceGs1Disabled(): boolean;
    /**
     * Disable or enable service (default : enable) :
     * Disabling clearing all composite data
     */
    /** @protected */
    protected set disableServiceGs1(disableServiceGs1: boolean);
    /**
     * Get current control manager instance
     */
    /** @protected */
    protected get controlManagerGs1(): ManagementServiceGs1;
    /**
     * Remove composite data
     */
    /** @protected */
    protected clearCompositeData(): void;
    /**
     * Remove composite data from storage
     * @param storageKey optional, for overriding current service key (use with caution)
     */
    /** @protected */
    protected clearCompositeDataStorage(storageKey?: string): void;
    /**
     * Remove all composite and storage data
     * @param storageKey optional, for overriding current service key (use with caution)
     */
    /** @protected */
    protected clearAllCompositeDataAndStorage(storageKey?: string): void;
    /**
     * Create and initialize manager for a given service :
     * manager stay available only when site has defined and initialization is done.
     *
     * @param site current site
     * @param compositePageKey key for storage operation
     * @param dictionaryFieldSupported fields screen to manage and control
     * @param dictionaryDataComposites? optional composite data
     * @param checkCompositeDataAllowed? optional client callback to check composite data code before to dispatch them
     * @return false when service has not properly initialized (unavailable)
     */
    /** @protected */
    protected createAndInitServiceGs1(site: string, compositePageKey: string, dictionaryFieldSupported: DictionaryFieldSupported, dictionaryDataComposites?: DictionaryDataComposite, checkCompositeDataAllowed?: AsyncCompositeAllowed): Promise<boolean>;
    /**
     * Load composite data from storage and erase them
     * @returns true when some data has been loaded
     */
    /** @protected */
    protected loadCompositeData(): boolean;
    /**
     * Save composite data, zero elements allowed
     * @returns true when operation has performed
     */
    /** @protected */
    protected saveCompositeData(): boolean;
    /**
     * call scan evaluator only when manager available and rawData has minimum requirement
     * @param mainField current screen field reference
     * @param rawData data to parse
     * @return false when is not a bar code composite
     */
    /** @protected */
    protected scanBarCode(mainField: BarcodeManagerSupportedFields, rawData: string): Promise<boolean>;
    /**
     * Update screen fields supported (only when exists Gs1 parameters).
     * mapping field has been performed after
     * @param dictionaryFieldSupported dictionary of page fields submitted
     * @returns true when done, false when no any field to process with data
     */
    protected setScreenFieldSupported(dictionaryFieldSupported: DictionaryFieldSupported): Promise<boolean>;
}
//# sourceMappingURL=support-service-management-gs-1-page.d.ts.map