/** Service of management code GS 1 */
import { GraphApi } from '@sage/x3-system-api';
import * as ui from '@sage/xtrem-ui';
import { AsyncAndVoidFunction, AsyncCompositeAllowed, BarcodeManagerSupportedFields, DictionaryDataComposite, DictionaryFieldSupported } from './screen-management-gs-1';
export declare const errorMessageCheckYourEntry = "Check your entry for {{#each fieldNames}}\n - {{this}}{{/each}}";
export declare const errorMessageError = "Error";
export declare class ManagementServiceGs1 {
    private readonly _storageKey;
    /**
     * Initialize permanent data for page
     * @param _storageKey       : storage key used for this page
     */
    constructor(_storageKey: string);
    /**
     * This Method build instance with retrieving all data
     * @param pageInstance : current page
     * @param dictionaryFieldSupported : page fields supported
     * @param dictionaryDataComposites : extracted composite data, may be send to storage
     * @param checkCompositeDataAllowed? : optional client callback to check composite data code before to dispatch them
     */
    initialize(pageInstance: ui.Page<GraphApi>, dictionaryFieldSupported?: DictionaryFieldSupported, dictionaryDataComposites?: DictionaryDataComposite, checkCompositeDataAllowed?: AsyncCompositeAllowed): Promise<boolean>;
    /**
     * Return if dispatch session is in progress
     */
    get isDispatchInProgress(): boolean;
    /**
     * Return if initialization is in progress
     */
    get isInitializationInProgress(): boolean;
    /**
     * Request to abort dispatch without error (end of scan) :
     * This is used only when onChange() has performed some operations,
     * ie : switching page... except when initialization is in progress
     * @param {function}    optional callback to be executed approx. 100ms after end of dispatching.
     * @returns {boolean}   true when request has be set
     */
    abortDispatch(postActionAbortDispatch?: AsyncAndVoidFunction): boolean;
    /**
     * Return if abort dispatch session is requested
     */
    get isAbortDispatchInProgress(): boolean;
    /**
     * Called when field update is in progress
     * @param pageInstance current page
     * @param currentField reference of field to updating
     * @param rawData received raw data
     * @param appendCompositeData true when is necessary to appending current date to previous set
     * @return true when is not necessary to continue and affect a value : composite value has been processed
     */
    scan(pageInstance: ui.Page<GraphApi>, currentField: BarcodeManagerSupportedFields, rawData: any, appendCompositeData?: boolean): Promise<boolean>;
    /**
     * Check if exists some fields loaded into service
     */
    get isExistsFieldsSupported(): boolean;
    /**
     * Check if exists some fields mapped into service,
     * ready to dispatch
     */
    get isExistsFieldsMapped(): boolean;
    /**
     *
     * @returns true when some composite data have been stored.
     */
    get isExistsDataComposite(): boolean;
    /**
     * Update screen fields supported.
     * field mapping was done after
     * @param pageInstance current page
     * @param dictionaryFieldSupported dictionary of page fields submitted
     * @returns true when done, false when no any field to process with data
     */
    setScreenFieldSupported(pageInstance: ui.Page<GraphApi>, dictionaryFieldSupported: DictionaryFieldSupported): Promise<boolean>;
    /**
     * Remove fields definition
     * @param removeCompositeData  : optionally remove composite data too
     */
    clearScreenFields(removeCompositeData?: boolean): void;
    /**
     * Remove composite data
     */
    clearCompositeData(): void;
    /**
     * Remove composite data from storage
     * @param pageInstance current page
     * @param storageKey optional, for overriding current service key (use with caution)
     */
    clearCompositeDataStorage(pageInstance: ui.Page<GraphApi>, storageKey?: string): void;
    /**
     * Remove all composite and storage data
     * @param pageInstance current page
     * @param storageKey optional, for overriding current service key (use with caution)
     */
    clearAllCompositeDataAndStorage(pageInstance: ui.Page<GraphApi>, storageKey?: string): void;
    /**
     * Load composite data from storage and then delete it there.
     * @returns true when some data has been loaded
     */
    loadCompositeData(pageInstance: ui.Page<GraphApi>): boolean;
    /**
     * Save composite data, zero elements allowed
     * @param pageInstance current page
     * @returns true when operation has performed
     */
    saveCompositeData(pageInstance: ui.Page<GraphApi>): boolean;
    /**
     * Section page validation
     * */
    /**
     * Perform validation of all segments managed
     * @param pageInstance current page
     * @param errorMessage translated message error errorMessageCheckYourEntry
     * @returns
     */
    validate(pageInstance: ui.Page, errorMessage?: string): Promise<boolean>;
    /**
     * Validate current page
     * @param pageInstance current page
     * @param errorMessage translated message error errorMessageError
     * @returns false when error occur
     */
    validatePage(pageInstance: ui.Page, errorMessage?: string): Promise<boolean>;
    /**
     * perform fields validation with detailed errors lists.
     * @param pageInstance current page
     * @param errorMessage errorMessageCheckYourEntry
     * @returns false when error occur
     */
    validateWithDetails(pageInstance: ui.Page, errorMessage?: string): Promise<boolean>;
}
//# sourceMappingURL=management-service-gs-1.d.ts.map