/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.serveStaticXtremUi=void 0;const xtrem_core_1=require("@sage/xtrem-core"),fs=require("fs/promises"),handlebars=require("handlebars"),lodash_1=require("lodash"),fsp=require("path"),util_1=require("./util"),logger=xtrem_core_1.Logger.getLogger(__filename,"xtrem-ui-app"),cachePeriod=604800,compiledTemplateCache=new Map,getIndexFileContent=async(e,r,t="",a=false)=>{const s=`${e}_pendo=${r.preferences.loadPendo}_NR=${r.preferences.loadNewRelic}`;let o=compiledTemplateCache.get(s);if(!o||a){const r=await fs.readFile(e,"utf-8");o=handlebars.compile(r),compiledTemplateCache.set(s,o)}return o({...r,version:t,pendoApiKey:xtrem_core_1.ConfigManager.current.pendo?.apiKey||"23e3553b-ace0-4473-7d86-4385a4f77f78"})},getUiPackageJsonPath=(0,lodash_1.memoize)(({isProd:e=false,frontEndAppHeader:r})=>{if(r){if(/^@[a-z][a-z0-9-]*\/[a-z][a-z0-9-]*$/.test(r))try{const e=require.resolve(`${r}/package.json`,{paths:[process.cwd()]});if(e){const r=require(e);if(r.xtrem?.isFrontEndApp)return e}}catch(e){logger.warn(e)}logger.warn(`Invalid front-end app header value: ${r}`)}if(e)return require.resolve("@sage/xtrem-standalone/package.json");return require.resolve("@sage/xtrem-ui/package.json")}),getWebAppDir=(0,lodash_1.memoize)(e=>fsp.join(fsp.dirname(e),"build")),serveStaticXtremUi=(e=false,r,t,a=false)=>(logger.info("Xtrem front-end app deployed."),(s,o)=>{const i=getUiPackageJsonPath({isProd:e,frontEndAppHeader:s.header("X-XTREM-FRONT-END-APP")});let n=getWebAppDir(i);if(n.endsWith("src"))n=n.replace("src","dev-resources");const c=fsp.join(n,"index.html"),l=getUserCookiePreference(o.locals?.context?.pref);if(-1!==s.path.indexOf(".."))return void o.status(404).send();const d=fsp.join(n,s.path);(async()=>{if(d!==c&&await(0,xtrem_core_1.fileExists)(d)&&(await fs.stat(d)).isFile()){if(e)o.set("Cache-control",`public, max-age=${cachePeriod}`);else(0,util_1.setNoCacheHeaders)(o);o.sendFile(d)}else{const e={nonce:s.nonce,...r,preferences:l};o.type("html"),(0,util_1.setNoCacheHeaders)(o),o.send(await getIndexFileContent(c,e,t,a))}})().catch(e=>{logger.error(e),o.status(500).send()})});exports.serveStaticXtremUi=serveStaticXtremUi;const getUserCookiePreference=e=>{const r={loadPendo:false,loadNewRelic:false};if(!e)return r;switch(e){case 1:case 5:return r.loadPendo=true,r;case 3:case 7:return r.loadPendo=true,r.loadNewRelic=true,r;default:return r}};
//# sourceMappingURL=xtrem-ui-app.js.map