/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.csrfMiddleware=void 0;const xtrem_core_1=require("@sage/xtrem-core"),error_handlers_1=require("./error-handlers"),csrfMiddleware=(e,r,t)=>{if(csrfFilter(e))return(0,error_handlers_1.badRequest)(e,r);return t()};function reject(e,r){return(0,xtrem_core_1.logSecurityAlert)(e,"csrf",r),true}function csrfFilter(e){if(null!=e.query?.query)return reject(e,"graphql query parameter is set");if(0===e.rawHeaders.length)return reject(e,"no headers");if("POST"===e.method&&!e.is("application/json"))return reject(e,`bad content-type expecting 'application/json' got '${e.headers["content-type"]}'`);const r=e.headers["x-requested-with"];if((!r?[]:Array.isArray(r)?r:[r]).some(e=>/^ShockwaveFlash\//i.test(e||"")))return reject(e,"flash request");return csrfFilterOrigin(e)}function csrfFilterOrigin(e){if(/^api\|/.test(e.res?.locals?.auth?.auth0))return false;let r=e.headers.origin;if("null"===r){if(r=e.headers.referer,!r)return reject(e,"null origin with empty referer")}else if(!r)r=e.headers.referer;if(r){const t=new URL(r),s=e.headers["x-forwarded-host"],i=((Array.isArray(s)?s[0]:s)||e.headers.host)?.toLowerCase();if(t.host.toLowerCase()!==i)return reject(e,`Url host '${t.host}' does not fully match '${i}'. host='${e.headers.host}', x-forwarded-host='${s}'`)}return false}exports.csrfMiddleware=csrfMiddleware;
//# sourceMappingURL=csrf-middleware.js.map