import { Application } from '@sage/xtrem-core';
import { Express } from 'express';
import { HttpEndpoint, HttpEndpointConfig } from './http-endpoint';
/**
 * Represents an endpoint for interop GraphQl calls between apps.
 */
export declare class InteropEndpoint extends HttpEndpoint {
    /**
     * Configures the Express app with the interop middleware.
     *
     * @param expressApp - The Express app instance.
     */
    configureExpressApp(expressApp: Express): void;
    /**
     * Retrieves the configuration for the interop endpoint.
     * @returns The HTTP endpoint configuration or undefined if the configuration is missing or the endpoint is not enabled.
     */
    static getConfig(): HttpEndpointConfig | undefined;
    /**
     * Creates a new InteropEndpoint instance.
     *
     * @param application - The application to associate with the InteropEndpoint.
     * @returns The created InteropEndpoint instance, or undefined if the endpoint is not enabled.
     */
    static create(application: Application): InteropEndpoint | undefined;
}
//# sourceMappingURL=interop-endpoint.d.ts.map