/// <reference types="node" />
/// <reference types="node" />
/// <reference types="node" />
import { Application } from '@sage/xtrem-core';
import { Express } from 'express';
import * as http from 'http';
import * as https from 'https';
import { TlsOptions } from 'tls';
export interface HttpEndpointConfig {
    port: number;
    description: string;
    ssl?: TlsOptions;
    exclusive?: boolean;
    sendPortToParentProcess?: boolean;
}
/**
 * Base class for HTTP endpoints
 */
export declare abstract class HttpEndpoint {
    readonly application: Application;
    private readonly config;
    protected httpServer: http.Server | https.Server;
    protected constructor(application: Application, config: HttpEndpointConfig);
    /** The port number for the HTTP endpoint. */
    get port(): number;
    /** The description of the HTTP endpoint. */
    get description(): string;
    /**
     * Configures the Express app with the necessary middleware, routes, etc.
     * This method should be implemented by subclasses to provide the specific configuration.
     *
     * @param expressApp The Express app instance.
     */
    protected abstract configureExpressApp(expressApp: Express): void;
    /**
     * Sends the dynamic port allocated back to the parent process via the worker instance 'message' event listener.
     * This method is intended to be used in a worker process.
     * @param port The dynamic port allocated for the worker process.
     * @param workerId The ID of the worker process.
     */
    private static sendPortToParentProcess;
    /**
     * Starts the HTTP server and listens for incoming requests.
     * If SSL is enabled, it creates an HTTPS server, otherwise it creates an HTTP server.
     * If running in a worker process, it allocates a dynamic port, otherwise it uses the configured port.
     *
     * @returns A Promise that resolves when the server has started successfully.
     */
    start(): Promise<void>;
}
//# sourceMappingURL=http-endpoint.d.ts.map