/// <reference types="node" />
import { Application } from '@sage/xtrem-core';
import { Express } from 'express';
import * as http from 'http';
import { HttpEndpoint, HttpEndpointConfig } from './http-endpoint';
export declare class GraphqlEndpoint extends HttpEndpoint {
    configureExpressApp(expressApp: Express): this;
    private addStandardGraphqlRoutes;
    private addNotFoundMiddleware;
    addAllGraphqlRoutes(expressApp: Express): void;
    start(): Promise<void>;
    static getConfig(): HttpEndpointConfig;
    static create(application: Application): GraphqlEndpoint;
}
export declare const GraphqlEndpointHooks: {
    setAuthenticationMiddlewares(expressApp: Express, application: Application): void;
    addSpecialRoutes(_expressApp: Express, _application: Application): void;
    getRequestSource(_request: http.IncomingMessage): string;
    getRequestRoutingKey(_request: http.IncomingMessage): string;
    getSourcesToSeed(): string[];
    /**
     * Starts the websocket services.
     * This is done via a hook because x3-services should not load the xtrem-infrastucture-adapter dependency
     * @param _application
     */
    startWebSocketServices(_application: Application): void;
};
//# sourceMappingURL=graphql-endpoint.d.ts.map