import { LocalizeLocale } from '@sage/xtrem-shared';
import type { DatePropertyValue, DateTimePropertyValue } from './types';
export declare function pad2(val: number): string;
export declare function pad3(val: number): string;
/**
 * All i18n keys are individual records. Some of these records needs to function in a group i.e. days of the week and months.
 * @param baseResource string[] - see datetime/baseResource.ts
 * @param data object | any[] - default is any. Data for i18n value handlebars
 * @param i18nKey string - example: @sage/xtrem-date-time/datetime__abbreviatedDayName - NB! without the index. see datetime/i18n/en-US.json
 * @param locale LocalizeLocale - default is base
 * @returns string[] of localized semantic values
 */
export declare function localizedGroup(baseResource: readonly string[], i18nKey: string, data?: object | any[], locale?: LocalizeLocale): string[];
export declare const isStringDate: (value: any) => boolean;
export declare function datePropertyValueToDateString(value: null | undefined, keepTime?: boolean): null;
export declare function datePropertyValueToDateString(value: DatePropertyValue | DateTimePropertyValue, keepTime?: boolean): string;
export declare function datePropertyValueToDateString(value: DatePropertyValue | DateTimePropertyValue | null | undefined, keepTime?: boolean): string | null;
export declare function isValidDatePropertyValue(value: DatePropertyValue): boolean;
//# sourceMappingURL=utils.d.ts.map