/** @packageDocumentation @module dateRange */
import { DateValue } from './date';
import { Range } from './range';
export declare class DateRange extends Range<DateValue> {
    static parse: typeof parse;
    static isDateRange: typeof isDateRange;
    static make: typeof make;
    static getDayRange: typeof getDayRange;
    static getMonthRange: typeof getMonthRange;
    static getYearRange: typeof getYearRange;
    static getDateRange: typeof getDateRange;
    get constructorName(): string;
    get durationInDays(): number;
}
export declare function isDateRange(obj: any): obj is DateRange;
export declare function parse(str: string): DateRange;
export declare function make(start: DateValue | null, end: DateValue | null, excludesStart?: boolean, excludesEnd?: boolean): DateRange;
export declare function getDayRange(d: DateValue): DateRange;
export declare function getMonthRange(d: DateValue): DateRange;
export declare function getYearRange(d: DateValue): DateRange;
type AggFunc = 'year' | 'month' | 'day';
export declare function getDateRange({ date: d, range, }: {
    date: string;
    range: `same-${AggFunc}` | `previous-${AggFunc}` | `last-${7 | 30}-days`;
}): DateRange;
export {};
//# sourceMappingURL=date-range.d.ts.map