declare module '@sage/x3-manufacturing-data-api-partial' {
    import type {
        BusinessPartner,
        Package as SageX3MasterData$Package,
        Product,
        ProductSite,
        UnitOfMeasure,
        WeeklyStructure,
    } from '@sage/x3-master-data-api';
    import type {
        Package as SageX3ProjectManagementData$Package,
        ProjectLink,
    } from '@sage/x3-project-management-data-api';
    import type {
        LicensePlateNumber,
        Location,
        MajorVersionStatus,
        OverheadFormulaCodes,
        OverheadFormulaCodesBinding,
        OverheadFormulaCodesInput,
        Package as SageX3StockData$Package,
        StockStatus,
        Warehouse,
    } from '@sage/x3-stock-data-api';
    import type { Package as SageX3Structure$Package } from '@sage/x3-structure-api';
    import type {
        GenericPrintReport,
        MiscellaneousTable,
        Package as SageX3System$Package,
        Site,
        User,
    } from '@sage/x3-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        QueryOperation,
        ReadOperation,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface ActualOverheadCalculationBase$Enum {
        expected: 1;
        actual: 2;
    }
    export type ActualOverheadCalculationBase = keyof ActualOverheadCalculationBase$Enum;
    export interface Allergens$Enum {
        foodAllergensRollup: 1;
        allergensUpdatedTo: 2;
        youMustEnterAValidAllergen: 3;
        theSameAllergenCannotBeEnteredMoreThanOnce: 4;
        allergenCountExceedsTheTableLimitOf1: 5;
        unableToUpdateAllergensOnProduct1: 6;
        wouldYouLikeToRunAllergensRollupOnThisBillOfMaterials: 7;
    }
    export type Allergens = keyof Allergens$Enum;
    export interface AllocationMode$Enum {
        manual: 1;
        automaticGlobal: 2;
        automaticDetailed: 3;
    }
    export type AllocationMode = keyof AllocationMode$Enum;
    export interface AllocationPriority$Enum {
        woPriority: 1;
        weighingPriority: 2;
    }
    export type AllocationPriority = keyof AllocationPriority$Enum;
    export interface AllocationSorts$Enum {
        product: 1;
        allocationType: 2;
        lot: 3;
        location: 4;
        stockStatus: 5;
    }
    export type AllocationSorts = keyof AllocationSorts$Enum;
    export interface AnalysisDimensions$Enum {
        resources: 1;
        materials: 2;
        all: 3;
    }
    export type AnalysisDimensions = keyof AnalysisDimensions$Enum;
    export interface ApplyLinkQtyRounding$Enum {
        no: 1;
        basedOnBom: 2;
    }
    export type ApplyLinkQtyRounding = keyof ApplyLinkQtyRounding$Enum;
    export interface AuthorizedStatus$Enum {
        planned: 1;
        firm: 2;
        bySelection: 3;
    }
    export type AuthorizedStatus = keyof AuthorizedStatus$Enum;
    export interface AvailabilityBalance$Enum {
        available: 1;
        unavailable: 2;
        beingWeighed: 3;
        beingCalibrated: 4;
        defective: 5;
    }
    export type AvailabilityBalance = keyof AvailabilityBalance$Enum;
    export interface BaseFormulaToCalculateCost$Enum {
        amount: 1;
        hoursOperationsOrQuantities: 2;
    }
    export type BaseFormulaToCalculateCost = keyof BaseFormulaToCalculateCost$Enum;
    export interface BcType$Enum {
        fieldSeparator: 1;
        fixedLength: 2;
    }
    export type BcType = keyof BcType$Enum;
    export interface BiMfgLineType$Enum {
        header: 1;
        releasedProduct: 2;
        component: 3;
        operation: 4;
    }
    export type BiMfgLineType = keyof BiMfgLineType$Enum;
    export interface BomUse$Enum {
        manufacturing: 1;
        costing: 2;
        mrp: 3;
        mps: 4;
    }
    export type BomUse = keyof BomUse$Enum;
    export interface CalibrationCode$Enum {
        noCalibration: 1;
        numberOfDays: 2;
        numberOfWeighings: 3;
        numberOfDaysAndWeighings: 4;
        eachWeighing: 5;
    }
    export type CalibrationCode = keyof CalibrationCode$Enum;
    export interface CancellationMode$Enum {
        withReturn: 1;
        withoutReturn: 2;
    }
    export type CancellationMode = keyof CancellationMode$Enum;
    export interface ChargeCodeNoTranslation$Enum {
        ow: 1;
        or: 2;
    }
    export type ChargeCodeNoTranslation = keyof ChargeCodeNoTranslation$Enum;
    export interface ChargeType$Enum {
        manufacturingOperation: 1;
        macroOperation: 2;
    }
    export type ChargeType = keyof ChargeType$Enum;
    export interface ChoiceRelupd$Enum {
        none: 1;
        routing: 2;
        bom: 3;
        routingAndBom: 4;
    }
    export type ChoiceRelupd = keyof ChoiceRelupd$Enum;
    export interface Classification$Enum {
        bySite: 1;
        byProduct: 2;
        byOrderType: 3;
        byDocumentType: 4;
        byDate: 5;
        byRequirementDate: 6;
        byBp: 7;
    }
    export type Classification = keyof Classification$Enum;
    export interface ClosingControls$Enum {
        noControl: 1;
        blockingOutstandingMaterials: 2;
        blockingOutstandingOperations: 3;
        blockingOutstandingMaterialsAndOperations: 4;
    }
    export type ClosingControls = keyof ClosingControls$Enum;
    export interface ComponentTypes$Enum {
        plannedComponent: 1;
        nonPlannedComponent: 2;
    }
    export type ComponentTypes = keyof ComponentTypes$Enum;
    export interface ConsolidateLoad$Enum {
        bySite: 1;
        byWCGroup: 2;
        byWorkCenter: 3;
    }
    export type ConsolidateLoad = keyof ConsolidateLoad$Enum;
    export interface ControlTrackingPrevOp$Enum {
        no: 1;
        yesWithoutBlock: 2;
        yesWithBlock: 3;
    }
    export type ControlTrackingPrevOp = keyof ControlTrackingPrevOp$Enum;
    export interface ControlUponClosing$Enum {
        noBlocking: 1;
        blockingMaterialsOnHold: 2;
        blockingServiceOnHold: 3;
        blockingMaterialsAndServiceOnHold: 4;
    }
    export type ControlUponClosing = keyof ControlUponClosing$Enum;
    export interface CostLevelChoice$Enum {
        singleLevel: 1;
        multilevel: 2;
    }
    export type CostLevelChoice = keyof CostLevelChoice$Enum;
    export interface CostToCompare$Enum {
        standard: 1;
        revised: 2;
        budget: 3;
        simulated: 4;
        estimatedTheoretical: 5;
        estimatedRelease: 6;
        estimatedProduction: 7;
        estimatedCostPrice: 8;
    }
    export type CostToCompare = keyof CostToCompare$Enum;
    export interface CostType314$Enum {
        unit: 1;
        fixed: 2;
    }
    export type CostType314 = keyof CostType314$Enum;
    export interface CrystalReportsProduction$Enum {
        surcharge: 1;
    }
    export type CrystalReportsProduction = keyof CrystalReportsProduction$Enum;
    export interface CrystalReportsWoStatus$Enum {
        notStarted: 1;
        started: 2;
        all: 3;
    }
    export type CrystalReportsWoStatus = keyof CrystalReportsWoStatus$Enum;
    export interface DeallocationMode$Enum {
        complete: 1;
        byAllocationType: 2;
    }
    export type DeallocationMode = keyof DeallocationMode$Enum;
    export interface DefaultQuantity$Enum {
        none: 1;
        technicalLot: 2;
        economicLot: 3;
    }
    export type DefaultQuantity = keyof DefaultQuantity$Enum;
    export interface DeschedulingType$Enum {
        deschedule: 1;
        flagForReschedule: 2;
    }
    export type DeschedulingType = keyof DeschedulingType$Enum;
    export interface DimensionRateSelection$Enum {
        standard: 1;
        revisedStandard: 2;
        budget: 3;
        simulation: 4;
    }
    export type DimensionRateSelection = keyof DimensionRateSelection$Enum;
    export interface DisplayLevel$Enum {
        level1: 1;
        level2: 2;
        level3: 3;
    }
    export type DisplayLevel = keyof DisplayLevel$Enum;
    export interface EfficiencyApplication$Enum {
        setupRunTimes: 1;
        runTime: 2;
    }
    export type EfficiencyApplication = keyof EfficiencyApplication$Enum;
    export interface EmployeeActivitySort$Enum {
        employeeId: 1;
        activityType: 2;
        startDate: 3;
        endDate: 4;
        workOrder: 5;
        indirectReferences: 6;
        numberOfJobs: 7;
    }
    export type EmployeeActivitySort = keyof EmployeeActivitySort$Enum;
    export interface EnterMeasurement$Enum {
        mandatory: 1;
        optional: 2;
        prohibited: 3;
    }
    export type EnterMeasurement = keyof EnterMeasurement$Enum;
    export interface EntryMode9641$Enum {
        byWeighingNumber: 1;
        complete: 2;
    }
    export type EntryMode9641 = keyof EntryMode9641$Enum;
    export interface EntryType2376$Enum {
        creation: 1;
        modification: 2;
        all: 3;
    }
    export type EntryType2376 = keyof EntryType2376$Enum;
    export interface EntryUnit$Enum {
        unitOfOperation: 1;
        unitOfStock: 2;
    }
    export type EntryUnit = keyof EntryUnit$Enum;
    export interface Enum9154$Enum {
        automatic: 1;
        manual: 2;
        no: 3;
    }
    export type Enum9154 = keyof Enum9154$Enum;
    export interface ExclusiveCodes$Enum {
        timeOff: 1;
        break: 2;
        nonExclusiveLabor: 3;
        exclusiveLabor: 4;
        autoBreak: 5;
    }
    export type ExclusiveCodes = keyof ExclusiveCodes$Enum;
    export interface ExpectedMaterialCostingPric$Enum {
        standardPrice: 1;
        revisedStandardPrice: 2;
        lastPrice: 3;
        averageWeightedPrice: 4;
    }
    export type ExpectedMaterialCostingPric = keyof ExpectedMaterialCostingPric$Enum;
    export interface FdmaRecalculation$Enum {
        forWorkOrdersInclStatusBeingOptimized: 1;
        forWorkOrdersInclStatusOptimized: 2;
        forWorkOrdersInclStatusInProgress: 3;
    }
    export type FdmaRecalculation = keyof FdmaRecalculation$Enum;
    export interface Filter2373$Enum {
        completeOrClose: 1;
        complete: 2;
        close: 3;
    }
    export type Filter2373 = keyof Filter2373$Enum;
    export interface FilterOperations$Enum {
        notClosed: 1;
        closed: 2;
        all: 3;
    }
    export type FilterOperations = keyof FilterOperations$Enum;
    export interface FilterType$Enum {
        none: 1;
        nonexclusiveFilter: 2;
        exclusiveFilter: 3;
    }
    export type FilterType = keyof FilterType$Enum;
    export interface Filter$Enum {
        notClosed: 1;
        closed: 2;
        all: 3;
    }
    export type Filter = keyof Filter$Enum;
    export interface FixedCostDistributionMode$Enum {
        proRata: 1;
        total: 2;
    }
    export type FixedCostDistributionMode = keyof FixedCostDistributionMode$Enum;
    export interface FixedOverheadHeadings$Enum {
        fixedA: 1;
        fixedB: 2;
        fixedC: 3;
        fixedD: 4;
    }
    export type FixedOverheadHeadings = keyof FixedOverheadHeadings$Enum;
    export interface Frequency2305$Enum {
        dayS: 1;
        weekS: 2;
        months: 3;
    }
    export type Frequency2305 = keyof Frequency2305$Enum;
    export interface GroupCostReport$Enum {
        material: 1;
        machine: 2;
        labor: 3;
        subcontracting: 4;
        overheadCosts: 5;
        calculatedCost: 6;
    }
    export type GroupCostReport = keyof GroupCostReport$Enum;
    export interface HistoricalSort$Enum {
        byDate: 1;
        byQuantity: 2;
    }
    export type HistoricalSort = keyof HistoricalSort$Enum;
    export interface IndirectAccess$Enum {
        user: 1;
        supervisor: 2;
    }
    export type IndirectAccess = keyof IndirectAccess$Enum;
    export interface LabelPrinting2334$Enum {
        noPrinting: 1;
        notPrinted: 2;
        printed: 3;
        rePrinted: 4;
    }
    export type LabelPrinting2334 = keyof LabelPrinting2334$Enum;
    export interface LabelingMode$Enum {
        manual: 1;
        automatic: 2;
    }
    export type LabelingMode = keyof LabelingMode$Enum;
    export interface LaborRateChoice$Enum {
        workCenterRate: 1;
        operatorRate: 2;
        operatorElseWorkCenter: 3;
    }
    export type LaborRateChoice = keyof LaborRateChoice$Enum;
    export interface LaunchingMode$Enum {
        full: 1;
        materialsOnly: 2;
        operationsOnly: 3;
        all: 4;
    }
    export type LaunchingMode = keyof LaunchingMode$Enum;
    export interface LinkType$Enum {
        completeOrder: 1;
        releasedProduct: 2;
    }
    export type LinkType = keyof LinkType$Enum;
    export interface LoadClassification$Enum {
        byStartDate: 1;
        byWorkCenterGroup: 2;
        byWorkCenter: 3;
        byWorkOrder: 4;
        byLoadType: 5;
        byStatus: 6;
    }
    export type LoadClassification = keyof LoadClassification$Enum;
    export interface LoadReport$Enum {
        notScheduled: 1;
        scheduled: 2;
    }
    export type LoadReport = keyof LoadReport$Enum;
    export interface LotChoice$Enum {
        no: 1;
        yesWithControl: 2;
        yes: 3;
    }
    export type LotChoice = keyof LotChoice$Enum;
    export interface LotCreationMode$Enum {
        noStockRulesApplied: 1;
        inPlanning: 2;
        inRelease: 3;
        atFirstTracking: 4;
    }
    export type LotCreationMode = keyof LotCreationMode$Enum;
    export interface LotMix$Enum {
        yes: 1;
        notInWeighing: 2;
        notInManufacture: 3;
    }
    export type LotMix = keyof LotMix$Enum;
    export interface MaterialAccumulation$Enum {
        noAccumulation: 1;
        accumulationUponRelease: 2;
        accumulationUponTracking: 3;
    }
    export type MaterialAccumulation = keyof MaterialAccumulation$Enum;
    export interface MaterialAllocationStatus$Enum {
        none: 1;
        globalWithShortage: 2;
        global: 3;
        detailedWithShortage: 4;
        detailed: 5;
    }
    export type MaterialAllocationStatus = keyof MaterialAllocationStatus$Enum;
    export interface MaterialConsumptionMode$Enum {
        forExpectedQuantityOnFirstTrack: 1;
        byQuantityProducedLimited: 2;
        byQuantityProducedUnlimited: 3;
    }
    export type MaterialConsumptionMode = keyof MaterialConsumptionMode$Enum;
    export interface MaterialConsumption$Enum {
        no: 1;
        yesManual: 2;
        yesAutomatic: 3;
        yesManualAndAutomatic: 4;
    }
    export type MaterialConsumption = keyof MaterialConsumption$Enum;
    export interface MaterialCostSelection$Enum {
        standardCost: 1;
        revisedStandardCost: 2;
        budgetCost: 3;
        simulatedCost: 4;
        lastCost: 5;
        averageCost: 6;
        lastPurchasePrice: 7;
        listPrice: 8;
    }
    export type MaterialCostSelection = keyof MaterialCostSelection$Enum;
    export interface MaterialListLoading$Enum {
        whenEnteringFunctionWeighingByMaterial: 1;
        beforeEachLoading: 2;
    }
    export type MaterialListLoading = keyof MaterialListLoading$Enum;
    export interface MaterialReconciliation$Enum {
        byWorkOrder: 1;
        byPhase: 2;
        byContainer: 3;
    }
    export type MaterialReconciliation = keyof MaterialReconciliation$Enum;
    export interface MaterialSortCriteria$Enum {
        byDate: 1;
        byComponent: 2;
        byWorkOrder: 3;
        byFinishedProduct: 4;
        lot: 5;
    }
    export type MaterialSortCriteria = keyof MaterialSortCriteria$Enum;
    export interface MaterialSort$Enum {
        byProduct: 1;
        byOperationProduct: 2;
        byReservationDateProduct: 3;
        bySequenceProduct: 4;
    }
    export type MaterialSort = keyof MaterialSort$Enum;
    export interface MaterialValuationPricePr$Enum {
        standardCost: 1;
        revisedStandardCost: 2;
        lastCost: 3;
        averageCost: 4;
        transactionCost: 5;
    }
    export type MaterialValuationPricePr = keyof MaterialValuationPricePr$Enum;
    export interface MethodOfCorrection$Enum {
        lot: 1;
        allocation: 2;
    }
    export type MethodOfCorrection = keyof MethodOfCorrection$Enum;
    export interface ModeSelection$Enum {
        no: 1;
        manual: 2;
        automatic: 3;
    }
    export type ModeSelection = keyof ModeSelection$Enum;
    export interface ModeType$Enum {
        toBeCompleted: 1;
        complete: 2;
    }
    export type ModeType = keyof ModeType$Enum;
    export interface MrpMessage$Enum {
        noAction: 1;
        advance: 2;
        delay: 3;
        increase: 4;
        reduce: 5;
        cancel: 6;
        advanceIncrease: 7;
        advanceReduce: 8;
        delayIncrease: 9;
        delayReduce: 10;
        delayFirmHorizon: 11;
        obsoleteProductEndOfLife: 12;
        overstock: 13;
        invalidRoutingVersion: 14;
    }
    export type MrpMessage = keyof MrpMessage$Enum;
    export interface MtoNetworkSort$Enum {
        byWo: 1;
        bySite: 2;
        byEndDate: 3;
    }
    export type MtoNetworkSort = keyof MtoNetworkSort$Enum;
    export interface NewStatus$Enum {
        planned: 1;
        firm: 2;
    }
    export type NewStatus = keyof NewStatus$Enum;
    export interface OhType$Enum {
        asPerContext: 1;
        material: 2;
        machine: 3;
        labor: 4;
        subcontracting: 5;
    }
    export type OhType = keyof OhType$Enum;
    export interface OperationSortCriteria$Enum {
        expectedCompletionDate: 1;
        workOrder: 2;
        releasedProduct: 3;
        workCenter: 4;
    }
    export type OperationSortCriteria = keyof OperationSortCriteria$Enum;
    export interface OperationStatus$Enum {
        pending: 1;
        previousOperationInProcess: 2;
        previousOperationClosed: 3;
        inProcess: 4;
        closed: 5;
        excluded: 6;
        ordered: 7;
    }
    export type OperationStatus = keyof OperationStatus$Enum;
    export interface OperationTimeCodes$Enum {
        timeFor1: 1;
        timeFor100: 2;
        timeFor1000: 3;
        timePerLot: 4;
    }
    export type OperationTimeCodes = keyof OperationTimeCodes$Enum;
    export interface OptimizationMethod$Enum {
        prepareDataGantt: 1;
        prepareData: 2;
        gantt: 3;
        updateTheResults: 4;
    }
    export type OptimizationMethod = keyof OptimizationMethod$Enum;
    export interface OptimizationPriorities$Enum {
        woPriorityCode: 1;
        forcedOperation: 2;
        displacedOperation: 3;
        firmStatus: 4;
        plannedStatus: 5;
        suggestedStatus: 6;
    }
    export type OptimizationPriorities = keyof OptimizationPriorities$Enum;
    export interface OrderMnemonicsNoTranslate$Enum {
        so: 1;
        po: 2;
        ms: 3;
        sc: 4;
        wo: 5;
        mw: 6;
        tr: 7;
        tp: 8;
        bw: 9;
        vd: 10;
        vr: 11;
        cr: 12;
        eo: 13;
        mt: 14;
    }
    export type OrderMnemonicsNoTranslate = keyof OrderMnemonicsNoTranslate$Enum;
    export interface OrderStatusNoTranslate$Enum {
        f: 1;
        p: 2;
        s: 3;
        c: 4;
    }
    export type OrderStatusNoTranslate = keyof OrderStatusNoTranslate$Enum;
    export interface OrderType$Enum {
        suggestedWorkOrder: 1;
        workOrder: 2;
        allTypes: 3;
    }
    export type OrderType = keyof OrderType$Enum;
    export interface OrdersToBeProcessed$Enum {
        workOrdersSuggested: 1;
        workOrdersPlanned: 2;
    }
    export type OrdersToBeProcessed = keyof OrdersToBeProcessed$Enum;
    export interface OriginOfSuggestions$Enum {
        mps: 1;
        mrp: 2;
        all: 3;
    }
    export type OriginOfSuggestions = keyof OriginOfSuggestions$Enum;
    export interface OverheadApplicationMethod$Enum {
        stockReceipt: 1;
        stockIssue: 2;
    }
    export type OverheadApplicationMethod = keyof OverheadApplicationMethod$Enum;
    export interface OverheadCalculationMethod$Enum {
        cumulated: 1;
        compound: 2;
    }
    export type OverheadCalculationMethod = keyof OverheadCalculationMethod$Enum;
    export interface OverheadFormulaHeadings$Enum {
        formulaA: 1;
        formulaB: 2;
        formulaC: 3;
        formulaD: 4;
    }
    export type OverheadFormulaHeadings = keyof OverheadFormulaHeadings$Enum;
    export interface ParameterApplicationType$Enum {
        no: 1;
        yesNonExclusive: 2;
        yesExclusive: 3;
    }
    export type ParameterApplicationType = keyof ParameterApplicationType$Enum;
    export interface Parity$Enum {
        noParity: 1;
        oddParity: 2;
        evenParity: 3;
    }
    export type Parity = keyof Parity$Enum;
    export interface PrintWorkOrderDocuments$Enum {
        optional: 1;
        mandatory: 2;
    }
    export type PrintWorkOrderDocuments = keyof PrintWorkOrderDocuments$Enum;
    export interface Priority$Enum {
        normal: 1;
        urgent: 2;
        veryUrgent: 3;
    }
    export type Priority = keyof Priority$Enum;
    export interface ProcedureTypesBox$Enum {
        openingOfBox: 1;
        emptyBoxAtEndOfWorkOrder: 2;
        emptyBoxAtEndOfPhase: 3;
    }
    export type ProcedureTypesBox = keyof ProcedureTypesBox$Enum;
    export interface ProcessStartControl$Enum {
        byWorkOrder: 1;
        byPhase: 2;
        byWeighing: 3;
    }
    export type ProcessStartControl = keyof ProcessStartControl$Enum;
    export interface ProcessType2304$Enum {
        completeWorkOrder: 1;
        workOrderOperationOnly: 2;
        workOrderReleasedProductOnly: 3;
        workOrderMaterialConsumptionOnly: 4;
        routing: 5;
        routingOperationOnly: 6;
        routingProductReleasedOnly: 7;
        bomMaterialOnly: 8;
        miscellaneousTimes: 9;
        trackingOfUnplannedWorkOrderOperation: 10;
        trackingOfUnplannedRoutingOperation: 11;
        trackingOfUnplannedWorkOrderMaterial: 12;
        trackingOfUnplannedBomMaterial: 13;
        returnOfWorkOrderMaterial: 14;
        returnOfUnplannedMaterial: 15;
        bomReintegration: 16;
        bomReintegrationOnNonPlannedMaterial: 17;
    }
    export type ProcessType2304 = keyof ProcessType2304$Enum;
    export interface ProcessingMode372$Enum {
        manual: 1;
        automatic: 2;
    }
    export type ProcessingMode372 = keyof ProcessingMode372$Enum;
    export interface ProcessingMode395$Enum {
        update: 1;
        simulation: 2;
        inquiry: 3;
    }
    export type ProcessingMode395 = keyof ProcessingMode395$Enum;
    export interface ProdSchedOperationFields$Enum {
        laborCenter: 1;
        technicalSheet: 2;
        operationPlanNumber: 3;
        fixture: 4;
        program: 5;
        groupingCriteria: 6;
        distinctionCriteria: 7;
    }
    export type ProdSchedOperationFields = keyof ProdSchedOperationFields$Enum;
    export interface ProductAnalysis$Enum {
        overdue: 1;
        leadTime: 2;
        time: 3;
        operationalYield: 4;
        materialYield: 5;
    }
    export type ProductAnalysis = keyof ProductAnalysis$Enum;
    export interface ProductCode$Enum {
        routing: 1;
        product: 2;
    }
    export type ProductCode = keyof ProductCode$Enum;
    export interface ProductRecontrolInStation$Enum {
        no: 1;
        lot: 2;
        productCodeLot: 3;
        lotSublot: 4;
        productCodeLotSublot: 5;
    }
    export type ProductRecontrolInStation = keyof ProductRecontrolInStation$Enum;
    export interface ProductSortCriteria$Enum {
        byDate: 1;
        byWorkOrder: 2;
        byProduct: 3;
    }
    export type ProductSortCriteria = keyof ProductSortCriteria$Enum;
    export interface ProductionCostDetailTitles$Enum {
        materialTotal: 1;
        componentMachineSubtotal: 2;
        machineTotal: 3;
        componentLaborSubtotal: 4;
        laborTotal: 5;
        componentSubcontractSubtotal: 6;
        subcontractTotal: 7;
        materialOverheadCost: 8;
        machineOverheadCost: 9;
        laborOverheadCost: 10;
        subcontractOverheadCost: 11;
        componentOverheadCost: 12;
        overheadCostTotal: 13;
        totalManufactureCost: 14;
        componentMaterialSubtotal: 15;
        serviceOverheadCost: 16;
        subcontractTotalCost: 17;
        invoicingElementTotal: 18;
    }
    export type ProductionCostDetailTitles = keyof ProductionCostDetailTitles$Enum;
    export interface ProductionCostPrintDetail$Enum {
        header: 1;
        materialDetail: 2;
        operationDetail: 3;
        subTotal: 4;
        overheadCostSummary: 5;
        total: 6;
        releasedOrderSummary: 7;
        closedReleasedOrderSummary: 8;
    }
    export type ProductionCostPrintDetail = keyof ProductionCostPrintDetail$Enum;
    export interface ProductionCostReport$Enum {
        none: 1;
        detail: 2;
        summary: 3;
    }
    export type ProductionCostReport = keyof ProductionCostReport$Enum;
    export interface ProductionCostSorting$Enum {
        byDate: 1;
        byOrderNumber: 2;
        byActualAmount: 3;
        byVariancePercentage: 4;
        byType: 5;
        byActualQuantity: 6;
    }
    export type ProductionCostSorting = keyof ProductionCostSorting$Enum;
    export interface ProductionDocuments$Enum {
        workOrder: 1;
        suggestedWorkOrder: 2;
        productionTracking: 3;
        preparation: 4;
        operationWip: 5;
        operationSuggestion: 6;
        wipValuationWithoutWorkOrder: 7;
    }
    export type ProductionDocuments = keyof ProductionDocuments$Enum;
    export interface ProductionOrderProcessed$Enum {
        inProgress: 1;
        closed: 2;
    }
    export type ProductionOrderProcessed = keyof ProductionOrderProcessed$Enum;
    export interface ProductionSchedulerWoFields$Enum {
        customerNameAndNumber: 1;
        customerName: 2;
        projectAndTaskNumber: 3;
        productCategory: 4;
        productLine: 5;
        statisticalAnalysis1: 6;
        statisticalAnalysis2: 7;
        statisticalAnalysis3: 8;
        salesOrderNumber: 9;
    }
    export type ProductionSchedulerWoFields = keyof ProductionSchedulerWoFields$Enum;
    export interface ProductionStatus$Enum {
        pending: 1;
        inProcess: 2;
        completed: 3;
        cancelled: 4;
    }
    export type ProductionStatus = keyof ProductionStatus$Enum;
    export interface ProjectCode$Enum {
        project: 1;
        document: 2;
    }
    export type ProjectCode = keyof ProjectCode$Enum;
    export interface ProvisionalCostPrint$Enum {
        no: 1;
        report: 2;
        trace: 3;
        reportAndTrace: 4;
    }
    export type ProvisionalCostPrint = keyof ProvisionalCostPrint$Enum;
    export interface ProvisionalCostType$Enum {
        theoretical: 1;
        release: 2;
        production: 3;
    }
    export type ProvisionalCostType = keyof ProvisionalCostType$Enum;
    export interface PsFdmaRecalculation$Enum {
        forWorkOrdersInclStatusBeingOptimized: 1;
        forWorkOrdersInclStatusOptimized: 2;
        forWorkOrdersInclStatusInProgress: 3;
    }
    export type PsFdmaRecalculation = keyof PsFdmaRecalculation$Enum;
    export interface QuantityType2311$Enum {
        active: 1;
        physical: 2;
    }
    export type QuantityType2311 = keyof QuantityType2311$Enum;
    export interface ReasonForReprint$Enum {
        printerUnavailable: 1;
        endOfRoller: 2;
        formatError: 3;
        labelIllegible: 4;
    }
    export type ReasonForReprint = keyof ReasonForReprint$Enum;
    export interface ReleaseMode$Enum {
        complete: 1;
        materialsOnly: 2;
        operationsOnly: 3;
    }
    export type ReleaseMode = keyof ReleaseMode$Enum;
    export interface ReportAllocationSorting$Enum {
        product: 1;
        lot: 2;
        location: 3;
        identifier1: 4;
        identifier2: 5;
        default: 6;
    }
    export type ReportAllocationSorting = keyof ReportAllocationSorting$Enum;
    export interface ResourceAnalysis$Enum {
        resourceUse: 1;
        resourceYield: 2;
    }
    export type ResourceAnalysis = keyof ResourceAnalysis$Enum;
    export interface ResultStandarization$Enum {
        correct: 1;
        incorrect: 2;
    }
    export type ResultStandarization = keyof ResultStandarization$Enum;
    export interface RoleOfTheTransaction$Enum {
        materialIssue: 1;
        materialReturn: 2;
    }
    export type RoleOfTheTransaction = keyof RoleOfTheTransaction$Enum;
    export interface RoutingModificationType$Enum {
        modifyOperation: 1;
        modifyStandardOperation: 2;
        addOperation: 3;
        deleteOperation: 4;
    }
    export type RoutingModificationType = keyof RoutingModificationType$Enum;
    export interface RoutingUse$Enum {
        production: 1;
        cost: 2;
        rccp: 3;
    }
    export type RoutingUse = keyof RoutingUse$Enum;
    export interface RunTimeType$Enum {
        proportional: 1;
        rate: 2;
        fixed: 3;
    }
    export type RunTimeType = keyof RunTimeType$Enum;
    export interface SalesOrderAllocationType$Enum {
        shortagesGlobal: 1;
        global: 2;
        shortagesDetailed: 3;
        detailed: 4;
    }
    export type SalesOrderAllocationType = keyof SalesOrderAllocationType$Enum;
    export interface ScheduleType$Enum {
        none: 1;
        normalTracking: 2;
        range: 3;
    }
    export type ScheduleType = keyof ScheduleType$Enum;
    export interface ScheduleValidated$Enum {
        schedulingToComplete: 1;
        schedulingValid: 2;
    }
    export type ScheduleValidated = keyof ScheduleValidated$Enum;
    export interface SchedulingCode$Enum {
        absoluteSuccessor: 1;
        overlappingWaitLots: 2;
        overlappingWaitTime: 3;
        overlappingWaitQuantity: 4;
        startSynchronization: 5;
        endSynchronization: 6;
        allOrderOperationsParallel: 7;
        subcontractSynchronization: 8;
        simpleSuccessor: 9;
    }
    export type SchedulingCode = keyof SchedulingCode$Enum;
    export interface SchedulingMode$Enum {
        backward: 1;
        forward: 2;
    }
    export type SchedulingMode = keyof SchedulingMode$Enum;
    export interface SchedulingProcess$Enum {
        scheduling: 1;
        rescheduling: 2;
        all: 3;
    }
    export type SchedulingProcess = keyof SchedulingProcess$Enum;
    export interface SchedulingStatus$Enum {
        notScheduled: 1;
        scheduled: 2;
        reschedule: 3;
        optimized: 4;
    }
    export type SchedulingStatus = keyof SchedulingStatus$Enum;
    export interface SelHistType$Enum {
        supplierOrder: 1;
        workOrder: 2;
        customerOrder: 3;
        purchaseOrderTransfer: 4;
        workOrderTransfer: 5;
    }
    export type SelHistType = keyof SelHistType$Enum;
    export interface SelectLeadTime$Enum {
        product: 1;
        routing: 2;
    }
    export type SelectLeadTime = keyof SelectLeadTime$Enum;
    export interface SelectManagementMethod$Enum {
        onStock: 1;
        byOrder: 2;
        all: 3;
    }
    export type SelectManagementMethod = keyof SelectManagementMethod$Enum;
    export interface SelectSchedulingMode$Enum {
        backward: 1;
        forward: 2;
        bySelection: 3;
    }
    export type SelectSchedulingMode = keyof SelectSchedulingMode$Enum;
    export interface SelectionOrder$Enum {
        startingDate: 1;
        priorityCode: 2;
    }
    export type SelectionOrder = keyof SelectionOrder$Enum;
    export interface SemiFinalValuationPriceP$Enum {
        standardCost: 1;
        revisedStandardCost: 2;
    }
    export type SemiFinalValuationPriceP = keyof SemiFinalValuationPriceP$Enum;
    export interface Separator$Enum {
        point: 1;
        comma: 2;
    }
    export type Separator = keyof Separator$Enum;
    export interface SequenceTheWeighingPlan$Enum {
        site: 1;
        product: 2;
        startDate: 3;
    }
    export type SequenceTheWeighingPlan = keyof SequenceTheWeighingPlan$Enum;
    export interface SerialNumberLinkStatus$Enum {
        new: 1;
        inProgress: 2;
        complete: 3;
    }
    export type SerialNumberLinkStatus = keyof SerialNumberLinkStatus$Enum;
    export interface SetupTimeType$Enum {
        cumulative: 1;
        maximum: 2;
    }
    export type SetupTimeType = keyof SetupTimeType$Enum;
    export interface ShopFloorActivities$Enum {
        clockInOut: 1;
        indirect: 2;
        break: 3;
        setup: 4;
        run: 5;
    }
    export type ShopFloorActivities = keyof ShopFloorActivities$Enum;
    export interface ShopFloorTracking$Enum {
        employeeId1AlreadyClockedIntoATask: 1;
        setupRunStartOperationSFailed: 2;
        operationStopFailed: 3;
        operationStartFailed: 4;
        restartOperationSFailed: 5;
        errorUpdatingNumberOfJobs: 6;
        selectedOperationSHasAnActiveSetupDoYouWantToStopTheSetupToStartRunActivity: 7;
        indirectReferences: 8;
        breaks: 9;
        errorCreating1Transaction: 10;
        onlyOneBreakOrExclusiveLaborTransactionAllowedAtATime: 11;
        employeeId1NotClockedIn: 12;
        errorStopping1Transaction: 13;
        employeeId1AlreadyClockedIn: 14;
        clockInTransactionsMustBeByEmployee: 15;
        transactionHasAlreadyEnded: 16;
        errorCreatingAutoBreakTransactions: 17;
        employeeOnABreakOrExclusiveTask: 18;
        recordSkippedDueToBreakOrExclusiveIndirect: 19;
        errorInValidation: 20;
        errorReadingRecord: 21;
        workOrderIsNotFirm: 22;
        errorWritingRecord: 23;
        errorUpdatingRecord: 24;
        rejectedQtyCannotBeMoreThanCompletedQty: 25;
        siteNotValidForSelectedWorkCenterOrWorkCenterGroup: 26;
        workCenterGroupNotValidForSelectedSiteOrWorkCenter: 27;
        workCenterNotValidForSelectedSiteOrWorkCenterGroup: 28;
        invalidWorkCenterType: 29;
        machineIncludedIsRequiredForThisOperation: 30;
        errorOpeningOperation1: 31;
        errorInTrackingCreation: 32;
        trackingRecordNotGenerated: 33;
        noSetupOrRunDurationHasBeenEnteredDoYouWantToContinue: 34;
        shiftDateIsGreaterThanStartDate: 35;
        workOrderIsNotAllocated: 36;
        displayLimitReached1: 37;
        shiftDateIsGreaterThanEndDate: 38;
        startOrEndDateIsMandatory: 39;
        userAlreadyUsedOnEmployeeId1: 40;
        invalidIndirectReferences: 41;
        laborEntryValidation: 42;
        recordSkippedDueToAPreviousFailure: 43;
        laborCenterDoesNotExistAtTheSite: 44;
        thisActivityHasSuspendedTransactionsAssociatedWithItDoYouWantToReopenThoseTransactions: 45;
        isNotALaborCenter: 46;
        substituteValue47: 47;
        laborCenterIsRequired: 48;
        laborCenterCannotBeEnteredIfThePreviousValueIsBlank: 49;
        operationStatusCannotBeClosedExcludedOrOrdered: 50;
        workOrderDoesNotExistAtTheSite: 51;
        workCenterTypeCannotBeSubcontract: 52;
        employeeIsInactiveCurrentDateIsPastTheEmployeesInactiveDate: 53;
        employeeId1IsInactive: 54;
        laborCenterTypeCannotBeSubcontract: 55;
        activeDateIsAfterOrEqualToInactiveDate: 56;
        inactiveDateIsBeforeOrEqualToActiveDate: 57;
        pleaseCreateShiftEndTime: 58;
        pleaseCreateShiftStartTime: 59;
        breakCannotEndBeforeShiftStarts: 60;
        breakCannotEndAfterShiftEnds: 61;
        breakEndTimeHasToBeAfterStartTime: 62;
        notAnAutobreak: 63;
        breakCannotStartBeforeShiftStarts: 64;
        breakCannotStartAfterShiftEnds: 65;
        breakStartTimeHasToBeBeforeEndTime: 66;
        errorDeletingRecord: 67;
        reloadTheTableAndCancelTheModifications: 68;
        invalidBreak: 69;
        employeeId1HasUnpostedShopFloorTrackingActivities: 70;
        substituteValue71: 71;
        breakMustStartAfterThePreviousBreak: 72;
        substituteValue73: 73;
        substituteValue74: 74;
        employeeClockInOutIsNotEnabledForThisSite: 75;
        employeeId1IsADetailedTeam: 76;
        substituteValue77: 77;
        substituteValue78: 78;
        substituteValue79: 79;
        substituteValue80: 80;
        substituteValue81: 81;
        substituteValue82: 82;
        operationAlreadyStarted: 83;
        operationClosed: 84;
        runInProcessForTheSelectedOperation: 85;
        openIndirects: 86;
        substituteValue87: 87;
        setupInProcessForTheSelectedOperation: 88;
        employeeId1DoesNotHaveAccessToElapsedLabor: 89;
        elapsed1TimeCreated: 90;
        durationOrCompletedQtyIsMandatoryForElapsedRecords: 91;
        durationIsMandatoryForElapsedRecords: 92;
        substituteValue93: 93;
        employeeTypeFieldCannotBeModifiedWhenShopFloorTrackingTransactionsExist: 94;
        teamHasShopFloorTrackingTransactionsModifyingNumberOfEmployeesWillNotAffectExistingTransactions: 95;
        substituteValue96: 96;
        substituteValue97: 97;
        substituteValue98: 98;
        shiftCodeAssignedToTheEmployeeDoesNotMatchTeamShiftCode: 99;
        employeeTypeCannotBeModifiedWhenTeamRecordsExist: 100;
        employeeTypeCannotBeModifiedWhenEmployeeIsPartOfATeam: 101;
        shiftCodeCannotBeModifiedWhenEmployeeIsPartOfATeam: 102;
        shiftCodeHasBeenUpdatedForTheTeamAndTheEmployeesAssignedToTheTeam: 103;
        employeeHasOpenActivitiesDoYouWantToStopAllOfTheEmployeesActivities: 104;
        employeeCannotBeAddedToTheTeam: 105;
        employeeIsCurrentlyPartOfTeam1DoYouWantToRemoveFromTeam2: 106;
        employeeHasOpenActivitiesOnATeamDoYouWantToStopAllOfTheEmployeesActivities: 107;
        employeeIsAlreadyPartOfAnotherTeam: 108;
        shopFloorTrackingTransactionsExistThisChangeCouldModifyTheBehaviorOfTheTransactionsDoYouWantToContinue: 109;
        team1DoesNotHaveAnyTeamMembersAvailableToStartAnActivity: 110;
        theSitesClockInOutParameter1MustBeActivatedForDetailedTeamEmployeeType: 111;
        openActivitiesHaveBeenStoppedTransactionsHaveBeenReopenedWithNewNumberOfEmployees: 112;
        deletingAMachineRecordWillAlsoDeleteTheLaborRecordsAssociatedWithTheMachine: 113;
        numberOfMachinesMustBeZeroWhenPrimaryWorkCenterTypeIsLabor: 114;
        onlyEmployeeAndSummaryTeamRecordsCanBeEntered: 115;
        employee1IsNowIncludedInTeam2Activities: 116;
        deletingAMachineRecordWillAlsoDeleteTheLaborAndMachineRecordsAssociatedWithTheMachine: 117;
        employee1IsNotOnTeam2: 118;
        substituteValue119: 119;
        siteAssignedToTheEmployeeDoesNotMatchTeamSite: 120;
        summaryTeamOnABreakOrExclusiveTask: 121;
        detailedTeamOnABreakOrExclusiveTask: 122;
    }
    export type ShopFloorTracking = keyof ShopFloorTracking$Enum;
    export interface SlackTimeCompression$Enum {
        none: 1;
        waitingTime: 2;
        preparationPostRunTimes: 3;
        allSlackTime: 4;
        preparationTime: 5;
        postRunTime: 6;
        preparationWaitingTimes: 7;
        postRunWaitingTimes: 8;
    }
    export type SlackTimeCompression = keyof SlackTimeCompression$Enum;
    export interface SortAllocations$Enum {
        byRequirementDate: 1;
        byPriority: 2;
        byProduct: 3;
        byShortageType: 4;
        lot: 5;
        location: 6;
        status: 7;
    }
    export type SortAllocations = keyof SortAllocations$Enum;
    export interface SortBookedTimes$Enum {
        byTrackingNumber: 1;
        byTrackingDate: 2;
        byWorkOrderNumber: 3;
        byWorkCenter: 4;
    }
    export type SortBookedTimes = keyof SortBookedTimes$Enum;
    export interface SortComponentWeighingSituat$Enum {
        workOrder: 1;
        phase: 2;
        component: 3;
        weighingSituation: 4;
    }
    export type SortComponentWeighingSituat = keyof SortComponentWeighingSituat$Enum;
    export interface SortCriteria2370$Enum {
        byDate: 1;
        byWorkOrder: 2;
    }
    export type SortCriteria2370 = keyof SortCriteria2370$Enum;
    export interface SortMaterialConsumptions$Enum {
        byTrackingNumber: 1;
        byTrackingDate: 2;
        byWorkOrderNumber: 3;
        byProduct: 4;
    }
    export type SortMaterialConsumptions = keyof SortMaterialConsumptions$Enum;
    export interface SortSubContract$Enum {
        byWorkOrder: 1;
        byWorkCenter: 2;
        byProduct: 3;
        byOrder: 4;
        byOrderDate: 5;
    }
    export type SortSubContract = keyof SortSubContract$Enum;
    export interface SortWeighingSituationHistor$Enum {
        workOrder: 1;
        phase: 2;
        component: 3;
        dateWeighed: 4;
        weighingLocation: 5;
    }
    export type SortWeighingSituationHistor = keyof SortWeighingSituationHistor$Enum;
    export interface SortWo$Enum {
        byStartDate: 1;
        byAR: 2;
    }
    export type SortWo = keyof SortWo$Enum;
    export interface Splitting$Enum {
        none: 1;
        equalQuantities: 2;
        equalRunTimes: 3;
        equalRunTimes1Rule: 4;
        equalQuantitiesEfficiency: 5;
    }
    export type Splitting = keyof Splitting$Enum;
    export interface StateOfTheBalance$Enum {
        inService: 1;
        notInService: 2;
    }
    export type StateOfTheBalance = keyof StateOfTheBalance$Enum;
    export interface StatusInProgress$Enum {
        firm: 1;
        planned: 2;
        suggested: 3;
        closed: 4;
    }
    export type StatusInProgress = keyof StatusInProgress$Enum;
    export interface StatusesToProcess$Enum {
        plannedFirm: 1;
        allStatuses: 2;
    }
    export type StatusesToProcess = keyof StatusesToProcess$Enum;
    export interface StopBit$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
    }
    export type StopBit = keyof StopBit$Enum;
    export interface SubContractCloseMethod$Enum {
        production: 1;
        purchasing: 2;
    }
    export type SubContractCloseMethod = keyof SubContractCloseMethod$Enum;
    export interface Subcontracting$Enum {
        no: 1;
        normal: 2;
        byException: 3;
    }
    export type Subcontracting = keyof Subcontracting$Enum;
    export interface SupplierPackaging$Enum {
        internalPackaging: 1;
        supplierPackaging: 2;
        mixed: 3;
    }
    export type SupplierPackaging = keyof SupplierPackaging$Enum;
    export interface TankRecontrol$Enum {
        no: 1;
        tank: 2;
    }
    export type TankRecontrol = keyof TankRecontrol$Enum;
    export interface TechnicalSheetControl$Enum {
        no: 1;
        yesWithoutBlocking: 2;
        yesWithBlocking: 3;
        yesWithoutBlockingFirstTracking: 4;
        yesWithBlockingFirstTracking: 5;
    }
    export type TechnicalSheetControl = keyof TechnicalSheetControl$Enum;
    export interface TimeType$Enum {
        preparation: 1;
        run: 2;
        postRun: 3;
        setup: 4;
    }
    export type TimeType = keyof TimeType$Enum;
    export interface TimeUnitCode$Enum {
        hours: 1;
        minutes: 2;
    }
    export type TimeUnitCode = keyof TimeUnitCode$Enum;
    export interface ToleranceApplication$Enum {
        onTheWeightRemainingToWeigh: 1;
        onTheTotalExpectedWeight: 2;
    }
    export type ToleranceApplication = keyof ToleranceApplication$Enum;
    export interface TrackingType$Enum {
        wo: 1;
        bom: 2;
        woReintegration: 3;
        bomReintegration: 4;
    }
    export type TrackingType = keyof TrackingType$Enum;
    export interface TransactionType$Enum {
        manufacturingRelease: 1;
        productionTracking: 2;
    }
    export type TransactionType = keyof TransactionType$Enum;
    export interface TypeOfAllocation349$Enum {
        global: 1;
        detailed: 2;
    }
    export type TypeOfAllocation349 = keyof TypeOfAllocation349$Enum;
    export interface TypeOfContainer$Enum {
        internal: 1;
        supplier: 2;
    }
    export type TypeOfContainer = keyof TypeOfContainer$Enum;
    export interface TypeOfManufacturingCost$Enum {
        theoretical: 1;
        release: 2;
        expected: 3;
        actual: 4;
        realCostPriceForPlannedQuantity: 5;
        provisionalProductionForAchievedQuantity: 6;
    }
    export type TypeOfManufacturingCost = keyof TypeOfManufacturingCost$Enum;
    export interface TypeOfSentence$Enum {
        risk: 1;
        security: 2;
        environment: 3;
    }
    export type TypeOfSentence = keyof TypeOfSentence$Enum;
    export interface TypeOfTime$Enum {
        workOrder: 1;
        product: 2;
        miscellaneous: 3;
    }
    export type TypeOfTime = keyof TypeOfTime$Enum;
    export interface TypeOfWeighing$Enum {
        center: 1;
        topRightCorner: 2;
        topLeftCorner: 3;
        bottomRightCorner: 4;
        bottomLeftCorner: 5;
    }
    export type TypeOfWeighing = keyof TypeOfWeighing$Enum;
    export interface Update$Enum {
        no: 1;
        deferred: 2;
        immediate: 3;
    }
    export type Update = keyof Update$Enum;
    export interface UserRole$Enum {
        productionPlanner: 1;
        planner: 2;
        buyer: 3;
        subcontractPlanner: 4;
    }
    export type UserRole = keyof UserRole$Enum;
    export interface VarianceCalculationSource$Enum {
        standard: 1;
        workOrder: 2;
    }
    export type VarianceCalculationSource = keyof VarianceCalculationSource$Enum;
    export interface VarianceType$Enum {
        inPercentage: 1;
        inAmount: 2;
    }
    export type VarianceType = keyof VarianceType$Enum;
    export interface WeighStationTakenIntoAcc$Enum {
        no: 1;
        toWeigh: 2;
        weighingPlan: 3;
        beingWeighed: 4;
        weighed: 5;
        reconciled: 6;
        committed: 7;
        weighingUnderProgressByProduct: 8;
    }
    export type WeighStationTakenIntoAcc = keyof WeighStationTakenIntoAcc$Enum;
    export interface WeighingMethod$Enum {
        byVariance: 1;
        accumulated: 2;
    }
    export type WeighingMethod = keyof WeighingMethod$Enum;
    export interface WeighingOptions$Enum {
        weighedByWorkOrder: 1;
        weighedByProduct: 2;
        weighedInProduction: 3;
    }
    export type WeighingOptions = keyof WeighingOptions$Enum;
    export interface WeighingStationMessages$Enum {
        valveAlreadyProcessed: 1;
        minimumRangeOrMaximumRange: 2;
        maximumTareMaximumRange: 3;
        elementAlreadyPresent: 4;
        containerTypeShiSheetFilePackaging: 5;
        sentenceDoesNotExistOrIsIncorrect: 6;
        optional: 7;
        mandatory: 8;
        boxProcedure: 9;
        phases: 10;
        components: 11;
        weighingHistory: 12;
        reconciliationNotAllowed: 13;
        beingReconciled: 14;
        beingWeighed: 15;
        elementDoesNotExist: 16;
        someMaterialsAreNotWeighed: 17;
        reconciliationStoppedForThePhaseYesValidateNoDelete: 18;
        severalEntriesWithTheSameLotWeightMandatory: 19;
        deletionOfAllTheReconciliationsOfThePhase: 20;
        reconciliationOfThePhaseNotCompletedDeletingTheReconciliationsOfThePhase: 21;
        reconciliationCompletedForThePhase: 22;
        nonexistentTrackingTransactionParameterWeitrsnum: 23;
        nonexistentTrackingCounter: 24;
        inWeighingProcessMessage: 25;
        orderNumberAlreadyReconciled: 26;
        phaseAlreadyReconciled: 27;
        aMaterialIsShortAndPreventsInclusionInTheWeighingPlan: 28;
        cancellationWithoutReturn: 29;
        cancellationWithReturn: 30;
        confirmationOf1CancellationLine: 31;
        woClosedWeighingCancellationNotAllowed: 32;
        weighingAlreadyCanceled: 33;
        incompatibilityBetweenPackagingAndWeighingMode: 34;
        reOpenTheLine: 35;
        endOfContainer: 36;
        returnThisWoInTheWeighingPlan: 37;
        reactivationOfTheWoInTheWeighingPlanCorrectlyDone: 38;
        someExcludedMaterialsExistForThisOfContinue: 39;
        rectification: 40;
        codeInUseIsProhibitedAtThisPhase: 41;
        weighingSelection: 42;
        weighingNumberAleadyExistsOnTheLine: 43;
        unableToCommit: 44;
        orderNumberAlreadyCommitted: 45;
        phaseAlreadyCommitted: 46;
        commitmentCompletedForThePhase: 47;
        commitmentNotCompletedForThePhaseDeletionOfTheCommitmentsForThePhase: 48;
        deleteAllTheCommitmentsForThePhase: 49;
        commitmentCompletedForThePhaseYesValidateNoDelete: 50;
        underCommitment: 51;
        numberOfMaterialsThatRemainToBeReconciled: 52;
        numberOfMaterialsThatRemainToBeCommitted: 53;
        workOrderNotReconciled: 54;
        operationSelection: 55;
        productSelection: 56;
        theEntryBoxIsLinkedWithAWorkstationTheLaunchFromTheCurrentStationIsNotAuthorized: 57;
        oneOrSeveralMaterialSAreNotReconciled: 58;
        youNeedToUpdateYourApplicationClientToUseThisFunctionality: 59;
        numberOfWeighings: 60;
        greaterThanTheGridSize: 61;
        cannotModifyWorkOrderBeingWeighed: 62;
        materialAlreadyReconciledUnableToCancel: 63;
        materialAlreadyCommittedUnableToCancel: 64;
        cancellationCompleted: 65;
        numberOfWeighingsStillToBeEntered: 66;
        proceedWithTheCancellationYesProceedNoStop: 67;
        cancellationStopped: 68;
        unableToCancelTheCancellationMinimumLevelIsThePhaseTheValueOfParameterEngageHasToBeModified: 69;
        woNotCommittedNoCancellationToBeProcessed: 70;
        phaseNotCommittedNoCancellationToBeProcessed: 71;
        resynchronizationOfFlagWeighingPlan: 72;
        workOrderUpdate: 73;
        processStartControlCompletedForTheWeighing: 74;
        processStartControlCompletedForTheWeighingYesValidateNoDelete: 75;
        weighingProcessStartControlNotCompletedDeletionOfTheWeighingProcessStartControl: 76;
        processStartControlPerWeighingProcessingOfOneWeighingAtATime: 77;
        reactivationComplete: 78;
        reconciliationCompletedForTheContainer: 79;
        containerAlreadyReconciled: 80;
        reconciliationCompletedForTheWorkOrder: 81;
        reconciliationStoppedForTheWorkOrderYesValidateNoDelete: 82;
        reconciliationStoppedForTheContainerYesValidateNoDelete: 83;
        deleteAllReconciliationsForThePhase: 84;
        deleteAllReconciliationsForTheContainer: 85;
        deleteAllReconciliationsForTheWorkOrder: 86;
        reconciliationsDidNotCompleteDeletingReconciliations: 87;
        containerAlreadyCommitted: 88;
        weighingNumberAlreadyProcessed: 89;
        weighNo: 90;
        weighingOperator: 91;
        unableToUncheckBomRecordAlreadyExistsForThisMasterContainer: 92;
        unableToUncheckWoRecordAlreadyExistsForThisMasterContainer: 93;
    }
    export type WeighingStationMessages = keyof WeighingStationMessages$Enum;
    export interface WeighingStatusMaterialMwf$Enum {
        notWeighed: 1;
        inWeighingProcess: 2;
        weighing: 3;
        reconciliationControl: 4;
        reconciled: 5;
        processStartControl: 6;
        processStarted: 7;
        consumed: 8;
    }
    export type WeighingStatusMaterialMwf = keyof WeighingStatusMaterialMwf$Enum;
    export interface WeighingStatusWoWof$Enum {
        notWeighed: 1;
        weighingInStationUnderProgress: 2;
        weighingInStationCompleted: 3;
        weighingInProductionUnderProgress: 4;
        inProduction: 5;
        endOfProduction: 6;
        reconciliationControl: 7;
        totalWeighingCompleted: 8;
        orderBlockedForWeighing: 9;
        orderBlockedForReconciliationControl: 10;
        orderBlockedForProcessStartControl: 11;
    }
    export type WeighingStatusWoWof = keyof WeighingStatusWoWof$Enum;
    export interface Weighing$Enum {
        none: 1;
        partial: 2;
        complete: 3;
        closePackaging: 4;
        stockCount: 5;
    }
    export type Weighing = keyof Weighing$Enum;
    export interface WipChoice$Enum {
        pcpNotCalculated: 1;
        pcpCalculated: 2;
        both: 3;
    }
    export type WipChoice = keyof WipChoice$Enum;
    export interface WipLineType$Enum {
        new: 1;
        modified: 2;
        deleted: 3;
    }
    export type WipLineType = keyof WipLineType$Enum;
    export interface WipTransactionType$Enum {
        materialCost: 1;
        laborCost: 2;
        machineCost: 3;
        subcontractorCost: 4;
        materialExpenses: 5;
        laborExpenses: 6;
        machineExpenses: 7;
        subcontractorExpenses: 8;
        materialVariance: 9;
        laborVariance: 10;
        machineVariance: 11;
        subcontractorVariance: 12;
        overheadVariance: 13;
        productionStatement: 14;
        wipBalance: 15;
        operationReject: 16;
        adjustment: 17;
        closingTrackingWithoutWo: 18;
        invoiceElement: 19;
        invoiceElementVariance: 20;
    }
    export type WipTransactionType = keyof WipTransactionType$Enum;
    export interface WipValuation$Enum {
        notYetCosted: 1;
        alreadyCosted: 2;
        all: 3;
    }
    export type WipValuation = keyof WipValuation$Enum;
    export interface WoListSort$Enum {
        byWorkOrder: 1;
        byWorkCenter: 2;
        byProduct: 3;
        byOrder: 4;
        byProject: 5;
        byComponent: 6;
    }
    export type WoListSort = keyof WoListSort$Enum;
    export interface WoProvisionalCostCalculation$Enum {
        no: 1;
        inWoCreation: 2;
        inWoCreationAndModification: 3;
    }
    export type WoProvisionalCostCalculation = keyof WoProvisionalCostCalculation$Enum;
    export interface WoSortOrder2391$Enum {
        productionSiteWoN: 1;
        productionSiteWoStartDate: 2;
        productionSiteWoEndDate: 3;
        woN: 4;
        woStartDate: 5;
        woEndDate: 6;
    }
    export type WoSortOrder2391 = keyof WoSortOrder2391$Enum;
    export interface WoSortOrder$Enum {
        woN: 1;
        woStartDate: 2;
        woEndDate: 3;
    }
    export type WoSortOrder = keyof WoSortOrder$Enum;
    export interface WoUnforeseenElements$Enum {
        ignore: 1;
        keepUnforeseenElements: 2;
        discardUnforeseenElements: 3;
    }
    export type WoUnforeseenElements = keyof WoUnforeseenElements$Enum;
    export interface WoWipHeader$Enum {
        material: 1;
        labor: 2;
        machine: 3;
        subcontract: 4;
        overhead: 5;
        totals: 6;
        balance: 7;
        actual: 8;
        standard: 9;
        reject: 10;
        variance11: 11;
        variance: 12;
        pcDetail: 13;
        product: 14;
        adjustment: 15;
        materialCostDetail: 16;
        laborCostDetail: 17;
        machineCostDetail: 18;
        subcontractorCostDetail: 19;
        expenses: 20;
        overheads: 21;
        accountingJournal: 22;
        standardCostLevel: 23;
        updatedCostLevel: 24;
        budgetCostLevel: 25;
        simulatedCostLevel: 26;
    }
    export type WoWipHeader = keyof WoWipHeader$Enum;
    export interface WorkCenterType2423$Enum {
        laborOnly: 1;
        machineOnly: 2;
        laborAndMachine: 3;
    }
    export type WorkCenterType2423 = keyof WorkCenterType2423$Enum;
    export interface WorkCenterType315$Enum {
        all: 1;
        machine: 2;
        labor: 3;
        subcontracting: 4;
    }
    export type WorkCenterType315 = keyof WorkCenterType315$Enum;
    export interface WorkCenterType$Enum {
        machine: 1;
        labour: 2;
        subcontractor: 3;
    }
    export type WorkCenterType = keyof WorkCenterType$Enum;
    export interface WorkOrderAllocationStatus$Enum {
        notAllocated: 1;
        partial: 2;
        complete: 3;
        partialShortage: 4;
        completeShortage: 5;
    }
    export type WorkOrderAllocationStatus = keyof WorkOrderAllocationStatus$Enum;
    export interface WorkOrderAllocationType$Enum {
        none: 1;
        global: 2;
        mixed: 3;
        detailed: 4;
    }
    export type WorkOrderAllocationType = keyof WorkOrderAllocationType$Enum;
    export interface WorkOrderManagementMode$Enum {
        noChange: 1;
        materialsChange: 2;
        operationChange: 3;
        changeMaterialsAndOperations: 4;
    }
    export type WorkOrderManagementMode = keyof WorkOrderManagementMode$Enum;
    export interface WorkOrderPreparationStatus$Enum {
        notPrepared: 1;
        partial: 2;
        full: 3;
    }
    export type WorkOrderPreparationStatus = keyof WorkOrderPreparationStatus$Enum;
    export interface WorkOrderSituation$Enum {
        pending: 1;
        beingOptimized: 2;
        printed: 3;
        inProgress: 4;
        completed: 5;
        closedCosted: 6;
    }
    export type WorkOrderSituation = keyof WorkOrderSituation$Enum;
    export interface WorkOrderStatus$Enum {
        firm: 1;
        closed: 2;
    }
    export type WorkOrderStatus = keyof WorkOrderStatus$Enum;
    export interface WorkOrderType$Enum {
        customerOrder: 1;
        supplierOrder: 2;
        subcontractedMaterial: 3;
        subcontractedService: 4;
        workOrder: 5;
        materialRequirements: 6;
        transferOrder: 7;
        transferRequest: 8;
        byProduct: 9;
        miscellaneousRequests: 10;
        miscellaneousResources: 11;
        customerReservation: 12;
        subcontractOrder: 13;
        projectDemand: 14;
    }
    export type WorkOrderType = keyof WorkOrderType$Enum;
    export interface WorkloadInitialization$Enum {
        loadInitialization: 1;
        loadRecalculationPF: 2;
        loadRecalculationSPF: 3;
    }
    export type WorkloadInitialization = keyof WorkloadInitialization$Enum;
    export interface WorkstationTypeLong$Enum {
        machine: 1;
        labor: 2;
        subcontracting: 3;
    }
    export type WorkstationTypeLong = keyof WorkstationTypeLong$Enum;
    export interface Assignment extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        _x3Auuid: string;
        storageSite: Site;
        product: ProductSite;
        requestType: EntryTypeEnum;
        demandNumber: string;
        demandLineNumber: integer;
        demandSequence: integer;
        demandOrderType: WorkOrderType;
        demandOrderStatus: StatusInProgress;
        resourceType: EntryTypeEnum;
        resourceNumber: string;
        resourceLineNumber: integer;
        resourceSequence: integer;
        resourceOrderType: WorkOrderType;
        resourceOrderStatus: StatusInProgress;
        quantityAssigned: string;
    }
    export interface AssignmentInput extends ClientNodeInput {
        _x3Auuid?: string;
        storageSite?: string;
        product?: string;
        requestType?: EntryTypeEnum;
        demandNumber?: string;
        demandLineNumber?: integer | string;
        demandSequence?: integer | string;
        demandOrderType?: WorkOrderType;
        demandOrderStatus?: StatusInProgress;
        resourceType?: EntryTypeEnum;
        resourceNumber?: string;
        resourceLineNumber?: integer | string;
        resourceSequence?: integer | string;
        resourceOrderType?: WorkOrderType;
        resourceOrderStatus?: StatusInProgress;
        quantityAssigned?: decimal | string;
    }
    export interface AssignmentBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        _x3Auuid: string;
        storageSite: Site;
        product: ProductSite;
        requestType: EntryTypeEnum;
        demandNumber: string;
        demandLineNumber: integer;
        demandSequence: integer;
        demandOrderType: WorkOrderType;
        demandOrderStatus: StatusInProgress;
        resourceType: EntryTypeEnum;
        resourceNumber: string;
        resourceLineNumber: integer;
        resourceSequence: integer;
        resourceOrderType: WorkOrderType;
        resourceOrderStatus: StatusInProgress;
        quantityAssigned: string;
    }
    export interface Assignment$Lookups {
        storageSite: QueryOperation<Site>;
        product: QueryOperation<ProductSite>;
    }
    export interface Assignment$Operations {
        query: QueryOperation<Assignment>;
        read: ReadOperation<Assignment>;
        aggregate: {
            read: AggregateReadOperation<Assignment>;
            query: AggregateQueryOperation<Assignment>;
        };
        lookups(dataOrId: string | { data: AssignmentInput }): Assignment$Lookups;
        getDefaults: GetDefaultsOperation<Assignment>;
    }
    export interface EmployeeId extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        teamId: integer;
        description: string;
        employeeShortDesignation: string;
        teamType: EmployeeType;
        userCode: User;
        laborRate: string;
        isActive: boolean;
        site: Site;
        workCenter: string;
        workCenterGroup: WorkCenterGroup;
    }
    export interface EmployeeIdInput extends ClientNodeInput {
        teamId?: integer | string;
        description?: string;
        employeeShortDesignation?: string;
        teamType?: EmployeeType;
        userCode?: string;
        laborRate?: decimal | string;
        isActive?: boolean | string;
        site?: string;
        workCenter?: string;
        workCenterGroup?: string;
    }
    export interface EmployeeIdBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        teamId: integer;
        description: string;
        employeeShortDesignation: string;
        teamType: EmployeeType;
        userCode: User;
        laborRate: string;
        isActive: boolean;
        site: Site;
        workCenter: string;
        workCenterGroup: WorkCenterGroup;
    }
    export interface EmployeeId$Lookups {
        userCode: QueryOperation<User>;
        site: QueryOperation<Site>;
        workCenterGroup: QueryOperation<WorkCenterGroup>;
    }
    export interface EmployeeId$Operations {
        query: QueryOperation<EmployeeId>;
        read: ReadOperation<EmployeeId>;
        aggregate: {
            read: AggregateReadOperation<EmployeeId>;
            query: AggregateQueryOperation<EmployeeId>;
        };
        lookups(dataOrId: string | { data: EmployeeIdInput }): EmployeeId$Lookups;
        getDefaults: GetDefaultsOperation<EmployeeId>;
    }
    export interface StockJournalImport extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        isUpdated: boolean;
        product: Product;
        effectiveDate: string;
        sequence: integer;
        index: integer;
        fifoDate: string;
        fifoTime: string;
        fifoTier: string;
        owner: string;
        lot: string;
        sublot: string;
        supplierLot: string;
        location: Location;
        warehouse: Warehouse;
        serialNumber: string;
        transactionType: StockTransactionType;
        stockMovementGroup: MiscellaneousTable;
        movementDescription: string;
        project: ProjectLink;
        businessPartner: BusinessPartner;
        documentType: EntryTypeEnum;
        documentId: string;
        documentLine: integer;
        documentTypeOriginal: EntryTypeEnum;
        documentIdOriginal: string;
        documentLineOriginal: integer;
        documentSequenceOriginal: integer;
        adjustementType: EntryTypeEnum;
        adjustementDocumentId: string;
        adjustementDocumentLineId: integer;
        lotCustomField1: string;
        lotCustomField2: string;
        lotCustomField3: string;
        lotCustomField4: string;
        packingUnit: UnitOfMeasure;
        quantityInPackingUnit: string;
        packingUnitToStockUnitConversionFactor: string;
        quantityInStockUnit: string;
        stockUnit: UnitOfMeasure;
        orginialPackingUnit: UnitOfMeasure;
        originalPackingUnitToStockUnitConversionFactor: string;
        orderAmount: string;
        movementValue: string;
        orderVariance: string;
        movementVariance: string;
        orderCost: string;
        valuedCost: string;
        costSource: CostSource;
        secondaryMovementValue: string;
        secondaryMovementVariance: string;
        secondaryValuedCost: string;
        secondaryCostSource: CostSource;
        isAdjusted: boolean;
        varianceNotAbsorbed: string;
        secondaryVarianceNotAbsorbed: string;
        expirationDate: string;
        status: StockStatus;
        potency: string;
        internationalUnitPotency: string;
        activQuantity: string;
        qualityAnalysisRequestId: string;
        isPrinted: boolean;
        isAdjustedMovement: boolean;
        labelFormat: GenericPrintReport;
        numberOfLabels: integer;
        financialSite: Site;
        hasStockInterfacePosted: boolean;
        hasStockAccountingPosted: boolean;
        hasStockAccountingPostedSecondary: boolean;
        identifier1: string;
        identifier2: string;
        intercompany: boolean;
        useByDate: string;
        recontrolDate: string;
        accountingDate: string;
        majorVersion: MajorVersionStatus;
        minorVersion: string;
        startingSerialNumber: string;
        stockCustomField1: string;
        endingSerialNumber: string;
        stockCustomField2: string;
        licensePlateNumber: LicensePlateNumber;
    }
    export interface StockJournalImportInput extends ClientNodeInput {
        stockSite?: string;
        isUpdated?: boolean | string;
        product?: string;
        effectiveDate?: string;
        sequence?: integer | string;
        index?: integer | string;
        fifoDate?: string;
        fifoTime?: string;
        fifoTier?: decimal | string;
        owner?: string;
        lot?: string;
        sublot?: string;
        supplierLot?: string;
        location?: string;
        warehouse?: string;
        serialNumber?: string;
        transactionType?: StockTransactionType;
        stockMovementGroup?: string;
        movementDescription?: string;
        project?: string;
        businessPartner?: string;
        documentType?: EntryTypeEnum;
        documentId?: string;
        documentLine?: integer | string;
        documentTypeOriginal?: EntryTypeEnum;
        documentIdOriginal?: string;
        documentLineOriginal?: integer | string;
        documentSequenceOriginal?: integer | string;
        adjustementType?: EntryTypeEnum;
        adjustementDocumentId?: string;
        adjustementDocumentLineId?: integer | string;
        lotCustomField1?: string;
        lotCustomField2?: string;
        lotCustomField3?: decimal | string;
        lotCustomField4?: string;
        packingUnit?: string;
        quantityInPackingUnit?: decimal | string;
        packingUnitToStockUnitConversionFactor?: decimal | string;
        quantityInStockUnit?: decimal | string;
        stockUnit?: string;
        orginialPackingUnit?: string;
        originalPackingUnitToStockUnitConversionFactor?: decimal | string;
        orderAmount?: decimal | string;
        movementValue?: decimal | string;
        orderVariance?: decimal | string;
        movementVariance?: decimal | string;
        orderCost?: decimal | string;
        valuedCost?: decimal | string;
        costSource?: CostSource;
        secondaryMovementValue?: decimal | string;
        secondaryMovementVariance?: decimal | string;
        secondaryValuedCost?: decimal | string;
        secondaryCostSource?: CostSource;
        isAdjusted?: boolean | string;
        varianceNotAbsorbed?: decimal | string;
        secondaryVarianceNotAbsorbed?: decimal | string;
        expirationDate?: string;
        status?: string;
        potency?: decimal | string;
        internationalUnitPotency?: decimal | string;
        activQuantity?: decimal | string;
        qualityAnalysisRequestId?: string;
        isPrinted?: boolean | string;
        isAdjustedMovement?: boolean | string;
        labelFormat?: string;
        numberOfLabels?: integer | string;
        financialSite?: string;
        hasStockInterfacePosted?: boolean | string;
        hasStockAccountingPosted?: boolean | string;
        hasStockAccountingPostedSecondary?: boolean | string;
        identifier1?: string;
        identifier2?: string;
        intercompany?: boolean | string;
        useByDate?: string;
        recontrolDate?: string;
        accountingDate?: string;
        majorVersion?: string;
        minorVersion?: string;
        startingSerialNumber?: string;
        stockCustomField1?: string;
        endingSerialNumber?: string;
        stockCustomField2?: string;
        licensePlateNumber?: string;
        expirationDateString?: string;
    }
    export interface StockJournalImportBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        isUpdated: boolean;
        product: Product;
        effectiveDate: string;
        sequence: integer;
        index: integer;
        fifoDate: string;
        fifoTime: string;
        fifoTier: string;
        owner: string;
        lot: string;
        sublot: string;
        supplierLot: string;
        location: Location;
        warehouse: Warehouse;
        serialNumber: string;
        transactionType: StockTransactionType;
        stockMovementGroup: MiscellaneousTable;
        movementDescription: string;
        project: ProjectLink;
        businessPartner: BusinessPartner;
        documentType: EntryTypeEnum;
        documentId: string;
        documentLine: integer;
        documentTypeOriginal: EntryTypeEnum;
        documentIdOriginal: string;
        documentLineOriginal: integer;
        documentSequenceOriginal: integer;
        adjustementType: EntryTypeEnum;
        adjustementDocumentId: string;
        adjustementDocumentLineId: integer;
        lotCustomField1: string;
        lotCustomField2: string;
        lotCustomField3: string;
        lotCustomField4: string;
        packingUnit: UnitOfMeasure;
        quantityInPackingUnit: string;
        packingUnitToStockUnitConversionFactor: string;
        quantityInStockUnit: string;
        stockUnit: UnitOfMeasure;
        orginialPackingUnit: UnitOfMeasure;
        originalPackingUnitToStockUnitConversionFactor: string;
        orderAmount: string;
        movementValue: string;
        orderVariance: string;
        movementVariance: string;
        orderCost: string;
        valuedCost: string;
        costSource: CostSource;
        secondaryMovementValue: string;
        secondaryMovementVariance: string;
        secondaryValuedCost: string;
        secondaryCostSource: CostSource;
        isAdjusted: boolean;
        varianceNotAbsorbed: string;
        secondaryVarianceNotAbsorbed: string;
        expirationDate: string;
        status: StockStatus;
        potency: string;
        internationalUnitPotency: string;
        activQuantity: string;
        qualityAnalysisRequestId: string;
        isPrinted: boolean;
        isAdjustedMovement: boolean;
        labelFormat: GenericPrintReport;
        numberOfLabels: integer;
        financialSite: Site;
        hasStockInterfacePosted: boolean;
        hasStockAccountingPosted: boolean;
        hasStockAccountingPostedSecondary: boolean;
        identifier1: string;
        identifier2: string;
        intercompany: boolean;
        useByDate: string;
        recontrolDate: string;
        accountingDate: string;
        majorVersion: MajorVersionStatus;
        minorVersion: string;
        startingSerialNumber: string;
        stockCustomField1: string;
        endingSerialNumber: string;
        stockCustomField2: string;
        licensePlateNumber: LicensePlateNumber;
        expirationDateString: string;
    }
    export interface StockJournalImport$Lookups {
        stockSite: QueryOperation<Site>;
        product: QueryOperation<Product>;
        location: QueryOperation<Location>;
        warehouse: QueryOperation<Warehouse>;
        stockMovementGroup: QueryOperation<MiscellaneousTable>;
        project: QueryOperation<ProjectLink>;
        businessPartner: QueryOperation<BusinessPartner>;
        packingUnit: QueryOperation<UnitOfMeasure>;
        stockUnit: QueryOperation<UnitOfMeasure>;
        orginialPackingUnit: QueryOperation<UnitOfMeasure>;
        status: QueryOperation<StockStatus>;
        labelFormat: QueryOperation<GenericPrintReport>;
        financialSite: QueryOperation<Site>;
        majorVersion: QueryOperation<MajorVersionStatus>;
        licensePlateNumber: QueryOperation<LicensePlateNumber>;
    }
    export interface StockJournalImport$Operations {
        query: QueryOperation<StockJournalImport>;
        read: ReadOperation<StockJournalImport>;
        aggregate: {
            read: AggregateReadOperation<StockJournalImport>;
            query: AggregateQueryOperation<StockJournalImport>;
        };
        lookups(dataOrId: string | { data: StockJournalImportInput }): StockJournalImport$Lookups;
        getDefaults: GetDefaultsOperation<StockJournalImport>;
    }
    export interface TeamEmployee extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        teamId: EmployeeId;
        teamLine: integer;
        employeeId: EmployeeId;
        startDate: string;
    }
    export interface TeamEmployeeInput extends ClientNodeInput {
        teamId?: integer | string;
        teamLine?: integer | string;
        employeeId?: integer | string;
        startDate?: string;
    }
    export interface TeamEmployeeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        teamId: EmployeeId;
        teamLine: integer;
        employeeId: EmployeeId;
        startDate: string;
    }
    export interface TeamEmployee$Lookups {
        teamId: QueryOperation<EmployeeId>;
        employeeId: QueryOperation<EmployeeId>;
    }
    export interface TeamEmployee$Operations {
        query: QueryOperation<TeamEmployee>;
        read: ReadOperation<TeamEmployee>;
        aggregate: {
            read: AggregateReadOperation<TeamEmployee>;
            query: AggregateQueryOperation<TeamEmployee>;
        };
        lookups(dataOrId: string | { data: TeamEmployeeInput }): TeamEmployee$Lookups;
        getDefaults: GetDefaultsOperation<TeamEmployee>;
    }
    export interface Team extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        teamId: integer;
        description: string;
        employeeShortDesignation: string;
        teamType: EmployeeType;
        userCode: User;
        laborRate: string;
        isActive: boolean;
        site: Site;
        workCenter: string;
        workCenterGroup: WorkCenterGroup;
        teamEmployees: ClientCollection<TeamEmployee>;
    }
    export interface TeamInput extends ClientNodeInput {
        teamId?: integer | string;
        description?: string;
        employeeShortDesignation?: string;
        teamType?: EmployeeType;
        userCode?: string;
        laborRate?: decimal | string;
        isActive?: boolean | string;
        site?: string;
        workCenter?: string;
        workCenterGroup?: string;
        teamEmployees?: Partial<TeamEmployeeInput>[];
    }
    export interface TeamBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        teamId: integer;
        description: string;
        employeeShortDesignation: string;
        teamType: EmployeeType;
        userCode: User;
        laborRate: string;
        isActive: boolean;
        site: Site;
        workCenter: string;
        workCenterGroup: WorkCenterGroup;
        teamEmployees: ClientCollection<TeamEmployee>;
    }
    export interface Team$Lookups {
        userCode: QueryOperation<User>;
        site: QueryOperation<Site>;
        workCenterGroup: QueryOperation<WorkCenterGroup>;
    }
    export interface Team$Operations {
        query: QueryOperation<Team>;
        read: ReadOperation<Team>;
        aggregate: {
            read: AggregateReadOperation<Team>;
            query: AggregateQueryOperation<Team>;
        };
        lookups(dataOrId: string | { data: TeamInput }): Team$Lookups;
        getDefaults: GetDefaultsOperation<Team>;
    }
    export interface WorkCenterGroup extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        description: string;
    }
    export interface WorkCenterGroupInput extends ClientNodeInput {
        code?: string;
        description?: string;
    }
    export interface WorkCenterGroupBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        description: string;
    }
    export interface WorkCenterGroup$Operations {
        query: QueryOperation<WorkCenterGroup>;
        read: ReadOperation<WorkCenterGroup>;
        aggregate: {
            read: AggregateReadOperation<WorkCenterGroup>;
            query: AggregateQueryOperation<WorkCenterGroup>;
        };
        getDefaults: GetDefaultsOperation<WorkCenterGroup>;
    }
    export interface WorkCenter extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        manufacturingSite: Site;
        workCenterGroup: WorkCenterGroup;
        costingDimension: string;
        weeklyStructure: WeeklyStructure;
        efficiencyInPercentage: string;
        shrinkageInPercentage: string;
        numberOfResources: integer;
        automaticClosingPercentage: string;
        qualificationLevel: string;
        totalExpectedTimeInHours: string;
        totalTimeCompleteInHours: string;
        isConstraint: boolean;
        isRccp: boolean;
        isRunDuringEmployeeBreak: boolean;
        description: string;
    }
    export interface WorkCenterInput extends ClientNodeInput {
        code?: string;
        manufacturingSite?: string;
        workCenterGroup?: string;
        costingDimension?: string;
        weeklyStructure?: string;
        efficiencyInPercentage?: decimal | string;
        shrinkageInPercentage?: decimal | string;
        numberOfResources?: integer | string;
        automaticClosingPercentage?: decimal | string;
        qualificationLevel?: string;
        totalExpectedTimeInHours?: decimal | string;
        totalTimeCompleteInHours?: decimal | string;
        isConstraint?: boolean | string;
        isRccp?: boolean | string;
        isRunDuringEmployeeBreak?: boolean | string;
        description?: string;
    }
    export interface WorkCenterBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        manufacturingSite: Site;
        workCenterGroup: WorkCenterGroup;
        costingDimension: string;
        weeklyStructure: WeeklyStructure;
        efficiencyInPercentage: string;
        shrinkageInPercentage: string;
        numberOfResources: integer;
        automaticClosingPercentage: string;
        qualificationLevel: string;
        totalExpectedTimeInHours: string;
        totalTimeCompleteInHours: string;
        isConstraint: boolean;
        isRccp: boolean;
        isRunDuringEmployeeBreak: boolean;
        description: string;
    }
    export interface WorkCenter$Lookups {
        manufacturingSite: QueryOperation<Site>;
        workCenterGroup: QueryOperation<WorkCenterGroup>;
        weeklyStructure: QueryOperation<WeeklyStructure>;
    }
    export interface WorkCenter$Operations {
        query: QueryOperation<WorkCenter>;
        read: ReadOperation<WorkCenter>;
        aggregate: {
            read: AggregateReadOperation<WorkCenter>;
            query: AggregateQueryOperation<WorkCenter>;
        };
        lookups(dataOrId: string | { data: WorkCenterInput }): WorkCenter$Lookups;
        getDefaults: GetDefaultsOperation<WorkCenter>;
    }
    export interface OverheadExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        overhead: string;
        localizedDescription: string;
        localizedShortDescription: string;
        formulaCodes: ClientCollection<OverheadFormulaCodes>;
        calculationMethod: OverheadCalculationMethod;
        overheadApplicationMode: OverheadApplicationMethod;
        formulaBase: BaseFormulaToCalculateCost;
    }
    export interface OverheadInputExtension {
        overhead?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        formulaCodes?: Partial<OverheadFormulaCodesInput>[];
        calculationMethod?: OverheadCalculationMethod;
        overheadApplicationMode?: OverheadApplicationMethod;
        formulaBase?: BaseFormulaToCalculateCost;
    }
    export interface OverheadBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        overhead: string;
        localizedDescription: string;
        localizedShortDescription: string;
        formulaCodes: ClientCollection<OverheadFormulaCodesBinding>;
        calculationMethod: OverheadCalculationMethod;
        overheadApplicationMode: OverheadApplicationMethod;
        formulaBase: BaseFormulaToCalculateCost;
    }
    export interface Package {
        '@sage/x3-manufacturing-data/Assignment': Assignment$Operations;
        '@sage/x3-manufacturing-data/EmployeeId': EmployeeId$Operations;
        '@sage/x3-manufacturing-data/StockJournalImport': StockJournalImport$Operations;
        '@sage/x3-manufacturing-data/TeamEmployee': TeamEmployee$Operations;
        '@sage/x3-manufacturing-data/Team': Team$Operations;
        '@sage/x3-manufacturing-data/WorkCenterGroup': WorkCenterGroup$Operations;
        '@sage/x3-manufacturing-data/WorkCenter': WorkCenter$Operations;
    }
    export interface GraphApi
        extends Package,
            SageX3MasterData$Package,
            SageX3ProjectManagementData$Package,
            SageX3StockData$Package,
            SageX3Structure$Package,
            SageX3System$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/x3-manufacturing-data-api' {
    export type * from '@sage/x3-manufacturing-data-api-partial';
}
declare module '@sage/x3-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-project-management-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-data-api-partial' {
    import type {
        OverheadBindingExtension,
        OverheadExtension,
        OverheadInputExtension,
    } from '@sage/x3-manufacturing-data-api';
    export interface Overhead extends OverheadExtension {}
    export interface OverheadBinding extends OverheadBindingExtension {}
    export interface OverheadInput extends OverheadInputExtension {}
}
