"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDownloadUrlPathForTenant = exports.getErpAdapterUploadDirtyUrlPathForTenant = exports.getUploadDirtyUrlPathForTenant = exports.getErpAdapterUploadPathPathForTenant = exports.getAttachmentDirtyPathForTenant = exports.getAttachmentPathForTenant = exports.getUploadPathForTenant = exports.TenantDataType = exports.S3_ERP_ADAPTER_UPLOAD_PATH = exports.S3_ATTACHMENT_PATH = exports.S3_UPLOAD_PATH = exports.S3_DIRTY_PATH = void 0;
exports.S3_DIRTY_PATH = "dirty";
exports.S3_UPLOAD_PATH = "uploads";
exports.S3_ATTACHMENT_PATH = "attachments";
exports.S3_ERP_ADAPTER_UPLOAD_PATH = "uploadsErpAdapter";
var TenantDataType;
(function (TenantDataType) {
    TenantDataType["IMPORT"] = "imports";
    TenantDataType["EXPORT"] = "exports";
    TenantDataType["EXPORT_IMPORT"] = "exports-imports";
    TenantDataType["DATA"] = "tenant-data";
    TenantDataType["DIRTY"] = "dirty/tenant-data";
})(TenantDataType || (exports.TenantDataType = TenantDataType = {}));
const getAppPath = (app) => app ? `${app}/` : "";
const getUploadPathForTenant = (tenantId, objectKey, app) => {
    return `${TenantDataType.DATA}/${getAppPath(app)}${tenantId}/${exports.S3_UPLOAD_PATH}/${objectKey}`;
};
exports.getUploadPathForTenant = getUploadPathForTenant;
const getAttachmentPathForTenant = (tenantId, objectKey, app) => {
    return `${TenantDataType.DATA}/${getAppPath(app)}${tenantId}/${exports.S3_ATTACHMENT_PATH}/${objectKey}`;
};
exports.getAttachmentPathForTenant = getAttachmentPathForTenant;
const getAttachmentDirtyPathForTenant = (tenantId, objectKey, app) => {
    return `${exports.S3_DIRTY_PATH}/${(0, exports.getAttachmentPathForTenant)(tenantId, objectKey, app)}`;
};
exports.getAttachmentDirtyPathForTenant = getAttachmentDirtyPathForTenant;
const getErpAdapterUploadPathPathForTenant = (tenantId, contextId, app) => {
    return `${TenantDataType.DATA}/${getAppPath(app)}${tenantId}/${exports.S3_ERP_ADAPTER_UPLOAD_PATH}/${contextId}`;
};
exports.getErpAdapterUploadPathPathForTenant = getErpAdapterUploadPathPathForTenant;
const getUploadDirtyUrlPathForTenant = (tenantId, objectKey, app) => {
    return `${exports.S3_DIRTY_PATH}/${(0, exports.getUploadPathForTenant)(tenantId, objectKey, app)}`;
};
exports.getUploadDirtyUrlPathForTenant = getUploadDirtyUrlPathForTenant;
const getErpAdapterUploadDirtyUrlPathForTenant = (tenantId, contextId, app) => {
    return `${exports.S3_DIRTY_PATH}/${(0, exports.getErpAdapterUploadPathPathForTenant)(tenantId, contextId, app)}`;
};
exports.getErpAdapterUploadDirtyUrlPathForTenant = getErpAdapterUploadDirtyUrlPathForTenant;
const getDownloadUrlPathForTenant = (tenantId, objectKey, app) => {
    return `${TenantDataType.DATA}/${getAppPath(app)}${tenantId}/${objectKey}`;
};
exports.getDownloadUrlPathForTenant = getDownloadUrlPathForTenant;
