"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isSupportClusterApp = exports.getTerraformAppName = exports.getClusterAppDynamoDBIdentifier = exports.getClusterAppIdentifier = exports.getRepositoryName = exports.getApplicationName = exports.CloudmanagerUserRole = exports.BillingUserType = exports.TenantAppExportStatus = exports.OperationEventStatus = exports.OperationStatus = exports.OperationAction = exports.OperationKind = exports.TenantAppDataType = exports.TenantType = exports.SubscriptionType = exports.AppStatus = exports.TenantAppStatus = exports.XtremApps = void 0;
/****  DANGER ZONE ****/
// In sync with xtrem code, don't change it
// KEEP lowercase in value => snakecase
// KEEP SHORT (13 letters)
// NO SPECIALCHARS (apart from underscore)
// Customer facing in URL
// Used in schema name
var XtremApps;
(function (XtremApps) {
    XtremApps["SDMO"] = "sdmo";
    XtremApps["SHOPFLOOR"] = "shopfloor";
    XtremApps["SHOWCASE"] = "showcase";
    XtremApps["GLOSSARY"] = "glossary";
    XtremApps["X3_PROXY"] = "x3_proxy";
    XtremApps["X3_CONNECTOR"] = "x3_connector";
    XtremApps["SHOWCASE_STOCK"] = "showcase_stock";
    XtremApps["SHOWCASE_SALES"] = "showcase_sales";
    XtremApps["UNKNOWN"] = "unknown";
})(XtremApps || (exports.XtremApps = XtremApps = {}));
var TenantAppStatus;
(function (TenantAppStatus) {
    TenantAppStatus["ERROR"] = "error";
    TenantAppStatus["UNKNOWN"] = "unknown";
    TenantAppStatus["CREATING"] = "creating";
    TenantAppStatus["IMPORTING"] = "importing";
    TenantAppStatus["READY"] = "ready";
    TenantAppStatus["DELETING"] = "deleting";
})(TenantAppStatus || (exports.TenantAppStatus = TenantAppStatus = {}));
var AppStatus;
(function (AppStatus) {
    AppStatus["READY"] = "ready";
    AppStatus["ERROR"] = "error";
    AppStatus["MAINTENANCE"] = "maintenance";
    AppStatus["UNKNOWN"] = "unknown";
})(AppStatus || (exports.AppStatus = AppStatus = {}));
var SubscriptionType;
(function (SubscriptionType) {
    SubscriptionType["PAID"] = "paid";
    SubscriptionType["INTERNAL"] = "internal";
})(SubscriptionType || (exports.SubscriptionType = SubscriptionType = {}));
var TenantType;
(function (TenantType) {
    TenantType["DEMO"] = "demo";
    TenantType["PRODUCTION"] = "production";
    TenantType["DATA_REFERENCE"] = "data reference";
    TenantType["SANDBOX"] = "sandbox";
    TenantType["IMPLEMENTATION"] = "implementation";
    TenantType["UNKNOWN"] = "unknown"; // used when we could not parse tenant kind from repository
})(TenantType || (exports.TenantType = TenantType = {}));
var TenantAppDataType;
(function (TenantAppDataType) {
    TenantAppDataType["SETUP"] = "setup";
    TenantAppDataType["DEMO"] = "demo";
    TenantAppDataType["REFERENCE"] = "reference";
    TenantAppDataType["LAYERS"] = "layers";
    TenantAppDataType["UNKNOWN"] = "unknown";
})(TenantAppDataType || (exports.TenantAppDataType = TenantAppDataType = {}));
var OperationKind;
(function (OperationKind) {
    // Tenant app
    OperationKind["TenantAppProvisioning"] = "TenantAppProvisioning";
    OperationKind["TenantAppDeletion"] = "TenantAppDeletion";
    OperationKind["TenantAppExport"] = "TenantAppExport";
    OperationKind["TenantAppSandbox"] = "TenantAppSandbox";
    OperationKind["TenantAppImport"] = "TenantAppImport";
    OperationKind["TenantAppSupportAccess"] = "TenantAppSupportAccess";
    // Cluster app
    OperationKind["ClusterAppExtractTenantsAndUsers"] = "ClusterAppExtractTenantsAndUsers";
    OperationKind["ClusterAppUpgrade"] = "ClusterAppUpgrade";
    OperationKind["ClusterAppExportData"] = "ClusterAppExportData";
    OperationKind["ClusterAppImportData"] = "ClusterAppImportData";
    OperationKind["ClusterAppEasyRestore"] = "ClusterAppEasyRestore";
    OperationKind["ClusterAppValidateAppVersion"] = "ClusterAppValidationAppVersion";
    OperationKind["ClusterAppExecuteCustomSQL"] = "ClusterAppExecuteCustomSQL";
    OperationKind["ClusterAppUpdateTenantSetupData"] = "ClusterAppUpdateTenantSetupData";
    // Cluster
    OperationKind["ClusterGatherDataStats"] = "ClusterGatherDataStats";
    // Global
    OperationKind["MultiTenantDBUpgrade"] = "MultitenantDatabaseUpgrade";
    OperationKind["MultiTenantRestartDeployment"] = "MultitenantRestartDeployment";
    OperationKind["Generic"] = "Generic";
    OperationKind["AdminTasks"] = "AdminTasks";
})(OperationKind || (exports.OperationKind = OperationKind = {}));
var OperationAction;
(function (OperationAction) {
    OperationAction["proceed"] = "proceed";
    OperationAction["reject"] = "reject";
    OperationAction["cancel"] = "cancel";
})(OperationAction || (exports.OperationAction = OperationAction = {}));
var OperationStatus;
(function (OperationStatus) {
    OperationStatus["pending"] = "pending";
    OperationStatus["running"] = "running";
    OperationStatus["success"] = "success";
    OperationStatus["error"] = "error";
    OperationStatus["cancelled"] = "cancelled";
})(OperationStatus || (exports.OperationStatus = OperationStatus = {}));
var OperationEventStatus;
(function (OperationEventStatus) {
    OperationEventStatus["running"] = "running";
    OperationEventStatus["success"] = "success";
    OperationEventStatus["error"] = "error";
})(OperationEventStatus || (exports.OperationEventStatus = OperationEventStatus = {}));
var TenantAppExportStatus;
(function (TenantAppExportStatus) {
    TenantAppExportStatus["pending"] = "pending";
    TenantAppExportStatus["running"] = "running";
    TenantAppExportStatus["success"] = "success";
    TenantAppExportStatus["error"] = "error";
    TenantAppExportStatus["cancelled"] = "cancelled";
})(TenantAppExportStatus || (exports.TenantAppExportStatus = TenantAppExportStatus = {}));
var BillingUserType;
(function (BillingUserType) {
    BillingUserType["BUSINESS_USER"] = "businessUser";
    BillingUserType["OPERATIONAL_USER"] = "operationalUser";
    BillingUserType["API_USER"] = "api";
    BillingUserType["UNKNOWN"] = "unknown"; // fallback for unknown kind
})(BillingUserType || (exports.BillingUserType = BillingUserType = {}));
var CloudmanagerUserRole;
(function (CloudmanagerUserRole) {
    CloudmanagerUserRole["OPS"] = "ops";
    CloudmanagerUserRole["SALES_OPS"] = "salesOps";
    CloudmanagerUserRole["SUPPORT"] = "support";
    CloudmanagerUserRole["SUPPORT_OPS"] = "supportOps";
    CloudmanagerUserRole["SALES_REP"] = "salesRep";
    CloudmanagerUserRole["BILLING"] = "billing";
    CloudmanagerUserRole["READ_ONLY"] = "readOnly";
})(CloudmanagerUserRole || (exports.CloudmanagerUserRole = CloudmanagerUserRole = {}));
const getApplicationName = (app) => {
    switch (app) {
        case XtremApps.SDMO:
            return "Sage Distribution and Manufacturing Operations";
        case XtremApps.SHOPFLOOR:
            return "Shopfloor";
        case XtremApps.SHOWCASE:
            return "Showcase";
        case XtremApps.GLOSSARY:
            return "Glossary";
        case XtremApps.X3_PROXY:
            return "X3 proxy";
        case XtremApps.X3_CONNECTOR:
            return "X3 connector";
        case XtremApps.SHOWCASE_STOCK:
            return "Showcase stock";
        case XtremApps.SHOWCASE_SALES:
            return "Showcase sales";
        default:
            return app;
    }
};
exports.getApplicationName = getApplicationName;
/**
 * Important, consider also updating the mapping file mapping-app-code-docker-images.txt in pipelines-v2/scripts used in the pipelines to get image name from app.
 * @param app
 */
const getRepositoryName = (app) => {
    switch (app) {
        case XtremApps.SHOWCASE_STOCK:
            return "xtrem-showcase-stock";
        case XtremApps.SHOWCASE_SALES:
            return "xtrem-showcase-sales";
        case XtremApps.SHOPFLOOR:
            return "xtrem-shopfloor";
        case XtremApps.GLOSSARY:
            return "xtrem-glossary";
        case XtremApps.X3_PROXY:
            return "xtrem-x3-proxy";
        case XtremApps.X3_CONNECTOR:
            return "xtrem-x3-connector";
        case XtremApps.SHOWCASE:
            return "xtrem-showcase";
        case XtremApps.SDMO:
        default:
            return "xtrem";
    }
};
exports.getRepositoryName = getRepositoryName;
const getClusterAppIdentifier = (id) => {
    const idSplit = id.split("#");
    const cluster = idSplit[0];
    const app = idSplit.length > 1 && idSplit[1] || "";
    return {
        cluster,
        app
    };
};
exports.getClusterAppIdentifier = getClusterAppIdentifier;
const getClusterAppDynamoDBIdentifier = (cluster, app) => {
    const appIdentifier = app ? `#${app}` : "";
    return `${cluster}${appIdentifier}`;
};
exports.getClusterAppDynamoDBIdentifier = getClusterAppDynamoDBIdentifier;
const getTerraformAppName = (xtremAppName) => {
    return xtremAppName ? xtremAppName.replace("_", "-") : xtremAppName;
};
exports.getTerraformAppName = getTerraformAppName;
const isSupportClusterApp = (clusterAppTags) => {
    const clusterAppSupportTag = clusterAppTags["support"];
    const clusterSupportTag = clusterAppTags["inherited#support"];
    return (clusterAppSupportTag !== null && clusterAppSupportTag !== void 0 ? clusterAppSupportTag : clusterSupportTag) === "true";
};
exports.isSupportClusterApp = isSupportClusterApp;
