/****  DANGER ZONE ****/
export declare enum XtremApps {
    SDMO = "sdmo",
    SHOPFLOOR = "shopfloor",
    SHOWCASE = "showcase",
    GLOSSARY = "glossary",
    X3_PROXY = "x3_proxy",
    X3_CONNECTOR = "x3_connector",
    SHOWCASE_STOCK = "showcase_stock",
    SHOWCASE_SALES = "showcase_sales",
    UNKNOWN = "unknown"
}
export declare enum TenantAppStatus {
    ERROR = "error",
    UNKNOWN = "unknown",
    CREATING = "creating",
    IMPORTING = "importing",
    READY = "ready",
    DELETING = "deleting"
}
export declare enum AppStatus {
    READY = "ready",
    ERROR = "error",
    MAINTENANCE = "maintenance",
    UNKNOWN = "unknown"
}
export declare enum SubscriptionType {
    PAID = "paid",
    INTERNAL = "internal"
}
export declare enum TenantType {
    DEMO = "demo",// Used to say the tenant is for a demo
    PRODUCTION = "production",// Actual production tenant
    DATA_REFERENCE = "data reference",// Used by sage internally (with reference cluster) to generate reference tenant to be used, ex reference-demo reference-release-template
    SANDBOX = "sandbox",// used when customer want to perform test when duplicating a tenant
    IMPLEMENTATION = "implementation",// used by intacct for setting up tenant and doing tests before deleting it for the actual tenant
    UNKNOWN = "unknown"
}
export declare enum TenantAppDataType {
    SETUP = "setup",
    DEMO = "demo",
    REFERENCE = "reference",
    LAYERS = "layers",
    UNKNOWN = "unknown"
}
export declare enum OperationKind {
    TenantAppProvisioning = "TenantAppProvisioning",
    TenantAppDeletion = "TenantAppDeletion",
    TenantAppExport = "TenantAppExport",
    TenantAppSandbox = "TenantAppSandbox",
    TenantAppImport = "TenantAppImport",
    TenantAppSupportAccess = "TenantAppSupportAccess",
    ClusterAppExtractTenantsAndUsers = "ClusterAppExtractTenantsAndUsers",
    ClusterAppUpgrade = "ClusterAppUpgrade",
    ClusterAppExportData = "ClusterAppExportData",
    ClusterAppImportData = "ClusterAppImportData",
    ClusterAppEasyRestore = "ClusterAppEasyRestore",
    ClusterAppValidateAppVersion = "ClusterAppValidationAppVersion",
    ClusterAppExecuteCustomSQL = "ClusterAppExecuteCustomSQL",
    ClusterAppUpdateTenantSetupData = "ClusterAppUpdateTenantSetupData",
    ClusterGatherDataStats = "ClusterGatherDataStats",
    MultiTenantDBUpgrade = "MultitenantDatabaseUpgrade",
    MultiTenantRestartDeployment = "MultitenantRestartDeployment",
    Generic = "Generic",
    AdminTasks = "AdminTasks"
}
export declare enum OperationAction {
    proceed = "proceed",
    reject = "reject",
    cancel = "cancel"
}
export declare enum OperationStatus {
    pending = "pending",
    running = "running",
    success = "success",
    error = "error",
    cancelled = "cancelled"
}
export declare enum OperationEventStatus {
    running = "running",
    success = "success",
    error = "error"
}
export declare enum TenantAppExportStatus {
    pending = "pending",
    running = "running",
    success = "success",
    error = "error",
    cancelled = "cancelled"
}
export declare enum BillingUserType {
    BUSINESS_USER = "businessUser",// charged as a user of the app
    OPERATIONAL_USER = "operationalUser",// charged as an OPS of the app
    API_USER = "api",
    UNKNOWN = "unknown"
}
export declare enum CloudmanagerUserRole {
    OPS = "ops",
    SALES_OPS = "salesOps",
    SUPPORT = "support",
    SUPPORT_OPS = "supportOps",
    SALES_REP = "salesRep",
    BILLING = "billing",
    READ_ONLY = "readOnly"
}
export declare const getApplicationName: (app: string) => string;
/**
 * Important, consider also updating the mapping file mapping-app-code-docker-images.txt in pipelines-v2/scripts used in the pipelines to get image name from app.
 * @param app
 */
export declare const getRepositoryName: (app: string) => "xtrem" | "xtrem-glossary" | "xtrem-shopfloor" | "xtrem-showcase-stock" | "xtrem-showcase-sales" | "xtrem-x3-proxy" | "xtrem-x3-connector" | "xtrem-showcase";
export declare const getClusterAppIdentifier: (id: string) => {
    cluster: string;
    app: string;
};
export declare const getClusterAppDynamoDBIdentifier: (cluster: string, app?: string) => string;
export declare const getTerraformAppName: (xtremAppName: string) => string;
export declare const isSupportClusterApp: (clusterAppTags: Record<string, string>) => boolean;
