"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const ts = __importStar(require("typescript"));
const x3_expression_parser_1 = require("../lib/functions/x3-expression-parser/x3-expression-parser");
(0, chai_1.use)(require('chai-as-promised'));
describe('Expression converter', () => {
    it('Can convert string literal', () => {
        const result = new x3_expression_parser_1.X3ExpressionParser('TestDocument').convertFunction("'foo'");
        chai_1.assert.isTrue(ts.isStringLiteral(result.newExpression));
    });
    it('Can convert numeric literal', () => {
        const result = new x3_expression_parser_1.X3ExpressionParser('TestDocument').convertFunction('1.2');
        chai_1.assert.isTrue(ts.isNumericLiteral(result.newExpression));
    });
    it('Can convert boolean literal', () => {
        const result = new x3_expression_parser_1.X3ExpressionParser('TestDocument').convertFunction('true');
        chai_1.assert.equal(result.escapedText, 'true');
    });
    it('Can convert null literal', () => {
        const result = new x3_expression_parser_1.X3ExpressionParser('TestDocument').convertFunction('null');
        chai_1.assert.equal(result.escapedText, 'null');
    });
    it('Can convert binary expression', () => {
        const result = new x3_expression_parser_1.X3ExpressionParser('TestDocument').convertFunction('a+b');
        chai_1.assert.isTrue(ts.isBinaryExpression(result.newExpression));
        chai_1.assert.isTrue(ts.isPlusToken(result.newExpression.operatorToken));
    });
    it('Can convert binary expression with ===', () => {
        const result = new x3_expression_parser_1.X3ExpressionParser('TestDocument').convertFunction('a===b');
        chai_1.assert.isTrue(ts.isBinaryExpression(result.newExpression));
        chai_1.assert.equal(result.newExpression.operatorToken.kind, ts.SyntaxKind.EqualsEqualsEqualsToken);
    });
    it('Can convert binary expression with == without null on right', () => {
        const result = new x3_expression_parser_1.X3ExpressionParser('TestDocument').convertFunction('a==b');
        chai_1.assert.isTrue(ts.isBinaryExpression(result.newExpression));
        chai_1.assert.equal(result.newExpression.operatorToken.kind, ts.SyntaxKind.EqualsEqualsEqualsToken);
    });
    it('Can convert binary expression with == with null on right', () => {
        const result = new x3_expression_parser_1.X3ExpressionParser('TestDocument').convertFunction('a==null');
        chai_1.assert.isTrue(ts.isBinaryExpression(result.newExpression));
        chai_1.assert.equal(result.newExpression.operatorToken.kind, ts.SyntaxKind.EqualsEqualsToken);
    });
    it('Can convert logical expression', () => {
        const result = new x3_expression_parser_1.X3ExpressionParser('TestDocument').convertFunction('a==null||b==null||a!==b');
        chai_1.assert.isTrue(ts.isBinaryExpression(result.newExpression));
        chai_1.assert.isTrue(ts.isBinaryExpression(result.newExpression.left));
        chai_1.assert.equal(result.newExpression.operatorToken.kind, ts.SyntaxKind.BarBarToken);
        chai_1.assert.equal(result.newExpression.left.operatorToken.kind, ts.SyntaxKind.BarBarToken);
        chai_1.assert.equal(result.escapedText, 'a == null || b == null || a !== b');
    });
});
//# sourceMappingURL=expression-converter-test.js.map