"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.eslintRcTemplate = void 0;
exports.eslintRcTemplate = {
    plugins: ['mocha', 'unicorn', '@sage/xtrem', 'unused-imports'],
    extends: ['airbnb', 'airbnb-typescript', 'eslint-config-airbnb-typescript', 'prettier'],
    rules: {
        // TODO: switch to "error" when all warning will be fixed and add more selectors
        '@typescript-eslint/naming-convention': [
            'warn',
            {
                selector: 'typeLike',
                format: ['StrictPascalCase'],
            },
        ],
        '@typescript-eslint/space-before-function-paren': 'off',
        // '@typescript-eslint/space-before-function-paren': ['error', 'never'],
        // eslint does not always indent like prettier so disable this one
        '@typescript-eslint/indent': 'off', // fixes for prettier
        // allow _foo functions and variables for now
        'no-underscore-dangle': 'off',
        // we export 1 artifact per source file so we need this one
        'import/prefer-default-export': 'off',
        // allow cycles in dependencies for now
        'import/no-cycle': 'off',
        'react/destructuring-assignment': 'off',
        // this rule detects bad imperative style so we should fix the code
        'no-param-reassign': [
            'error',
            {
                props: false,
            },
        ],
        'mocha/no-exclusive-tests': 'error',
        'unicorn/filename-case': [
            'error',
            {
                case: 'kebabCase',
                ignore: [/^(Jenkinsfile|Dockerfile|(CHANGELOG|README)\.md)$/],
            },
        ],
        'require-await': 'error',
        // conflict with prettier plugin
        'import/order': 'off',
        'prefer-template': 'off',
        'prefer-arrow-callback': 'off',
    },
    overrides: [
        {
            files: ['lib/**/*.ts', 'test/**/*.ts'],
            extends: ['plugin:@sage/xtrem/recommended-ts'],
            rules: {
                '@sage/xtrem/sql-compatible': 'error',
                '@sage/xtrem/call-super-in-control': 'error',
                'unused-imports/no-unused-imports': 'error',
                // promise rules
                'no-await-in-loop': 'off',
                'no-async-promise-executor': 'error',
                'no-promise-executor-return': 'error',
                'no-return-await': 'error',
                'require-await': 'error',
                'prefer-promise-reject-errors': 'error',
                '@typescript-eslint/no-floating-promises': 'error',
                // TODO: reenable this rule later
                // '@typescript-eslint/no-misused-promises': 'error',
                '@typescript-eslint/await-thenable': 'error',
                // TODO: review why we have to disable this react rule for xtrem-x3-gateway
                'react/forbid-prop-types': 'off',
            },
        },
        {
            files: ['test/**/*.ts'],
            rules: {
                // allow dependencies on dev packages for test
                'import/no-extraneous-dependencies': ['error', { devDependencies: true }],
            },
        },
        {
            files: ['lib/{pages,page-extensions,stickers}/**/*.ts'],
            rules: {
                // enforce these rules only server-side
                '@typescript-eslint/no-floating-promises': 'off',
                '@typescript-eslint/no-misused-promises': 'off',
                'require-await': 'off',
                '@typescript-eslint/await-thenable': 'off',
                'no-promise-executor-return': 'off',
                'no-return-await': 'off',
            },
        },
        {
            files: ['test/graphql/**/*.json'],
            extends: ['plugin:@sage/xtrem/recommended-json'],
        },
    ],
    parserOptions: {
        tsconfigRootDir: '.',
        project: 'tsconfig.json',
        extraFileExtensions: ['.json'],
    },
};
//# sourceMappingURL=eslintrc-template.js.map