export declare const eslintRcTemplate: {
    plugins: string[];
    extends: string[];
    rules: {
        '@typescript-eslint/naming-convention': (string | {
            selector: string;
            format: string[];
        })[];
        '@typescript-eslint/space-before-function-paren': string;
        '@typescript-eslint/indent': string;
        'no-underscore-dangle': string;
        'import/prefer-default-export': string;
        'import/no-cycle': string;
        'react/destructuring-assignment': string;
        'no-param-reassign': (string | {
            props: boolean;
        })[];
        'mocha/no-exclusive-tests': string;
        'unicorn/filename-case': (string | {
            case: string;
            ignore: RegExp[];
        })[];
        'require-await': string;
        'import/order': string;
        'prefer-template': string;
        'prefer-arrow-callback': string;
    };
    overrides: ({
        files: string[];
        extends: string[];
        rules: {
            '@sage/xtrem/sql-compatible': string;
            '@sage/xtrem/call-super-in-control': string;
            'unused-imports/no-unused-imports': string;
            'no-await-in-loop': string;
            'no-async-promise-executor': string;
            'no-promise-executor-return': string;
            'no-return-await': string;
            'require-await': string;
            'prefer-promise-reject-errors': string;
            '@typescript-eslint/no-floating-promises': string;
            '@typescript-eslint/await-thenable': string;
            'react/forbid-prop-types': string;
            'import/no-extraneous-dependencies'?: undefined;
            '@typescript-eslint/no-misused-promises'?: undefined;
        };
    } | {
        files: string[];
        rules: {
            'import/no-extraneous-dependencies': (string | {
                devDependencies: boolean;
            })[];
            '@sage/xtrem/sql-compatible'?: undefined;
            '@sage/xtrem/call-super-in-control'?: undefined;
            'unused-imports/no-unused-imports'?: undefined;
            'no-await-in-loop'?: undefined;
            'no-async-promise-executor'?: undefined;
            'no-promise-executor-return'?: undefined;
            'no-return-await'?: undefined;
            'require-await'?: undefined;
            'prefer-promise-reject-errors'?: undefined;
            '@typescript-eslint/no-floating-promises'?: undefined;
            '@typescript-eslint/await-thenable'?: undefined;
            'react/forbid-prop-types'?: undefined;
            '@typescript-eslint/no-misused-promises'?: undefined;
        };
        extends?: undefined;
    } | {
        files: string[];
        rules: {
            '@typescript-eslint/no-floating-promises': string;
            '@typescript-eslint/no-misused-promises': string;
            'require-await': string;
            '@typescript-eslint/await-thenable': string;
            'no-promise-executor-return': string;
            'no-return-await': string;
            '@sage/xtrem/sql-compatible'?: undefined;
            '@sage/xtrem/call-super-in-control'?: undefined;
            'unused-imports/no-unused-imports'?: undefined;
            'no-await-in-loop'?: undefined;
            'no-async-promise-executor'?: undefined;
            'prefer-promise-reject-errors'?: undefined;
            'react/forbid-prop-types'?: undefined;
            'import/no-extraneous-dependencies'?: undefined;
        };
        extends?: undefined;
    } | {
        files: string[];
        extends: string[];
        rules?: undefined;
    })[];
    parserOptions: {
        tsconfigRootDir: string;
        project: string;
        extraFileExtensions: string[];
    };
};
//# sourceMappingURL=eslintrc-template.d.ts.map