"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.X3TranslationGenerator = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const fs = __importStar(require("fs"));
const _ = __importStar(require("lodash"));
const path = __importStar(require("path"));
const x3_local_menu_dictionary_helper_1 = require("./x3-local-menu-dictionary-helper");
const x3_package_generator_1 = require("./x3-package-generator");
class X3TranslationGenerator {
    constructor(x3FolderName, dir, packageName, connPool, serviceName) {
        this.x3FolderName = x3FolderName;
        this.dir = dir;
        this.packageName = packageName;
        this.connPool = connPool;
        this.serviceName = serviceName;
    }
    async init() {
        const packages = await x3_package_generator_1.X3PackageGenerator.getPackages(this.connPool, this.x3FolderName, this.serviceName, {});
        const pack = packages.find(p => p.name === this.packageName);
        if (!pack)
            throw new Error(`Package ${this.packageName} not registered in metadata.`);
        this._metadata = pack;
        const localMenuHeaders = await x3_local_menu_dictionary_helper_1.X3LocalMenuDictionaryHelper.loadPackageLocalMenuHeaders(this.connPool, this.x3FolderName, this._metadata);
        await (0, xtrem_core_1.asyncArray)(Object.keys(localMenuHeaders)).forEach(async (localMenuNumber) => {
            await x3_local_menu_dictionary_helper_1.X3LocalMenuDictionaryHelper.getTranslationLocalMenuDefinition(this.connPool, this.x3FolderName, Number(localMenuNumber), this._metadata);
        });
    }
    async generateTranslationObject() {
        const localMenuDefinitions = {};
        const localMenusHeaderObjects = await x3_local_menu_dictionary_helper_1.X3LocalMenuDictionaryHelper.loadPackageLocalMenuHeaders(this.connPool, this.x3FolderName, this._metadata);
        const localMenuNumbers = Object.keys(localMenusHeaderObjects);
        await (0, xtrem_core_1.asyncArray)(localMenuNumbers).forEachParallel(10, async (localMenuNumber) => {
            const localMenuDefinition = await x3_local_menu_dictionary_helper_1.X3LocalMenuDictionaryHelper.getTranslationLocalMenuDefinition(this.connPool, this.x3FolderName, Number(localMenuNumber), this._metadata);
            if (Object.keys(localMenuDefinition).length > 0) {
                _.merge(localMenuDefinitions, localMenuDefinition);
            }
        });
        return localMenuDefinitions;
    }
    async generateTranslation() {
        if (!this._metadata.isCustom && !this._metadata.name.split('/')[1].startsWith(`${this.serviceName}-`)) {
            x3_package_generator_1.logger.verbose(() => `${this._metadata.name}: package will not be generated as it does not belong to the service ${this.serviceName}`);
            return;
        }
        // read data from database
        const translationObject = await this.generateTranslationObject();
        Object.keys(translationObject).forEach(lmdlangKey => {
            // read files
            // read files by key in localMenuDefinitions - language.
            const translationFilePath = path.join(this.dir, 'lib/i18n', `${lmdlangKey}.json`);
            if (fs.existsSync(translationFilePath)) {
                const translationJsonContent = JSON.parse(fs.readFileSync(translationFilePath, 'utf-8'));
                // merge data
                // merge enums
                _.merge(translationJsonContent, translationObject[lmdlangKey].enums);
                // save files
                fs.writeFileSync(`${translationFilePath}`, x3_package_generator_1.X3PackageGenerator.prettyifyJson(JSON.stringify(translationJsonContent)));
            }
        });
    }
}
exports.X3TranslationGenerator = X3TranslationGenerator;
//# sourceMappingURL=x3-translations-generator.js.map