"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.X3ServiceOptionsGenerator = void 0;
const fs = __importStar(require("fs"));
const _ = __importStar(require("lodash"));
const path = __importStar(require("path"));
const ts = __importStar(require("typescript"));
const x3_dictionary_helper_1 = require("./x3-dictionary-helper");
const x3_dictionary_interfaces_1 = require("./x3-dictionary-interfaces");
const x3_package_generator_1 = require("./x3-package-generator");
class X3ServiceOptionsGenerator {
    constructor(packageGenerator, activityCode) {
        this.packageGenerator = packageGenerator;
        this.activityCode = activityCode;
    }
    static { this.activityCodes = []; }
    get activityCodeName() {
        return this.activityCode.name;
    }
    get filename() {
        return `${_.kebabCase(this.activityCodeName)}.ts`;
    }
    get filepath() {
        return path.join(this.packageGenerator.dir, 'lib/service-options', this.filename);
    }
    generateServiceOptionsStatement() {
        // Example: const service = new ServiceOption({
        //     __filename,
        //     status: 'released',
        //     description: 'Safe X3 WAS',
        //     code: 'AYT',
        //     isHidden: false,
        // })
        return ts.factory.createVariableStatement([ts.factory.createToken(ts.SyntaxKind.ExportKeyword)], ts.factory.createVariableDeclarationList([
            ts.factory.createVariableDeclaration(ts.factory.createIdentifier(this.activityCodeName), undefined, undefined, ts.factory.createNewExpression(ts.factory.createIdentifier('ServiceOption'), [], [
                ts.factory.createObjectLiteralExpression([
                    ts.factory.createShorthandPropertyAssignment(ts.factory.createIdentifier('__filename'), undefined),
                    ts.factory.createPropertyAssignment(ts.factory.createIdentifier('status'), ts.factory.createStringLiteral('released')),
                    ts.factory.createPropertyAssignment(ts.factory.createIdentifier('description'), ts.factory.createStringLiteral(this.activityCode.description)),
                    ts.factory.createPropertyAssignment(ts.factory.createIdentifier('code'), ts.factory.createStringLiteral(this.activityCode.code)),
                    ts.factory.createPropertyAssignment(ts.factory.createIdentifier('isHidden'), ts.factory.createFalse()),
                ], true),
            ])),
        ], ts.NodeFlags.Const));
    }
    static generateServiceOptionImport() {
        return ts.factory.createImportDeclaration(undefined, ts.factory.createImportClause(false, undefined, ts.factory.createNamedImports([
            ts.factory.createImportSpecifier(false, undefined, ts.factory.createIdentifier('ServiceOption')),
        ])), ts.factory.createStringLiteral('@sage/xtrem-core'));
    }
    createServiceOption() {
        const activityCodeStatement = this.generateServiceOptionsStatement();
        const activityCodeImport = X3ServiceOptionsGenerator.generateServiceOptionImport();
        this.activityCodeDef = x3_package_generator_1.X3PackageGenerator.prettyifyTypescript([
            activityCodeImport,
            x3_package_generator_1.X3PackageGenerator.newline,
            x3_package_generator_1.X3PackageGenerator.newline,
            activityCodeStatement,
            x3_package_generator_1.X3PackageGenerator.newline,
            x3_package_generator_1.X3PackageGenerator.newline,
        ]);
        return this.activityCodeDef;
    }
    generateServiceOption() {
        const profiler = x3_package_generator_1.logger.info(`${this.packageGenerator.packageName}: Create Service Option file `);
        const acNode = this.createServiceOption();
        profiler.success(`${this.packageGenerator.packageName}: Create Service Option file success`);
        fs.writeFileSync(this.filepath, acNode);
    }
    static async generatePackageServiceOptions(packageGenerator) {
        const pathToActivityCodes = path.join(packageGenerator.dir, 'lib/service-options');
        if (fs.existsSync(pathToActivityCodes))
            fs.rmSync(pathToActivityCodes, { recursive: true });
        fs.mkdirSync(pathToActivityCodes, { recursive: true });
        // Get activity codes
        const activityCodes = await X3ServiceOptionsGenerator.loadActivityCodes(packageGenerator.connPool, packageGenerator.x3FolderName, packageGenerator.serviceName);
        // Create service-options
        const indexExports = [];
        activityCodes
            .filter(activityCode => packageGenerator.metadata.name === activityCode.packageName)
            .forEach(activityCode => {
            const generator = new X3ServiceOptionsGenerator(packageGenerator, activityCode);
            generator.generateServiceOption();
            indexExports.push(generator.filename);
        });
        // Create index file for service-option
        const serviceOptionsIndexFilename = path.join(pathToActivityCodes, 'index.ts');
        let indexContent = 'export type Dummy = void';
        if (indexExports.length > 0) {
            indexContent = indexExports
                .slice()
                .sort((a, b) => a.localeCompare(b))
                .map(indexExport => `export * from './${path.parse(indexExport).name}';`)
                .join('\n');
        }
        fs.writeFileSync(serviceOptionsIndexFilename, x3_package_generator_1.X3PackageGenerator.prettyifyTypescript(indexContent));
    }
    static queryActivityCodes(connPool, x3Folder) {
        const activityCodeSql = `SELECT
                                    ac.CODACT_0,
                                    ac.MODULE_0,
                                    atxt.TEXTE_0,
                                    pack.APACK_0
                                FROM
                                    ${x3Folder}.ACTIV ac
                                LEFT JOIN
                                    ${x3Folder}.ATEXTE atxt
                                ON
                                    ac.LIBACT_0 = atxt.NUMERO_0 AND atxt.LAN_0 = 'ENG'
                                LEFT JOIN
                                    ${x3Folder}.APACKACV acv
                                ON
                                    ac.CODACT_0 = acv.CODACT_0
                                LEFT JOIN
                                    ${x3Folder}.APACKAGE pack
                                ON
                                    pack.APACKCOD_0  = acv.APACKCOD_0
                                WHERE
                                    ac.TYP_0 IN (1,3)
                                AND
                                    (EXISTS(SELECT 1 FROM ${x3Folder}.ANODPROP prop WHERE prop.CODACT_0 = ac.CODACT_0)
                                    OR EXISTS(SELECT 1 FROM ${x3Folder}.ANODE anod WHERE anod.CODACT_0 = ac.CODACT_0))
                                ORDER BY ac.MODULE_0, ac.CODACT_0`;
        return connPool.withConnection(cnx => {
            return connPool.createReader(cnx, activityCodeSql).readAll();
        });
    }
    static async findActivityCode(connPool, x3Folder, code, serviceName) {
        if (this.activityCodes.length === 0) {
            await this.loadActivityCodes(connPool, x3Folder, serviceName);
        }
        return this.activityCodes.find(activityCode => {
            return activityCode.code === code;
        });
    }
    static async loadActivityCodes(connPool, x3Folder, serviceName) {
        if (this.activityCodes.length > 0) {
            return this.activityCodes;
        }
        const wrongCustomAC = [];
        const queryActivityCodes = await this.queryActivityCodes(connPool, x3Folder);
        queryActivityCodes.forEach(ac => {
            const code = x3_dictionary_helper_1.X3DictionaryHelper.fromSql('string', ac.CODACT_0);
            const isCustom = /^[X-Z].*/.test(x3_dictionary_helper_1.X3DictionaryHelper.fromSql('string', ac.CODACT_0));
            const acPackageName = x3_dictionary_helper_1.X3DictionaryHelper.fromSql('string', ac.APACK_0);
            const acDescription = x3_dictionary_helper_1.X3DictionaryHelper.fromSql('string', ac.TEXTE_0);
            const activityCodeData = {
                code,
                description: acDescription || `Activity Code ${code}`,
                isCustom,
                module: x3_dictionary_helper_1.X3DictionaryHelper.fromSql('integer', ac.MODULE_0),
                packageName: isCustom ? acPackageName : x3_dictionary_interfaces_1.platformPackages.system(serviceName),
                name: `${_.startCase(code.toLowerCase()).replaceAll(' ', '')}ActivityCode`,
            };
            if (isCustom && !acPackageName)
                wrongCustomAC.push(code);
            this.activityCodes.push(activityCodeData);
        });
        if (wrongCustomAC.length > 0) {
            throw new Error(`Partner activity codes need to be allocated to partner packages. Activity codes not allocated to a partner package ${wrongCustomAC}`);
        }
        return this.activityCodes;
    }
}
exports.X3ServiceOptionsGenerator = X3ServiceOptionsGenerator;
//# sourceMappingURL=x3-service-options-generator.js.map