"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.X3NodeGeneratorHelper = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const _ = __importStar(require("lodash"));
const ts = __importStar(require("typescript"));
const x3_node_dictionary_helper_1 = require("./x3-node-dictionary-helper");
const x3_package_generator_1 = require("./x3-package-generator");
class X3NodeGeneratorHelper {
    /**
     * Get the properties of a node from the metadata
     * @param anodeObjectResult
     * @returns
     */
    static async getNodeProperties(connPool, x3FolderName, anodeObjectResult) {
        const anodeProperties = await x3_node_dictionary_helper_1.X3NodeDictionaryHelper.getNodeProperties(connPool, x3FolderName, anodeObjectResult.nodeName, anodeObjectResult.nodeBinding, anodeObjectResult.packageName);
        return anodeProperties;
    }
    static { this.nodeObjects = {}; }
    /**
     * Get the node object
     * @param anodeObjectResult
     * @returns
     */
    static getNodeObject(nodeName) {
        return this.nodeObjects[nodeName];
    }
    /**
     * Get node metadata from the database
     * @param nodePackage
     * @param nodeName
     * @returns
     */
    static async loadNodeObjects(connPool, x3FolderName) {
        if (Object.keys(this.nodeObjects).length)
            return Object.values(this.nodeObjects);
        const anodeObjectResults = await x3_node_dictionary_helper_1.X3NodeDictionaryHelper.getAllNodeData(connPool, x3FolderName);
        await (0, xtrem_core_1.asyncArray)(anodeObjectResults).forEach(async (anodeObjectResult) => {
            const pckNodeObject = {
                package: anodeObjectResult.packageName,
                nodeName: anodeObjectResult.nodeName,
                nodeBinding: anodeObjectResult.nodeBinding,
                storage: 'external',
                isPublished: anodeObjectResult.isPublished,
                tableName: anodeObjectResult.tableName,
                properties: [],
                keyPropertyNames: [],
                canRead: true, // TODO: Number(anodeObjectResults[index].canRead) === 2
                canSearch: true, // TODO: Number(anodeObjectResults[index].canSearch) === 2
                denormalized: anodeObjectResult.denormalized,
                denormalizedNodes: anodeObjectResult.denormalizedNodes,
                isVitalReferenceChild: anodeObjectResult.isVitalReferenceChild,
                isVitalCollectionChild: anodeObjectResult.isVitalCollectionChild,
                tableFilters: anodeObjectResult.tableFilters,
                authorizationCode: anodeObjectResult.authorizationCode,
            };
            if (anodeObjectResult.activityCode) {
                pckNodeObject.activityCode = anodeObjectResult.activityCode;
            }
            const nodeProperties = await X3NodeGeneratorHelper.getNodeProperties(connPool, x3FolderName, anodeObjectResult);
            if (!pckNodeObject.denormalized) {
                pckNodeObject.indexes = [{ orderBy: {}, isUnique: true, isNaturalKey: true }];
            }
            nodeProperties.forEach(prop => {
                x3_package_generator_1.logger.verbose(() => `Detected ${prop.packageName}/${pckNodeObject.nodeName}.${prop.name}`);
                pckNodeObject.properties.push(prop);
                if (prop.keyPart) {
                    pckNodeObject.keyPropertyNames.push(prop.name);
                    if (pckNodeObject.indexes?.length) {
                        pckNodeObject.indexes[0].orderBy[prop.name] = Number(prop.keyOrder) === 2 ? 1 : -1;
                    }
                }
                const { joinValues } = prop;
                if (['collections'].includes(prop.type) && !joinValues?.length && !prop.composite?.propertyPath) {
                    throw Error(`Missing join values on property ${prop.nodeName}.${prop.name}`);
                }
            });
            pckNodeObject.operations = (await this.getNodeOperations(connPool, x3FolderName)).filter(operation => operation.nodeName === anodeObjectResult.nodeName);
            pckNodeObject.canCreate = !!pckNodeObject.operations.find(op => (op.type === 'create' || (op.createFlag && op.type === 'create/update/delete')) &&
                (op.packageName == null || op.packageName === pckNodeObject.package));
            pckNodeObject.canUpdate = !!pckNodeObject.operations.find(op => (op.type === 'update' || (op.updateFlag && op.type === 'create/update/delete')) &&
                (op.packageName == null || op.packageName === pckNodeObject.package));
            pckNodeObject.canDelete = !!pckNodeObject.operations.find(op => (op.type === 'delete' || (op.deleteFlag && op.type === 'create/update/delete')) &&
                (op.packageName == null || op.packageName === pckNodeObject.package));
            this.nodeObjects[pckNodeObject.nodeName] = pckNodeObject;
        });
        return Object.values(this.nodeObjects);
    }
    static getNodeExtensionName(nodeName) {
        return `${nodeName}Extension`;
    }
    static setDecoratorAttribute(decoratorAttributes, flag, attributeName, value) {
        if (flag)
            decoratorAttributes.push(ts.factory.createPropertyAssignment(attributeName, value));
    }
    /**
     * resolve which property decorator to allocate to the node property
     * @param type
     * @returns
     */
    static generateNodePropertyDecoratorName(type) {
        if (type === 'localizedString')
            return ts.factory.createIdentifier(`stringProperty`);
        return ts.factory.createIdentifier(`${type}Property`);
    }
    /**
     * Build join object
     * @param joins
     * @returns
     */
    static makeJoinObjectLiteral(joins) {
        if (Object.keys(joins).length > 0) {
            const referenceJoinsProperties = Object.entries(joins).map(entry => {
                const propertyName = entry[0];
                const propertyJoin = entry[1];
                const joinObject = Object.entries(propertyJoin).map(join => {
                    const targetPropertyName = join[0];
                    const targetJoin = join[1];
                    if (ts.isMethodDeclaration(targetJoin))
                        return targetJoin;
                    return ts.factory.createPropertyAssignment(targetPropertyName, targetJoin);
                });
                return ts.factory.createPropertyAssignment(propertyName, ts.factory.createObjectLiteralExpression(joinObject, true));
            });
            return ts.factory.createObjectLiteralExpression(referenceJoinsProperties, true);
        }
        return undefined;
    }
    /**
     * Generate const join object that will be passed as a parameter to the X3StorageManagerExtension constructor
     * @param nodeObject
     * @param packageName package of proeprties to generate joins on
     * @returns
     */
    static generateNodeExtensionModule(nodeExtensionObject) {
        return ts.factory.createModuleDeclaration([ts.factory.createToken(ts.SyntaxKind.DeclareKeyword)], ts.factory.createStringLiteral(`${nodeExtensionObject.nodePackage}/lib/nodes/${_.kebabCase(nodeExtensionObject.nodeName)}`), ts.factory.createModuleBlock([
            ts.factory.createInterfaceDeclaration([ts.factory.createToken(ts.SyntaxKind.ExportKeyword)], ts.factory.createIdentifier(nodeExtensionObject.nodeName), undefined, [
                ts.factory.createHeritageClause(ts.SyntaxKind.ExtendsKeyword, [
                    ts.factory.createExpressionWithTypeArguments(ts.factory.createIdentifier(X3NodeGeneratorHelper.getNodeExtensionName(nodeExtensionObject.nodeName)), undefined),
                ]),
            ], []),
        ]), ts.NodeFlags.ExportContext);
    }
    /**
     * generate the primary order by
     * @param nodeObject
     * @returns
     */
    static generateIndexesPropertyAssignments(nodeObject) {
        let indexObjects = [];
        if (nodeObject.indexes?.length) {
            indexObjects = nodeObject.indexes.map(index => {
                const orderByObject = [];
                Object.entries(index.orderBy).forEach(([key, val]) => {
                    orderByObject.push(ts.factory.createPropertyAssignment(ts.factory.createStringLiteral(String(key)), val > 0
                        ? ts.factory.createNumericLiteral(val)
                        : ts.factory.createPrefixUnaryExpression(ts.SyntaxKind.MinusToken, ts.factory.createNumericLiteral(-val))));
                });
                const indexProperties = [
                    ts.factory.createPropertyAssignment('orderBy', ts.factory.createObjectLiteralExpression(orderByObject, true)),
                    ts.factory.createPropertyAssignment('isUnique', index.isUnique ? ts.factory.createTrue() : ts.factory.createFalse()),
                ];
                if (index.isNaturalKey) {
                    indexProperties.push(ts.factory.createPropertyAssignment('isNaturalKey', ts.factory.createTrue()));
                }
                return ts.factory.createObjectLiteralExpression(indexProperties, true);
            });
        }
        return ts.factory.createPropertyAssignment('indexes', ts.factory.createArrayLiteralExpression(indexObjects, true));
    }
    static getCompositeReferencesManagerOption(nodeObject, isExtension = false) {
        if (nodeObject.properties.filter(prop => (prop.packageName === nodeObject.package || (!isExtension && prop.packageName === null)) &&
            prop.composite?.referenceProperty &&
            prop.composite?.propertyPath).length > 0) {
            return ts.factory.createShorthandPropertyAssignment('compositeReferences');
        }
        return undefined;
    }
    static getAccessMappingsManagerOption(nodeObject, isExtension = false) {
        const operationWithauthorizationOption = (nodeObject.operations || []).filter(op => (op.packageName === nodeObject.package || (!isExtension && op.packageName === null)) &&
            op.authorizationOption != null);
        if (operationWithauthorizationOption.length > 0) {
            return ts.factory.createPropertyAssignment('accessMapping', ts.factory.createObjectLiteralExpression(operationWithauthorizationOption.map(op => ts.factory.createPropertyAssignment(op.operationName, ts.factory.createStringLiteral(op.authorizationOption || '')))));
        }
        return undefined;
    }
    static getStorageManagerOptions(nodeObject) {
        const storageManagerOptionProperties = [
            ts.factory.createShorthandPropertyAssignment('joins'),
        ];
        if (nodeObject.denormalized) {
            storageManagerOptionProperties.push(ts.factory.createPropertyAssignment('isDenormalized', ts.factory.createTrue()));
            storageManagerOptionProperties.push(ts.factory.createShorthandPropertyAssignment('denormalized'));
        }
        const compostiteReferences = this.getCompositeReferencesManagerOption(nodeObject);
        if (compostiteReferences) {
            storageManagerOptionProperties.push(compostiteReferences);
        }
        const accessMapping = this.getAccessMappingsManagerOption(nodeObject);
        if (accessMapping) {
            storageManagerOptionProperties.push(accessMapping);
        }
        const keyProperties = nodeObject.properties.filter(prop => !!prop.keyPart);
        if (keyProperties.length > 1) {
            const joinFallProperties = keyProperties
                .filter(prop => prop.isNullable)
                .map(prop => ts.factory.createStringLiteral(prop.name));
            if (joinFallProperties.length > 0) {
                storageManagerOptionProperties.push(ts.factory.createPropertyAssignment(ts.factory.createIdentifier('joinFallbackProperties'), ts.factory.createArrayLiteralExpression(joinFallProperties, true)));
            }
        }
        const denPropertiesColSuffixList = nodeObject.properties.filter(prop => prop.denomColumnIndex && prop.denomColumnIndex !== 0);
        if (denPropertiesColSuffixList.length > 0) {
            const denProperties = denPropertiesColSuffixList.map(prop => {
                return ts.factory.createPropertyAssignment(ts.factory.createIdentifier(prop.name), ts.factory.createNumericLiteral(this.getDenPropertiesIndexSuffix(prop.denomColumnIndex)));
            });
            storageManagerOptionProperties.push(ts.factory.createPropertyAssignment(ts.factory.createIdentifier('denormalizedPropertyColumnSuffix'), ts.factory.createObjectLiteralExpression(denProperties, true)));
        }
        return ts.factory.createObjectLiteralExpression(storageManagerOptionProperties, true);
    }
    static getStorageManagerExtensionOptions(nodeExtensionObject) {
        const storageManagerOptionProperties = [
            ts.factory.createShorthandPropertyAssignment('joins'),
        ];
        const compostiteReferences = this.getCompositeReferencesManagerOption(nodeExtensionObject, true);
        if (compostiteReferences) {
            storageManagerOptionProperties.push(compostiteReferences);
        }
        const accessMapping = this.getAccessMappingsManagerOption(nodeExtensionObject, true);
        if (accessMapping) {
            storageManagerOptionProperties.push(accessMapping);
        }
        if (nodeExtensionObject.canCreate)
            storageManagerOptionProperties.push(ts.factory.createPropertyAssignment('canCreate', ts.factory.createTrue()));
        if (nodeExtensionObject.canUpdate)
            storageManagerOptionProperties.push(ts.factory.createPropertyAssignment('canUpdate', ts.factory.createTrue()));
        if (nodeExtensionObject.canDelete)
            storageManagerOptionProperties.push(ts.factory.createPropertyAssignment('canDelete', ts.factory.createTrue()));
        return ts.factory.createObjectLiteralExpression(storageManagerOptionProperties, true);
    }
    static async getNodeExtensions(connPool, x3Folder, packageName) {
        // Get a distinct nodes with extened properties
        const nodeExtensionData = (await x3_node_dictionary_helper_1.X3NodeDictionaryHelper.getNodeExtensionData(connPool, x3Folder)).filter(nodeExtension => nodeExtension.package === packageName);
        return (0, xtrem_core_1.asyncArray)(nodeExtensionData)
            .map(async (nodeExtension) => {
            const operations = (await X3NodeGeneratorHelper.getNodeOperations(connPool, x3Folder)).filter(operation => operation.packageName === packageName && operation.nodeName === nodeExtension.nodeName);
            const canCreate = !!operations.find(op => op.type === 'create' || (op.type === 'create/update/delete' && op.createFlag));
            const canUpdate = !!operations.find(op => op.type === 'update' || (op.type === 'create/update/delete' && op.updateFlag));
            const canDelete = !!operations.find(op => op.type === 'delete' || (op.type === 'create/update/delete' && op.deleteFlag));
            return {
                ...nodeExtension,
                properties: (await x3_node_dictionary_helper_1.X3NodeDictionaryHelper.getNodeProperties(connPool, x3Folder, nodeExtension.nodeName, nodeExtension.nodeBinding, nodeExtension.nodePackage)).filter(property => property.packageName === packageName),
                operations,
                canCreate,
                canUpdate,
                canDelete,
            };
        })
            .filter(async (nodeExtension) => {
            const mainNodeProps = (await x3_node_dictionary_helper_1.X3NodeDictionaryHelper.getNodeProperties(connPool, x3Folder, nodeExtension.nodeName, nodeExtension.nodeBinding, nodeExtension.nodePackage)).filter(property => property.packageName === nodeExtension.nodePackage);
            const mainNodeOperations = (await X3NodeGeneratorHelper.getNodeOperations(connPool, x3Folder)).filter(operation => (operation.packageName || nodeExtension.nodePackage) === nodeExtension.nodePackage);
            if (mainNodeProps.length === 0 && mainNodeOperations.length === 0) {
                x3_package_generator_1.logger.error(() => `Cannot create node extension for ${nodeExtension.nodeName} in ${nodeExtension.package}, the main node has no properties/operations and was not created`);
                return false;
            }
            return true;
        })
            .toArray();
    }
    static async getOperationInputOutputNode(connPool, x3Folder, nodeName, nodeBinding, packageName, direction) {
        return {
            nodeName,
            nodeBinding,
            package: packageName,
            storage: 'json',
            canRead: false,
            canSearch: false,
            isPublished: false,
            keyPropertyNames: [],
            tableName: '',
            properties: (await x3_node_dictionary_helper_1.X3NodeDictionaryHelper.getOperationNodeProperties(connPool, x3Folder, nodeBinding)).filter(prop => prop.direction === 'both' || prop.direction === direction),
        };
    }
    static async getNodeOperations(connPool, x3Folder) {
        if (this.nodeOperations)
            return this.nodeOperations;
        const baseNodeOperations = await x3_node_dictionary_helper_1.X3NodeDictionaryHelper.getBaseNodeOperations(connPool, x3Folder);
        this.nodeOperations = await (0, xtrem_core_1.asyncArray)(baseNodeOperations)
            .map(async (operation) => {
            const mainNode = await x3_node_dictionary_helper_1.X3NodeDictionaryHelper.findNodeData(connPool, x3Folder, operation.nodeName);
            if (operation.type === 'custom') {
                if (operation.parameter.type === 'node') {
                    operation.parameter.nodeObject = this.nodeObjects[operation.parameter.nodeName];
                }
                else {
                    if (!operation.parameter.nodeBinding) {
                        throw new Error(`${operation.nodeName}.${operation.operationName}: missing parameter node binding`);
                    }
                    operation.parameter.nodeObject = await this.getOperationInputOutputNode(connPool, x3Folder, operation.parameter.nodeName, operation.parameter.nodeBinding, operation.packageName || mainNode.packageName, 'input');
                }
                switch (operation.returnParam.type) {
                    case 'keys':
                    case 'node':
                        operation.returnParam.nodeObject = this.nodeObjects[operation.returnParam.nodeName];
                        break;
                    case 'constructed':
                        if (operation.returnParam.nodeBinding)
                            operation.returnParam.nodeObject = await this.getOperationInputOutputNode(connPool, x3Folder, operation.returnParam.nodeName, operation.returnParam.nodeBinding, operation.packageName || mainNode.packageName, 'output');
                        break;
                    default:
                        throw new Error(`${operation.nodeName}.${operation.operationName}: unmanaged response binding, ${operation.returnParam.type}`);
                }
                if (operation.returnParam.type === 'node') {
                    operation.returnParam.nodeObject = this.nodeObjects[operation.returnParam.nodeName];
                }
                else if (operation.returnParam.nodeBinding) {
                    operation.returnParam.nodeObject = await this.getOperationInputOutputNode(connPool, x3Folder, operation.returnParam.nodeName, operation.returnParam.nodeBinding, operation.packageName || mainNode.packageName, 'output');
                }
            }
            return operation;
        })
            .toArray();
        return this.nodeOperations;
    }
    static getDenPropertiesIndexSuffix(index) {
        if (index === 0)
            return index;
        return index - 1;
    }
}
exports.X3NodeGeneratorHelper = X3NodeGeneratorHelper;
//# sourceMappingURL=x3-node-generator-helper.js.map