import { Dict } from '@sage/xtrem-core';
import { Pool } from '@sage/xtrem-x3-sql';
import * as ts from 'typescript';
import { AnodeDataModelBind, AnodeOperation, AnodeProperty, ApiNodeClassObject, ApiNodeExtensionClassObject, PropertyType } from './x3-dictionary-interfaces';
export declare class X3NodeGeneratorHelper {
    /**
     * Get the properties of a node from the metadata
     * @param anodeObjectResult
     * @returns
     */
    static getNodeProperties(connPool: Pool, x3FolderName: string, anodeObjectResult: AnodeDataModelBind): Promise<AnodeProperty[]>;
    private static nodeObjects;
    /**
     * Get the node object
     * @param anodeObjectResult
     * @returns
     */
    static getNodeObject(nodeName: string): ApiNodeClassObject;
    /**
     * Get node metadata from the database
     * @param nodePackage
     * @param nodeName
     * @returns
     */
    static loadNodeObjects(connPool: Pool, x3FolderName: string): Promise<ApiNodeClassObject[]>;
    static getNodeExtensionName(nodeName: string): string;
    static setDecoratorAttribute(decoratorAttributes: ts.ObjectLiteralElementLike[], flag: boolean, attributeName: string, value: ts.Expression): void;
    /**
     * resolve which property decorator to allocate to the node property
     * @param type
     * @returns
     */
    static generateNodePropertyDecoratorName(type: PropertyType): ts.Identifier;
    /**
     * Build join object
     * @param joins
     * @returns
     */
    static makeJoinObjectLiteral(joins: Dict<Dict<ts.LiteralExpression | ts.MethodDeclaration | ts.ArrowFunction>>): ts.ObjectLiteralExpression | undefined;
    /**
     * Generate const join object that will be passed as a parameter to the X3StorageManagerExtension constructor
     * @param nodeObject
     * @param packageName package of proeprties to generate joins on
     * @returns
     */
    static generateNodeExtensionModule(nodeExtensionObject: ApiNodeExtensionClassObject): ts.ModuleDeclaration;
    /**
     * generate the primary order by
     * @param nodeObject
     * @returns
     */
    static generateIndexesPropertyAssignments(nodeObject: ApiNodeClassObject): ts.PropertyAssignment;
    private static getCompositeReferencesManagerOption;
    private static getAccessMappingsManagerOption;
    static getStorageManagerOptions(nodeObject: ApiNodeClassObject): ts.ObjectLiteralExpression;
    static getStorageManagerExtensionOptions(nodeExtensionObject: ApiNodeExtensionClassObject): ts.ObjectLiteralExpression;
    static getNodeExtensions(connPool: Pool, x3Folder: string, packageName: string): Promise<ApiNodeExtensionClassObject[]>;
    private static getOperationInputOutputNode;
    private static nodeOperations;
    static getNodeOperations(connPool: Pool, x3Folder: string): Promise<AnodeOperation[]>;
    static getDenPropertiesIndexSuffix(index: number): number;
}
//# sourceMappingURL=x3-node-generator-helper.d.ts.map