import { Pool } from '@sage/xtrem-x3-sql';
import * as ts from 'typescript';
import { ActivityCode, AnodeOperation, AnodeProperty, ApiNodeClassObject, ApiNodeExtensionClassObject, ImportEntry } from './x3-dictionary-interfaces';
import { X3PackageGenerator } from './x3-package-generator';
export declare class X3NodeClassGenerator {
    private readonly packageGenerator;
    private readonly connPool;
    private readonly x3FolderName;
    constructor(packageGenerator: X3PackageGenerator, connPool: Pool, x3FolderName: string);
    addImport(name: string, importEntry: ImportEntry, isExtension: boolean): void;
    private getGenericDatatype;
    private createTableFiltersArg;
    /**
     * Generate the object passed in as an argument to the node decorator
     * @param nodeObject
     * @returns
     */
    generateNodeDecoratorArgument(nodeObject: ApiNodeClassObject): Promise<ts.ObjectLiteralExpression>;
    getNodePackageDetails(nodeClassPropObject: AnodeProperty): Promise<{
        targetNode: string;
        targetPackage: string;
        targetPackageAlias: string;
    }>;
    private getFilterObjectExpression;
    private setReferencePropertyDecoratorAttributes;
    private setCollectionPropertyDecoratorAttributes;
    private setStringPropertyDecoratorAttributes;
    private setDecimalPropertyDecoratorAttributes;
    private setEnumPropertyDecoratorAttributes;
    private setDatePropertyDefaultDecoratorAttributes;
    private generateComputeValue;
    /**
     * generate the getValue method and add it to the decorator attributes list
     * @param nodeClassPropObject
     * @param decoratorAttributes
     * @returns
     */
    private static generateGetValue;
    /**
     * Generate the computeValue method and add it to the decorator attributes list
     * @param nodeClassPropObject
     * @param decoratorAttributes
     * @returns
     */
    private generateComputedValuesExpression;
    /**
     * Take in an array of property paths and transform them to an array literal that contains,
     * string literals (for single depth paths)
     * or object literal for complex paths
     * Example:
     * receive an array like
     * ['defaultPotencyInInternationalUnit','unitForDays.numberOfDecimals','company.legislation.code','company.code']
     *
     * Transform it to a selector object like below
     *
     * {
     *   defaultPotencyInInternationalUnit: true,
     *   unitForDays: { numberOfDecimals: true },
     *   company, { legislation: { code: true }, code: true}
     * }
     *
     * and the use this selector to construct the dependsOn attribute array value
     *
     * dependsOn: [
     *       'defaultPotencyInInternationalUnit',
     *       { unitForDays: ['numberOfDecimals'] },
     *       { company: [{ legislation: ['code'] }, 'code'] },
     *   ],
     *
     * @param dependsOn
     * @returns
     */
    private static generateDependsOnArray;
    generateServiceOptions(activityCode: ActivityCode, nodeClassPropObject: AnodeProperty, isExtension: boolean): ts.PropertyAccessExpression;
    getPropertyServiceOptions(nodeClassPropObject: AnodeProperty, isExtension: boolean): Promise<ts.ArrayLiteralExpression | undefined>;
    /**
     * Generate property decorator object literal parameter
     * @param nodeClassPropObject
     * @returns
     */
    generateNodeClassPropertyDecoratorArgument(nodeClassPropObject: AnodeProperty, isExtension: boolean): Promise<ts.ObjectLiteralExpression>;
    /**
     * Generate a property's decorator
     * @param nodeClassPropObject
     * @returns
     */
    generatePropertyDecorator(nodeClassPropObject: AnodeProperty, isExtension: boolean): Promise<ts.Decorator>;
    /**
     * Generate a node property with its decorator
     * @param nodeClassPropObject
     * @returns
     */
    generateNodeClassProperty(nodeClassPropObject: AnodeProperty, isExtension: boolean): Promise<ts.ClassElement>;
    /**
     * generate all properties of a node or node extension
     * @param nodeObject
     * @param packageName source package of the properties,
     *                    for node extensions this will be different from the node's package
     * @param isExtension
     * @returns
     */
    generateNodeClassProperties(nodeObject: ApiNodeClassObject | ApiNodeExtensionClassObject, packageName: string, isExtension: boolean): Promise<ts.ClassElement[]>;
    /**
     * Generate the value of a element pf the parameters/return attribute on the mutation/query decorator
     * @param operation
     * @param parameterNode
     * @param property
     * @param options
     * isExtension - are we processing an operation in a extension
     * respectIsMutable - if the parameter is a reference and is non-mutable, we do not need to type the reference to the target, but the actual scalar column type
     * @returns
     */
    generateParameterDecoratorLiteral(operation: AnodeOperation, parameterNode: ApiNodeClassObject, property: AnodeProperty, options: {
        isExtension: boolean;
        respectIsMutable?: boolean;
    }): Promise<ts.ObjectLiteralExpression | ts.StringLiteral>;
    private getNodeExpression;
    generateOperationDecoratorArgument(operation: AnodeOperation, isExtension: boolean): Promise<ts.ObjectLiteralExpression>;
    generateOperationDecorator(operation: AnodeOperation, isExtension: boolean): Promise<ts.Decorator>;
    private getPropertyTsType;
    private getNodePath;
    private generateOperationParameters;
    private generateReturnObject;
    private generateNodeClassOperation;
    generateNodeClassOperations(nodeObject: ApiNodeClassObject | ApiNodeExtensionClassObject, packageName: string, isExtension: boolean): Promise<ts.ClassElement[]>;
    /**
     * generate a node's decorator
     * @param nodeObject
     * @returns
     */
    generateNodeDecorator(nodeObject: ApiNodeClassObject): Promise<ts.Decorator>;
    /**
     * Generate node/node extension members memebers
     * @param nodeObject
     * @returns
     */
    generateNodeMembers(nodeObject: ApiNodeClassObject | ApiNodeExtensionClassObject, isExtension: boolean): Promise<ts.ClassElement[]>;
    /**
     * Generate a node class
     * @param nodeObject
     * @returns
     */
    generateNodeClass(nodeObject: ApiNodeClassObject): Promise<ts.Node>;
    /**
     * Generate the object passed in as an argument to the node decorator
     * @param nodeObject
     * @returns
     */
    generateNodeExtensionDecoratorArgument(nodeExtensionObject: ApiNodeExtensionClassObject): Promise<ts.ObjectLiteralExpression>;
    /**
     * generate a node extension decorator
     * @param nodeObject
     * @returns
     */
    generateNodeExtensionDecorator(nodeExtensionObject: ApiNodeExtensionClassObject): Promise<ts.Decorator>;
    /**
     * Generate a node extension class
     * @param nodeObject
     * @returns
     */
    generateNodeExtensionClass(nodeExtensionObject: ApiNodeExtensionClassObject): Promise<ts.Node>;
}
//# sourceMappingURL=x3-node-class-generator.d.ts.map