import { AnyValue } from '@sage/xtrem-shared';
import * as estree from 'estree';
import * as ts from 'typescript';
import { ConversionExpressionResult } from './x3-expression-interfaces';
export declare class X3ExpressionParser {
    readonly nodeName: string;
    constructor(nodeName: string);
    static resolveLiteral(value: AnyValue): string;
    static getBinaryToken(operator: string): ts.BinaryOperator | ts.BinaryOperatorToken;
    private convertBinaryExpression;
    private getExpressionFromPath;
    private walkMemberExpression;
    private convertMemberExpression;
    static convertLiteral(value: AnyValue | RegExp | bigint): ConversionExpressionResult;
    private convertUnaryExpression;
    private convertLogicalExpression;
    private convertIdentifier;
    convertExpression(expression: estree.BaseExpression, isBinaryExpression?: boolean): ConversionExpressionResult;
    convertFunction(x3Expression: string): ConversionExpressionResult;
}
//# sourceMappingURL=x3-expression-parser.d.ts.map