"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.X3EnumGenerator = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const fs = __importStar(require("fs"));
const _ = __importStar(require("lodash"));
const path = __importStar(require("path"));
const ts = __importStar(require("typescript"));
const x3_dictionary_interfaces_1 = require("./x3-dictionary-interfaces");
const x3_local_menu_dictionary_helper_1 = require("./x3-local-menu-dictionary-helper");
const x3_package_generator_1 = require("./x3-package-generator");
class X3EnumGenerator {
    constructor(packageGenerator, localMenuDefinition) {
        this.packageGenerator = packageGenerator;
        this.localMenuDefinition = localMenuDefinition;
        this.nodeDefinitions = {};
    }
    addImport(importEntry) {
        this.packageGenerator.addImport('enum', this.name, importEntry);
    }
    get name() {
        let name = this.rootName;
        // we are creating an extension so we construct a name for the enum using the package name and original name
        if (this.isExtension)
            name = `${_.camelCase(_.startCase(this.packageGenerator.metadata.name))}${name}Enum`;
        return name;
    }
    get rootName() {
        let name = this.localMenuDefinition.overriddenName || this.localMenuDefinition.name;
        if (x3_package_generator_1.X3PackageGenerator.allNodeObjects.find(node => node.nodeName === name))
            name = `${name}Enum`;
        return name;
    }
    get enumName() {
        return `${this.name}Enum`;
    }
    get dataTypeName() {
        return `${_.camelCase(this.name)}Datatype`;
    }
    get rootDataTypeName() {
        return `${_.camelCase(this.rootName)}Datatype`;
    }
    get isCustom() {
        return this.localMenuDefinition.isCustom;
    }
    get rootPackageName() {
        return x3_local_menu_dictionary_helper_1.X3LocalMenuDictionaryHelper.getPackageFromHeader(this.localMenuDefinition) || '';
    }
    /**
     * Then the current package is one the extension packages this instance will be manages as an enum extension.
     */
    get isExtension() {
        return this.localMenuDefinition.extensionPackages.includes(this.packageGenerator.metadata.name || '');
    }
    get localMenuNumber() {
        return this.localMenuDefinition.localMenuNumber;
    }
    get filename() {
        return `${_.kebabCase(this.name)}.ts`;
    }
    get rootFilename() {
        return `${_.kebabCase(this.rootName)}.ts`;
    }
    get filepath() {
        return path.join(this.packageGenerator.dir, 'lib/enums', this.filename);
    }
    get extensionFilepath() {
        return path.join(this.packageGenerator.dir, 'lib/enum-extensions', this.filename);
    }
    get interfaceName() {
        return `${this.rootName}$EnumInterface`;
    }
    /**
     * The local menu values relevant to the current package.
     */
    get values() {
        return this.localMenuDefinition.values.filter(value => {
            if (this.isExtension)
                return value.definingPackage === this.packageGenerator.metadata.name;
            return value.definingPackage == null || value.definingPackage === this.packageGenerator.metadata.name;
        });
    }
    getEnumPropertySignatures() {
        return this.values.map(val => ts.factory.createPropertySignature([], val.name, undefined, ts.factory.createLiteralTypeNode(ts.factory.createNumericLiteral(val.valueNumber))));
    }
    getEnumInterface() {
        return ts.factory.createInterfaceDeclaration([ts.factory.createToken(ts.SyntaxKind.ExportKeyword)], this.interfaceName, undefined, undefined, this.getEnumPropertySignatures());
    }
    getEnumDeclaration() {
        return ts.factory.createEnumDeclaration([ts.factory.createToken(ts.SyntaxKind.ExportKeyword)], this.enumName, this.values.map(val => {
            return ts.factory.createEnumMember(val.name, ts.factory.createNumericLiteral(val.valueNumber));
        }));
    }
    getTypeAliasDeclaration() {
        if (this.isExtension) {
            this.addImport({ packageName: this.rootPackageName, value: '*' });
            const rootPackageAlias = x3_package_generator_1.X3PackageGenerator.getPackageAlias(this.rootPackageName);
            return ts.factory.createTypeAliasDeclaration([ts.factory.createToken(ts.SyntaxKind.ExportKeyword)], this.name, [], ts.factory.createTypeReferenceNode(ts.factory.createQualifiedName(ts.factory.createQualifiedName(ts.factory.createIdentifier(rootPackageAlias), 'enums'), this.rootName)));
        }
        return ts.factory.createTypeAliasDeclaration([ts.factory.createToken(ts.SyntaxKind.ExportKeyword)], this.name, [], ts.factory.createTypeOperatorNode(ts.SyntaxKind.KeyOfKeyword, ts.factory.createTypeReferenceNode(this.interfaceName)));
    }
    getDataTypeDeclaration() {
        this.addImport({ packageName: x3_dictionary_interfaces_1.platformPackages.x3Gateway, value: 'X3EnumDataType' });
        const dataTypeOptions = [
            ts.factory.createPropertyAssignment(ts.factory.createIdentifier('enum'), ts.factory.createIdentifier(this.enumName)),
            ts.factory.createPropertyAssignment(ts.factory.createIdentifier('filename'), ts.factory.createIdentifier('__filename')),
            ts.factory.createPropertyAssignment(ts.factory.createIdentifier('localMenuNumber'), ts.factory.createNumericLiteral(this.localMenuNumber)),
        ];
        let typeIdentifier = ts.factory.createIdentifier(this.rootName);
        if (this.isExtension) {
            this.addImport({ packageName: this.rootPackageName, value: '*' });
            const rootPackageAlias = x3_package_generator_1.X3PackageGenerator.getPackageAlias(this.rootPackageName);
            dataTypeOptions.push(ts.factory.createPropertyAssignment(ts.factory.createIdentifier('extends'), ts.factory.createPropertyAccessExpression(ts.factory.createPropertyAccessExpression(ts.factory.createIdentifier(rootPackageAlias), 'enums'), this.rootDataTypeName)));
            typeIdentifier = ts.factory.createQualifiedName(ts.factory.createQualifiedName(ts.factory.createIdentifier(rootPackageAlias), 'enums'), this.rootName);
        }
        return ts.factory.createVariableStatement([ts.factory.createToken(ts.SyntaxKind.ExportKeyword)], ts.factory.createVariableDeclarationList([
            ts.factory.createVariableDeclaration(ts.factory.createIdentifier(this.dataTypeName), undefined, undefined, ts.factory.createNewExpression(ts.factory.createIdentifier('X3EnumDataType'), [ts.factory.createTypeReferenceNode(typeIdentifier, undefined)], [ts.factory.createObjectLiteralExpression(dataTypeOptions, true)])),
        ], ts.NodeFlags.Const));
    }
    generateImportForEnum() {
        const enumKey = `enum~${this.name}`;
        const importsMap = this.packageGenerator.imports[enumKey] || {};
        const result = [];
        x3_package_generator_1.X3PackageGenerator.sortImports(importsMap).forEach(entry => {
            const key = entry[0];
            const value = entry[1];
            if (value.includes('*')) {
                const alias = x3_package_generator_1.X3PackageGenerator.getPackageAlias(key === '..' ? this.packageGenerator.metadata.name : key);
                result.push(ts.factory.createImportDeclaration(undefined, ts.factory.createImportClause(false, undefined, ts.factory.createNamespaceImport(ts.factory.createIdentifier(alias))), ts.factory.createStringLiteral(key)));
            }
            const packageImports = value.filter(importValue => importValue !== '*');
            if (packageImports.length > 0)
                result.push(ts.factory.createImportDeclaration(undefined, ts.factory.createImportClause(false, undefined, ts.factory.createNamedImports(packageImports.map(imp => ts.factory.createImportSpecifier(false, undefined, ts.factory.createIdentifier(imp))))), ts.factory.createStringLiteral(key)));
        });
        return result;
    }
    /**
     * Create the node from metadata
     * @param nodeObject
     * @returns
     */
    createEnum() {
        if (this.enumDefinition)
            return this.enumDefinition;
        const enumDeclaration = this.getEnumDeclaration();
        const enumInterface = this.getEnumInterface();
        const enumDefinitionElements = [
            x3_package_generator_1.X3PackageGenerator.newline,
            x3_package_generator_1.X3PackageGenerator.newline,
            enumDeclaration,
            x3_package_generator_1.X3PackageGenerator.newline,
            x3_package_generator_1.X3PackageGenerator.newline,
            enumInterface,
            x3_package_generator_1.X3PackageGenerator.newline,
            x3_package_generator_1.X3PackageGenerator.newline,
        ];
        enumDefinitionElements.push(this.getTypeAliasDeclaration());
        enumDefinitionElements.push(x3_package_generator_1.X3PackageGenerator.newline);
        enumDefinitionElements.push(x3_package_generator_1.X3PackageGenerator.newline);
        enumDefinitionElements.push(this.getDataTypeDeclaration());
        enumDefinitionElements.push(x3_package_generator_1.X3PackageGenerator.newline);
        enumDefinitionElements.push(x3_package_generator_1.X3PackageGenerator.newline);
        const enumImports = this.generateImportForEnum();
        this.enumDefinition = x3_package_generator_1.X3PackageGenerator.prettyifyTypescript([...enumImports, ...enumDefinitionElements]);
        return this.enumDefinition;
    }
    generateEnum() {
        const profiler = x3_package_generator_1.logger.info(`${this.packageGenerator.packageName}: Create enum file ${this.rootPackageName}/${this.name} -> ${this.filepath}`);
        const enumNode = this.createEnum();
        profiler.success(`${this.packageGenerator.packageName}: Create enum file ${this.rootPackageName}/${this.name} -> ${this.filepath} complete`);
        fs.writeFileSync(this.filepath, enumNode);
    }
    createEnumExtension() {
        if (this.enumExtensionDefinition)
            return this.enumExtensionDefinition;
        const dummyStatement = ts.factory.createVariableStatement([ts.factory.createToken(ts.SyntaxKind.ExportKeyword)], ts.factory.createVariableDeclarationList([
            ts.factory.createVariableDeclaration(ts.factory.createIdentifier('_dummy'), undefined, undefined, ts.factory.createNumericLiteral(1)),
        ], ts.NodeFlags.Const));
        const moduleDeclaration = ts.factory.createModuleDeclaration([ts.factory.createToken(ts.SyntaxKind.DeclareKeyword)], ts.factory.createStringLiteral(`${this.rootPackageName}/lib/enums/${_.kebabCase(this.rootName)}`), ts.factory.createModuleBlock([this.getEnumInterface()]), ts.NodeFlags.ExportContext);
        this.enumExtensionDefinition = x3_package_generator_1.X3PackageGenerator.prettyifyTypescript([
            dummyStatement,
            x3_package_generator_1.X3PackageGenerator.newline,
            x3_package_generator_1.X3PackageGenerator.newline,
            moduleDeclaration,
            x3_package_generator_1.X3PackageGenerator.newline,
            x3_package_generator_1.X3PackageGenerator.newline,
        ]);
        return this.enumExtensionDefinition;
    }
    generateEnumExtension() {
        const profiler = x3_package_generator_1.logger.info(`${this.packageGenerator.packageName}: Create enum-extension file ${this.rootPackageName}/${this.name} -> ${this.filepath}`);
        const enumExtensionNode = this.createEnumExtension();
        profiler.success(`${this.packageGenerator.packageName}: Create enum-extension file ${this.rootPackageName}/${this.name} -> ${this.filepath} complete`);
        fs.writeFileSync(this.extensionFilepath, enumExtensionNode);
    }
    static resetDirectory(packageGenerator, folder) {
        const pathToDirectory = path.join(packageGenerator.dir, `lib/${folder}`);
        if (fs.existsSync(pathToDirectory))
            fs.rmSync(pathToDirectory, { recursive: true });
        fs.mkdirSync(pathToDirectory, { recursive: true });
    }
    static generateIndexFile(packageGenerator, folder, indexExports) {
        const pathToDirectory = path.join(packageGenerator.dir, `lib/${folder}`);
        const enumsIndexFilename = path.join(pathToDirectory, 'index.ts');
        let indexContent = 'export type Dummy = void;';
        if (indexExports.length > 0)
            indexContent = indexExports
                .slice()
                .sort((a, b) => a.localeCompare(b))
                .map(indexExport => `export * from './${path.parse(indexExport).name}';`)
                .join('\n');
        fs.writeFileSync(enumsIndexFilename, x3_package_generator_1.X3PackageGenerator.prettyifyTypescript(indexContent));
    }
    static async generatePackageEnums(packageGenerator) {
        const currentPackage = packageGenerator.metadata;
        this.resetDirectory(packageGenerator, 'enums');
        const localMenuNumbers = Object.keys(await x3_local_menu_dictionary_helper_1.X3LocalMenuDictionaryHelper.loadPackageLocalMenuHeaders(packageGenerator.connPool, packageGenerator.x3FolderName, currentPackage));
        const indexExports = [];
        const extensionGenerators = [];
        await (0, xtrem_core_1.asyncArray)(localMenuNumbers).forEachParallel(10, async (localMenuNumber) => {
            const localMenuDefinition = await x3_local_menu_dictionary_helper_1.X3LocalMenuDictionaryHelper.getLocalMenuDefinition(packageGenerator.connPool, packageGenerator.x3FolderName, Number(localMenuNumber), currentPackage);
            const generator = new X3EnumGenerator(packageGenerator, localMenuDefinition);
            if (generator.isExtension) {
                // We need to generate the enum extensions separately
                extensionGenerators.push(generator);
                return;
            }
            // If the enum is not custom and the package is custom we skip the generation of the enum
            if (!generator.isCustom && packageGenerator.metadata.isCustom)
                return;
            generator.generateEnum();
            indexExports.push(generator.filename);
        });
        this.generateIndexFile(packageGenerator, 'enums', indexExports);
        const pathToEnumExtensions = path.join(packageGenerator.dir, 'lib', 'enum-extensions');
        // drop enum-extensions directory if it exists
        if (fs.existsSync(pathToEnumExtensions))
            fs.rmSync(pathToEnumExtensions, { recursive: true });
        if (extensionGenerators.length > 0) {
            // We can safely recreate the directory
            fs.mkdirSync(pathToEnumExtensions, { recursive: true });
            const extensionIndexExports = [];
            extensionGenerators.forEach(extensionGenerator => {
                extensionGenerator.generateEnumExtension();
                extensionIndexExports.push(extensionGenerator.filename);
            });
            this.generateIndexFile(packageGenerator, 'enum-extensions', extensionIndexExports);
        }
    }
}
exports.X3EnumGenerator = X3EnumGenerator;
//# sourceMappingURL=x3-enum-generator.js.map