import { integer } from '@sage/xtrem-shared';
import * as ts from 'typescript';
export interface MetadataPackage {
    name: string;
    description: string;
    type: string;
    isMain: boolean;
    module: number;
    isActive: boolean;
    serviceName: string;
    owner?: string;
    activityCode?: string;
    isCustom?: boolean;
    linkedPackage1?: string;
    linkedPackage2?: string;
    dependsOn?: string[];
    isHidden?: boolean;
}
export interface ApiNodeClassObjectIndex {
    orderBy: {
        [keyPropName: string]: number;
    };
    isUnique: boolean;
    isNaturalKey: boolean;
}
export type JoinValueType = 'property' | 'string' | 'integer' | 'date' | 'decimal' | 'enum' | 'propertyPath' | 'globalVariable' | 'expression';
export declare const platformPackages: {
    core: string;
    datetime: string;
    x3Gateway: string;
    systemUtils: string;
    masterData: (serviceName: string) => string;
    system: (serviceName: string) => string;
};
export interface Denormalized {
    collectionPropertyName: string;
    parentNode: string;
    dimension?: number;
    activityCode?: string;
}
export interface Anode {
    packageName: string;
    nodeName: string;
    nodeBinding: string;
    denormalized?: Denormalized;
    isVitalReferenceChild?: boolean;
    isVitalCollectionChild?: boolean;
}
export type PropertyKind = 'reference' | 'collection';
export type PropertyType = PropertyKind | 'boolean' | 'integer' | 'decimal' | 'string' | 'date' | 'localizedString' | 'enum' | 'object' | 'expression' | 'binaryStream' | 'textStream' | 'datetime';
export interface JoinValue {
    targetPropertyName: string;
    value: string;
    type: JoinValueType;
}
export interface NodeKey {
    propertyName: string;
    columnType: PropertyType;
}
export type PropertyDirection = 'input' | 'output' | 'both';
export interface ComputedAnodeProperty {
    event: number;
    depends?: string[];
    expression?: string;
    functionPackage?: string;
    functionPath?: string;
}
export interface AnodeProperty {
    nodeName: string;
    nodeBinding: string;
    packageName?: string;
    nodePackage: string;
    name: string;
    keyPart?: number;
    keyOrder?: number;
    joinKind?: PropertyKind;
    type: PropertyType;
    columnName?: string;
    columnType?: PropertyType;
    isNullable?: boolean;
    targetNode?: string;
    joinValues?: JoinValue[];
    isStored?: boolean;
    isPublished?: boolean;
    localizedStringInfo?: {
        tableName?: string;
        columnName?: string;
    };
    localMenuNumber?: number;
    isVital?: boolean;
    isVitalParent?: boolean;
    reverseReference?: string;
    activityCode?: string;
    composite?: {
        referenceProperty: string;
        propertyPath: string;
    };
    isArray?: boolean;
    parentProperty?: string;
    direction?: PropertyDirection;
    provides?: string;
    computedProperty?: ComputedAnodeProperty;
    isMutable?: boolean;
    isTransientInput?: boolean;
    filters?: {
        lookup?: JoinValue[];
        control?: JoinValue[];
    };
    denomColumnIndex: number;
}
export type OperationType = 'custom' | 'create' | 'update' | 'delete' | 'create/update/delete';
export type OperationMethod = 'WINDOW' | 'IMPORT' | 'CLASS' | 'SCRIPT';
export interface OperationParameter {
    type: 'constructed' | 'node' | 'keys';
    isMainNode?: boolean;
    nodeName: string;
    nodeBinding?: string;
    nodeBindingType?: number;
    nodeObject?: ApiNodeClassObject;
}
export interface AnodeOperation {
    nodeName: string;
    operationName: string;
    packageName?: string;
    method: OperationMethod;
    type: OperationType;
    activityCode?: string;
    isPublished?: boolean;
    parameter: OperationParameter;
    returnParam: OperationParameter;
    authorizationCode?: string;
    authorizationOption?: string;
    requestNodeName: string;
    createFlag?: boolean;
    updateFlag?: boolean;
    deleteFlag?: boolean;
}
export interface ApiNodeClassObject {
    nodeName: string;
    nodeBinding: string;
    package: string;
    storage: string;
    isPublished: boolean;
    tableName: string;
    canRead: boolean;
    canSearch: boolean;
    canCreate?: boolean;
    canUpdate?: boolean;
    canDelete?: boolean;
    keyPropertyNames: string[];
    indexes?: ApiNodeClassObjectIndex[];
    properties: AnodeProperty[];
    denormalized?: Denormalized;
    denormalizedNodes?: AnodeDataModelBind[];
    isVitalReferenceChild?: boolean;
    isVitalCollectionChild?: boolean;
    activityCode?: string;
    tableFilters?: string;
    operations?: AnodeOperation[];
    authorizationCode?: string;
}
export interface ApiNodeExtensionClassObjectBase {
    nodeName: string;
    nodeBinding: string;
    package: string;
    nodePackage: string;
    tableName: string;
    canCreate?: boolean;
    canUpdate?: boolean;
    canDelete?: boolean;
}
export interface ApiNodeExtensionClassObject extends ApiNodeExtensionClassObjectBase {
    properties: AnodeProperty[];
    operations?: AnodeOperation[];
}
export interface AnodeDataModelBind extends Anode {
    tableName: string;
    activityCode?: string;
    denormalizedNodes?: AnodeDataModelBind[];
    tableFilters?: string;
    authorizationCode?: string;
    isPublished: boolean;
}
export interface ImportEntry {
    packageName: string;
    value: string;
}
export declare const packageJsonFileName = "package.json";
export interface LocalMenuHeader {
    localMenuNumber: number;
    description: string;
    name: string;
    module: integer;
    isCustom: boolean;
    activityCode?: string;
    modulePackageName?: string;
    overriddenPackageName?: string;
    activityCodePackageName?: string;
    overriddenName?: string;
    issue?: string;
}
export interface BaseLocalMenuValue {
    valueNumber: number;
    description: string;
    isoLanguage: string;
}
export interface LocalMenuValue extends BaseLocalMenuValue {
    name: string;
    definingPackage?: string;
}
export interface LocalMenuDefinition extends LocalMenuHeader {
    values: LocalMenuValue[];
    extensionPackages: string[];
}
export interface ActivityCode {
    code: string;
    description: string;
    isCustom: boolean;
    module: number;
    packageName: string;
    name: string;
}
export type ResolvedJoinValue = ts.StringLiteral | ts.MethodDeclaration | ts.ArrowFunction;
export type ResolvedFilterValue = ts.Expression | ts.MethodDeclaration;
export interface TranslationLocalMenuValueKeyValue {
    [translationKey: string]: string;
}
export interface TranslationLocalMenuLanguageValues {
    [isoLanguage: string]: {
        enums: TranslationLocalMenuValueKeyValue;
        nodePropertues?: TranslationLocalMenuValueKeyValue;
    };
}
//# sourceMappingURL=x3-dictionary-interfaces.d.ts.map