"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.X3DictionaryHelper = void 0;
const xtrem_log_1 = require("@sage/xtrem-log");
const xtrem_x3_sql_manager_1 = require("@sage/xtrem-x3-sql-manager");
const logger = xtrem_log_1.Logger.getLogger(__filename, 'x3-dictionary-helper');
class X3DictionaryHelper {
    static { this.poolsCache = {}; }
    /**
     * @param sqlConfig
     * @returns
     */
    static getConnectionPool(sqlConfig) {
        return xtrem_x3_sql_manager_1.PoolManager.create(sqlConfig, this.poolsCache, logger);
    }
    static { this.tableDefinitions = {}; }
    static async getTableDefinition(connPool, x3Folder, tableName) {
        if (this.tableDefinitions[tableName])
            return this.tableDefinitions[tableName];
        this.tableDefinitions[tableName] = await connPool.readTableSchema(x3Folder, tableName, {});
        return this.tableDefinitions[tableName];
    }
    static fromSql(type, value) {
        switch (type) {
            case 'string':
                if (value === ' ')
                    return undefined;
                return value;
            case 'integer':
                if (!Number.isFinite(Number(value)) || Number(value) === 0)
                    return undefined;
                return Number(value);
            case 'boolean':
                if (Number(value) === 2)
                    return true;
                return false;
            default:
                throw new Error(`Type ${type} not managed`);
        }
    }
    static { this.referenceFolders = {}; }
    static async getReferenceFolderFromParam(connPool, currentFolder) {
        if (this.referenceFolders[currentFolder])
            return this.referenceFolders[currentFolder];
        const paramSQL = `SELECT VALEUR_0 AS REFERENCE_FOLDER  FROM ${currentFolder}.ADOVAL WHERE PARAM_0 = 'SUPDOS'`;
        const response = await connPool.execute(paramSQL);
        if (response.length) {
            this.referenceFolders[currentFolder] = response[0].REFERENCE_FOLDER;
        }
        return this.referenceFolders[currentFolder];
    }
}
exports.X3DictionaryHelper = X3DictionaryHelper;
//# sourceMappingURL=x3-dictionary-helper.js.map