"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.X3TranslationMigration = void 0;
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
const x3_package_generator_1 = require("../x3-package-generator");
const x3_translations_migration_logger_1 = require("./x3-translations-migration-logger");
class X3TranslationMigration {
    constructor(targetPackagePath, sourcePackageName, sourcePackagePath) {
        this.targetPackagePath = targetPackagePath;
        this.sourcePackageName = sourcePackageName;
        this.sourcePackagePath = sourcePackagePath;
    }
    migrateTranslation() {
        const targetI18nFilesPath = path.join(this.targetPackagePath, 'lib/i18n');
        const sourceI18nFilesPath = path.join(this.sourcePackagePath, 'lib/i18n');
        let sourceI18nFileNames = [];
        // set migration rules for package naming
        // global rename rule xtrem-x3 -> x3
        let oldPackagePrefix = 'xtrem-x3-';
        let newPackagePrefix = 'x3-';
        // specific rule for xtrem-x3-inventory package naming
        if (this.sourcePackageName === '@sage/xtrem-x3-inventory') {
            oldPackagePrefix = 'xtrem-x3-inventory';
            newPackagePrefix = 'x3-stock';
        }
        if (this.sourcePackageName === '@sage/xtrem-x3-stock') {
            oldPackagePrefix = 'xtrem-x3-stock';
            newPackagePrefix = 'x3-stock-data';
        }
        (0, x3_translations_migration_logger_1.infoMessageI18nMigration)(x3_translations_migration_logger_1.MessageI18nMigration.SET_ENV, '', '', `Source package  ${this.sourcePackagePath} - Target package ${this.targetPackagePath} - Package prefix ${newPackagePrefix}`);
        if (fs.existsSync(sourceI18nFilesPath)) {
            sourceI18nFileNames = fs.readdirSync(sourceI18nFilesPath).filter(fileName => {
                return fileName !== 'base.json';
            });
        }
        else {
            throw new Error(`Not existing path ${sourceI18nFilesPath}`);
        }
        sourceI18nFileNames.forEach((sFn) => {
            const sourceI18nObject = JSON.parse(fs.readFileSync(path.join(sourceI18nFilesPath, sFn), 'utf-8'));
            const targetFullPathI18nFileName = path.join(targetI18nFilesPath, sFn);
            if (fs.existsSync(targetFullPathI18nFileName)) {
                const targetI18nObject = JSON.parse(fs.readFileSync(targetFullPathI18nFileName, 'utf-8'));
                Object.entries(sourceI18nObject).forEach(([eKey, eVal]) => {
                    if (eKey.match(new RegExp(oldPackagePrefix, 'g')) && !eKey.match(/enums__/g)) {
                        let targetKey = eKey.replace(oldPackagePrefix, newPackagePrefix);
                        const targetVal = eVal;
                        if (targetKey.match(/__adc_/g)) {
                            targetKey = targetKey.replace('__adc_', '__mobile_');
                        }
                        if (targetKey in targetI18nObject &&
                            targetI18nObject[targetKey] === '' &&
                            targetI18nObject[targetKey] !== sourceI18nObject[eKey]) {
                            (0, x3_translations_migration_logger_1.infoMessageI18nMigration)(x3_translations_migration_logger_1.MessageI18nMigration.UPDATE, targetKey, targetVal, `${sFn}`);
                            targetI18nObject[targetKey] = targetVal;
                        }
                        // rule: not to create new translation
                    }
                    else {
                        (0, x3_translations_migration_logger_1.warnMessageI18nMigration)(x3_translations_migration_logger_1.MessageI18nMigration.NOT_FOUND, '', '', `Couldn't find package prefix ${oldPackagePrefix}.`);
                    }
                });
                fs.writeFileSync(`${targetFullPathI18nFileName}`, x3_package_generator_1.X3PackageGenerator.prettyifyJson(JSON.stringify(targetI18nObject)));
            }
            else {
                (0, x3_translations_migration_logger_1.warnMessageI18nMigration)(x3_translations_migration_logger_1.MessageI18nMigration.NOT_FOUND, '', '', `Not existing path to target file: ${targetFullPathI18nFileName}.`);
            }
        });
    }
}
exports.X3TranslationMigration = X3TranslationMigration;
//# sourceMappingURL=x3-translations-migration.js.map