import { Context, integer, Node } from '@sage/xtrem-core';
import * as fixtures from '../index';
type ComplexParameters = {
    object: {
        simple?: boolean | string;
        mandatory: string;
        nullable?: integer | null;
    };
    optionalObjects?: {
        nestedStrings?: string[] | null;
        flag?: boolean | string;
    }[];
};
type ObjectWithArrayOfEnums = {
    statusList: fixtures.enums.TestEnumEnum[];
};
export declare class TestOperationReference extends Node {
    readonly code: Promise<string>;
    readonly quantity: Promise<integer>;
}
export declare class TestOperation extends Node {
    readonly code: Promise<string>;
    readonly value: Promise<integer>;
    static mutationReturningString(context: Context, code: string, stringVal: string, intVal: integer): Promise<string>;
    static queryReturningString(context: Context, code: string, stringVal: string, intVal: integer, enumVal: fixtures.enums.TestEnum): string;
    static mutationReturningNode(context: Context, code: string, intVal: integer): Promise<TestOperation>;
    static mutationWithNodeParameter(context: Context, arg: TestOperation): TestOperation;
    static queryWithComplexInput(context: Context, object: ComplexParameters['object'], optionalObjects?: ComplexParameters['optionalObjects']): string;
    static queryWithComplexOutput(context: Context, object: ComplexParameters['object'], optionalObjects?: ComplexParameters['optionalObjects']): ComplexParameters;
    static queryWithReferences(context: Context, reference: TestOperationReference, nullableReference: TestOperationReference | null, arrayOfReferences: TestOperationReference[], arrayOfNullableReferences: (TestOperationReference | null)[], nested: {
        reference: TestOperationReference;
        nullableReference: TestOperationReference | null;
        arrayOfReferences: TestOperationReference[];
        arrayOfNullableReferences: (TestOperationReference | null)[];
    }): {
        reference: fixtures.nodes.TestOperationReference;
        nullableReference: fixtures.nodes.TestOperationReference | null;
        arrayOfReferences: fixtures.nodes.TestOperationReference[];
        arrayOfNullableReferences: (fixtures.nodes.TestOperationReference | null)[];
        nested: {
            reference: TestOperationReference;
            nullableReference: TestOperationReference | null;
            arrayOfReferences: TestOperationReference[];
            arrayOfNullableReferences: (TestOperationReference | null)[];
        };
    };
    static queryReturningReference(context: Context, id: integer): Promise<TestOperationReference>;
    static queryReturningSimpleArray(context: Context, len: integer): string[];
    static queryReturningArrayOfObjects(context: Context, len: integer): {
        index: number;
        text: string;
    }[];
    static mutationArrayOfInstanceReturningString(context: Context, instanceArray: TestOperation[]): Promise<string>;
    static mutationArrayOfEnums(context: Context, objectWithArrayOfEnums: ObjectWithArrayOfEnums): string;
}
export {};
//# sourceMappingURL=operation.d.ts.map