import { Collection, Context, decimal, integer, Node, Reference } from '@sage/xtrem-core';
import * as testApp from '../../index';
import { StatusEnum } from '../enums/_index';
import { Address } from './address';
type ComplexParameters = {
    object: {
        simple?: boolean | string;
        mandatory: string;
        nullable?: integer | null;
    };
    optionalObjects?: {
        nestedStrings?: string[];
        flag?: boolean | string;
    }[];
};
export declare class Document extends Node {
    readonly id: Promise<string>;
    readonly status: Promise<StatusEnum>;
    readonly statusList: Promise<StatusEnum[]>;
    readonly numberList: Promise<integer[]>;
    readonly stringList: Promise<string[]>;
    readonly amount: Promise<decimal>;
    readonly address: Reference<testApp.nodes.Address>;
    readonly addresses: Promise<testApp.nodes.Address[]>;
    readonly lines: Collection<testApp.nodes.DocumentLine>;
    readonly transient: Promise<string>;
    readonly transientRef: Reference<testApp.nodes.Address>;
    readonly transientLines: Collection<testApp.nodes.DocumentLine>;
    readonly json: Promise<object>;
    readonly isStoredOutput: Promise<string>;
    static customQuery(context: Context, id: string): Promise<Document | null>;
    static customMutation(context: Context, id: string, stringVal?: string, intVal?: integer): string;
    static mutationWithReferences(context: Context, mandatoryReference: Address, mandatoryNullableReference: Address | null, optionalReference?: Address, optionalNullableReference?: Address | null): {
        mandatoryReference: testApp.nodes.Address;
        mandatoryNullableReference: testApp.nodes.Address | null;
        optionalReference: testApp.nodes.Address | undefined;
        optionalNullableReference: testApp.nodes.Address | null | undefined;
    };
    static queryWithComplexOutput(context: Context, object: ComplexParameters['object'], optionalObjects?: ComplexParameters['optionalObjects']): ComplexParameters;
}
export {};
//# sourceMappingURL=document.d.ts.map