/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const chai_1=require("chai"),fs=require("fs"),fsp=require("path"),index_1=require("../lib/index"),index_2=require("./fixtures/index"),Module=require("module");function hackModuleResolve(){const e=Module._resolveFilename;Module._resolveFilename=function resolveFilename(a){if("@sage/test-client-gen-app/package.json"===a)return require.resolve("./fixtures/test-app/package.json");if("@sage/test-extended-client-gen-app/package.json"===a)return require.resolve("./fixtures/test-extended-app/package.json");if("@sage/xtrem-service"===a)return require.resolve("../../xtrem-service");if("@sage/test-client-gen-app/build/application"===a)return require.resolve("./fixtures/test-app/extra-folder/application");return e.apply(this,arguments)}}(0,index_2.setup)(),describe("client package generator",()=>{it("can generate complete client package directory",async()=>{const e=(0,index_2.createTestApp)(),a=fsp.join(__dirname,"./fixtures/test-app/api"),i=fsp.join(a,"api.d.ts"),t=fsp.join(a,"package.json"),n=fsp.join(__dirname,"./fixtures/test-app/extra-folder/api"),s=fsp.join(n,"api.d.ts"),r=fsp.join(n,"package.json");function cleanup(){if(fs.existsSync(i))fs.unlinkSync(i);if(fs.existsSync(t))fs.unlinkSync(t)}cleanup(),await(0,index_1.generateClientPackage)(e),checkFile(i,s),checkFile(t,r,true),cleanup()})}),describe("client api generator",()=>{before(hackModuleResolve),it("can generate an api type definition file",async()=>{const e=await(0,index_1.generateClientApi)((0,index_2.createTestApp)()),a=fs.readFileSync(fsp.join(__dirname,"./fixtures/test-app/extra-folder/api/api.d.ts"),"utf8");chai_1.assert.equal(e,a)}),it("can generate an api type definition file for an extension package",async()=>{const e=await(0,index_1.generateClientApi)((0,index_2.createTestExtendedApp)()),a=fs.readFileSync(fsp.join(__dirname,"./fixtures/test-extended-app/extra-folder/api/api.d.ts"),"utf8");chai_1.assert.equal(e,a)})}),describe("client package.json generator",()=>{it("can generate package.json for base api",()=>{const e=(0,index_1.generateClientPackageJson)((0,index_2.createTestApp)()),a=fs.readFileSync(fsp.join(__dirname,"./fixtures/test-app/extra-folder/api/package.json"),"utf8");chai_1.assert.deepEqual(JSON.parse(e),JSON.parse(a))}),it("can generate package.json for extension api",()=>{const e=(0,index_1.generateClientPackageJson)((0,index_2.createTestExtendedApp)()),a=fs.readFileSync(fsp.join(__dirname,"./fixtures/test-extended-app/extra-folder/api/package.json"),"utf8");chai_1.assert.deepEqual(JSON.parse(e),JSON.parse(a))})});const checkFile=(e,a,i=false)=>{chai_1.assert.notEqual(e,a);const t=fs.readFileSync(e,"utf8"),n=fs.readFileSync(a,"utf8");if(i)chai_1.assert.deepEqual(JSON.parse(t),JSON.parse(n));else chai_1.assert.equal(t,n)};
//# sourceMappingURL=client-gen-test.js.map