/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.generateClientApi=exports.ApiGenerator=void 0;const xtrem_core_1=require("@sage/xtrem-core"),lodash_1=require("lodash"),ts=require("typescript"),pretty_1=require("./pretty"),tsf=ts.factory;function pascalCase(e){const t=(0,lodash_1.camelCase)(e);return t[0].toUpperCase()+t.substring(1)}function compareImports(e,t){return e<t?-1:1}var NodeVariant;!function(e){e[e.input=0]="input",e[e.output=1]="output",e[e.binding=2]="binding"}(NodeVariant||(NodeVariant={}));class NodeImport{constructor(e,t){this.factory=e,this.variant=t}}class ApiGenerator{constructor(e){this.pack=e,this.libImports=[],this.nodeImports=[],this.enumImports=[],this.nodeExtensions={},this.enumExtensions={}}get application(){return this.pack.application}addLibImport(e){if(!this.libImports.includes(e))this.libImports.push(e);return e}libImportStatements(){return this.libImports.length>0?[ApiGenerator.importStatement(this.libImports,"@sage/xtrem-client")]:[]}addNodeImport(e,t,a=false){const pushNodeImport=t=>{if(!this.nodeImports.find(a=>a.factory===e&&a.variant===t))this.nodeImports.push(new NodeImport(e,t))};switch(t){case NodeVariant.input:return pushNodeImport(t),`${e.name}Input`;case NodeVariant.binding:if(!a)return pushNodeImport(NodeVariant.output),e.name;return pushNodeImport(t),`${e.name}Binding`;default:return pushNodeImport(t),e.name}}addEnumImport(e){if(!this.enumImports.includes(e))this.enumImports.push(e);return e}static trimApi(e){if(!e.endsWith("-api"))throw new Error(`${e}: invalid api package name`);return e.replace(/-api$/,"")}nodeImportsMap(){const e=this.nodeImports.reduce((e,t)=>{const a=t.factory.package;switch(e[a.name]=e[a.name]||[],t.variant){case NodeVariant.input:e[a.name].push(`${t.factory.name}Input`);break;case NodeVariant.binding:e[a.name].push(`${t.factory.name}Binding`);break;default:e[a.name].push(t.factory.name)}return e},{});return this.pack.application.mainPackage.apiDependencies.map(e=>ApiGenerator.trimApi(e)).reverse().forEach(t=>{e[t]=e[t]||[],e[t].push(`Package as ${ApiGenerator.packageAlias(t)}`)}),e}nodeImportStatements(){const e=this.nodeImportsMap();return Object.keys(e).filter(e=>e!==this.pack.name).sort(compareImports).map(t=>{const a=e[t];return ApiGenerator.importStatement(a,`${t}-api`)})}addNodeExtensionModule(e,{name:t,hasQueries:a,hasMutations:r,hasLookups:n,hasAsyncOperations:i}){const o=e.package;(this.nodeExtensions[o.name]||(this.nodeExtensions[o.name]=[])).push({name:t,type:"node",hasQueries:a,hasMutations:r,hasLookups:n,hasAsyncOperations:i})}addEnumExtensionModule(e){const{rootDataType:t}=e;if(!t)return;if(!xtrem_core_1.ConfigManager.current.storage?.managedExternal)throw new Error("Enum extension is only allowed on external applications.");const a=t.packageName;(this.enumExtensions[a]||(this.enumExtensions[a]=[])).push({name:t.enumName(),type:"enum"})}static interfaceExtensionStatement(e,t){return tsf.createInterfaceDeclaration([tsf.createToken(ts.SyntaxKind.ExportKeyword)],`${e}${t}`,[],[tsf.createHeritageClause(ts.SyntaxKind.ExtendsKeyword,[tsf.createExpressionWithTypeArguments(tsf.createIdentifier(`${e}Extension${t}`),[])])],[])}graphExtensionStatements(){return[ApiGenerator.importStatement(["GraphApi as GraphApiExtension"],`${this.pack.name}-api`),ApiGenerator.interfaceExtensionStatement("GraphApi","")]}graphExtensions(){return this.application.mainPackage.apiDependencies.map(e=>ApiGenerator.trimApi(e)).filter(e=>e!==this.application.mainPackage.name).sort(compareImports).map(e=>tsf.createModuleDeclaration([tsf.createToken(ts.SyntaxKind.DeclareKeyword)],tsf.createStringLiteral(`${e}-api-partial`),tsf.createModuleBlock(this.graphExtensionStatements())))}extensionStatements(e,t){const a=(0,lodash_1.flatten)([...e.map(e=>[`${e.name}Extension`,`${e.name}BindingExtension`,`${e.name}InputExtension`,...e.hasLookups?[`${e.name}Extension$Lookups`]:[],...e.hasQueries?[`${e.name}Extension$Queries`]:[],...e.hasMutations?[`${e.name}Extension$Mutations`]:[],...e.hasAsyncOperations?[`${e.name}Extension$AsyncOperations`]:[],...e.hasQueries||e.hasMutations||e.hasLookups||e.hasAsyncOperations?[`${e.name}Extension$Operations`]:[]]),...t.map(e=>[`${e.name}$EnumExtension`])]),r=(0,lodash_1.flatten)([...e.map(e=>[ApiGenerator.interfaceExtensionStatement(e.name,""),ApiGenerator.interfaceExtensionStatement(`${e.name}Binding`,""),ApiGenerator.interfaceExtensionStatement(`${e.name}Input`,""),...e.hasLookups?[ApiGenerator.interfaceExtensionStatement(e.name,"$Lookups")]:[],...e.hasQueries?[ApiGenerator.interfaceExtensionStatement(e.name,"$Queries")]:[],...e.hasMutations?[ApiGenerator.interfaceExtensionStatement(e.name,"$Mutations")]:[],...e.hasAsyncOperations?[ApiGenerator.interfaceExtensionStatement(e.name,"$AsyncOperations")]:[],...e.hasQueries||e.hasMutations||e.hasLookups||e.hasAsyncOperations?[ApiGenerator.interfaceExtensionStatement(e.name,"$Operations")]:[]]),...t.map(e=>[ApiGenerator.interfaceExtensionStatement(`${e.name}$Enum`,"")])]);return[ApiGenerator.importStatement(a,`${this.pack.name}-api`),...r]}moduleExtensionStatement(e,t,a){return tsf.createModuleDeclaration([tsf.createToken(ts.SyntaxKind.DeclareKeyword)],tsf.createStringLiteral(`${e}-api-partial`),tsf.createModuleBlock(this.extensionStatements(t,a)))}moduleExtensionsStatements(){return(0,lodash_1.uniq)((0,lodash_1.merge)(Object.keys(this.nodeExtensions),Object.keys(this.enumExtensions))).filter(e=>e!==this.pack.name).map(e=>this.moduleExtensionStatement(e,this.nodeExtensions[e]||[],this.enumExtensions[e]||[]))}static importStatement(e,t){return tsf.createImportDeclaration([],tsf.createImportClause(true,void 0,tsf.createNamedImports([...e].sort(compareImports).map(e=>tsf.createImportSpecifier(false,void 0,tsf.createIdentifier(e))))),tsf.createStringLiteral(t))}parameterAsProperty(e,t){if("string"==typeof t)return{name:e,type:t};const a=ApiGenerator.getNodeFn(t);return{...t,targetFactory:a?this.application.getFactoryByConstructor(a()):void 0}}createObjectTypeNode(e,t){const a=Object.keys(e.properties).map(a=>{const r=this.parameterAsProperty(a,e.properties[a]),n=ApiGenerator.getNodeFn(r),i=n?this.application.getFactoryByConstructor(n()):void 0,o=r.dataType;return tsf.createPropertySignature([],a,r.isMandatory||t===NodeVariant.output?void 0:tsf.createToken(ts.SyntaxKind.QuestionToken),this.memberTypeNode({...r,name:a,targetFactory:i,columnType:"reference"===r.type&&"external"!==i?.storage?"integer":r.columnType,dataType:o?o():void 0},t))});return tsf.createTypeLiteralNode(a)}createArrayTypeNode(e,t){let a=e.item;if(a&&"object"==typeof a){const e=a.dataType;a={...a,dataType:e?e():void 0}}const r=this.parameterAsProperty(e.name,a);if(!r.name)r.name=e.name;return tsf.createArrayTypeNode(this.memberTypeNode(r,t))}memberTypeNode(e,t){if(e.isNullable)return ApiGenerator.nullableType(this.memberTypeNode({...e,isNullable:false},t),true);const createStringType=()=>tsf.createTypeReferenceNode("string",[]),createIntegerType=()=>tsf.createTypeReferenceNode(this.addLibImport("integer"),[]),a=e.isVital||e.isTransientInput;switch(e.type){case"boolean":return t===NodeVariant.input?tsf.createUnionTypeNode([tsf.createTypeReferenceNode("boolean",[]),createStringType()]):tsf.createTypeReferenceNode("boolean",[]);case"integer":case"short":return t===NodeVariant.input?tsf.createUnionTypeNode([createIntegerType(),createStringType()]):createIntegerType();case"integerArray":return tsf.createArrayTypeNode(this.memberTypeNode({...e,type:"integer"},t));case"enum":{const t=e.dataType;return tsf.createTypeReferenceNode(this.addEnumImport(`${t.enumName()}`))}case"enumArray":return tsf.createArrayTypeNode(this.memberTypeNode({...e,type:"enum"},t));case"stringArray":return tsf.createArrayTypeNode(this.memberTypeNode({...e,type:"string"},t));case"decimal":if(t===NodeVariant.input){const e=tsf.createTypeReferenceNode(this.addLibImport("decimal"),[]);return tsf.createUnionTypeNode([e,createStringType()])}return createStringType();case"float":case"double":{const e=tsf.createTypeReferenceNode("number",[]);return t===NodeVariant.input?tsf.createUnionTypeNode([e,createStringType()]):e}case"json":return t===NodeVariant.binding?tsf.createTypeReferenceNode("any",[]):tsf.createTypeReferenceNode("string",[]);case"date":case"dateRange":case"datetimeRange":case"integerRange":case"decimalRange":case"time":case"datetime":case"string":case"uuid":return tsf.createTypeReferenceNode("string",[]);case"binaryStream":return tsf.createTypeReferenceNode(this.addLibImport("BinaryStream"),[]);case"textStream":return tsf.createTypeReferenceNode(this.addLibImport("TextStream"),[]);case"jsonReference":case"reference":{const r=e.targetFactory;if(!r)throw new xtrem_core_1.LogicError("no factory");if(e.isVitalParentInput&&r)return tsf.createTypeReferenceNode(this.addNodeImport(r,t),[]);if(t===NodeVariant.input&&!e.isVital)return this.memberTypeNode({...e,type:e.columnType||"string"},t);return tsf.createTypeReferenceNode(this.addNodeImport(r,t,a),[])}case"referenceArray":{const a=e.targetFactory;return tsf.createArrayTypeNode(this.memberTypeNode({...e,targetFactory:a,type:"reference",columnType:"external"!==a?.storage?"integer":e.columnType},t))}case"collection":{const r=e.targetFactory;if(!r)throw new xtrem_core_1.LogicError("no target factory");if(t===NodeVariant.input){if(!r)throw new xtrem_core_1.LogicError("no target factory");return tsf.createArrayTypeNode(tsf.createTypeReferenceNode("Partial",[tsf.createTypeReferenceNode(this.addNodeImport(r,t),[])]))}return tsf.createTypeReferenceNode(this.addLibImport("ClientCollection"),[tsf.createTypeReferenceNode(this.addNodeImport(r,t,a),[])])}case"object":return this.createObjectTypeNode(e,t);case"array":return this.createArrayTypeNode(e,t);case"instance":{const r=e.targetFactory;if(!r)throw new xtrem_core_1.LogicError("no target factory");return tsf.createTypeReferenceNode(this.addNodeImport(r,t,a),[])}default:throw new Error(`${e.name}: invalid type: ${e.type}`)}}static getNodeFn(e){return e.decorator?e.decorator.node:e.node}nodePropertiesSignatures(e,t){return(e.properties?e.properties.filter(e=>e.isPublished):[]).filter(e=>!["_id","_tenantId","_sourceId","_sortValue","_action","_etag","_customData","_updateTick"].includes(e.name)).filter(a=>{if(a.isForeignNodeProperty()&&!a.targetFactory.isPublished)return console.warn(`${e.name}.${a.name}: ignored because ${a.targetFactory.name} is not published`),false;if(t===NodeVariant.input){if(["_createUser","_updateUser"].includes(a.name))return false;if((0,xtrem_core_1.isPropertyOutputOnly)(a))return false;if(a.isReferenceProperty()&&a.isVitalParent&&!a.isVitalParentInput)return false}if(t===NodeVariant.output&&(0,xtrem_core_1.isPropertyInputOnly)(a))return false;return true}).map(e=>{const a=t===NodeVariant.input,r=e.isCollectionProperty()&&e.factory.isAbstract&&t===NodeVariant.output&&e.targetFactory.isAbstract,n=e.isForeignNodeProperty()?e.targetFactory:void 0,i=e.isForeignNodeProperty()?e.isVital:false,o=e.isReferenceProperty()&&e.isVitalParent?e.isVitalParentInput:false,s=r?`any${pascalCase(e.name)}`:e.name;return tsf.createPropertySignature([],s,a?tsf.createToken(ts.SyntaxKind.QuestionToken):void 0,this.memberTypeNode({name:e.name,type:e.type,targetFactory:n,isVital:i,isVitalParentInput:o,columnType:"reference"===e.type&&"external"!==n?.storage?"integer":e.columnType,dataType:e.dataType,isTransientInput:e.isTransientInput},t))})}static createExtendsClause(e){return tsf.createHeritageClause(ts.SyntaxKind.ExtendsKeyword,[tsf.createExpressionWithTypeArguments(tsf.createIdentifier(e),[])])}addNodeDeclaration(e,t){t.push(tsf.createInterfaceDeclaration([tsf.createToken(ts.SyntaxKind.ExportKeyword)],e.name,[],[ApiGenerator.createExtendsClause(this.addLibImport(e.isVitalChild?"VitalClientNode":"ClientNode"))],this.nodePropertiesSignatures(e,NodeVariant.output)))}addNodeInputDeclaration(e,t){t.push(tsf.createInterfaceDeclaration([tsf.createToken(ts.SyntaxKind.ExportKeyword)],`${e.name}Input`,[],[ApiGenerator.createExtendsClause(this.addLibImport(e.isVitalChild?"VitalClientNodeInput":"ClientNodeInput"))],this.nodePropertiesSignatures(e,NodeVariant.input)))}addBindingNodeDeclaration(e,t){t.push(tsf.createInterfaceDeclaration([tsf.createToken(ts.SyntaxKind.ExportKeyword)],`${e.name}Binding`,[],[ApiGenerator.createExtendsClause(this.addLibImport(e.isVitalChild?"VitalClientNode":"ClientNode"))],this.nodePropertiesSignatures(e,NodeVariant.binding)))}addNodeExtensionDeclaration(e,t){t.push(tsf.createInterfaceDeclaration([tsf.createToken(ts.SyntaxKind.ExportKeyword)],`${e.name}Extension`,[],[],this.nodePropertiesSignatures(e,NodeVariant.output)))}static addEnumExtensionDeclaration(e,t){const a=ApiGenerator.getEnumPropertySignatures(e);t.push(tsf.createInterfaceDeclaration([tsf.createToken(ts.SyntaxKind.ExportKeyword)],`${e.rootDataType?.enumName()??e.enumName()}$EnumExtension`,[],[],a))}addNodeInputExtensionDeclaration(e,t){t.push(tsf.createInterfaceDeclaration([tsf.createToken(ts.SyntaxKind.ExportKeyword)],`${e.name}InputExtension`,[],[],this.nodePropertiesSignatures(e,NodeVariant.input)))}addNodeBindingExtensionDeclaration(e,t){t.push(tsf.createInterfaceDeclaration([tsf.createToken(ts.SyntaxKind.ExportKeyword)],`${e.name}BindingExtension`,[],[],this.nodePropertiesSignatures(e,NodeVariant.binding)))}parameterType(e,t,a){if("string"==typeof t)return tsf.createTypeReferenceNode(t,[]);switch(t.type){case"instance":return ApiGenerator.nullableType(tsf.createTypeReferenceNode(this.addNodeImport(this.application.getFactoryByConstructor(t.node()),a),[]),!!t.isNullable);case"reference":if(a===NodeVariant.input)return ApiGenerator.nullableType(tsf.createTypeReferenceNode("string",[]),!!t.isNullable);return ApiGenerator.nullableType(tsf.createTypeReferenceNode(this.addNodeImport(this.application.getFactoryByConstructor(t.node()),a),[]),!!t.isNullable);default:{const r=t.dataType;return this.memberTypeNode({...t,dataType:r?r():void 0,name:e},a)}}}static nullableType(e,t){return t?tsf.createUnionTypeNode([e,tsf.createTypeReferenceNode("null")]):e}operationParametersType(e){return tsf.createTypeLiteralNode(e.parameters.map(e=>tsf.createPropertySignature([],e.name,e.isMandatory?void 0:tsf.createToken(ts.SyntaxKind.QuestionToken),this.parameterType(e.name,e,NodeVariant.input))))}operationTypeAst(e){const t="Node$Operation";return this.addLibImport(`Operation as ${t}`),tsf.createTypeReferenceNode(t,[this.operationParametersType(e),this.parameterType("return",e.return,NodeVariant.output)])}operationSignatures(e){if(!(e&&e.length>0))return[];return e.map(e=>tsf.createPropertySignature([],e.action||e.name,void 0,this.operationTypeAst(e)))}builtinAggregateOperations(e){return tsf.createPropertySignature([],"aggregate",void 0,tsf.createTypeLiteralNode([this.builtinOperationSignature("read","AggregateReadOperation",[e]),this.builtinOperationSignature("query","AggregateQueryOperation",[e])]))}operationsDeclaration(e,t,a,r,n,i){const o=[],s=e.canRead&&!i;if(s)o.push(this.builtinOperationSignature("query","QueryOperation",[e.name])),o.push(this.builtinOperationSignature("read","ReadOperation",[e.name])),o.push(this.builtinAggregateOperations(e.name));if(t)o.push(tsf.createPropertySignature([],"queries",void 0,tsf.createTypeReferenceNode(`${e.name}${i}$Queries`,[])));const p=e.canCreate&&!i,c=e.canBeDuplicated&&p;if(p)if(o.push(this.builtinOperationSignature("create","CreateOperation",[`${e.name}Input`,e.name])),o.push(this.builtinOperationSignature("getDuplicate","GetDuplicateOperation",[e.name])),c)o.push(this.builtinOperationSignature("duplicate","DuplicateOperation",["string",`${e.name}Input`,e.name]));const d=e.canUpdate&&!i;if(d)o.push(this.builtinOperationSignature("update","UpdateOperation",[`${e.name}Input`,e.name])),o.push(this.builtinOperationSignature("updateById","UpdateByIdOperation",[`${e.name}Input`,e.name]));if(e.canDelete&&!i)o.push(this.builtinOperationSignature("delete","DeleteOperation",["{}"])),o.push(this.builtinOperationSignature("deleteById","DeleteOperation",["string"]));if(a)o.push(tsf.createPropertySignature([],"mutations",void 0,tsf.createTypeReferenceNode(`${e.name}${i}$Mutations`,[])));if(r)o.push(tsf.createPropertySignature([],"asyncOperations",void 0,tsf.createTypeReferenceNode(`${e.name}${i}$AsyncOperations`,[])));if(n){const t=`string | { data: ${e.name}Input  }`,a=tsf.createTypeReferenceNode(t,[]);if(o.push(tsf.createMethodSignature([],"lookups",void 0,[],[tsf.createParameterDeclaration(void 0,void 0,tsf.createIdentifier("dataOrId"),void 0,a)],tsf.createTypeReferenceNode(`${e.name}${i}$Lookups`,[]))),i)this.addNodeImport(e,NodeVariant.input)}if(t||a||p||s||d)o.push(this.builtinOperationSignature("getDefaults","GetDefaultsOperation",[e.name]));return tsf.createInterfaceDeclaration([tsf.createToken(ts.SyntaxKind.ExportKeyword)],`${e.name}${i}$Operations`,[],[],o)}builtinOperationSignature(e,t,a){return tsf.createPropertySignature([],e,void 0,tsf.createTypeReferenceNode(this.addLibImport(t),a.map(e=>tsf.createTypeReferenceNode(e,[]))))}addQueriesDeclaration(e,t,a){const r=this.operationSignatures(e.queries?e.queries.filter(e=>e.isPublished&&e.definingPackage===this.pack&&!e.action):[]);if(0===r.length)return false;return t.push(tsf.createInterfaceDeclaration([tsf.createToken(ts.SyntaxKind.ExportKeyword)],`${e.name}${a}$Queries`,[],[],r)),true}addMutationsDeclaration(e,t,a){const r=this.operationSignatures(e.mutations?e.mutations.filter(e=>e.isPublished&&e.definingPackage===this.pack&&!e.action):[]);if(0===r.length)return false;return t.push(tsf.createInterfaceDeclaration([tsf.createToken(ts.SyntaxKind.ExportKeyword)],`${e.name}${a}$Mutations`,[],[],r)),true}static addRunToCompletionAction(e){const t=e.find(e=>"start"===e.action),a=e.find(e=>"track"===e.action);if(t&&a){const r={...t,action:"runToCompletion",return:a?.return?.properties?.result};if(r.return)e.push(r)}}addAsyncOperationsDeclaration(e,t,a){const r=[...e.mutations,...e.queries].filter(e=>e.isPublished&&e.definingPackage===this.pack&&e.action),n={};r.forEach(e=>{if(!n[e.name])n[e.name]=[];n[e.name].push(e)});const i=Object.entries(n);if(0===i.length)return false;const o=i.map(([e,t])=>(ApiGenerator.addRunToCompletionAction(t),tsf.createPropertySignature(void 0,e,void 0,tsf.createTypeLiteralNode(this.operationSignatures(t)))));return t.push(tsf.createInterfaceDeclaration([tsf.createToken(ts.SyntaxKind.ExportKeyword)],`${e.name}${a}$AsyncOperations`,[],[],o)),true}addLookupsDeclaration(e,t,a){const r=e.properties&&e.properties.filter(e=>e.isPublished&&e.definingPackage===this.pack&&e.name&&e.isReferenceProperty()&&e.canLookup&&!e.isVital&&!e.isVitalParent).map(e=>{const t=e.decorator,a=t?t.node().name:e.node().name;return this.builtinOperationSignature(e.name,"QueryOperation",[a])});if(r&&r.length)return t.push(tsf.createInterfaceDeclaration([tsf.createToken(ts.SyntaxKind.ExportKeyword)],`${e.name}${a}$Lookups`,[],[],r)),true;return false}apiSignatures(e){return e.map(e=>tsf.createPropertySignature([],tsf.createStringLiteral(`${this.pack.name}/${pascalCase(e.name)}`),void 0,tsf.createTypeReferenceNode(`${e.name}$Operations`,[])))}static packageAlias(e){return`${pascalCase(e)}$Package`}packageDeclaration(e,t){return tsf.createInterfaceDeclaration([tsf.createToken(ts.SyntaxKind.ExportKeyword)],"Package",[],[],[...this.apiSignatures(e),...t?.length?this.apiSignaturesNoOperations(t):[]])}apiSignaturesNoOperations(e){return e.map(e=>tsf.createPropertySignature([],tsf.createStringLiteral(`${this.pack.name}/${pascalCase(e.name)}`),void 0,tsf.createTypeReferenceNode(`${e.name}`,[])))}graphDeclaration(){const e=this.application.mainPackage.apiDependencies.map(e=>ApiGenerator.trimApi(e)).filter(e=>e!==this.application.mainPackage.name).map(e=>ApiGenerator.packageAlias(e)).sort(compareImports).map(e=>tsf.createExpressionWithTypeArguments(tsf.createIdentifier(e),[]));return e.unshift(tsf.createExpressionWithTypeArguments(tsf.createIdentifier("Package"),[])),tsf.createInterfaceDeclaration([tsf.createToken(ts.SyntaxKind.ExportKeyword)],"GraphApi",[],[tsf.createHeritageClause(ts.SyntaxKind.ExtendsKeyword,e)],[])}static getEnumPropertySignatures(e){return Object.entries(e.instanceValues).map(([e,t])=>tsf.createPropertySignature([],e,void 0,tsf.createLiteralTypeNode(tsf.createNumericLiteral(t))))}static enumDeclaration(e){const t=ApiGenerator.getEnumPropertySignatures(e),a=`${e.enumName()}$Enum`;return[tsf.createInterfaceDeclaration([tsf.createToken(ts.SyntaxKind.ExportKeyword)],a,void 0,void 0,t),tsf.createTypeAliasDeclaration([tsf.createToken(ts.SyntaxKind.ExportKeyword)],e.enumName(),[],tsf.createTypeOperatorNode(ts.SyntaxKind.KeyOfKeyword,tsf.createTypeReferenceNode(a)))]}moduleStatements(){const e=[];this.pack.getEnumDataTypes().filter(e=>null==e.baseDataType).forEach(t=>{e.push(...ApiGenerator.enumDeclaration(t))});const t=this.pack.factories,a=t.filter(e=>e.isPublished).filter(t=>{this.addNodeDeclaration(t,e),this.addNodeInputDeclaration(t,e),this.addBindingNodeDeclaration(t,e);const a=this.addQueriesDeclaration(t,e,""),r=t.canRead,n=this.addMutationsDeclaration(t,e,""),i=this.addAsyncOperationsDeclaration(t,e,""),o=this.addLookupsDeclaration(t,e,""),s=t.canCreate,p=t.isAbstract||a||r||n||i||s||o;if(p)e.push(this.operationsDeclaration(t,a,n,i,o,""));return p});this.pack.getExtensionDecorators().map(e=>this.application.getFactoryByConstructor(e.extends())).filter(e=>e.isPublished).forEach(t=>{this.addNodeExtensionDeclaration(t,e),this.addNodeInputExtensionDeclaration(t,e),this.addNodeBindingExtensionDeclaration(t,e);const a=this.addQueriesDeclaration(t,e,"Extension"),r=this.addMutationsDeclaration(t,e,"Extension"),n=this.addAsyncOperationsDeclaration(t,e,"Extension"),i=this.addLookupsDeclaration(t,e,"Extension");if(a||r||n||i)e.push(this.operationsDeclaration(t,a,r,n,i,"Extension"));this.addNodeExtensionModule(t,{name:t.name,type:"node",hasQueries:a,hasMutations:r,hasAsyncOperations:n,hasLookups:i})}),this.pack.getEnumDataTypes().filter(e=>null!=e.baseDataType).forEach(t=>{this.addEnumExtensionModule(t),ApiGenerator.addEnumExtensionDeclaration(t,e)});const r=t.filter(e=>e.isPublished&&["sql","external"].includes(e.storage||"")&&!a.includes(e)),n=this.packageDeclaration(a,r),i=this.graphDeclaration();return[...this.nodeImportStatements(),...this.libImportStatements(),...e,n,i]}moduleDeclarationPartial(){return tsf.createModuleDeclaration([tsf.createToken(ts.SyntaxKind.DeclareKeyword)],tsf.createStringLiteral(`${this.pack.name}-api-partial`),tsf.createModuleBlock(this.moduleStatements()))}moduleDeclaration(){return tsf.createModuleDeclaration([tsf.createModifier(ts.SyntaxKind.DeclareKeyword)],tsf.createStringLiteral(`${this.pack.name}-api`),tsf.createModuleBlock([tsf.createExportDeclaration(void 0,true,void 0,tsf.createStringLiteral(`${this.pack.name}-api-partial`))]))}moduleDeclarations(){return[this.moduleDeclarationPartial(),this.moduleDeclaration(),...this.graphExtensions(),...this.moduleExtensionsStatements()]}}function generateClientApi(e){return(0,pretty_1.pretty)(new ApiGenerator(e.mainPackage).moduleDeclarations())}exports.ApiGenerator=ApiGenerator,exports.generateClientApi=generateClientApi;
//# sourceMappingURL=gen-api.js.map