"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.copAccessRightsManager = void 0;
/* eslint-disable @typescript-eslint/no-unused-vars */
const xtrem_core_1 = require("@sage/xtrem-core");
const fixtures = (0, xtrem_core_1.getTestFixtures)();
const { TestActivity } = fixtures.nodes;
const mockUser = { _id: 1000000, email: 'test@sage.com' };
exports.copAccessRightsManager = {
    getUserAccessFor(context, nodeName, propertyOrOperation, options) {
        return { sites: null, accessCodes: null, status: 'authorized' };
    },
    isAccessCodeAvailable(context, accessCode) {
        return true;
    },
    createAdminUser(context, data, options) { },
    createRequiredUsers(context) { },
    ensureAdminPersonaCreated(context) {
        return xtrem_core_1.adminDemoPersona;
    },
    getUser(context, email) {
        return mockUser;
    },
    getCurrentUser(context) {
        return mockUser;
    },
    getUserNode() {
        return xtrem_core_1.TestUser;
    },
    // stub implementation for now
    getPermissions(context, activity) {
        return ['create', 'read', 'update', 'delete', 'lookup'];
    },
    createActivities(context) { },
    updateActivities(context) { },
    deleteActivities(context) { },
    getActivityNode() {
        return TestActivity;
    },
    getActivitiesInfo(context) {
        return [];
    },
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    supportsPersona(context) {
        return false;
    },
    getPersonaUser(context, email) {
        return null;
    },
    getDemoPersonas(context) {
        return [];
    },
    invalidateAuthorizationCache(context) {
        return context.invalidateCachedCategory('AUTHORIZATION', {});
    },
};
//# sourceMappingURL=access-rights-manager.js.map