import * as estree from 'estree';
export declare class ExplorationError extends Error {
    readonly node: estree.BaseNode;
    constructor(node: estree.BaseNode, message: string);
}
export declare class Explorer {
    private static exploreThisExpression;
    private exploreMemberExpression;
    private exploreChainExpression;
    private exploreConditionalExpression;
    private exploreBinaryExpression;
    private exploreLogicalExpression;
    private exploreUnaryExpression;
    private exploreTemplateLiteral;
    private exploreBlockStatement;
    private exploreReturnStatement;
    private exploreSwitchStatement;
    private exploreIfStatement;
    private exploreCallExpression;
    private exploreVariableDeclaration;
    private exploreProperty;
    private exploreObject;
    private exploreArrayExpression;
    private explorerNewExpression;
    private explorerSequenceExpression;
    private explorerThrowStatement;
    private exploreExpressionStatement;
    private exploreAwaitExpression;
    exploreExpression(expression: estree.BaseExpression): string[];
    exploreFunctionExpression(expression: estree.FunctionExpression | estree.ArrowFunctionExpression): string[];
    exploreArrowFunctionExpression(expression: estree.ArrowFunctionExpression): string[];
    exploreFunction(fn: () => any): string[];
}
//# sourceMappingURL=explorer.d.ts.map